/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CPGPtoolsWipeFreeSpaceTask.h,v 1.5 1999/03/10 02:41:18 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LListener.h>

#include "MacCursors.h"
#include "pgpMacVolumeWiping.h"

#include "CPGPtoolsTask.h"

class CWipeFreeSpaceProgressDialog;

class CPGPtoolsWipeFreeSpaceTask : public CPGPtoolsTask, public LListener
{
public:
	
					CPGPtoolsWipeFreeSpaceTask(void);
	virtual			~CPGPtoolsWipeFreeSpaceTask(void);
	
	virtual void	ListenToMessage(MessageT inMessage, void *ioParam);
	CToolsError		SetParams(PGPContextRef	context, short vRefNum,
							PGPUInt32 numPasses = 0);
	CToolsError		WipeFreeSpace(void);
	
protected:

	short				mVRefNum;
	PGPUInt32			mNumPasses;
	PGPContextRef		mContext;
	AnimatedCursorRef	mCursorRef;
	Boolean				mWiping;
	
	CWipeFreeSpaceProgressDialog	*mProgressDialog;
	
	OSStatus		WipeVolumeEventHandler(const VolumeWipeEvent *event);

	static OSStatus	WipeVolumeEventHandlerShell(const VolumeWipeEvent *event,
							PGPUserValue userValue);
};



