/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPAppmenu.h,v 1.6 1999/05/07 08:55:38 jason Exp $
____________________________________________________________________________*/

#pragma once

#include "pgpClientErrors.h"
#include "pgpClientLib.h"

#include "CEventAvailPatcher.h"
#include "CGetKeysPatcher.h"
#include "CPutScrapPatcher.h"
#include "CSaveRestoreScrap.h"

#include "CPGPmenu.h"

class CPGPAppmenu	:	public	CPGPmenu {
public:
									CPGPAppmenu(FSSpec * inFSSpec,
										SPGPmenuMESPData * inMESPData);
	virtual							~CPGPAppmenu();

	virtual void					Patch();

protected:
	enum EOperation { op_Sign, op_Encrypt, op_EncryptAndSign, op_DecryptVerify };

	class CPGPAppmenuEventAvailPatch : public CEventAvailPatcher {
		virtual Boolean	NewEventAvail(EventMask eventMask, EventRecord * eventRecord);
	};
	friend class CPGPAppmenuEventAvailPatch;
	
	class CPGPAppmenuGetKeysPatch : public CGetKeysPatcher {
		virtual void		NewGetKeys(KeyMap theKeys);
	};
	friend class CPGPAppmenuGetKeysPatch;
	
	class CPGPAppmenuPutScrapPatch : public CPutScrapPatcher {
		virtual long	NewPutScrap(long length, ResType theType, void * source);
	};
	friend class CPGPAppmenuPutScrapPatch;

	PGPBoolean						mPatchEventAvail;
	PGPBoolean						mPatchGetKeys;
	PGPBoolean						mPatchPutScrap;
	PGPBoolean						mUsesOutputDialog;
	PGPContextRef					mContext;
	PGPMemoryMgrRef					mMemoryMgr;
	PGPtlsContextRef				mTLSContext;
	PGPClientEncodeDecodeDataRef	mClientEncodeDecodeData;
	PGPInt8							mState;
	EOperation						mOperation;
	CSaveRestoreScrap *				mSaveRestoreScrap;
	SInt32							mCurrentKey;
	PGPByte *						mData;
	PGPSize							mDataSize;
	
	virtual void					Initialize();

	virtual void					Sign();
	virtual void					Encrypt();
	virtual void					EncryptAndSign();
	virtual void					DecryptVerify();
	virtual void					ClearPassphraseCaches();
	virtual void					UpdatePrefs();
	
	virtual void					AppSign(const char * inText, PGPSize inTextSize,
										char ** outText, PGPSize * outTextSize);
	virtual void					AppEncrypt(PGPUInt32 inNumRecipients,
										PGPRecipientSpec * inRecipients,
										const char * inText, PGPSize inTextSize,
										char ** outText, PGPSize * outTextSize);
	virtual void					AppEncryptAndSign(PGPUInt32 inNumRecipients,
										PGPRecipientSpec * inRecipients,
										const char * inText, PGPSize inTextSize,
										char ** outText, PGPSize * outTextSize);
	virtual void					AppDecryptVerify(const char * inText, PGPSize inTextSize,
										char ** outText, PGPSize * outTextSize);

	virtual void					DoOperation(EOperation inOperation);
	virtual PGPInt8					SwitchState(PGPInt8	inEvent);
	virtual void					HandleKeyDown();
	virtual void					EventAvail(EventRecord * inEvent);
	virtual void					GetKeys(KeyMap outKeys);
	virtual PGPBoolean				PutScrap(PGPInt32 inLength, ResType inType,
										void * inSource);
	virtual void					Cleanup();
	
	void							PostCommandKey(SInt32 inKey);
};