/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CConfirmRemoteKeyDialog.cp,v 1.9 1999/04/20 11:52:45 wprice Exp $
____________________________________________________________________________*/

#include <LProgressBar.h>
#include <LPushButton.h>
#include <PP_Messages.h>
#include <URegistrar.h>

#include "pgpMem.h"

#include "PGPclientLibUtils.h"
#include "pgpClientLib.h"

#include "WarningAlert.h"

#include "CString.h"

#include "CConfirmRemoteKeyDialog.h"


static const PaneIDT	caption_Prompt			=	'cPro';
static const PaneIDT	caption_RemoteAddress	=	'cRem';
static const PaneIDT	caption_Name			=	'cNam';
static const PaneIDT	caption_Fingerprint		=	'cFin';
static const PaneIDT	progressBar_Validity	=	'pVal';
static const PaneIDT	caption_TLSCipherSuite	=	'cTLS';
static const PaneIDT	button_Cancel			=	'bCAN';
static const PaneIDT	button_Confirm			=	'bOK ';

static const ResIDT		kConfirmKeyDialogID		=	4754;
static const ResIDT		kTLSCiphersStringListID	=	8947;


	PGPError
PGPConfirmRemoteKeyDialog(
	const char *			prompt,
	const char *			remoteHostName,
	PGPKeyRef				keyToConfirm,
	PGPtlsCipherSuiteNum	tlsCipher,
	PGPBoolean				askConfirm )
{
	PGPError				result = kPGPError_NoErr;
	PGPclientLibState		state;
	
	PGPValidatePtr(prompt);
	PGPValidatePtr(remoteHostName);
	PGPValidateParam(PGPKeyRefIsValid(keyToConfirm));
	
	try {
		result = EnterPGPclientLib(PGPGetKeyContext(keyToConfirm), &state);
		if (IsntPGPError(result))
		{
			DialogRef	theDialog;

			RegisterClass_(CConfirmRemoteKeyDialog);
			
			// Suspend leak checking since LGAProgressBarImp leaks its LGWorlds
			MacLeaks_Suspend();
			theDialog = CConfirmRemoteKeyDialog::CreateDialog(
													kConfirmKeyDialogID);
			MacLeaks_Resume();
			if (IsntNull(theDialog))
			{
				CConfirmRemoteKeyDialog *	dialog;
				ModalFilterUPP				filterUPP;
				short						itemHit = 0;
				MessageT					dismissMessage;
				
				InitCursor();
				
				SetPort( theDialog );
				dialog = (CConfirmRemoteKeyDialog *) 
											::GetWRefCon(theDialog);
				result = dialog->SetInfo(	CString(prompt),
											CString(remoteHostName),
											keyToConfirm,
											tlsCipher,
											askConfirm);
				ShowWindow( theDialog );
				SelectWindow( theDialog );
				pgpAssertAddrValid(dialog, VoidAlign);
				
				filterUPP = NewModalFilterProc(
							CPGPModalGrafPortView::ModalFilterProcHandler );
				dialog->SetDismissMessage( msg_Nothing );

				while( itemHit == 0 )
				{
					ModalDialog( filterUPP, &itemHit );
				}
				dismissMessage = dialog->GetDismissMessage();
				if( dismissMessage == msg_Cancel )
					result = kPGPError_UserAbort;
				
				DisposeRoutineDescriptor( filterUPP );
				delete dialog;
				::DisposeDialog(theDialog);
			}
			else
			{
				result = kPGPError_OutOfMemory;
			}
		}
		ExitPGPclientLib(&state);
	}
	
	catch (...) {
		result = kPGPError_UnknownError;
	}
	
	return result;
}
	
	
	
CConfirmRemoteKeyDialog::CConfirmRemoteKeyDialog(
	LStream *	inStream)
	: CPGPModalGrafPortView(inStream)
{
	mWindowIsMoveable = true;
}



CConfirmRemoteKeyDialog::~CConfirmRemoteKeyDialog()
{
}



	PGPError
CConfirmRemoteKeyDialog::SetInfo(
	StringPtr				inPrompt,
	StringPtr				inRemoteHostName,
	PGPKeyRef				inKey,
	PGPtlsCipherSuiteNum	tlsCipher,
	PGPBoolean				askConfirm)
{
	PGPError		result;
	Str255			string;
	PGPSize			fullSize;
	PGPByte			fingerprint[256];
	uchar *			p;
	PGPInt32		validity;
	LProgressBar *	validityBar = (LProgressBar *) FindPaneByID(
													progressBar_Validity);
	static char		sHexDigit[] = "0123456789ABCDEF";
	
	FindPaneByID(caption_Prompt)->SetDescriptor(inPrompt);
	FindPaneByID(caption_RemoteAddress)->SetDescriptor(inRemoteHostName);
	
	if( !askConfirm )
	{
		FindPaneByID(button_Cancel)->Hide();
		GetIndString( string, kTLSCiphersStringListID, 1 );
		FindPaneByID(button_Confirm)->SetDescriptor( string );
	}
	GetIndString( string, kTLSCiphersStringListID, ( (Int16)tlsCipher ) + 2 );
	FindPaneByID(caption_TLSCipherSuite)->SetDescriptor(string);
	
	result = PGPGetPrimaryUserIDNameBuffer(	inKey,
											sizeof(Str255) - 1,
											(char *) &string[1],
											&fullSize);
	if (IsntPGPError(result)) {
		string[0] = fullSize - 1;
		FindPaneByID(caption_Name)->SetDescriptor(string);
		
		result = PGPGetKeyPropertyBuffer(	inKey,
											kPGPKeyPropFingerprint,
											sizeof(fingerprint),
											fingerprint,
											&fullSize);
		if (IsntPGPError(result)) {
			if (fullSize == 20) {
				string[0] = 50;
			} else {
				string[0] = 40;
				fullSize = 16;
			}
			p = string + 1;
			for (SInt16 i = 0; i < fullSize; i++) {
				*p++ = sHexDigit[fingerprint[i] >> 4];
				*p++ = sHexDigit[fingerprint[i] & 0x0F];
				if (i & 0x0001) {
					*p++ = ' ';
				}
				if (((fullSize == 20) && (i == 9))
				|| ((fullSize != 20) && (i == 7))) {
					*p++ = ' ';
				}
			}
			FindPaneByID(caption_Fingerprint)->SetDescriptor(string);
			
			result = PGPGetKeyNumber(	inKey,
										kPGPKeyPropValidity,
										&validity);
			if (IsntPGPError(result)) {
				switch (validity) {
					case kPGPValidity_Marginal:
					{
						validity = 1;
					} 
					break;
					
					
					case kPGPValidity_Complete:
					{
						validity = 2;
					}
					break;
					
					
					default:
					{
						validity = 0;
					}
					break;
				}
				validityBar->SetMaxValue(2);
				validityBar->SetValue(validity);
			}
		}
	}
	
	return result;
}

