/*____________________________________________________________________________
	PGPPlugGlue.cp
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: PGPPlugGlue.cp,v 1.11 1999/04/26 09:41:23 heller Exp $
____________________________________________________________________________*/

#include <CodeFragments.h>
#include <MixedMode.h>

#include "EudoraTypes.h"

#include "PGPPlug.h"
#include "MacFiles.h"
#include "MacEnvirons.h"
#include "MacStrings.h"

#include "PluginProcInfo.h"




#if GENERATING68K
	#define	CALL_TO_CFM		1
#else
	#define	CALL_TO_CFM		0
#endif

#if CALL_TO_CFM	// [

typedef pascal long	(*EMSInitProcPtr)(Handle globals,
						short eudAPIVersion, emsMailConfigP	mailConfig,
    					emsPluginInfoP pluginInfo);

typedef pascal long (*EMSFinishProcPtr)(Handle globals);

typedef pascal long	(*EMSTranslatorInfoProcPtr)(Handle globals,
						emsTranslatorP transInfo);

typedef pascal long	(*EMSConfigProcPtr)(Handle globals,
						emsMailConfigP mailConfig);

typedef pascal long (*EMSCanTranslateProcPtr)(Handle globals,
						emsTranslatorP trans, emsDataFileP inTransData,
    					emsResultStatusP transStatus);

typedef pascal long (*EMSTranslateFileProcPtr)(Handle globals,
						emsTranslatorP trans, emsDataFileP inFile,
    					EMSProgressUPP progress, emsDataFileP outFile,
    					emsResultStatusP transStatus);
															
typedef struct MyRoutineDescriptors
{
	EMSInitProcPtr				init;
	EMSFinishProcPtr			finish;
	EMSTranslatorInfoProcPtr	getTranslatorInfo;
	EMSConfigProcPtr			config;
	EMSCanTranslateProcPtr		canTranslate;
	EMSTranslateFileProcPtr		translateFile;
	
}  MyRoutineDescriptors;

static CFragConnectionID sMyConnectionID	=
							(CFragConnectionID) kUnresolvedCFragSymbolAddress;
							
static MyRoutineDescriptors		sMyRoutines	= { nil, };

	static CFragConnectionID
GetMyConnectionID()
{
	return( sMyConnectionID );
}

	static OSErr
GetSymbol(
	ConstStringPtr		symbolName,
	Ptr	*				symbol )
{
	OSErr				err	= noErr;
	CFragSymbolClass	theSymClass;
		
	err = FindSymbol( GetMyConnectionID(), symbolName, symbol, &theSymClass);
	AssertNoErr( err, "GetSymbol" );
		
	return( err );
}


	static OSErr
LoadMyLibrary( )
{
	Ptr					mainAddr;
	Str255				errorName;
	OSStatus			err	= noErr;
	CFragConnectionID	connectionID;
	short				curResFile = CurResFile();
	FSSpec				spec;

	GetSpecFromRefNum( curResFile, &spec);
	
	if ( IsntErr( err ) )
	{
		err	= GetDiskFragment( &spec,
				0UL, kCFragGoesToEOF, nil, kPrivateCFragCopy,
				&connectionID, &mainAddr, errorName);
		AssertNoErr( err, "LoadMyLibrary" );
		
		if ( IsntErr( err ) )
		{
			sMyConnectionID	= connectionID;
			
			err = GetSymbol( "\pPlugInInitRD", (Ptr *)&sMyRoutines.init);
			AssertNoErr( err, "LoadMyLibrary: can't find symbol" );
			
			err = GetSymbol( "\pPlugInFinishRD", (Ptr *)&sMyRoutines.finish);
			AssertNoErr( err, "LoadMyLibrary: can't find symbol" );
			
			err = GetSymbol( "\pGetTranslatorInfoRD",
					(Ptr *)&sMyRoutines.getTranslatorInfo);
			AssertNoErr( err, "LoadMyLibrary: can't find symbol" );

			err = GetSymbol( "\pPlugInConfigRD",
					(Ptr *)&sMyRoutines.config);
			AssertNoErr( err, "LoadMyLibrary: can't find symbol" );
			
			err = GetSymbol( "\pCanTranslateRD",
					(Ptr *)&sMyRoutines.canTranslate);
			AssertNoErr( err, "LoadMyLibrary: can't find symbol" );
			
			err = GetSymbol( "\pTranslateFileRD",
					(Ptr *)&sMyRoutines.translateFile);
			AssertNoErr( err, "LoadMyLibrary: can't find symbol" );
		}
	}
	AssertNoErr( err, "LoadMyLibrary" );
	
	return( err );
}


	static void
UnloadMyLibrary(  )
{
	OSErr	err	= noErr;
	
	if ( sMyConnectionID != 0 )
	{
		err	= CloseConnection( &sMyConnectionID );
		pgpAssert( sMyConnectionID == 0 );
		AssertNoErr( err, "UnloadMyLibrary" );
	}
}
	
#endif	// ]

	pascal long
ems_plugin_version(
	Handle	globals,
	short	*api_version)
{
	(void) globals;
	
	if( IsntNull( api_version ) )
	{
		*api_version = EMS_VERSION;
	}
	
	return( EMSR_OK );
}

	
	pascal long
ems_plugin_init(
	Handle			globals,
	short			eudAPIVersion,
	emsMailConfigP	mailConfig,
    emsPluginInfoP	pluginInfo)
{
	long	err	= noErr;
	
	pgpAssert( sizeof( int ) == 4 );
	if ( sizeof( int ) != 4 )
	{
		SysError( 444 );
	}
	
#if CALL_TO_CFM
	err	= LoadMyLibrary();
	if ( IsntErr( err ) )
	{
		err	= (*sMyRoutines.init)( globals, eudAPIVersion,
				mailConfig, pluginInfo );
	}
#else
	err	= PlugInInit( (emsUserGlobals **)globals, eudAPIVersion,
				mailConfig, pluginInfo );
#endif
	
	AssertNoErr( err, "ems_plugin_init" );
	return( err );
}


	pascal long
ems_plugin_finish(Handle globals)
{
	long	err	= noErr;

#if CALL_TO_CFM
	err	= (*sMyRoutines.finish)( globals );
	UnloadMyLibrary();
#else
	err	= PlugInFinish( (emsUserGlobals **) globals );
#endif
	return( err );
}



	pascal long
ems_translator_info(
	Handle			globals,
	emsTranslatorP	transInfo)
{
	long	err	= noErr;

#if CALL_TO_CFM
	err	= (*sMyRoutines.getTranslatorInfo)( globals, transInfo );
#else
	err	= GetTranslatorInfo( (emsUserGlobals **) globals, transInfo);
#endif
	return( err );
}

	pascal long
ems_plugin_config(
	Handle			globals,
	emsMailConfigP	mailConfig)
{
	long	err	= noErr;

#if CALL_TO_CFM
	err	= (*sMyRoutines.config)( globals, mailConfig );
#else
	err	= PlugInConfig( (emsUserGlobals **) globals, mailConfig);
#endif
	return( err );
}



	pascal long
ems_can_translate(
	Handle				globals,
	emsTranslatorP		trans,		
    emsDataFileP 		inTransData,
    emsResultStatusP 	transStatus)
{
	long	err;
	
#if CALL_TO_CFM
	err	= (*sMyRoutines.canTranslate)( globals, trans,
					inTransData, transStatus );
#else
	err	= CanTranslate( (emsUserGlobals **) globals, trans,
			inTransData, transStatus );
#endif
		
	return( err );
}


	pascal long
ems_translate_file(
	Handle				globals,
	emsTranslatorP		trans,
    emsDataFileP		inFile,
    EMSProgressUPP		progress,
    emsDataFileP		outFile,
    emsResultStatusP 	transStatus)
{
	long	err;
	
#if CALL_TO_CFM
	err	= (*sMyRoutines.translateFile)( globals, trans, inFile, progress,
					outFile, transStatus );
#else
	err	= TranslateFile( (emsUserGlobals **) globals, trans, inFile, progress,
					outFile, transStatus );
#endif
	
	return( err );
}






