/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: PGPFMacUtils.cp,v 1.5 1999/03/10 02:50:53 heller Exp $
____________________________________________________________________________*/
#include <Timer.h>
#include <Threads.h>
#include <UDesktop.h>

#include "PGPFMacUtils.h"
#include "PGPFoneUtils.h"
#include "MacFiles.h"
#include "CEncryptionStream.h"

SFReply gSFReply;
long gGoodDirID;

static uchar prefFilename[]="\pPGPFone Preferences";

static PGPFoneOptions initPGPFoneOptions = {
		PGPFONEOPTSVERSION,
		"",
		_enc_cast,			// preferred encryptor
		0x0007,				// cryptor mask, all but none
		'GSM7','GS6L',3,	// Blowfish,3DES,GSM7,GS6L,2048 bit pref prime
		0x003e,				// prime mask defaults to 4096-1024
		1,1,1,				// listen, play ring, full duplex,
		1,1,1,				// identity: incoming, outgoing, unencrypted
		_cme_Internet,		// disable key cache, force encryptor, connection
		0,0,				// sound input gain, threshold
		"\pModem Port", "S0=0", "19200",	// serial options
			0x13, 0x0C, 0, 0, 2,
		
		1, 0,				// numDialSetups, curDialSet
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"Local", "", "","","1","","","",160,0,
		"\p", 0,			// default receive folder
		'ttxt',
		"\pSimpleText",
		0,0,0,0,			// main window bounds
		0,0,0,0,			// auth window bounds
		0,					// main windows state
		
		0,
		"","","",
	};

//	Apple's grayscale ramp as defined in
//	"Apple Grayscale Appearance" (C) 1996 Apple Computer

RGBColor gGrayRamp[] = {
	{0x0000,0x0000,0x0000},		//0
	{0x2222,0x2222,0x2222},		//1
	{0x4444,0x4444,0x4444},		//2
	{0x5555,0x5555,0x5555},		//3
	{0x6666,0x6666,0x6666},		//4
	{0x7777,0x7777,0x7777},		//5
	{0x8888,0x8888,0x8888},		//6
	{0x9999,0x9999,0x9999},		//7
	{0xaaaa,0xaaaa,0xaaaa},		//8
	{0xbbbb,0xbbbb,0xbbbb},		//9
	{0xcccc,0xcccc,0xcccc},		//10
	{0xdddd,0xdddd,0xdddd},		//11
	{0xeeee,0xeeee,0xeeee},		//12
	{0xffff,0xffff,0xffff},		//13
	};
	
void GrayBorder(const Rect &frame)
{
	::PenNormal();
	::RGBForeColor(&gGrayRamp[8]);
	::MoveTo(frame.left, frame.bottom-1);
	::LineTo(frame.left, frame.top);
	::LineTo(frame.right-1,frame.top);
	::MoveTo(frame.right-2,frame.top+2);
	::LineTo(frame.right-2,frame.bottom-2);
	::LineTo(frame.left,frame.bottom-2);
	::RGBForeColor(&gGrayRamp[13]);
	::MoveTo(frame.right-1,frame.top+1);
	::LineTo(frame.left+1,frame.top+1);
	::LineTo(frame.left+1,frame.bottom-1);
	::MoveTo(frame.left+2,frame.bottom-1);
	::LineTo(frame.right-1,frame.bottom-1);
	::LineTo(frame.right-1,frame.top+2);
	::RGBForeColor(&gGrayRamp[0]);
}

// we need to know if the machine has the Power Manager so we can
// disable processor cycling which causes major havoc in a real-time app

Boolean PowerManagerExists()
{
	Boolean routinesExist = false;
	long pmgrAttributes;
	
	if(!Gestalt(gestaltPowerMgrAttr, &pmgrAttributes))
		if((pmgrAttributes & (1<<gestaltPMgrDispatchExists)) &&
			(pmgrAttributes & (1<<gestaltPMgrCPUIdle)))
			routinesExist = true;
	return routinesExist;
}

/*
 * Return the difference between now and a Microsecond value
 * Integer subtraction is used to preserve accuracy.
 * Accuracy limited to 32 bits
 */
ulong MicrosecondEndTimer(UnsignedWide *start)
{
	UnsignedWide nowms;
	
	Microseconds(&nowms);
	return nowms.lo - start->lo;
}

Boolean IsFullDuplexMac()
{
	long gestValue;
	
	Gestalt(gestaltSoundAttr, &gestValue);
	return ((gestValue & (1<<gestaltPlayAndRecord)) != 0);

}

static pascal Boolean DirFilter(ParmBlkPtr pbp)
{
	return (!(pbp->fileParam.ioFlAttrib & 8));
}

static pascal short DirFileHook(short item, DialogPtr dialog)
{
	short ret, iKind;
	Handle iHandle;
	Rect iRect;
	
	ret = item;
	switch(item)
	{
		case -1:
			break;
		case 11:
			if(gSFReply.fType)
			{
				gGoodDirID = gSFReply.fType;
				ret = 1;
			}
			break;
		case 12:
			gGoodDirID=LMGetCurDirStore();
			ret = 1;
			break;
		case 100:
			if(!gSFReply.fType)
			{
				GetDialogItem(dialog,11,&iKind,&iHandle,&iRect);
				HiliteControl((ControlHandle)iHandle,0xFF);
			}
			else
			{
				GetDialogItem(dialog,11,&iKind,&iHandle,&iRect);
				HiliteControl((ControlHandle)iHandle,0);
			}
			YieldToAnyThread();
			break;
	}
	return ret;
}

short GetSFDir(short useWD, long *aDir, short *vref, uchar *name)
{
	SFTypeList typeList;
	FileFilterUPP ffil;
	DlgHookUPP dirHook;
	static Point where={0,0};
	WDPBRec pb;
	uchar s[32];
	
	ffil = NewFileFilterProc(DirFilter);
	dirHook = NewDlgHookProc(DirFileHook);
	UDesktop::Deactivate();
	SFPGetFile(where, "\p", ffil, -1, typeList, dirHook, &gSFReply, 2003, NIL);
	UDesktop::Activate();
	DisposeRoutineDescriptor(ffil);
	DisposeRoutineDescriptor(dirHook);
	if(gSFReply.good)
	{
		if(useWD)
		{
			*vref=-LMGetSFSaveDisk();
			*aDir=gGoodDirID;
		}
		else
		{
			pb.ioCompletion=NIL;
			pb.ioNamePtr = s;
			pb.ioVRefNum=-LMGetSFSaveDisk();
			pb.ioWDIndex=0;
			pb.ioWDProcID='ERIK';
			pb.ioWDVRefNum=-LMGetSFSaveDisk();
			if(!PBGetWDInfoSync(&pb))
			{
				if(pstrlen(pb.ioNamePtr)<28)
				{
					pstrcpy(name, pb.ioNamePtr);
					pstrcat(name, "\p:");
				}
				*aDir=gGoodDirID;
			}
		}
		return 1;
	}
	else
		return 0;
}

short pgp_GetVolRefNum(uchar *volName)
{
	VolumeParam vpb;
	uchar vname[32];
	short iov;
	
	pstrcpy(vname, volName);
	vpb.ioCompletion=NIL;
	vpb.ioNamePtr=vname;
	vpb.ioVolIndex=-1;
	vpb.ioVRefNum=0;
	if(!PBGetVInfoSync((ParmBlkPtr)&vpb))
		iov=vpb.ioVRefNum;
	else
		iov=0;
	return iov;
}

void pgp_GetFullPathname(short vRefNum, long dirID, uchar *path)
{
	CInfoPBRec cpb;
	uchar fpath[64], temppath[256];
	OSErr err;
	
	cpb.dirInfo.ioCompletion = NIL;
	cpb.dirInfo.ioNamePtr = fpath;
	cpb.dirInfo.ioVRefNum = vRefNum;
	cpb.dirInfo.ioFDirIndex = -1;
	cpb.dirInfo.ioDrDirID = dirID;
	err = PBGetCatInfoSync(&cpb);
	if(!err)
	{
		pstrcat(fpath, "\p:");
		pstrcpy(temppath, fpath);
		pstrcat(temppath, path);
		pstrcpy(path, temppath);
	}
	if(cpb.dirInfo.ioDrDirID!=2)	////////RECURSIVE
		pgp_GetFullPathname(vRefNum, cpb.dirInfo.ioDrParID, path);
}

short pgp_GetDTRef()
{
	DTPBRec dtpb;
	OSErr err;
	
	// Open the Desktop Manager to get file icons
	dtpb.ioNamePtr = NIL;
	dtpb.ioVRefNum = -1;
	err = PBDTGetPath(&dtpb);
	pgpAssertNoErr(err);
	return dtpb.ioDTRefNum; 
}

OSErr pgp_GetDTAppName(OSType creator, uchar *name)
{
	DTPBRec dtpb;
	
	dtpb.ioDTRefNum = pgp_GetDTRef();
	dtpb.ioCompletion = NIL;
	dtpb.ioNamePtr = name;
	dtpb.ioIndex = 0;
	dtpb.ioFileCreator = creator;
	return PBDTGetAPPLSync(&dtpb);
}

void DoPrefs(short save)
{
	long dir, len;
	short vol, ref;
	OSErr result;
	
	result = FindPGPPreferencesFolder(kOnSystemDisk, &vol, &dir);
	result = HOpen(vol, dir, prefFilename, fsRdWrPerm, &ref);
	if(result && !save)
	{
		result=HDelete(vol, dir, prefFilename);
		result=HCreate(vol, dir, prefFilename, PGPFONECREATOR, 'pref');
		if(HOpen(vol,dir, prefFilename, fsRdWrPerm, &ref))
		{
			PGFAlert("Could not create preferences file!", 0);
			return;
		}
		pgp_memcpy(&gPGFOpts, &initPGPFoneOptions, sizeof(PGPFoneOptions));
		save = 1;
	}
	len = sizeof(PGPFoneOptions);
	if(save)
		result = FSWrite(ref, &len, &gPGFOpts);
	else
		result = FSRead(ref, &len, &gPGFOpts);
	result = FSClose(ref);
	if(gPGFOpts.version < PGPFONEOPTSVERSION)
		pgp_memcpy(&gPGFOpts, &initPGPFoneOptions, sizeof(PGPFoneOptions));
}

short pstrlen(uchar *str)
{
	return str[0];
}

void pstrcpy(uchar *dest, uchar *src)
{
	short len=src[0];
	
	BlockMoveData(&src[1], &dest[1], len);
	dest[0]=len;
}

void pstrcat(uchar *dest, uchar *src)
{
    short destLen=dest[0], srcLen=src[0];
    
    if (dest[0]+srcLen > 255)
    	srcLen = 255 - dest[0];
    BlockMoveData(src + 1,  dest + destLen + 1, srcLen);
    dest[0]+=srcLen;
}

short pstrcmp(uchar *s, uchar *t)
{
	short len;
	
	len=*(uchar *)s;
	if(len!=*(uchar *)t)
		return 1;
	s++,t++;
	while(len--)
		if(*s++!=*t++)
			return 1;
	return 0;
}

