/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: FileWrapper.c,v 1.3 1999/03/10 02:42:55 heller Exp $
____________________________________________________________________________*/
#include "FileWrapper.h"

OSErr PGPFCreate(LThread *t, uchar *fileName, long dirID, short vRefNum,
				OSType creator, OSType fileType, HFileParam *fileInfo,short async)
{
	SThreadParamBlk spb;
	HParmBlkPtr pb;
	
	pb=(HParmBlkPtr)&spb;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->ioParam.ioNamePtr=(uchar *)fileName;
	pb->ioParam.ioVRefNum=vRefNum;
	pb->fileParam.ioDirID=dirID;
	if(async)
		PBHCreateAsync(pb);
	else
		PBHCreateSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	if(!pb->ioParam.ioResult)
	{
		if(fileInfo)
			pb->fileParam=*fileInfo;
		else
		{
			pb->fileParam.ioFlCrDat=pb->fileParam.ioFlMdDat=LMGetTime();
			pb->fileParam.ioFlFndrInfo.fdType=fileType;
			pb->fileParam.ioFlFndrInfo.fdCreator=creator;
			pb->fileParam.ioFlFndrInfo.fdFlags=0;
			pb->fileParam.ioFlFndrInfo.fdLocation.h=0;
			pb->fileParam.ioFlFndrInfo.fdLocation.v=0;
			pb->fileParam.ioFlFndrInfo.fdFldr=0;
		}
		if(async)
			PBHSetFInfoAsync(pb);
		else
			PBHSetFInfoSync(pb);
		if(async)
			t->SuspendUntilAsyncResume(&spb);
		if(pb->ioParam.ioResult)
			PGPFDelete(t, fileName, dirID, vRefNum, async);
	}
	return pb->ioParam.ioResult;
}

OSErr PGPFGetFInfo(LThread *t, uchar *fileName, long dirID, short vRefNum, short dirIndex, 
					HFileParam *fileInfo,short async)
{
	SThreadParamBlk spb;
	HParmBlkPtr pb;
	
	pb=&spb.ioPB.H;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->ioParam.ioNamePtr=(uchar *)fileName;
	pb->ioParam.ioVRefNum=vRefNum;
	pb->fileParam.ioFDirIndex=dirIndex;
	pb->fileParam.ioDirID=dirID;
	if(async)
		PBHGetFInfoAsync(pb);
	else
		PBHGetFInfoSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	*fileInfo=pb->fileParam;
	return pb->ioParam.ioResult;
}

OSErr PGPFWrite(LThread *t, short refNum,long filePos,long *count,void *buffer,short async)
{
	SThreadParamBlk spb;
	ParmBlkPtr pb;
	
	pb=&spb.ioPB.F;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->ioParam.ioRefNum=refNum;
	pb->ioParam.ioBuffer=(Ptr)buffer;
	pb->ioParam.ioReqCount=*count;
	if(filePos>=0)
	{
		pb->ioParam.ioPosMode=fsFromStart;
		pb->ioParam.ioPosOffset=filePos;
	}
	else
	{
		pb->ioParam.ioPosMode=fsAtMark;
		pb->ioParam.ioPosOffset=0;
	}
	if(async)
		PBWriteAsync(pb);
	else
		PBWriteAsync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	*count=pb->ioParam.ioActCount;
	return pb->ioParam.ioResult;
}

OSErr PGPFRead(LThread *t, short refNum,long filePos,long *count,void *buffer,short async)
{
	SThreadParamBlk spb;
	ParmBlkPtr pb;
	
	pb=&spb.ioPB.F;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->ioParam.ioRefNum=refNum;
	pb->ioParam.ioBuffer=(Ptr)buffer;
	pb->ioParam.ioReqCount=*count;
	if(filePos>=0)
	{
		pb->ioParam.ioPosMode=fsFromStart;
		pb->ioParam.ioPosOffset=filePos;
	}
	else
	{
		pb->ioParam.ioPosMode=fsAtMark;
		pb->ioParam.ioPosOffset=0;
	}
	if(async)
		PBReadAsync(pb);
	else
		PBReadSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	*count=pb->ioParam.ioActCount;
	return pb->ioParam.ioResult;
}

OSErr PGPFFlushFile(LThread *t, short refNum,short async)
{
	SThreadParamBlk spb;
	ParmBlkPtr pb;
	
	pb=&spb.ioPB.F;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->ioParam.ioRefNum=refNum;
	if(async)
		PBFlushFileAsync(pb);
	else
		PBFlushFileSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	return pb->ioParam.ioResult;
}

OSErr PGPFOpenDF(LThread *t, uchar *fileName,long dirID,short vRefNum,short ioPerm,short *refNum,short async)
{
	SThreadParamBlk spb;
	HParmBlkPtr pb;
	
	pb=&spb.ioPB.H;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	async=0;			//+++++ per Rosenthal, compatibility with disk compressors
	pb->ioParam.ioNamePtr=(uchar *)fileName;
	pb->ioParam.ioVRefNum=vRefNum;
	pb->ioParam.ioPermssn=ioPerm;
	pb->ioParam.ioMisc=NIL;
	pb->fileParam.ioDirID=dirID;
	if(async)
		PBHOpenDFAsync(pb);
	else
		PBHOpenDFSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	*refNum=pb->ioParam.ioRefNum;
	return pb->ioParam.ioResult;
}

OSErr PGPFOpenRF(LThread *t, uchar *fileName,long dirID,short vRefNum,short ioPerm,short *refNum,short async)
{
	SThreadParamBlk spb;
	HParmBlkPtr pb;
	
	pb=&spb.ioPB.H;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	async=0;			//+++++ per Rosenthal, compatibility with disk compressors
	pb->ioParam.ioNamePtr=(uchar *)fileName;
	pb->ioParam.ioVRefNum=vRefNum;
	pb->ioParam.ioPermssn=ioPerm;
	pb->ioParam.ioMisc=NIL;
	pb->fileParam.ioDirID=dirID;
	if(async)
		PBHOpenRFAsync(pb);
	else
		PBHOpenRFSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	*refNum=pb->ioParam.ioRefNum;
	return pb->ioParam.ioResult;
}

OSErr PGPFSetEOF(LThread *t, short refNum,long logEOF,short async)
{
	SThreadParamBlk spb;
	ParmBlkPtr pb;
	
	pb=&spb.ioPB.F;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->ioParam.ioRefNum=refNum;
	pb->ioParam.ioMisc=(Ptr)logEOF;
	if(async)
		PBSetEOFAsync(pb);
	else
		PBSetEOFSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	return pb->ioParam.ioResult;
}

OSErr PGPFClose(LThread *t, short refNum,short async)
{
	SThreadParamBlk spb;
	ParmBlkPtr pb;
	
	pb=&spb.ioPB.F;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	async=0;	//+++++per Rosenthal
	pb->ioParam.ioRefNum=refNum;
	if(async)
		PBCloseAsync(pb);
	else
		PBCloseSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	return pb->ioParam.ioResult;
}

OSErr PGPFDelete(LThread *t, uchar *fileName, long dirID, short vRefNum,short async)
{
	SThreadParamBlk spb;
	HParmBlkPtr pb;
	
	pb=&spb.ioPB.H;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->ioParam.ioNamePtr=(uchar *)fileName;
	pb->ioParam.ioVRefNum=vRefNum;
	pb->fileParam.ioDirID=dirID;
	if(async)
		PBHDeleteAsync(pb);
	else
		PBHDeleteSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	return pb->ioParam.ioResult;
}

OSErr PGPFSetFInfo(LThread *t, uchar *fileName, long dirID, short vRefNum, HFileParam *fileInfo,short async)
{
	SThreadParamBlk spb;
	HParmBlkPtr pb;
	
	pb=&spb.ioPB.H;
	if(async)
		t->SetupAsynchronousResume(&spb, nil);
	else
		pb->ioParam.ioCompletion = nil;
	pb->fileParam=*fileInfo;
	pb->ioParam.ioNamePtr=(uchar *)fileName;
	pb->ioParam.ioVRefNum=vRefNum;
	pb->fileParam.ioDirID=dirID;
	if(async)
		PBHSetFInfoAsync(pb);
	else
		PBHSetFInfoSync(pb);
	if(async)
		t->SuspendUntilAsyncResume(&spb);
	return pb->ioParam.ioResult;
}

