/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CDirTable.h,v 1.4 1999/03/10 02:32:26 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LTableView.h>
#include <LBroadcaster.h>

#include "PGPfone.h"

class	CDirTable :	public LTableView,
					public LBroadcaster
{
public:
	enum { class_ID = 'uTBV' };
	static CDirTable*	CreateDirTableStream(LStream *inStream);
	
						CDirTable(LStream *inStream);
	virtual				~CDirTable();
	void				FinishCreateSelf();
	void				DrawSelf();

protected:
	virtual void		DrawCell(
								const STableCell		&inCell,
								const Rect				&inLocalRect);
	virtual void		ClickCell(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);
	virtual void		HiliteCellActively(
								const STableCell	&inCell,
								Boolean				inHilite);
	virtual void		HiliteCellInactively(
								const STableCell	&inCell,
								Boolean				inHilite);
private:
	ulong				mLastClickTime;
	STableCell			mLastClickCell;
};

