/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPDiskPreferences.h,v 1.5 1999/03/10 02:49:50 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "DriverPrefs.h"

#pragma options align=mac68k

typedef struct PGPDiskPrefs
{
	OSType		magic;
	UInt8		majorVersion;
	UInt8		minorVersion;
	
	PGPDiskDriverPrefs	driverPrefs;

	UInt32		newDiskDefaultSize;
	Boolean		newDiskDefaultIsMB;
	Boolean		reserved;
	Point		mainWindowLocation;
	UInt32		reservedNonZero;
	UInt32		reservedLongs[10];

} PGPDiskPrefs;

#pragma options align=reset

void		ReadPreferences(PGPDiskPrefs *prefs);
OSStatus	SendPreferencesToAllDrivers(const PGPDiskDriverPrefs *driverPrefs);
void		WritePreferences(const PGPDiskPrefs *prefs);

extern	PGPDiskPrefs gPGPDiskPrefs;

