/*
 * T.C.F.S. Utils 2.0 $Revision: 1.6 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /home/anidel/Wip/TCFS-2.2.0a/tcfsutils-1.1/src/RCS/tcfsrmgroup.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.6 $
 *       $Author: anidel $
 *         $Date: 1998/12/10 10:33:24 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfsrmgroup.c,v 1.6 1998/12/10 10:33:24 anidel Exp $";

#include <stdio.h>
#include <getopt.h>
#include <tcfslib.h>
#include <grp.h>

#include "tcfserrors.h"

static struct option long_options[]=
{
	{ "help", 0, NULL, 'h' },
	{ "group", 1, NULL, 'g' },
	{ "verbose", 0, NULL, 'v' },
	{ 0, 0, 0, 0 }
};

char *usage="Usage: %s [OPTION]...
Remove a TCFS group from the TCFS group database.

  -g [--group] <group>    Specifies the TCFS group to be removed
  -h [--help]             Shows this help
  -v [--verbose]          Makes the output a little more verbose\n";

int main (int argn, char *argv[])
{
	int index, val;
	tcfs_gid_t gid;
	int have_gid=FALSE, be_verbose=FALSE;

	/*
	 * Going to check the arguments
	 */
	while ((val=getopt_long (argn, argv, "hg:v", long_options, &index))!=EOF)
		switch (val)
		{
			case 'g':
				gid=(tcfs_gid_t)atoi(optarg);
				if (!gid && optarg[0]!='0') /* group name given */
				{
					struct group *group_id;

					group_id=getgrnam(optarg);
					if (!group_id)
						tcfs_error (ER_CUSTOM, "Nonexistent group.");
					gid=group_id->gr_gid;
				}

				have_gid=TRUE;
				break;
			case 'h':
				show_usage (usage, argv[0]);
				exit (OK);
			case 'v':
				be_verbose=TRUE;
				break;
			default:
				fprintf (stderr, "Try %s --help for more informations.\n", argv[0]);
				exit (ER_UNKOPT);
		}

	if (argn-optind)
		tcfs_error (ER_UNKOPT, NULL);

	if (!have_gid)
	{
		char *buff=NULL;

		buff=(char*)calloc(2048, sizeof(char));
		if (!buff)
			tcfs_error (ER_MEM, NULL);

		printf ("Group id of the TCFS group to remove from the database: ");
		gets (buff);
		gid=(tcfs_gid_t)atoi(buff);

		if (!gid && optarg[0]!='0') /* group name given */
		{
			struct group *group_id;

			group_id=getgrnam(optarg);
			if (!group_id)
				tcfs_error (ER_CUSTOM, "Nonexistent group.");
			gid=group_id->gr_gid;
		}

		if (gid<=0)
			tcfs_error (ER_CUSTOM, "A positive ID please!");

		free (buff);
	}

	if (!tcfs_rmgroup (gid))
		tcfs_error (ER_CUSTOM, "Wrong ID or an error as occurred.\n");
}
