/*
 * T.C.F.S. Utils 2.0 $Revision: 1.12 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33-tcfs/fs/tcfs/contrib/utils/src/RCS/tcfsrmkey.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.12 $
 *       $Author: anidel $
 *         $Date: 1998/01/19 14:12:28 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfsrmkey.c,v 1.12 1998/01/19 14:12:28 anidel Exp $";
/* -+-_== */ 

#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <strings.h>

#include "tcfserrors.h"
#include "tcfslib.h"

static struct option long_options[]=
{
	{ "--force", 0, NULL, 'f' },
	{ "--help", 0, NULL, 'h' },
	{ 0, 0, 0, 0 }
};

char *usage="Usage: %s [OPTION]
Decrement key counter, or remove key (-f), from the kernel.

  -f [--force]     Removes the key from the kernel, if possible
  -h [--help]      Shows this help\n";

int main (int argn, char *argv[])
{
	int index, val, setzero=FALSE;
	char *user, *passwd;

	/*
	 * Going to check command lines arguments
	 */
	while ((val=getopt_long (argn, argv, "fh", long_options, &index))!=EOF)
		switch (val)
		{
			case 'f':
				setzero=TRUE;
				break;
			case 'h':
				show_usage (usage, argv[0]);
				exit (OK);
				break;
			default:
				exit (ER_UNKOPT);
				break;
		}

	if (argn-optind)
		tcfs_error (ER_UNKOPT, NULL);

#ifdef SECURE_LOGOUT
	if (!unix_auth (&user, &passwd))
		tcfs_error (ER_AUTH, user);
#else
	if (!getlogin())
		tcfs_error (ER_USER, NULL);
	
	user=(char*)calloc(MAXUSERLOGIN_LEN, sizeof(char));
	strcpy (user, getlogin());
#endif

	/* TODO: implement --force */
	tcfs_disable (user, setzero?ALL:ONE);
	tcfs_error (OK, NULL);
}
