/*
 * T.C.F.S. Utils 2.0 $Revision: 1.4 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33/fs/tcfs/contrib/utils/lib/RCS/md5_if.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.4 $
 *       $Author: luicat $
 *         $Date: 1998/01/23 09:35:08 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: md5_if.c,v 1.4 1998/01/23 09:35:08 luicat Exp $";
/* -+-_== */ 

/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 *  MD5 interface module between sec_hash, sec_sign, sec_verify and
 *  the "RSA Data Security, Inc. MD5 Message Digest Algorithm"
 *  Reference C version
 *
 *  WS 11.7.91
 *
 *  Last change: 11.7.91
 *
 *  Imports from RSADSI:
 *
 *  MD5Init(mdContext)
 *  MD5Update(mdContext, inBuf, inLen)
 *  MD5Final(mdContext)
 *
 *  Exports to libdes.a or libSECUDE.a:
 *
 *  md5_hash(in_octets, hash_result, more)
 *
 */

#include "md5.h"

/***************************************************************
 *
 * Procedure md5_hash
 *
 ***************************************************************/
#ifdef __STDC__

RC md5_hash(
	OctetString	 *in_octets,
	OctetString	 *hash_result,
	More		  more
)

#else

RC md5_hash(
	in_octets,
	hash_result,
	more
)
OctetString	 *in_octets;
OctetString	 *hash_result;
More		  more;

#endif

{
        static char first = TRUE;
        static MD5_CTX mdContext;
	unsigned char digest[16];

        if(first) {
                MD5Init(&mdContext);
                first = FALSE;
        }
        MD5Update(&mdContext, in_octets->octets, in_octets->noctets);

        if(more == SEC_END) {
                first = TRUE;
                MD5Final(digest, &mdContext);
                /* memory of hash_result->octets provided by calling program */
                bcopy(&digest[0], hash_result->octets, 16);
                hash_result->noctets = 16;
        }
        return(0);
}
