/*
 * T.C.F.S. 2.0.1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */
#ifndef _TCFS_FS_I
#define _TCFS_FS_I

#include <linux/tcfs.h>
#include <linux/pipe_fs_i.h>
#include <asm/semaphore.h>
/*
 * tcfs fs inode data in memory
 */
struct tcfs_inode_info {
	struct pipe_inode_info pipeinfo;
	struct tcfs_fh fhandle;
	/*
	 * read_cache_jiffies is when we started read-caching this inode,
	 * and read_cache_mtime is the mtime of the inode at that time.
	 *
	 * We need to invalidate the cache for this inode if
	 *
	 *	jiffies - read_cache_jiffies > 30*HZ
	 * AND
	 *	mtime != read_cache_mtime
	 */
	unsigned long read_cache_jiffies;
	unsigned long read_cache_mtime;
	/*
	 * This is to support the clandestine rename on unlink.
	 * Instead of the directory inode, we might as well keep its
	 * TCFS FH, but that requires a kmalloc.
	 */
	struct inode *silly_rename_dir;
	/*
	 * attrtimeo defines for how long the cached attributes are valid
	 */
	unsigned int readcount;
	unsigned long attrtimeo;
	char pathname[TCFS_MAXPATHLEN+1];
	union {
		unsigned int cflag; 
		struct {
			unsigned int ext2:7;
			unsigned int mb:1;
			unsigned int spure:3;
			unsigned int unknow:21;
		} bf;
	} tcfs_fl;
	struct semaphore mutex;
	struct semaphore wrt;
};

#endif
