
#include <linux/autoconf.h>
#ifdef TCFS_IDEA

#define _LINUX_IDEA_IF
#include<linux/idea.h>

#ifdef __STDC__
unsigned idea_mod (int num, unsigned int modulo)
#else
unsigned idea_mod (num, modulo)
int num;
unsigned modulo;
#endif
{
  register int eax asm ("ax");
  register int edx asm ("dx");
  unsigned long tmp=modulo;
  
  if (num < 0)
    {
      while (num < 0)
	num += modulo;
      return num;
    }
  
  eax = num;
  edx = 0;
  
  __asm__ ("divl %2"
	   :"=a" (eax), "=d" (edx)
	   :"r" (tmp),
	   "0" (eax), "1" (edx));
  
  return (unsigned) edx;
}

#ifdef __STDC__
void cip_octets(
	unsigned char	 *outblock,
	unsigned Z[7][10]
)
#else
void cip_octets(
	outblock,
	Z
)
unsigned char	 *outblock;
unsigned Z[7][10];
#endif
{
	unsigned IN[5];
	unsigned OUT[5];
	int i;

	for(i=0;i<4;i++) IN[i+1] = outblock[2*i]+outblock[2*i+1]*0x100;

	idea_cip(IN, OUT, Z);

	for(i=0;i<4;i++) {
		outblock[2*i] = idea_mod (OUT[i+1],  0x100);
		OUT[i+1] /= 0x100;
		outblock[2*i+1] = idea_mod (OUT[i+1], 0x100);
	}

}


#ifdef __STDC__
void idea_set_key(char *key,idea_key_schedule *schedule)
#else
void idea_set_key(key,schedule)
char *key;
idea_key_schedule *schedule;
#endif
{
	idea_key(key, (unsigned *)schedule[0]);
	idea_de_key((unsigned *)schedule[0], (unsigned *)schedule[1]);
}

#ifdef __STDC__
void idea_encrypt(char *inout, idea_key_schedule e_key)
#else
void idea_encrypt(inout,e_key)
char *inout;
idea_key_schedule e_key;
#endif
{
  register int	i;
  
  cip_octets((unsigned char *)inout, (unsigned *)e_key);
}

#ifdef __STDC__
void idea_decrypt(char *inout, idea_key_schedule d_key)
#else
void idea_decrypt(inout, d_key)
char *inout;
idea_key_schedule d_key;
#endif

{
  register int	i;
  
  cip_octets((unsigned char *)inout, (unsigned *)d_key);
}

#endif
