/*
 * T.C.F.S. v. 2.0
 *
 * passwd.c  -  change password on an account 
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <termios.h>
#include <pwd.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include "tcfscode.h"
#include "defines.h"
#include "linux/kdes.h"

#define ascii_to_bin(c) ((c)>='a'?(c-59):(c)>='A'?((c)-53):(c)-'.')
#define bin_to_ascii(c) ((c)>=38?((c)-38+'a'):(c)>=12?((c)-12+'A'):(c)+'.')

int main(argc,argv)
	int argc;
	char *argv[];
{
	struct passwd *pe;
	uid_t gotuid = getuid();
	char *pwdstr, *cryptstr;
	char pwdstr1[10];
	int ucase, lcase, other;
	char *p, *q, *user, *key, *cryptedkey;
	time_t tm;
	char salt[2];
	char tcfspwdold[1024];
	FILE *fp, *tcfstmp, *tcfspwd;
	int r;
	des_key_schedule ks;

	umask(022);

	if(argc > 2) {
		puts("Too many arguments");
		exit(1);
	} else if(argc == 2) {
		if(gotuid) {
			puts("Only root can change the password for others");
			exit(1);
		}
		user = argv[1];
	} else {
		user = getlogin();
	}
	if(!(pe = getpwnam(user))) {
		puts("Can't find username in password file?!");
		exit(1);
	}

	/* if somebody got into changing utmp... */
	if(gotuid && gotuid != pe->pw_uid) {
	    puts("UID and username does not match, imposter!");
	    exit(1);
	}

	if(gotuid && pe->pw_passwd && pe->pw_passwd[0]) {
		pwdstr = getpass("Enter old password: ");
		if(strncmp(pe->pw_passwd, crypt(pwdstr, pe->pw_passwd), 13)) {
			puts("Illegal password, imposter.");
			exit(1);
		}
	}
	
	strncpy (tcfspwdold, pwdstr, strlen(pwdstr));

redo_it:
	pwdstr = getpass("Enter new password: ");
	strncpy(pwdstr1, pwdstr, 9);
	pwdstr = getpass("Re-type new password: ");

	if(strncmp(pwdstr, pwdstr1, 8)) {
		puts("You misspelled it. Password not changed.");
		exit(0);
	}
	
	if((strlen(pwdstr) < 6) && gotuid) {
		puts("The password must be at least 6 chars, try again.");
		goto redo_it;
	}
	
	other = ucase = lcase = 0;
	for(p = pwdstr; *p; p++) {
		ucase = ucase || isupper(*p);
		lcase = lcase || islower(*p);
		other = other || !isalpha(*p);
	}
	
	if((!ucase || !lcase) && !other && gotuid) {
		puts("The password must have both upper- and lowercase");
		puts("letters, or non-letters; try again.");
		goto redo_it;
	}
	
	r = 0;
	for(p = pwdstr, q = pe->pw_name; *q && *p; q++, p++) {
	  if(tolower(*p) != tolower(*q)) {
	    r = 1;
	    break;
	  }
	}

	for(p = pwdstr + strlen(pwdstr)-1, q = pe->pw_name;
	    *q && p >= pwdstr; q++, p--) {
	  if(tolower(*p) != tolower(*q)) {
	    r += 2;
	    break;
	  }
	}
	  
	if(gotuid && r != 3) {
	  puts("Please don't use something like your username as password!");
	  goto redo_it;
	}

	/* do various other checks for stupid passwords here... */

	time(&tm);
	salt[0] = bin_to_ascii(tm & 0x3f);
	salt[1] = bin_to_ascii((tm >> 5) & 0x3f);
	cryptstr = crypt(pwdstr, salt);
	
	if(access("/etc/ptmp", 0) == 0) {
		puts("/etc/ptmp exists, can't change password");
		exit(1);
	}
	
	if(!(fp = fopen("/etc/ptmp", "w"))) {
		puts("Can't open /etc/ptmp, can't update password");
		exit(1);
	}

	setpwent();
	while((pe = getpwent())) {
		if (!strcmp(user, pe->pw_name)) {
			pe->pw_passwd = cryptstr;
		}
		if(putpwent(pe, fp) < 0) {
			puts("Error while writing new password file, password not changed.");
			fclose(fp);
			endpwent();
			unlink("/etc/ptmp");
			exit(1);
		}
	}
	fclose(fp);
	endpwent();

	if(access("/etc/tcfstmp", 0) == 0)
	{
		puts("/etc/tcfstmp exists, can't update key file");
		exit(1);
	}
	
	if(!(tcfstmp = fopen("/etc/tcfstmp", "w")))
	{
		puts("Can't open /etc/tcfstmp, can't update key file");
		exit(1);
	}

	tcfspwd=fopen (TCFSPWDFILE, "r");
	
	while (!feof(tcfspwd))
	{
		char entry[50];
		
		fgets (entry, 50, tcfspwd);
		if (feof (tcfspwd))
			break;

		if (strncmp(entry, user, strlen(user))!=0)
			fwrite (entry, 1, strlen(entry), tcfstmp);
		else
		{
			int len;

			(void)strtok(entry,":");
			cryptedkey=strtok(NULL, ":");

			key=tcfs_decode (cryptedkey, &len);
			
			if (strlen (tcfspwdold)<8)
				strncat (tcfspwdold, tcfspwdold, 10-strlen(tcfspwdold));

			des_set_key ((des_cblock *)tcfspwdold, ks);
			des_ecb_encrypt ((des_cblock *)key, (des_cblock *)key, ks, DES_DECRYPT);

			if (strlen (pwdstr)<8)
				strncat (pwdstr, pwdstr, 128-strlen(pwdstr));

			des_set_key ((des_cblock *)pwdstr, ks);
			des_ecb_encrypt ((des_cblock *)key, (des_cblock *)key, ks, DES_ENCRYPT);

			key=tcfs_encode(key, strlen(key));
			fprintf (tcfstmp, "%s:%s\n", user, key);
		}			
	}
	
	sprintf (tcfspwdold, "%s.OLD", TCFSPWDFILE);
	unlink(tcfspwdold);
	link(TCFSPWDFILE, tcfspwdold);
	unlink(TCFSPWDFILE);
	link("/etc/tcfstmp", TCFSPWDFILE);
	unlink("/etc/tcfstmp");
	chmod(TCFSPWDFILE, 0644);

	unlink("/etc/passwd.OLD");
	link("/etc/passwd", "/etc/passwd.OLD");
	unlink("/etc/passwd");
	link("/etc/ptmp", "/etc/passwd");
	unlink("/etc/ptmp");
	chmod("/etc/passwd", 0644);

	puts("Password changed.");	
	exit(0);
}
