/*
 * T.C.F.S. 2.0 Alpha 1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */

#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/tcfs_fs.h>
#include <linux/stat.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/string.h>

#include <asm/segment.h>

static int tcfs_readlink(struct inode *, char *, int);
static int tcfs_follow_link(struct inode *, struct inode *, int, int,
			   struct inode **);

/*
 * symlinks can't do much...
 */
struct inode_operations tcfs_symlink_inode_operations = {
	NULL,			/* no file-operations */
	NULL,			/* create */
	NULL,			/* lookup */
	NULL,			/* link */
	NULL,			/* unlink */
	NULL,			/* symlink */
	NULL,			/* mkdir */
	NULL,			/* rmdir */
	NULL,			/* mknod */
	NULL,			/* rename */
	tcfs_readlink,		/* readlink */
	tcfs_follow_link,	/* follow_link */
	NULL,			/* readpage */
	NULL,			/* writepage */
	NULL,			/* bmap */
	NULL,			/* truncate */
	NULL			/* permission */
};

static int tcfs_follow_link(struct inode *dir, struct inode *inode,
			   int flag, int mode, struct inode **res_inode)
{
 	int error, *mem;
	unsigned int len;
	char *res, *res2;

	*res_inode = NULL;
	if (!dir) {
		dir = current->fs->root;
		dir->i_count++;
	}
	if (!inode) {
		iput(dir);
		return -ENOENT;
	}
	if (!S_ISLNK(inode->i_mode)) {
		iput(dir);
		*res_inode = inode;
		return 0;
	}
	if (current->link_count > 5) {
		iput(inode);
		iput(dir);
		return -ELOOP;
	}
	error = tcfs_proc_readlink(TCFS_SERVER(inode), TCFS_FH(inode), &mem,
		&res, &len, TCFS_MAXPATHLEN);
	if (error) {
		iput(inode);
		iput(dir);
		kfree(mem);
		return error;
	}
	while ((res2 = (char *) kmalloc(TCFS_MAXPATHLEN + 1, GFP_NFS)) == NULL) {
		schedule();
	}
	memcpy(res2, res, len);
	res2[len] = '\0';
	kfree(mem);
	iput(inode);
	current->link_count++;
	error = open_namei(res2, flag, mode, res_inode, dir);
	current->link_count--;
	kfree_s(res2, TCFS_MAXPATHLEN + 1);
	return error;
}

static int tcfs_readlink(struct inode *inode, char *buffer, int buflen)
{
	int error, *mem;
	unsigned int len;
	char *res;

	if (!S_ISLNK(inode->i_mode)) {
		iput(inode);
		return -EINVAL;
	}
	if (buflen > TCFS_MAXPATHLEN)
		buflen = TCFS_MAXPATHLEN;
	error = tcfs_proc_readlink(TCFS_SERVER(inode), TCFS_FH(inode), &mem,
		&res, &len, buflen);
	iput(inode);
	if (! error) {
		memcpy_tofs(buffer, res, len);
		put_user('\0', buffer + len);
		error = len;
	}
	kfree(mem);
	return error;
}
