/*
 * S.F.S. v. 0.5alpha-linux
 *
 * keyboard     get the digit to bild the sfs-passwd.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <stdio.h>
#include <sys/time.h>
#include <termios.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>

#ifdef SECUDEDES
#include <af.h>
#else
#include "d3des.h"
#endif

#include "genkey.h"
#include "defines.h"

char *gendeskey (void)
{
	int kcount=0;
	struct timeval tempo;
	struct termios oldtty, newtty;
	char *buff;
	OctetString *in, *res;
	
	buff=(char*)calloc(100,sizeof(char));

	if (tcgetattr (0, &oldtty)<0)
	{
		fprintf (stderr, "This is not a terminal!!\n");
		exit (1);
	}
	bcopy (&oldtty, &newtty, sizeof (struct termios));
	newtty.c_lflag &= ~ICANON;
	newtty.c_lflag &= ~ECHO;
	newtty.c_cc[VMIN]=1;
	newtty.c_cc[VTIME]=0;
	printf ("press 10 keys:");
	fflush (stdout);
	if (tcsetattr (0, TCSANOW, &newtty)<0)
	{
		perror ("Error setting terminal attributes");
		exit (1);
	}

	while (kcount<10)
	{
		char c=0;
		if (read(0, &c, 1)==1)
		{
			int i;
			struct timeval oldtempo;
	
			oldtempo.tv_sec=tempo.tv_sec;
			oldtempo.tv_usec=tempo.tv_usec;
			gettimeofday(&tempo, NULL);
			*(buff+kcount*9)=c;
			bcopy ((long*)&tempo.tv_sec, (char*)(buff+kcount*9+1), 4);
			tempo.tv_sec-=oldtempo.tv_sec;
			bcopy ((long*)&tempo.tv_sec, (char*)(buff+kcount*9+5), 4);
			printf("*");
			fflush (stdout);
			kcount++;
		}
	}

	if (tcsetattr (0, TCSANOW, &oldtty)<0)
	{
		perror ("Error while resetting terminal");
		exit (1);
	}

	printf ("\nOk.\n");
	in=(OctetString*)malloc(sizeof(OctetString));
	res=(OctetString*)malloc(sizeof(OctetString));
	res->octets=(char*)calloc(16,sizeof(char));
	in->octets=buff;
	in->noctets=6;
	md5_hash (in, res, SEC_END);

#ifdef SECUDEDES
	desinit(DESMETHOD, D3DES);
	setkey_(res->octets);
	endes(buff);
	setkey_(res->octets+KEYSIZE);
	dedes(buff);
	setkey_(res->octets);
	endes(buff);
#else
	deskey (res->octets, EN0);
	desd3 (buff, buff);
	deskey (res->octets+KEYSIZE, DE1);
	desd3(buff, buff);
	deskey (res->octets, EN0);
	desd3 (buff, buff);
#endif

	*(buff+KEYSIZE)='\0';
	free(res->octets);
	free(res);
	free(in);
	return buff;
}
