/*
 * S.F.S. v. 0.5alpha-linux
 *
 * uid.c: hash-table for the user - criptation key couples.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */
/* 	$Id: uid.c,v 1.2 1996/02/19 10:50:19 andcoz Exp $	 */

#ifndef lint
static char vcid[] = "$Id: uid.c,v 1.2 1996/02/19 10:50:19 andcoz Exp $";
#endif /* lint */

#include <stdio.h>
#include <strings.h>
#include "uid.h"

#define MODULE_FSKEYTABLE 16

typedef struct fskeytable_t{
  uid_t uid;
  char *key;
  struct fskeytable_t *next; 
} fskeytable_t;

static fskeytable_t *fskeytable=NULL;
static fskeytable_t *fskeyendtable;

static fskeytable_t *find_fskey(uid_t uid);
static int point_fskey(uid_t uid);
static fskeyerror_t init_fskey();

char *fskey(uid_t uid)
{
  fskeytable_t *temp;

  if (fskeytable==NULL) init_fskey();
  return ((temp=find_fskey(uid))==NULL?NULL:temp->key);
}

fskeyerror_t set_fskey(uid_t uid, char* key)
{
  fskeytable_t *oldkey;
  fskeytable_t *find;

  if (fskeytable==NULL) init_fskey();

  if ((oldkey=find_fskey(uid))!=NULL)
    {
      memcpy(oldkey->key, key, 8);
      return 0;
    }
  /* ELSE */

  if((find=fskeytable+point_fskey(uid))->key==NULL)
    {
      if (find->key=(char *) malloc(sizeof(char)*8))
        {
          find->uid=uid;
          memcpy(find->key, key, 8);
          return 0;
        }
      else
        {
          return E_NoMemLeft;
        }
    }
  /* ELSE */
  
  for (;
       (find->uid!=uid)&&(find->next!=NULL);
       find=find->next)
    ;

  if (((find->next)=(fskeytable_t *) malloc(sizeof(fskeytable_t)))!=NULL)
    {
      if (((find->next->key)=(char *) malloc(sizeof(char)*8))!=NULL)
        {
          find->next->uid=uid;
          memcpy(find->next->key, key, 8);
          return 0;
        }
      else
        {
          return E_NoMemLeft;
        }
    }
  /* ELSE */

  return E_NoMemLeft;
}

fskeyerror_t del_fskey(uid_t uid)
{
  fskeytable_t *find, *tmp, *pre=NULL;

  for (find=fskeytable+point_fskey(uid);
       (find->uid!=uid)&&(find->next!=NULL);
       pre=find, find=find->next)
    ;

  if ((find->uid)!=uid)
    {
      return E_NotFound;
    }
  /* ELSE */

  if (pre==NULL)
    {
      if (find->next!=NULL)
        {
          memcpy(find->key, find->next->key, 8);
          find->uid=find->next->uid;
          tmp=find->next;
          find->next=find->next->next;
          free(tmp);
        }
      else
        {
          bzero(find, sizeof(fskeytable_t));
        }
    }
  else
    {
      pre->next=find->next;
      free(find);
    }

  return 0;

}

static fskeytable_t *find_fskey(uid_t uid)
{
  fskeytable_t *find;

  for (find=fskeytable+point_fskey(uid);
       (find->uid!=uid)&&(find->next!=NULL);
       find=find->next)
    ;

  if ((find->uid)==uid)
    return (find);
  else
    return (NULL);
}

static int point_fskey(uid_t uid)
{
  return (uid%MODULE_FSKEYTABLE);
}

static fskeyerror_t init_fskey()
{
  fskeytable=(fskeytable_t *) malloc(sizeof(fskeytable_t)*MODULE_FSKEYTABLE);
  bzero(fskeytable, sizeof(fskeytable_t)*MODULE_FSKEYTABLE);
}

