/*
 * S.F.S. v. 0.5alpha-linux
 *
 * nfsd.h: This program implements a user-space NFS server.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 * This code derives from: 
 *		 The LINUX User-Space NFS Server 1.5
 *	    by Mark Shand, Donald J. Becker, Rick Sladkey,
 *		 Orest Zborowski, Fred N. van Kempen 
 */

/*
 * nfsd.h	This program implements a user-space NFS server.
 *
 * Authors:	Mark A. Shand, May 1988
 *		Rick Sladkey, <jrs@world.std.com>
 *		Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *
 *		Copyright 1988 Mark A. Shand
 *		This software maybe be used for any purpose provided
 *		the above copyright notice is retained.  It is supplied
 *		as is, with no warranty expressed or implied.
 */

#include "system.h"

#include "mount.h"
#include "tcfs_prot.h"

union argument_types {
	nfs_fh			nfsproc_getattr_2_arg;
	sattrargs		nfsproc_setattr_2_arg;
	diropargs		nfsproc_lookup_2_arg;
	nfs_fh			nfsproc_readlink_2_arg;
	readargs		nfsproc_read_2_arg;
	writeargs		nfsproc_write_2_arg;
	createargs		nfsproc_create_2_arg;
	diropargs		nfsproc_remove_2_arg;
	renameargs		nfsproc_rename_2_arg;
	linkargs		nfsproc_link_2_arg;
	symlinkargs		nfsproc_symlink_2_arg;
	createargs		nfsproc_mkdir_2_arg;
	diropargs		nfsproc_rmdir_2_arg;
	readdirargs		nfsproc_readdir_2_arg;
	nfs_fh			nfsproc_statfs_2_arg;
	getextatargs		nfsproc_getextat_2_arg;
	setextatargs		nfsproc_setextat_2_arg;
};

union result_types {
	attrstat		attrstat;
	diropres		diropres;
	readlinkres		readlinkres;
	readres			readres;
	nfsstat			nfsstat;
	readdirres		readdirres;
   	statfsres		statfsres;
};

typedef struct options {
	enum {map_daemon, identity}
				uidmap;		/* uid/gid mapping functions */
	int			root_squash;
	int			secure_port;	/* client options */
	int			read_only;
	int			link_relative;
} options;

typedef struct clnt_param {
	struct clnt_param	*next;
	struct in_addr		clnt_addr;
	char			*clnt_name;
	char			*mount_point;
	options			o;
} clnt_param;

/* Global variables. */
extern union argument_types	argument;
extern union result_types	result;

/* Include the other module definitions. */
#ifdef __STDC__
#   define _PRO(f, a)	f a
#else
#   define _PRO(f, a)	f ()
#endif
#include "auth.h"
#include "fh.h"
#include "logging.h"

/* Global Function prototypes. */
extern _PRO( void mallocfailed, (void)					);
extern _PRO( nfsstat getattr, (nfs_fh *fh, fattr *attr,			\
			       struct stat *stat_optimize)		);

#ifndef HAVE_REALPATH
extern _PRO( char *realpath, (const char *path, char *resolved_path)	);
#endif /* HAVE_REALPATH */

#ifndef HAVE_STRERROR
extern _PRO( char *strerror, (int errnum)				);
#endif /* HAVE_STRERROR */

/* End of nfsd.h. */
