#!/bin/csh -f

#
# $Id: xmst_start.sh,v 1.36 1995/01/09 14:04:44 koletzki Exp $
#
# $Log: xmst_start.sh,v $
#


#*******************************************************************
# Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
#                                                                  *
#                                                                  *
#                         NOTICE                                   *
#                                                                  *
#    Acquisition, use, and distribution of this module             *
#    and related materials are subject to restrictions             *
#    mentioned in each volume of the documentation.                *
#                                                                  *
#*******************************************************************

#-------------------------------------------------------------------
# Start script for xmst users without Motif environment
#-------------------------------------------------------------------

setenv SECUDE /usr/local/secude
setenv ISODE /usr/local/ICR1/IC/isode

uname -r | egrep -s 5
if ($status == 0) then
	set SOL2
else
	set SOL1
endif

if ( $?SOL1 ) then
	setenv MOTIF /usr/local/motif1.2.1
else
	setenv MOTIF /usr/local/SDK/SUNWmotif
endif
if ( $?SOL1 ) then
	setenv OPENWINHOME /usr/local/openwin3
else
	setenv OPENWINHOME /usr/openwin
endif
	
if ( ! $?XAPPLRESDIR ) then 
	setenv XAPPLRESDIR $OPENWINHOME/lib/app-defaults
	if ( ! -d $XAPPLRESDIR ) then
		setenv XAPPLRESDIR /usr/local/lib/X11/app-defaults
	endif
endif
if ( $?SOL2 ) then
	setenv XLIBDIR /usr/local/X11R5/lib/X11
	setenv XMBINDIR $MOTIF/etc/key_bindings
	setenv XKEYSYMDB /usr/local/X11R6/lib/X11/XKeysymDB
	setenv XFILESEARCHPATH $MOTIF/lib/%T/%N%S
else
	setenv XLIBDIR $OPENWINHOME/lib/X11
	setenv XKEYSYMDB $OPENWINHOME/lib/X11/XKeysymDB
	setenv XMBINDIR $MOTIF/SRC/motif/X11/motif_bindings
	setenv XFILESEARCHPATH $MOTIF/lib/X11/%T/%N%S
endif

setenv UIDPATH $SECUDE/lib/X11/%U
setenv LD_LIBRARY_PATH /usr/lib:$MOTIF/lib:/usr/local/X11R5/lib:$OPENWINHOME/lib:$SECUDE/lib:$ISODE/lib
setenv PATH $SECUDE/bin:$PATH

exec $SECUDE/bin/xmst $*


