/* ./src/util/xmsectool/xmst.c */

static char *rcsid = "$Id: xmst.c,v 1.30 1995/03/16 14:43:18 koletzki Exp $";

/*
 * $Id: xmst.c,v 1.30 1995/03/16 14:43:18 koletzki Exp $
 *
 * $Log: xmst.c,v $
 * 	configuration
 * 	properties
 * 	clipboard
 *
 * Revision 1.19  1994/12/15  17:26:41  nuessler
 * Included:
 * - struct of xmst-shells with certain options
 * - array of this struct
 * - inititalize the array
 *
 * Revision 1.18  1994/12/09  16:58:35  nuessler
 * There is an nicer and better busy - and think
 * Cursor function called setCursor
 *
 * Revision 1.17  1994/12/09  15:13:00  koletzki
 * *** empty log message ***
 *
 * Revision 1.16  1994/11/24  18:15:56  koletzki
 * *** empty log message ***
 *
 * Revision 1.15  1994/11/14  18:29:33  koletzki
 * Color & font resources
 *
 * Revision 1.14  1994/11/11  16:17:02  nuessler
 * rename dir500bwr to d5bwr
 *
 * Revision 1.13  1994/11/11  13:32:47  koletzki
 * using af_x500_check now
 *
 * Revision 1.12  1994/11/11  11:10:16  koletzki
 * some changes for proper installation in /usr/local/secude
 *
 * Revision 1.11  1994/11/04  15:44:24  koletzki
 * Refresh-Button:
 * 	re-open current PSE, re-read objects
 *
 * Revision 1.10  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.9  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 *
 */

/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/*
 ************************
 *	includes	*
 ************************
 */

#include "xmst.h"
#include "xmst_icons.h"



/*
 ************************
 *	statics		*
 ************************
 */

static char	*uidVersion;

static void	usage();
static void	init_toolkits();
static void	get_selfdef_resources();
static void	init_uil();
static void	modify_dialogs();
static void	init_secude();
static void	open_sectool();


/*
 *	Resource list (self defined)
 */
static XtResource	xmstResources[] = 
		{
/* Busy Cursor */	{ 	XmstNbusycursor, "Cursor",		/* name, class         */
			  	XmRCursor, sizeof(Cursor),		/* type, size          */
			  	XtOffset(ApplResType *, busycursor),	/* offset              */
			  	XmRCursor, (XtPointer)NULL		/* default type, value */
			},
/* Think Cursor */	{ 	XmstNthinkcursor, "Cursor",
			  	XmRCursor, sizeof(Cursor),
			  	XtOffset(ApplResType *, thinkcursor),
			  	XmRCursor, (XtPointer)NULL
			},
/* Focus Color */	{ 	XmstNfocuscolor, "Pixel",			
			  	XmRPixel, sizeof(Pixel),			
			  	XtOffset(ApplResType *, focuscolor),		
			  	XmRPixel, (XtPointer)NULL			
			},
/* Active List Color */	{ 	XmstNactivelistcolor, "Pixel",			
			  	XmRPixel, sizeof(Pixel),			
			  	XtOffset(ApplResType *, activelistcolor),
			  	XmRPixel, (XtPointer)NULL		
			}
		};


/*
 *	Resource list (fallbacks)
 */
static String		xmstFallbacks[] = 
	{
/* Resizable shells */	"XMst.geometry:				555x666+50+50",
			"XMst*guide_dialog.geometry:		400x300+100+100",
			"XMst*viewer_dialog.geometry:		400x300+110+110",
			"XMst*debug_dialog.geometry:		400x300+120+120",
			"XMst*clipboard_dialog.geometry:	400x300+130+130",
			"XMst*alias_dialog.geometry:		400x300+140+140",
			"XMst*d5bwr_dialog.geometry:		400x300+150+150",
/* Non-resizable sh. */ "XMst*file_dialog.geometry:		400x300+160+160",
			"XMst*secude_dialog.geometry:		400x300+170+170",
			"XMst*crypt_dialog.geometry:		400x300+180+180",
			"XMst*config_dialog.geometry:		400x300+190+190",
			
/* General */           "XMst*st_transient_toggle.set:		true",
			"XMst*st_beep_toggle.set:		true",
			"XMst*st_useeditor_toggle.set:		false",
			
/* Nice level */	"XMst*st_nicelow_toggle.set:		false",
			"XMst*st_nicemedium_toggle.set:		true",
			"XMst*st_nicehigh_toggle.set:		false",
			
/* PSE name */   	"XMst*config_psename_textfield.value:	.pse",
			
/* SmartCard */  	"XMst*st_autodetect_toggle.set:		true",
			"XMst*st_softrsa_toggle.set:		true",
			
/* Security */  	"XMst*st_crypt_clipboard_toggle.set:	true",
			"XMst*st_consultcrl_toggle.set:		false",
			"XMst*st_trustfcpath_toggle.set:	false",
			"XMst*st_nosubordination_toggle.set:	false",
			"XMst*st_pserandom_toggle.set:		false",
			
/* Directory */ 	"XMst*st_accessdir_toggle.set:		false",
			"XMst*st_authnone_toggle.set:		true",
			"XMst*st_authsimple_toggle.set:		false",
			"XMst*st_authstrong_toggle.set:		false",
			
			NULL
	};




/*
 *	UIL Names
 */
static MrmRegisterArg	applicationRegvec[] =
		{

/*
 *	INCLUDES
 */
#include "st_callb.h"
#include "ae_callb.h"
#include "d5_callb.h"
#include "su_callb.h"


/* dialogs */		{ "pin_dialog_cb", (caddr_t)pin_dialog_cb },
			{ "chpin_dialog_cb", (caddr_t)chpin_dialog_cb },
			{ "addalias_dialog_cb", (caddr_t)addalias_dialog_cb },
			{ "ok_dialog_cb", (caddr_t)ok_dialog_cb },
			{ "error_dialog_cb", (caddr_t)error_dialog_cb },
			{ "warning_dialog_cb", (caddr_t)warning_dialog_cb },
			{ "question_dialog_cb", (caddr_t)question_dialog_cb },
			{ "debug_dialog_cb", (caddr_t)debug_dialog_cb },
			{ "guide_dialog_cb", (caddr_t)guide_dialog_cb },
			{ "viewer_dialog_cb", (caddr_t)viewer_dialog_cb },
			{ "viewer_clear_cb", (caddr_t)viewer_clear_cb },
			{ "viewer_print_cb", (caddr_t)viewer_print_cb },
			{ "otheraliases_dialog_cb", (caddr_t)otheraliases_dialog_cb },
			{ "file_dialog_cb", (caddr_t)file_dialog_cb },
			{ "file_selection_dialog_cb", (caddr_t)file_selection_dialog_cb },
			{ "file_object_selection_dialog_cb", (caddr_t)file_object_selection_dialog_cb },
			{ "crypt_selection_cb", (caddr_t)crypt_selection_cb },
			{ "crypt_sct_toggle_cb", (caddr_t)crypt_sct_toggle_cb },
			{ "crypt_test_button_cb", (caddr_t)crypt_test_button_cb },
			{ "crypt_generate_button_cb", (caddr_t)crypt_generate_button_cb },
			{ "crypt_keysize_arrow_cb", (caddr_t)crypt_keysize_arrow_cb },
			{ "crypt_dialog_cb", (caddr_t)crypt_dialog_cb },
			{ "toolquit_dialog_cb", (caddr_t)toolquit_dialog_cb },
			{ "clipboard_dialog_cb", (caddr_t)clipboard_dialog_cb },
			{ "config_dialog_cb", (caddr_t)config_dialog_cb },
/* verificate */
			{ "verify_dialog_cb", (caddr_t)verify_dialog_cb },
/* pse_objsel_box */
			{ "pseobjselection_dialog_cb", (caddr_t)pseobjselection_dialog_cb },
			{ "pseobjselection_list_cb", (caddr_t)pseobjselection_list_cb },

/* misc */		{ "check_passwd_cb", (caddr_t)check_passwd_cb },
			{ "textfield_focus_cb", (caddr_t)textfield_focus_cb }
		};







/*
 ************************
 *	Main program	*
 ************************
 */

/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{


	xmst_argc = cnt;
	xmst_argv = parm;



	/*
	 *	Initialize Mrm/Xt/Context/Display/Arguments
	 */
	init_toolkits();


	/*
	 *	Read application resources from XMst / as command line options
	 */
	get_selfdef_resources();


	/*
	 *	Initialize UIL hierarchy
	 */
	init_uil();


	/*
	 *	Add Callbacks to / Change mwm behavior of dialogs
	 */
	modify_dialogs();


	/*
	 *	Initialize SecuDE interface
	 */
	init_secude();


	/*
	 *	Open PSE
	 */
	st_open_pse(CNULL);


	/*
	 *	Fill Base Widgets
	 */
	st_fill_widgets();

	
	/*
	 *	Not in Debug Mode: Drop stacked errors that happened during initialization
	 */
	if (!Debug) {

		aux_free_error();
		XmTextSetString(STWIDGET("*debug_text"), "");
	}


	/*
	 *  Loop and process events
	 */
	XtAppMainLoop(applicationContext);
}



/***************************************************************
 *
 * Procedure init_toolkits
 *
 ***************************************************************/
#ifdef __STDC__

static
void init_toolkits(
)

#else

static
void init_toolkits(
)

#endif

{
	Atom		WM_DELETE_WINDOW;

	/* initialize */
	XrmInitialize();
	MrmInitialize();
	
	
	/* language */
	XtSetLanguageProc(NULL, NULL, NULL);
	
	
	/* application */
	applicationShell = XtVaAppInitialize(	&applicationContext,
						"XMst",
						NULL,		0,
						&xmst_argc,	xmst_argv,
						xmstFallbacks,
						XmNtitle,	XMST_VERSION_LONG,
						XmNiconName,	XMST_VERSION,
						NULL);
	/* Display, Screen */
	display = XtDisplay(applicationShell);
	screen = XtScreen(applicationShell);
			
	xmstIcon = XCreateBitmapFromData(	display,
 						RootWindowOfScreen(screen),
  						(char *)xmst_icon_bits,
  						xmst_icon_width, xmst_icon_height);
 	xmstIconMask = XCreateBitmapFromData(	display,
 						RootWindowOfScreen(screen),
  						(char *)xmst_iconmask_bits,
  						xmst_iconmask_width, xmst_iconmask_height);
  	XtVaSetValues(	applicationShell,
  			XmNiconPixmap,	xmstIcon,
  			XmNiconMask,	xmstIconMask,
  			NULL);
   			
	/* settings for destruction by WM */
	add_destroy_callback(applicationShell, (caddr_t)st_destroy_cb); 

	/* Register new data structure for clipboard functions */
	XmClipboardRegisterFormat(	display,
					XMST_CRYPTED_CLIPBOARD_FORMAT,
					XMST_CLIPBOARD_FORMAT_LENGTH);
	XmClipboardRegisterFormat(	display,
					XMST_CLEAR_CLIPBOARD_FORMAT,
					XMST_CLIPBOARD_FORMAT_LENGTH);
	
}


/***************************************************************
 *
 * Procedure get_selfdef_resources
 *
 ***************************************************************/
#ifdef __STDC__

static
void get_selfdef_resources(
)

#else

static
void get_selfdef_resources(
)

#endif

{
	
	/* read all resources */
	XtGetApplicationResources(	applicationShell,
					&applResources,
					xmstResources, XtNumber(xmstResources),
					(Arg *)NULL, 0);


	/* set global variables */
	focus_color =		applResources.focuscolor;
	active_list_color =	applResources.activelistcolor;


}



/***************************************************************
 *
 * Procedure init_uil
 *
 ***************************************************************/
#ifdef __STDC__

static
void init_uil(
)

#else

static
void init_uil(
)

#endif

{
	Pixel			fgPixel, bgPixel;
	Dimension		width, height;
	XtPointer		pointer;
	MrmCode			mrm_type;
	int			i;
	
	


	/*
	 *	Open UIL Hierarchy/Register Names
	 */

	if (MrmOpenHierarchy(	1,
				applicationUidVector,
				NULL,	
	    			&applicationHierarchy) != MrmSUCCESS) {

		fprintf(stderr,
			"Can't find file xmst.uid in $UIDPATH, $XAPPLRESDIR/uid, or $HOME[/uid] !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}

	if (MrmRegisterNames(	applicationRegvec,
				XtNumber(applicationRegvec)) != MrmSUCCESS) {

    		fprintf(stderr, "Error in xmst.uid: Can't register names.\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}


	/*
	 *	Check Version of UID file
	 */

	if (MrmFetchLiteral(	applicationHierarchy,
				"xmstUIDVersion",
				display,
				(XtPointer) &uidVersion,
				&mrm_type) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch string xmstUIDVersion !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
	if (mrm_type != MrmRtypeChar8) {
	
		fprintf(stderr, "Error in xmst.uid: Value xmstUIDVersion is no string !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}

	if (strcmp(uidVersion, XMST_VERSION)) {
	
		fprintf(stderr, "Error in xmst.uid: Version %s found, needed version is %s !\n",
				 uidVersion, XMST_VERSION);
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}

	/*
	 *	Fetch Main Shell, Colors, Pixmaps
	 */

	if (MrmFetchWidget(	applicationHierarchy,
				"stMainShell",
				applicationShell,
				&stMainShell,
				&opaqueClass) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch stMainShell !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}


	/*
	 *	Status Picture Bitmaps
	 */
	if (MrmFetchColorLiteral(	applicationHierarchy,
					"pictureForegroundPixel",
					display,
					(Colormap)NULL,
					&fgPixel) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch pictureForegroundPixel !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
					
	XtVaGetValues(	applicationShell,
			XmNbackground, 	&bgPixel,
			NULL					);

	if (MrmFetchIconLiteral(	applicationHierarchy,
					"scvendorPicture",
					screen,
					display,
					fgPixel,
					bgPixel,
					&scvendorPixmap) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch scvendorPicture !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
		
	if (MrmFetchIconLiteral(	applicationHierarchy,
					"scPicture",
					screen,
					display,
					fgPixel,
					bgPixel,
					&scPixmap) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch scPicture !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
		
	if (MrmFetchIconLiteral(	applicationHierarchy,
					"psePicture",
					screen,
					display,
					fgPixel,
					bgPixel,
					&psePixmap) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch psePicture !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
		
	if (MrmFetchIconLiteral(	applicationHierarchy,
					"scpsePicture",
					screen,
					display,
					fgPixel,
					bgPixel,
					&scpsePixmap) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch scpsePicture !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
		
	if (MrmFetchIconLiteral(	applicationHierarchy,
					"onepairPicture",
					screen,
					display,
					fgPixel,
					bgPixel,
					&onepairPixmap) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch onepairPicture !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
		
	if (MrmFetchIconLiteral(	applicationHierarchy,
					"twopairsPicture",
					screen,
					display,
					fgPixel,
					bgPixel,
					&twopairsPixmap	) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch twopairsPicture !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}	
	
			
	/* Minimum/Maximum keysizes for keysizeScale */		
	if (MrmFetchLiteral(	applicationHierarchy,
				"keysizeScaleMinimum",
				display,
				(XtPointer) &keysizeScaleMinimum,
				&mrm_type) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch string keysizeScaleMinimum !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
	if (mrm_type != MrmRtypeInteger) {
	
		fprintf(stderr, "Error in xmst.uid: Value keysizeScaleMinimum is no integer !\n");
		exit(-1);
	}
	if (MrmFetchLiteral(	applicationHierarchy,
				"keysizeScaleMaximum",
				display,
				(XtPointer) &keysizeScaleMaximum,
				&mrm_type) != MrmSUCCESS) {

		fprintf(stderr, "Error in xmst.uid: Can't fetch string keysizeScaleMaximum !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
	if (mrm_type != MrmRtypeInteger) {
	
		fprintf(stderr, "Error in xmst.uid: Value keysizeScaleMaximum is no integer !\n");
		fprintf(stderr, "Try running xmst_start.\n");
		exit(-1);
	}
	
	
	/*
	 *	Initialize table of xmst shells
	 */

	for (i=0; xmstshells[i].name; i++ ) {
	
		if (!strcmp(xmstshells[i].name, ""))
			xmstshells[i].widget = STWIDGET("*stMainShell");
		else
			xmstshells[i].widget = STWIDGET(xmstshells[i].name);
	}
	
	/*
	 *	Init some widget pointers
	 */
	pseList = STWIDGET("*st_pselist");
	pkList = STWIDGET("*st_pklist");
	ekList = STWIDGET("*st_eklist");
	pcaList = STWIDGET("*st_pcalist");

}



/*
 *	Add callbacks to dialogs of xmst toplevel window
 */
/***************************************************************
 *
 * Procedure modify_dialogs
 *
 ***************************************************************/
#ifdef __STDC__

static
void modify_dialogs(
)

#else

static
void modify_dialogs(
)

#endif

{
	/*
	 *	Add check_passwd_cb & textfield_focus_cb to some dialog textfields
	 */
	
	add_password_callbacks(XmSelectionBoxGetChild(STWIDGET("*pin_dialog"), XmDIALOG_TEXT));
	add_password_callbacks(XmSelectionBoxGetChild(STWIDGET("*chpin_dialog"), XmDIALOG_TEXT));
	add_focus_callbacks(XmSelectionBoxGetChild(STWIDGET("*pin_dialog"), XmDIALOG_TEXT));
	add_focus_callbacks(XmSelectionBoxGetChild(STWIDGET("*chpin_dialog"), XmDIALOG_TEXT));
	add_focus_callbacks(XmSelectionBoxGetChild(STWIDGET("*addalias_dialog"), XmDIALOG_TEXT));
	add_focus_callbacks(XmSelectionBoxGetChild(STWIDGET("*prompt_dialog"), XmDIALOG_TEXT));
	add_focus_callbacks(XmFileSelectionBoxGetChild(STWIDGET("*file_selection_box"), XmDIALOG_FILTER_TEXT));
	add_focus_callbacks(XmFileSelectionBoxGetChild(STWIDGET("*file_selection_box"), XmDIALOG_TEXT));
	add_focus_callbacks(XmSelectionBoxGetChild(STWIDGET("*file_object_selection_box"), XmDIALOG_TEXT));
	add_focus_callbacks(STWIDGET("*pseobjselection_sel_text"));
	
	/*
	 *	Add WM delete callbacks for each dialog
	 */	
	
	/* complex dialogs defined in dialog.uil */
	
	add_destroy_callback(STWIDGET("*debug_dialog"), (caddr_t)debug_dialog_cb);			
	add_destroy_callback(STWIDGET("*guide_dialog"), (caddr_t)guide_dialog_cb);			
 	add_destroy_callback(STWIDGET("*d5bwr_dialog"), (caddr_t)d5bwr_dialog_cb);			
	add_destroy_callback(STWIDGET("*viewer_dialog"), (caddr_t)viewer_dialog_cb);			
	add_destroy_callback(STWIDGET("*clipboard_dialog"), (caddr_t)clipboard_dialog_cb);			
	add_destroy_callback(STWIDGET("*config_dialog"), (caddr_t)config_dialog_cb);			
	add_destroy_callback(STWIDGET("*crypt_dialog"), (caddr_t)crypt_dialog_cb);			
	add_destroy_callback(STWIDGET("*file_dialog"), (caddr_t)file_dialog_cb);			
								
	/* simple dialogs */
	
	add_destroy_callback(STWIDGET("*pin_dialog"), (caddr_t)pin_dialog_cb);			
	add_destroy_callback(STWIDGET("*chpin_dialog"), (caddr_t)chpin_dialog_cb);			
	add_destroy_callback(STWIDGET("*addalias_dialog"), (caddr_t)addalias_dialog_cb);			
	add_destroy_callback(STWIDGET("*prompt_dialog"), (caddr_t)question_dialog_cb);			
	add_destroy_callback(STWIDGET("*ok_dialog"), (caddr_t)ok_dialog_cb);			
	add_destroy_callback(STWIDGET("*abort_dialog"), (caddr_t)error_dialog_cb);			
	add_destroy_callback(STWIDGET("*retr_abort_dialog"), (caddr_t)error_dialog_cb);			
	add_destroy_callback(STWIDGET("*retr_canc_dialog"), (caddr_t)error_dialog_cb);			
	add_destroy_callback(STWIDGET("*signature_dialog"), (caddr_t)question_dialog_cb);			
	add_destroy_callback(STWIDGET("*cont_quit_dialog"), (caddr_t)error_dialog_cb);			
	add_destroy_callback(STWIDGET("*cont_canc_dialog"), (caddr_t)warning_dialog_cb);			
	add_destroy_callback(STWIDGET("*save_loose_dialog"), (caddr_t)warning_dialog_cb);			
	add_destroy_callback(STWIDGET("*cont_show_dialog"), (caddr_t)warning_dialog_cb);			
	add_destroy_callback(STWIDGET("*repl_canc_dialog"), (caddr_t)warning_dialog_cb);			
	add_destroy_callback(STWIDGET("*processing_dialog"), (caddr_t)processing_dialog_cb);
	add_destroy_callback(STWIDGET("*printing_dialog"), (caddr_t)processing_dialog_cb);
	add_destroy_callback(STWIDGET("*verify_dialog"), (caddr_t)verify_dialog_cb);
	add_destroy_callback(STWIDGET("*pseobjselection_dialog"), (caddr_t)pseobjselection_dialog_cb);			
	
}


/***************************************************************
 *
 * Procedure open_sectool
 *
 ***************************************************************/
#ifdef __STDC__

static
void open_sectool(
)

#else

static
void open_sectool(
)

#endif

{

	XtManageChild(stMainShell);
	
	get_geometry_resources();

	XtRealizeWidget(applicationShell);
	
	XmUpdateDisplay(applicationShell);
}



/***************************************************************
 *
 * Procedure init_secude
 *
 ***************************************************************/
#ifdef __STDC__

static
void init_secude(
)

#else

static
void init_secude(
)

#endif

{
	char			xmst_option;
	extern char		*optarg;
	
	
	/* 
	 *      Set fix paths
	 */

	if (! (unix_home = getenv("HOME")) || !strlen(unix_home))  {

		fprintf(stderr, "Can't get $HOME from environment!\n");
		exit(-1);
	}

	editor_tempfile = aux_cat_paths(unix_home, XMST_TEMP_FILE);
	config_rcfile   = aux_cat_paths(unix_home, XMST_CONFIG_FILE);
	d5bwr_tempfile  = aux_cat_paths(unix_home, D5BWR_TEMPFILE);

	/* 
	 *      Set SecuDE global options
	 */

	accept_alias_without_verification = FALSE;		
	MF_check = FALSE;
	af_verbose = sec_verbose = sec_gen_verbose = FALSE;
	sec_debug = 0;
	alias_save_required = FALSE;
		
	/* 
	 *      Pre-Set configurable options
	 */

	auto_save_configuration = FALSE;
	Debug = FALSE;
	beep_on_error = FALSE;
	external_editor = CNULL;
	print_command = CNULL;
	
#ifdef SCA
	auto_detect_sct = FALSE;
	SC_verify = SC_encrypt = FALSE;
#endif /* SCA */
	
	af_chk_crl = FALSE;
	af_FCPath_is_trusted = TRUE;
	chk_PEM_subordination = TRUE;
	random_from_pse = FALSE;
	
	af_access_directory = FALSE;

#ifdef X500
	af_dir_authlevel = DBA_AUTH_NONE;
	af_dir_dsaname = CNULL;
	af_dir_tailor = CNULL;
#endif /* X500 */


	while ( (xmst_option = getopt(xmst_argc, xmst_argv, "p:c:shvV")) != -1 ) switch(xmst_option) {

		case 'p':
			argPSEName = strdup(optarg);
			continue;
		case 'c':
			argCAName = strdup(optarg);
			continue;
		case 'h':
			usage(LONG_HELP);
			continue;
		case 's':
			start_with_configuration = TRUE;
			continue;
		case 'v':
			verbose = sectool_verbose = TRUE;
			break;
		case 'V':
			verbose = sectool_verbose = sec_gen_verbose = TRUE;
			af_verbose = sec_verbose = TRUE;
			sec_debug = 2;
			break;
		default:
			usage(SHORT_HELP);
	}                    

	/*
	 *	Manage & Realize top level shell, get geometry resources of all xmst shells
	 */
	config_database = XrmGetDatabase(display);
	if (!XrmCombineFileDatabase(config_rcfile, &config_database, TRUE)) {
	
			start_with_configuration = TRUE;
	}

	open_sectool();

	/*** generate a general session key ***/
	{
		BitString *bitstr;
		
		bitstr                       = sec_random_bstr(64);
		session_key.subjectAI        = aux_Name2AlgId("DES-CBC");
		session_key.subjectkey.nbits = bitstr->nbits;
		session_key.subjectkey.bits  = bitstr->bits;
	}

	/* generate symmetric session key for clipboard data (avoid random_from_pse is set */
	clipboard_sessionkey = (Key *)malloc(sizeof(Key));
	if (!clipboard_sessionkey)
		goto no_sessionkey;
	clipboard_sessionkey->key = (KeyInfo *)malloc(sizeof(KeyInfo));
	if (!clipboard_sessionkey->key)
		goto no_sessionkey;
	clipboard_sessionkey->key->subjectAI = aux_Name2AlgId("DES-CBC");
	if (!clipboard_sessionkey->key->subjectAI) {
		free(clipboard_sessionkey->key);
		free(clipboard_sessionkey);
 		goto no_sessionkey;
	}
	clipboard_sessionkey->alg = (AlgId *)0;

	if (sec_gen_key(clipboard_sessionkey, FALSE) >= 0)
		goto sessionkey_ok;
	
no_sessionkey:
	XtSetSensitive(STWIDGET("*st_crypt_clipboard_toggle"), FALSE);
	
	if (sectool_verbose)
		fprintf(stderr, "Generation of symmetric session key for clipboard data failed!\n");
	sprintf(dialog_message, "\n\n%s\n%s%s\n\n",
			" Generation of symmetric session key for clipboard data failed!\n",
			"Cut & Copy will write non-encrypted ASN.1 code to the clipboard,\n",
			"Copy is not available for Secret Key objects.\n");
	ok_dialog_open(applicationShell, dialog_message);	
		
sessionkey_ok:


	/*
	 *	Configuration
	 */
	get_resources();
	
	backup_configuration();
	
	if (start_with_configuration) {
	
		config_dialog_open();
	}

	/* set ALL variables as given in configuration / properties */
	set_properties((Widget)NULL);
	
	/* set pse_path ... */
	set_pse_ca();

}



/*
 *	SecTool usage help
 */
/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static
void usage(
	int	  help
)

#else

static
void usage(
	help
)
int	  help;

#endif

{

	aux_fprint_version(stderr);

	fprintf(stderr, "xmst: Maintain your PSE\n\n\n");
	fprintf(stderr, "Description:\n\n"); 
	fprintf(stderr, "'xmst ' is, like psemaint, a maintenance program which can be used by both\n");
	fprintf(stderr, "certification authority administrators and users for the purpose\n");
	fprintf(stderr, "of maintaining their PSEs. This includes moving information (e.g. keys,\n");
	fprintf(stderr, "certificates, revocation lists etc.) from Unix files or a X.500 Directory\n");
	fprintf(stderr, "into the PSE and vice versa, generating keys, changing PINs, displaying\n"); 
	fprintf(stderr, "the content of the PSE, and maintaining the user's aliases. In contrast\n");
        fprintf(stderr, "to psemaint, which is line-oriented, sectool is an Motif(tm) tool.\n\n");
        
        fprintf(stderr, "Try running xmst_start instead of xmst to ensure a correct setting of\n");
        fprintf(stderr, "the environment, esp. if another window manager than Motif's mwm is used.\n\n\n");

        fprintf(stderr, "usage:\n\n");
	fprintf(stderr, "xmst [-p <pse>] [-c <ca>] [-sh]\n\n");
	fprintf(stderr, "xmst_start [-p <pse>] [-c <ca>] [-sh]\n\n");

        if (help == LONG_HELP) {

        fprintf(stderr, "with:\n\n");
        fprintf(stderr, "-s          Setup XMST.\n");
        fprintf(stderr, "-h          Print this help text.\n");
        }

        exit(0);

} 
