/* ./src/util/xmsectool/util.c */

static char *rcsid = "$Id: util.c,v 1.30 1995/03/17 17:05:16 koletzki Exp $";

/*
 * $Id: util.c,v 1.30 1995/03/17 17:05:16 koletzki Exp $
 *
 * $Log: util.c,v $
 * 	configuration
 * 	properties
 * 	clipboard
 *
 * Revision 1.20  1994/12/19  09:25:49  nuessler
 * Bug fixed in util_XmStringTable...
 *
 * Revision 1.19  1994/12/15  20:06:07  nuessler
 * util_XmStringTable.... added
 *
 * Revision 1.18  1994/12/15  19:44:54  nuessler
 * Bug fixed in setCursor
 *
 * Revision 1.17  1994/12/15  17:29:35  nuessler
 * Included:
 * - xmstshells[] in setCursor().
 *
 * Revision 1.16  1994/12/09  16:58:29  nuessler
 * There is an nicer and better busy - and think
 * Cursor function called setCursor
 *
 * Revision 1.15  1994/12/09  15:08:53  koletzki
 * *** empty log message ***
 *
 * Revision 1.14  1994/12/05  11:34:45  nuessler
 * *** empty log message ***
 *
 * Revision 1.13  1994/12/02  14:36:00  koletzki
 * vendor pixmap
 * clipboard copy/retrieve
 *
 * Revision 1.12  1994/11/24  18:15:56  koletzki
 * *** empty log message ***
 *
 * Revision 1.11  1994/11/23  12:01:05  koletzki
 * set_properies()
 * 	removed sec_verbose = TRUE for high nice level
 *
 * Revision 1.10  1994/11/14  18:29:00  koletzki
 * Color & font resources
 *
 * Revision 1.9  1994/11/11  11:09:49  koletzki
 * some changes for proper installation in /usr/local/secude
 *
 * Revision 1.8  1994/11/04  15:09:52  nuessler
 * removed warning from "text_wrap_RDN()"
 *  semantics of "<=" change in ANSI C; use explicit cast
 *
 * Revision 1.7  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.6  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 * some print flags changed
 *
 * Revision 1.4  1994/10/31  10:20:16  koletzki
 * ???
 *
 * Revision 1.3  1994/10/21  16:20:19  koletzki
 * 1. lauffaehige Version unter RCS
 *
 * Revision 1.2  1994/10/19  17:31:37  koletzki
 * Header edited
 *
 * Revision 1.1  1994/10/19  10:56:25  koletzki
 * Initial revision
 *
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/



/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"



/*
 ************************
 *	STATICS		*
 ************************
 */

static Boolean	debug_input_handler_installed = FALSE;
static char	value_string[256];

#ifdef __STDC__

static void	_init_clientdata(XtPointer cd_vector[]);
static char	*get_geometry_resource(Widget  widget, char *widget_name, Boolean resize);
static Boolean	get_toggle_resource(char *widget_name);
static char	*get_textfield_resource(char *widget_name);
static void	put_geometry_resource(Widget widget, char *widget_name, Boolean managed, char *geometry);
static void	put_toggle_resource(char *widget_name);
static void	put_textfield_resource(char *widget_name);
static void	change_WM_behavior(Widget dialog, Boolean transient);
static void	get_sct_vendor();

#else

static void	_init_clientdata();
static char	*get_geometry_resource();
static Boolean	get_toggle_resource();
static char	*get_textfield_resource();
static void	put_geometry_resource();
static void	put_toggle_resource();
static void	put_textfield_resource();
static void	change_WM_behavior();
static void	get_sct_vendor();

#endif

static char	*save_config_psename_textfield;
static char	*save_config_caname_textfield;
static char	*save_config_editor_textfield;
static char	*save_config_printcmd_textfield;
static char	*save_config_guide_textfield;
static char	*save_config_dsaname_textfield;
static char	*save_config_dsaptailor_textfield;



/*
 *	Leave sectool in a proper manner after an error occured
 */
/***************************************************************
 *
 * Procedure exit_sectool
 *
 ***************************************************************/
#ifdef __STDC__

void exit_sectool(
)

#else

void exit_sectool(
)

#endif

{

	/* AliasList */
	save_aliaslist();

	/* Temporary files */
	remove_tempfile();
	strcat(editor_tempfile, "%");
	remove_tempfile();
	
	/* Configuration */
	if (auto_save_configuration) {
	
		if (save_loose_dialog_open(applicationShell, "Save changes to configuration?")) {
		
			save_configuration();
		}
	}

	/* Das war's! */
	exit(0);

}


/*
 *	Save AliasList if required
 */
/***************************************************************
 *
 * Procedure save_aliaslist
 *
 ***************************************************************/
#ifdef __STDC__

void save_aliaslist(
)

#else

void save_aliaslist(
)

#endif

{

	if (alias_save_required) {

		if (save_loose_dialog_open(applicationShell,
			"The local AliasList has been changed.\n  You can save or loose all edits.")) {

			aux_put_AliasList(useralias);
			alias_save_required = FALSE;
		}
	}
}


/*
 *	Call XtNameToWidget for specified uil name, exit if not found
 */
/***************************************************************
 *
 * Procedure name2widget
 *
 ***************************************************************/
#ifdef __STDC__

Widget name2widget(
	Widget	  parentShell,
	char	 *s
)

#else

Widget name2widget(
	parentShell,
	s
)
Widget	  parentShell;
char	 *s;

#endif

{
	Widget		widget = XtNameToWidget(parentShell, s);

	if (!widget) {

		fprintf(stderr, "XMST ERROR in XtNameToWidget(\"%s\")\n", s);

		exit(-1);
	}

	return(widget);
}


/*
 *	LIST CLIENT DATA type
 *	This is my quick & dirty solution for XmList client data substitute.
 *	Hope there will be such an enhancement in the standard Motif lib in future...
 */


/*
 *	Init all client data vectors
 */
/***************************************************************
 *
 * Procedure init_all_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

void init_all_clientdata(
)

#else

void init_all_clientdata(
)

#endif

{

	_init_clientdata(pselist_clientdata);
	_init_clientdata(pklist_clientdata);
	_init_clientdata(eklist_clientdata);
	_init_clientdata(pcalist_clientdata);
	_init_clientdata(aliaslist_clientdata);

}


/*
 *	Init specified client data vector
 */
/***************************************************************
 *
 * Procedure _init_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

static void _init_clientdata(
	XtPointer	  cd_vector[]
)

#else

static void _init_clientdata(
	cd_vector
)
XtPointer	  cd_vector[];

#endif

{
	int		entry;
	
	
	cd_vector[0] = (XtPointer)1;
	
	for (entry = 1; entry < XMST_MAX_LIST_ITEMS; entry++)
		cd_vector[entry] = (XtPointer)NULL;

}


/*
 *	Free & Init specified client data vector
 */
/***************************************************************
 *
 * Procedure init_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

void init_clientdata(
	XtPointer	  cd_vector[]
)

#else

void init_clientdata(
	cd_vector
)
XtPointer	  cd_vector[];

#endif

{
	int		entry;
	
	
	cd_vector[0] = (XtPointer)1;
	
	for (entry = 1; entry < XMST_MAX_LIST_ITEMS; entry++) {

		if (cd_vector[entry]) free(cd_vector[entry]);
		cd_vector[entry] = (XtPointer)NULL;
	}
}


/*
 *	Insert client data at position in vector
 */
/***************************************************************
 *
 * Procedure insert_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

Boolean insert_clientdata(
	XtPointer	  cd_vector[],
	XtPointer	  cd,
	int		  position
)

#else

Boolean insert_clientdata(
	cd_vector,
	cd,
	position
)
XtPointer	  cd_vector[];
XtPointer	  cd;
int		  position;

#endif

{
	int		entry;

		
	if (count_clientdata(cd_vector) >= XMST_MAX_LIST_ITEMS) {

		fprintf(stderr, "XMST WARNING: insert_clientdata() client data vector overflow\n");
		
		return(FALSE);
	}

	for (entry = count_clientdata(cd_vector); entry >= position; entry--)
		cd_vector[entry + 1] = cd_vector[entry];

	entry++;
	cd_vector[entry] = cd;

	cd_vector[0] = (XtPointer)((int)cd_vector[0] + 1);


	return(TRUE);

}


/*
 *	Append client data to vector
 */
/***************************************************************
 *
 * Procedure append_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

Boolean append_clientdata(
	XtPointer	  cd_vector[],
	XtPointer	  cd
)

#else

Boolean append_clientdata(
	cd_vector,
	cd
)
XtPointer	  cd_vector[];
XtPointer	  cd;

#endif

{
	Boolean		rvalue;

		
	rvalue = insert_clientdata(cd_vector, cd, (int)cd_vector[0]);


	return(rvalue);

}


/*
 *	Delete client data at position in vector
 */
/***************************************************************
 *
 * Procedure delete_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

void delete_clientdata(
	XtPointer	  cd_vector[],
	int		  position
)

#else

void delete_clientdata(
	cd_vector,
	position
)
XtPointer	  cd_vector[];
int		  position;

#endif

{
	int		entry;

		

	for (entry = position; entry < count_clientdata(cd_vector); entry++)
		cd_vector[entry] = cd_vector[entry + 1];

	cd_vector[entry] = (XtPointer)NULL;

	cd_vector[0] = (XtPointer)((int)cd_vector[0] - 1);

}


/*
 *	Get number of client data entries in vector
 */
/***************************************************************
 *
 * Procedure count_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

int count_clientdata(
	XtPointer	  cd_vector[]
)

#else

int count_clientdata(
	cd_vector
)
XtPointer	  cd_vector[];

#endif

{

	return( (int)cd_vector[0] - 1 );

}


/*
 *	Get client data at position in vector
 */
/***************************************************************
 *
 * Procedure get_clientdata
 *
 ***************************************************************/
#ifdef __STDC__

XtPointer get_clientdata(
	XtPointer	  cd_vector[],
	int		  position
)

#else

XtPointer get_clientdata(
	cd_vector,
	position
)
XtPointer	  cd_vector[];
int		  position;

#endif

{

	return( cd_vector[position] );

}


/*
 *	Transform Serialnumber to (char *) according to aux_fprint_Serialnumber() formatting;
 *	i.e. values with size of int are formatted to decimal integers, others to hex octets
 */
/***************************************************************
 *
 * Procedure Serialnumber2String
 *
 ***************************************************************/
#ifdef __STDC__

char *Serialnumber2String(
	OctetString	 *serial
)

#else

char *Serialnumber2String(
	serial
)
OctetString	 *serial;

#endif

{
	char			*proc = "Serialnumber2String";
	char			rstring[XMST_PKSERIAL_LENGTH];
	int	 		int_repr;
	L_NUMBER 		lnum[8];
	OctetString		*ostr;
	int			noc;
	char			*fill = "", *pfill = ".", *ppfill = " ... ";


	if (sectool_verbose) fprintf(stderr, "%s\n", proc);	

	if (!serial || !serial->octets) return(CNULL);

	strcpy(rstring, "");

	if (serial->noctets <= sizeof(int)) {

		octetstoln(serial, lnum, 0, serial->noctets);
		int_repr =  lnum[1];
		if (int_repr < 0) {

			if (verbose) fprintf(stderr, "Sectool: Problem with conversion of Serialnumber\n");

			return(CNULL);
		}
		sprintf(rstring, "%5d", int_repr);
		sprintf(rstring, "%-5.5s (decimal)", rstring);

	} else {

		ostr = aux_enchex(serial);
		if (!ostr || !ostr->octets) return(CNULL);

		if (ostr->noctets <= XMST_PKSERIAL_NOCTETS) {

			for (noc = 0; noc < ostr->noctets; noc+=2)
				sprintf(rstring, 	"%s%-2.2s%1s",
							rstring,
							ostr->octets[noc],
							pfill			);
			rstring[noc] = '\0';

		} else {

			sprintf(rstring, 	"%-2.2s%1s%-2.2s%4s%-2.2s%1s%-2.2s",
						ostr->octets,
						pfill,
						ostr->octets + 2,
						ppfill,
						ostr->octets + ostr->noctets - 4,
						pfill,
						ostr->octets + ostr->noctets - 2	);
		}

		aux_free_OctetString(&ostr);
	}

	return( aux_cpy_String(rstring) );
}



/* 
 *	Open temporary text file
 */
/***************************************************************
 *
 * Procedure open_write_tempfile
 *
 ***************************************************************/
#ifdef __STDC__

int open_write_tempfile(
	Widget	  parentShell
)

#else

int open_write_tempfile(
	parentShell
)
Widget	  parentShell;

#endif

{
	char		*proc = "open_write_tempfile";


	if (sectool_verbose) fprintf(stderr, "-->%s\n", proc);

	remove_tempfile();
	logfile = fopen(editor_tempfile, "w");
	if (logfile == (FILE *)NULL)  {

		sprintf(dialog_message, "Can't open temporary file\n\"%s\"", editor_tempfile);
		if (verbose) fprintf(stderr, "Can't open temporary file %s.", editor_tempfile);
		cont_quit_dialog_open(parentShell, dialog_message);

		return(-1);
	}

	return(0);
}




/*
 *	Close temporary text file
 */
/***************************************************************
 *
 * Procedure close_tempfile
 *
 ***************************************************************/
#ifdef __STDC__

void close_tempfile(
)

#else

void close_tempfile(
)

#endif

{
	char		*proc = "close_tempfile";


	if (sectool_verbose) fprintf(stderr, "-->%s\n", proc);


	fclose(logfile);
	logfile = (FILE *)NULL;

	chmod(editor_tempfile, S_IRWXU & S_IRUSR);	/* Read permission for user only */
}


/*
 *	Remove temporary text file
 */
/***************************************************************
 *
 * Procedure remove_tempfile
 *
 ***************************************************************/
#ifdef __STDC__

void remove_tempfile(
)

#else

void remove_tempfile(
)

#endif

{
	char		*proc = "remove_tempfile";


	if (sectool_verbose) fprintf(stderr, "-->%s\n", proc);

	unlink(editor_tempfile);
}

/*
 *	Start external editor if resource is set
 */
/***************************************************************
 *
 * Procedure start_editor
 *
 ***************************************************************/
#ifdef __STDC__

void start_editor(
)

#else

void start_editor(
)

#endif

{
	static int		paragraph = 1;
	static XmTextPosition	last_position = 0;
	
	char			command_string[256];
	int			status;
	OctetString		*file_ostr;
	char			*file_string;
	Widget			viewer_dialog = STWIDGET("*viewer_dialog");
	Widget			viewer_text = STWIDGET("*viewer_text");
		


	if (use_external_editor && !XtIsManaged(viewer_dialog)) {

		sprintf(command_string, "%s %s &", external_editor, editor_tempfile);
		status = system(command_string);
		if (status) {
		
			sprintf(dialog_message, "ERROR: Unable to spawn external editor!\n\n\
							Status of system call is <%d>.", status);
			ok_dialog_open(applicationShell, dialog_message);
		}

	} else {
		
		if (! (file_ostr = aux_file2OctetString(editor_tempfile)) ) {
		
			ok_dialog_open(applicationShell, "Can't read temporary file.");
			
		} else {
		
			file_string = CATSPRINTF(CNULL,
					"\n\n=====[ Paragraph %d ]======================================\n\n",
					paragraph++);
			
			file_string = CATNSTR(file_string, file_ostr->octets, file_ostr->noctets);
			file_string = CATSPRINTF(file_string, "\n");
			
			XmTextInsert(viewer_text, last_position, file_string);
			free(file_string);
			aux_free_OctetString(&file_ostr);
			
			XmTextShowPosition(viewer_text, (last_position = XmTextGetLastPosition(viewer_text)));
			
			MANAGE_MODELESS_DIALOG(viewer_dialog);
		}
	}
}


/*
 *	Send string to printer
 */
/***************************************************************
 *
 * Procedure print_string
 *
 ***************************************************************/
#ifdef __STDC__

void print_string(
	Widget	  parentShell,
	char	 *string
)

#else

void print_string(
	parentShell,
	string
)
Widget	  parentShell;
char	 *string;

#endif

{
	char				command_string[256];
	int				status;
		
		
	if (!string || !strlen(string)) {
	
		ALARM();
		return;
	}

	if (open_write_tempfile(parentShell) >= 0) {
	
		THINK_CURSOR();
		printing_dialog_open(parentShell, "Sending file to printer ...");
		XmUpdateDisplay(parentShell);
	
		fprintf(logfile, "%s\n", string);
		close_tempfile();

		sprintf(command_string, "%s %s", print_command, editor_tempfile);
		status = system(command_string);
	
		READY_CURSOR();
		printing_dialog_open(parentShell, CNULL);
		if (status) sprintf(dialog_message, "ERROR: Unable to print!\n\n\
							Status of system call is <%d>.", status);
		else sprintf(dialog_message, "... Ready and printing.");
		ok_dialog_open(parentShell, dialog_message);
		
		remove_tempfile();
	}
}



/*
 *	Callback for password textfields
 *	Password is stored in static char *passwd
 */
#ifdef __STDC__

void
check_passwd_cb(
	Widget        			text_w,
	XtPointer     			unused,
	XmTextVerifyCallbackStruct 	*cbs
)

#else

void
check_passwd_cb(
	text_w,
	unused,
	cbs
)
	Widget        			text_w;
	XtPointer     			unused;
	XmTextVerifyCallbackStruct 	*cbs;

#endif

{
    	char 				*new;
    	int 				len;


    	if (cbs->reason == XmCR_ACTIVATE) {

	       	return;
    	}

    	if (cbs->text->ptr == (char)NULL) { 			/* backspace */

        	cbs->endPos = strlen(passwd);
        	passwd[cbs->startPos] = 0;

        	return;
    	}

    	if (cbs->text->length > 1) {

        	cbs->doit = False; 				/* don't allow "paste" operations */

        	return;
    	}

    	new = (char *)malloc(cbs->endPos + 2); 			/* new char + NULL terminator */

    	if (passwd) {

        	strcpy(new, passwd);
        	free(passwd);

    	} else new[0] = (char)NULL;

    	passwd = new;
    	strncat(passwd, cbs->text->ptr, cbs->text->length);
    	passwd[cbs->endPos + cbs->text->length] = 0;

    	for (len = 0; len < cbs->text->length; len++)
        	cbs->text->ptr[len] = '*';

}


/*
 *	Work procedure for Debug mode
 */
#ifdef __STDC__

Boolean debug_workproc(
	Widget	  debug_text
)

#else

Boolean debug_workproc(
	debug_text
)
Widget	  debug_text;

#endif

{
	static struct ErrStack  	*err = NULL;
	static struct ErrStack  	*prev_err = NULL;
	static int			last_position = 0;
	static int			group = 1;
	char				*string = CNULL;


	if (!err_stack) return( debugmode_on ? FALSE : TRUE );			/* no errors at all */
	if (err == err_stack) return( debugmode_on ? FALSE : TRUE );		/* no new error on stack */
	if (err_stack == &err_malloc) return( debugmode_on ? FALSE : TRUE );	/* malloc failed */

	string = CATSPRINTF(CNULL, "[%d]\n", group++);
	XmTextInsert(debug_text, last_position, string);
	free(string);
	
	last_position = XmTextGetLastPosition(debug_text);
		
	for (prev_err = err, err = err_stack; err && err != prev_err; err = err->next) {
	
		string = CATSPRINTF(	CNULL,
					"%s in %s: (%d) %s",
					err->e_is_error ? "ERROR" : "WARNING",
					err->e_proc,
					err->e_number,
					err->e_text);
					
		if (err->e_addr) {
		
 			switch (err->e_addrtype) {

				case char_n:
					string = CATSPRINTF(string, " \"%s\"", err->e_addr);
					break;
				case int_n:
					string = CATSPRINTF(string, " %d", err->e_addr);
					break;
	                        case DName_n:
	                                string = CATSPRINTF(string, " \"%s\"",
	                                			aux_DName2Name((DName *)err->e_addr));
	                                break;
	                        default:
	                         	string = CATSPRINTF(string, " <...>");
	        	};
		};
		string = CATSPRINTF(string, "\n");
		XmTextInsert(debug_text, last_position, string);
		free(string);
	}
	err = err_stack;

	XmTextShowPosition(debug_text, (last_position = XmTextGetLastPosition(debug_text)));

	MANAGE_MODELESS_DIALOG(STWIDGET("*debug_dialog"));


	return( debugmode_on ? FALSE : TRUE );
}



/*
 *	Callback for textfields to change color depending on focus possession
 */
/***************************************************************
 *
 * Procedure textfield_focus_cb
 *
 ***************************************************************/
#ifdef __STDC__

void textfield_focus_cb(
	Widget				  text_w,
	XtPointer			  unused,
	XmTextVerifyCallbackStruct	 *cbs
)

#else

void textfield_focus_cb(
	text_w,
	unused,
	cbs
)
Widget				  text_w;
XtPointer			  unused;
XmTextVerifyCallbackStruct	 *cbs;

#endif

{
    	Widget 				parent;
    	Pixel	 			parent_color;


	if (focus_color) {

	    	switch (cbs->reason) {
	    	
	    		case XmCR_FOCUS:
	    		
	    			XtVaSetValues(	text_w,
	    					XmNbackground, focus_color,
	    					NULL);
	
		       		break;
	
		       	case XmCR_LOSING_FOCUS:
		       	
	    			XtVaGetValues(	XtParent(text_w),
	    					XmNbackground, &parent_color,
	    					NULL);
	
	    			XtVaSetValues(	text_w,
	    					XmNbackground, parent_color,
	    					NULL);
	
		       	      	break;
		       	      	
			default:
		 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
		}
	}	
	


}



/* 
 *	Test SC/SCT configuration
 */
/***************************************************************
 *
 * Procedure set_sct_widget
 *
 ***************************************************************/
#ifdef __STDC__

void set_sct_widget(
)

#else

void set_sct_widget(
)

#endif

{
	Boolean			sct_done = FALSE;
	Boolean			sct_avail = FALSE;
	

#ifdef SCA
	while (!sct_done) switch (sec_scttest()) {
	
		case ERR_in_scttest:
		
			if (auto_detect_sct) ok_dialog_open(applicationShell,
						"Error in SCT Test! Switching to software operation.");
			sct_done = TRUE;
			break;
		
		case SCTDev_not_avail:
		
			if (auto_detect_sct) ok_dialog_open(applicationShell,
						"SCT is not available. Switching to software operation.");
			sct_done = TRUE;
			break;
		
		case SCTDev_avail:
		
			sct_avail = TRUE;
			sct_done = TRUE;
			break;
		
		case SCTDev_lock:
		
			if (auto_detect_sct) {
				if (!retr_canc_dialog_open(applicationShell,
							"   SCT is locked by another process.\n	\
							Cancel to switch to software operation.")) 
					sct_done = TRUE;
						
			} else sct_done = TRUE;
			break;
			
		case SCTDev_not_config:
		
			if (auto_detect_sct) ok_dialog_open(applicationShell,
						"Unable to configure SCT. Switching to software operation.");
			sct_done = TRUE;
			break;
			
		default:
			break;
	}
		
	if (!sct_avail) {				/* there is no SCT */

		XtUnmanageChild(STWIDGET("*st_scvendor_label"));
		XtSetSensitive(STWIDGET("*st_softrsa_toggle"), FALSE);
		XmToggleButtonSetState(STWIDGET("*st_softrsa_toggle"), FALSE, FALSE);
		SC_verify = SC_encrypt = FALSE;
		
	} else if (auto_detect_sct) {			/* SCT is available: can use it for rsa */
		
		get_sct_vendor();
		XtManageChild(STWIDGET("*st_scvendor_label"));
		/* keep soft rsa toggle as set in properties */

	} else {					/* force software rsa despite SCT is available */

		get_sct_vendor();
		XtManageChild(STWIDGET("*st_scvendor_label"));
		XmToggleButtonSetState(STWIDGET("*st_softrsa_toggle"), FALSE, FALSE);
		SC_verify = SC_encrypt = FALSE;	
	}
	
	release_SCT(1);
	
#endif /* SCA */

}

/* 
 *	Try to find out the vendor of the SCT/SC/SC-OS
 *	Set corresponding pixmap as vendor label
 */
/***************************************************************
 *
 * Procedure get_sct_vendor
 *
 ***************************************************************/
#ifdef __STDC__

static
void get_sct_vendor(
)

#else

static
void get_sct_vendor(
)

#endif

{
	
	
	/*
	 * Only supporting STARCOS 1.1 at the moment
	 */
	 
	XtVaSetValues(	STWIDGET("*st_scvendor_label"),
			XmNlabelPixmap, scvendorPixmap,
			NULL);
							
}


/* 
 *	Set property variables, read from given configuration / property widget
 *	set all if widget == NULL
 */
/***************************************************************
 *
 * Procedure set_properties
 *
 ***************************************************************/
#ifdef __STDC__

void set_properties(
	Widget		widget
)

#else

void set_properties(
	widget
)
Widget		widget;

#endif

{
	char		*proc = "set_properties";
	Widget		radio_button;



	/*
	 *	Properties
	 */
	
	/* Show options */
	if (!widget || widget == STWIDGET("*st_nicelow_toggle")
		    || widget == STWIDGET("*st_nicemedium_toggle")
		    || widget == STWIDGET("*st_nicehigh_toggle")) {

		if ( XmToggleButtonGetState((radio_button = STWIDGET("*st_nicelow_toggle"))) ) {
	
			af_verbose = FALSE;
			print_cert_flag = TBS | ALG;
			print_keyinfo_flag = ALGID;
			
			initialNiceToggle = radio_button;
		}
		if ( XmToggleButtonGetState((radio_button = STWIDGET("*st_nicemedium_toggle"))) ) {
	
			af_verbose = TRUE;
			print_cert_flag = TBS | ALG | SIGNAT;
			print_keyinfo_flag = ALGID | KEYBITS;
	
			initialNiceToggle = radio_button;
		}
		if ( XmToggleButtonGetState((radio_button = STWIDGET("*st_nicehigh_toggle"))) ) {
	
			af_verbose = TRUE;
			print_cert_flag = TBS | ALG | SIGNAT | VER | HSH;
			print_keyinfo_flag = ALGID | KEYBITS | BSTR;
	
			initialNiceToggle = radio_button;
		}
	}


	/* Directory access */
	if (!widget || widget == STWIDGET("*st_accessdir_toggle")) {

		af_access_directory = XmToggleButtonGetState(STWIDGET("*st_accessdir_toggle"));
	}
#ifdef X500
	/* Authentication method */
	if (!widget || widget == STWIDGET("*st_authnone_toggle")
		    || widget == STWIDGET("*st_authsimple_toggle")
		    || widget == STWIDGET("*st_authstrong_toggle")) {

		if ( XmToggleButtonGetState((radio_button = STWIDGET("*st_authnone_toggle"))) ) {
	
			af_dir_authlevel = DBA_AUTH_NONE;
			initialAuthToggle = radio_button;
		}
		if ( XmToggleButtonGetState((radio_button = STWIDGET("*st_authsimple_toggle"))) ) {
	
			af_dir_authlevel = DBA_AUTH_SIMPLE;
			initialAuthToggle = radio_button;
		}
		if ( XmToggleButtonGetState((radio_button = STWIDGET("*st_authstrong_toggle"))) ) {
	
			af_dir_authlevel = DBA_AUTH_STRONG;
			initialAuthToggle = radio_button;
		}
	}
#endif /* X500 */


#ifdef SCA	
	/* Autodetect SCT */
	if (!widget || widget == STWIDGET("*st_autodetect_toggle")) {

		auto_detect_sct = XmToggleButtonGetState(STWIDGET("*st_autodetect_toggle"));
	}
	/* RSA done in SCT / via software */
	if (!widget || widget == STWIDGET("*st_softrsa_toggle")) {

		SC_verify = SC_encrypt = !XmToggleButtonGetState(STWIDGET("*st_softrsa_toggle"));
	}
#endif /* SCA */


	/* Debug mode toggle */
	if (!widget || widget == STWIDGET("*st_debug_toggle")) {
	
		if (debugmode_on = XmToggleButtonGetState(STWIDGET("*st_debug_toggle"))) {
	
			if (!debug_input_handler_installed) {
	
				XtAppAddWorkProc(	applicationContext,
							(XtWorkProc)debug_workproc,
							STWIDGET("*debug_text"));
	
				debug_input_handler_installed = TRUE;
			}
		} else {
	
			XtUnmanageChild(STWIDGET("*debug_dialog"));
	
			if (debug_input_handler_installed) debug_input_handler_installed = FALSE;
		}
	}
		
	/* Use external editor */
	if (!widget || widget == STWIDGET("*st_useeditor_toggle")) {
	
		use_external_editor = XmToggleButtonGetState(STWIDGET("*st_useeditor_toggle"));
	}

	/* Crypt clipboard data toggle */
	if (!widget || widget == STWIDGET("*st_crypt_clipboard_toggle")) {
	
		cryptoClipboard = XmToggleButtonGetState(STWIDGET("*st_crypt_clipboard_toggle"));
	}

	/* Transient dialogs */
	if (!widget || widget == STWIDGET("*st_transient_toggle")) {
	
		change_WM_behaviors(XmToggleButtonGetState(STWIDGET("*st_transient_toggle")));
	}
	
	/* Error beep */
	if (!widget || widget == STWIDGET("*st_beep_toggle")) {
	
		beep_on_error = XmToggleButtonGetState(STWIDGET("*st_beep_toggle"));
	}
	
	/* Consult CRLs */
	if (!widget || widget == STWIDGET("*st_consultcrl_toggle")) {
	
		af_chk_crl = XmToggleButtonGetState(STWIDGET("*st_consultcrl_toggle"));
	}
	
	/* Trust own FCPath */
	if (!widget || widget == STWIDGET("*st_trustfcpath_toggle")) {
	
		af_FCPath_is_trusted = XmToggleButtonGetState(STWIDGET("*st_trustfcpath_toggle"));
	}
	
	/* No PEM DName subordination */
	if (!widget || widget == STWIDGET("*st_nosubordination_toggle")) {
	
		chk_PEM_subordination = XmToggleButtonGetState(STWIDGET("*st_nosubordination_toggle"));
	}
	
	/* Read random from PSE object */
	if (!widget || widget == STWIDGET("*st_pserandom_toggle")) {
	
		random_from_pse = XmToggleButtonGetState(STWIDGET("*st_pserandom_toggle"));
	}
	
	
	/*
	 *	Configuration
	 */
	 
	if (!widget || widget == STWIDGET("*config_dialog")) {
	
		/* PSE / CA name */
		if (ca_dir) free(ca_dir);
		ca_dir = (argCAName) ? aux_cpy_ReducedString(argCAName)
					: aux_cpy_ReducedString(XmTextGetString(
								STWIDGET("*config_caname_textfield")));
	
		if (pse_name) free(pse_name);
		pse_name = (argPSEName) ? aux_cpy_ReducedString(argPSEName)
					: (argCAName) ? aux_cpy_ReducedString(DEF_CAPSE)
						      : aux_cpy_ReducedString(XmTextGetString(
								STWIDGET("*config_psename_textfield")));

		XmTextSetString(STWIDGET("*config_caname_textfield"), ca_dir);
		put_textfield_resource("*config_caname_textfield");
		XmTextSetString(STWIDGET("*config_psename_textfield"), pse_name);
		put_textfield_resource("*config_psename_textfield");

		/* Editor */
		if (external_editor) free(external_editor);
		external_editor = aux_cpy_ReducedString(XmTextGetString(
					STWIDGET("*config_editor_textfield")));
		if (!external_editor) external_editor = aux_cpy_String(XMST_DEFAULT_EDITOR);
	
		/* Print command */
		if (print_command) free(print_command);
		print_command = aux_cpy_ReducedString(XmTextGetString(
					STWIDGET("*config_printcmd_textfield")));
		if (!print_command) print_command = aux_cpy_String(XMST_DEFAULT_PRINTCMD);
	
		/* Guide */
		if (guide_file) free(guide_file);
		guide_file = aux_cpy_ReducedString(XmTextGetString(
					STWIDGET("*config_guide_textfield")));
		/* default guide file path is $SECUDE/lib/X11 */
		if (!guide_file) guide_file = aux_cat_paths(	(getenv("SECUDE")) ?
								getenv("SECUDE") : XMST_LOCAL_SECUDE,
								XMST_LIB_X11);
		guide_file = aux_cat_paths(guide_file, XMST_GUIDE_FILE);
	
			
#ifdef X500
		/* AF DSA name */		
		if (af_dir_dsaname) free(af_dir_dsaname);
		af_dir_dsaname = aux_cpy_ReducedString(XmTextGetString(
					STWIDGET("*config_dsaname_textfield")));
		/* AF tailor */		
		if (af_dir_tailor) free(af_dir_tailor);
		af_dir_tailor = aux_cpy_ReducedString(XmTextGetString(
					STWIDGET("*config_dsaptailor_textfield")));
#endif
	}
	
	/* Remember to save configuration (not during initialization) */
	if (widget || argPSEName || argCAName) {
	
		/* Enable Auto save and Undo */
		auto_save_configuration = TRUE;
		
		XtVaSetValues(	STWIDGET("*config_undo_pushbutton"),
				XmNsensitive,	TRUE,
				NULL);
	}

}


/*
 *	Get configuration / property widget values from file .xmstrc
 *	If .xmstrc does not exist, fallback resources are taken
 */
/***************************************************************
 *
 * Procedure get_resources
 *
 ***************************************************************/
#ifdef __STDC__

void get_resources(
)

#else

void get_resources(
)

#endif

{

	/* Generate new resource database if none exists */
	if (!config_database) {
	
		put_resources();
		start_with_configuration = TRUE;
	}
	
	/*
	 *	Properties
	 */
	
	get_toggle_resource("*st_transient_toggle");
	get_toggle_resource("*st_beep_toggle");
	get_toggle_resource("*st_useeditor_toggle");
	
	get_toggle_resource("*st_nicelow_toggle");
	get_toggle_resource("*st_nicemedium_toggle");
	get_toggle_resource("*st_nicehigh_toggle");
	
#ifdef SCA
	XtManageChild(STWIDGET("*st_softrsa_toggle"));
	XtManageChild(STWIDGET("*st_autodetect_toggle"));

	get_toggle_resource("*st_softrsa_toggle");
	get_toggle_resource("*st_autodetect_toggle");
#endif /* SCA */
	
	get_toggle_resource("*st_crypt_clipboard_toggle");
	get_toggle_resource("*st_consultcrl_toggle");
	get_toggle_resource("*st_trustfcpath_toggle");
	get_toggle_resource("*st_nosubordination_toggle");
	get_toggle_resource("*st_pserandom_toggle");

	get_toggle_resource("*st_accessdir_toggle");



	/*
	 *	Configuration
	 */
	get_textfield_resource("*config_caname_textfield");
	get_textfield_resource("*config_psename_textfield");

	get_textfield_resource("*config_editor_textfield");
	get_textfield_resource("*config_printcmd_textfield");
	get_textfield_resource("*config_guide_textfield");
	
#ifdef X500
	XtManageChild(STWIDGET("*st_authentication_button"));
	XtManageChild(STWIDGET("*config_dsa_frame"));

	get_textfield_resource("*config_dsaname_textfield");
	get_textfield_resource("*config_dsaptailor_textfield");
	
	get_toggle_resource("*st_authnone_toggle");
	get_toggle_resource("*st_authsimple_toggle");
	get_toggle_resource("*st_authstrong_toggle");
#endif /* X500 */
	
}


/*
 *	Get single Boolean Toggle Button Value resource from config_database
 *	Set given widget's value to that resource
 *	Set to FALSE if resource was not specified correctly to "true" (case-insensitive)
 */
/***************************************************************
 *
 * Procedure get_toggle_resource
 *
 ***************************************************************/
#ifdef __STDC__

static Boolean get_toggle_resource(
	char	 *widget_name
)

#else

static Boolean get_toggle_resource(
	widget_name
)
char	 *widget_name;

#endif

{
	char			resource_name[256];
	char			*type;
	XrmValue		value;	

		
	if (!widget_name) return(FALSE);
	
	sprintf(resource_name, "XMst%s.set", widget_name);
	
	if (XrmGetResource(config_database, resource_name, NULL, &type, &value)) {
	
		strncpy(value_string, (char *)value.addr, (int)value.size);
		if (!strcasecmp(value_string, "true")) {
		
			XmToggleButtonSetState(STWIDGET(widget_name), TRUE, FALSE);
			return(TRUE);
		}
	}
			
	XmToggleButtonSetState(STWIDGET(widget_name), FALSE, FALSE);
		
	return(FALSE);	
}

	

/*
 *	Get single Textfield String Value resource from config_database
 *	Set given widget's value to that resource
 *	Returns value or ""; Strings must not be freed!
 */
/***************************************************************
 *
 * Procedure get_textfield_resource
 *
 ***************************************************************/
#ifdef __STDC__

static
char *get_textfield_resource(
	char	 *widget_name
)

#else

static
char *get_textfield_resource(
	widget_name
)
char	 *widget_name;

#endif

{
	char			resource_name[256];
	char			*type;
	XrmValue		value;	

		
	if (!widget_name) return("");
	
	sprintf(resource_name, "XMst%s.value", widget_name);
	
	if (XrmGetResource(config_database, resource_name, NULL, &type, &value)) {
	
		if (value.addr && value.size) {
		
			strncpy(value_string, (char *)value.addr, (int)value.size);
			XmTextSetString(STWIDGET(widget_name), value_string);
			return(value_string);
		}
	}
			
	XmTextSetString(STWIDGET(widget_name), "");
		
	return("");	
}

	


/*
 *	Get single Geometry String Value resource from config_database
 *	return non-allocated string containing geometry on success, NULL elsewhere
 */
/***************************************************************
 *
 * Procedure get_geometry_resource
 *
 ***************************************************************/
#ifdef __STDC__

static
char *get_geometry_resource(
	Widget	  widget,
	char	 *widget_name,
	Boolean	  resize
)

#else

static
char *get_geometry_resource(
	widget,
	widget_name,
	resize
)
Widget	  widget;
char	 *widget_name;
Boolean	  resize;

#endif

{
	char			resource_name[256];
	char			*type;
	XrmValue		value;
	int			x, y;
	unsigned int		width, height;	
	
		
	sprintf(resource_name, "XMst%s.geometry", widget_name);
	
	if (XrmGetResource(config_database, resource_name, NULL, &type, &value)) {
	
		if (value.addr && value.size) {
		
			strncpy(value_string, (char *)value.addr, (int)value.size);
			
			/* Defaults */
			x = y = 0;
			
			XParseGeometry(value_string, &x, &y, &width, &height);
			
			/* Application Shell */
			if (widget == stMainShell) {
			
				XtVaSetValues(	widget,
						XmNgeometry,	value_string,
						NULL);
			} else {
		
				XtRealizeWidget(widget);
			
				XtVaSetValues(	widget,
						XmNx,		x,
						XmNy,		y,
						NULL);
				XtVaSetValues(	XtParent(widget),
						XmNx,		x,
						XmNy,		y,
						NULL);
				if (resize) XtVaSetValues(	widget,
								XmNwidth,	width,
								XmNheight,	height,
								NULL);
			}
			return(strdup(value_string));
			
		} else return(CNULL);
		
	} else return(CNULL);
}




/*
 *	Put configuration / property widget values into database
 */
/***************************************************************
 *
 * Procedure put_resources
 *
 ***************************************************************/
#ifdef __STDC__

void put_resources(
)

#else

void put_resources(
)

#endif

{
	/*
	 *	Properties
	 */
	put_toggle_resource("*st_transient_toggle");
	put_toggle_resource("*st_beep_toggle");
	put_toggle_resource("*st_useeditor_toggle");
	put_toggle_resource("*st_nicelow_toggle");
	put_toggle_resource("*st_nicemedium_toggle");
	put_toggle_resource("*st_nicehigh_toggle");

	put_toggle_resource("*st_autodetect_toggle");
	put_toggle_resource("*st_softrsa_toggle");

	put_toggle_resource("*st_crypt_clipboard_toggle");
	put_toggle_resource("*st_consultcrl_toggle");
	put_toggle_resource("*st_trustfcpath_toggle");
	put_toggle_resource("*st_nosubordination_toggle");
	put_toggle_resource("*st_pserandom_toggle");

	put_toggle_resource("*st_accessdir_toggle");
	put_toggle_resource("*st_authnone_toggle");
	put_toggle_resource("*st_authsimple_toggle");
	put_toggle_resource("*st_authstrong_toggle");
	
	/*
	 *	Configuration
	 */
	put_textfield_resource("*config_psename_textfield");
	put_textfield_resource("*config_caname_textfield");
	put_textfield_resource("*config_editor_textfield");
	put_textfield_resource("*config_printcmd_textfield");
	put_textfield_resource("*config_guide_textfield");
	put_textfield_resource("*config_dsaname_textfield");
	put_textfield_resource("*config_dsaptailor_textfield");
}


/*
 *	Undo configuration
 */
/***************************************************************
 *
 * Procedure undo_configuration
 *
 ***************************************************************/
#ifdef __STDC__

void undo_configuration(
)

#else

void undo_configuration(
)

#endif

{
	
	/*
	 *	Undo configuration textfield changes
	 */
	 
	XmTextSetString(STWIDGET("*config_psename_textfield"), save_config_psename_textfield);
	XmTextSetString(STWIDGET("*config_caname_textfield"), save_config_caname_textfield);
	XmTextSetString(STWIDGET("*config_editor_textfield"), save_config_editor_textfield);
	XmTextSetString(STWIDGET("*config_printcmd_textfield"), save_config_printcmd_textfield);
	XmTextSetString(STWIDGET("*config_guide_textfield"), save_config_guide_textfield);
	XmTextSetString(STWIDGET("*config_dsaname_textfield"), save_config_dsaname_textfield);
	XmTextSetString(STWIDGET("*config_dsaptailor_textfield"), save_config_dsaptailor_textfield);
	
	put_textfield_resource("*config_psename_textfield");
	put_textfield_resource("*config_caname_textfield");
	put_textfield_resource("*config_editor_textfield");
	put_textfield_resource("*config_printcmd_textfield");
	put_textfield_resource("*config_guide_textfield");
	put_textfield_resource("*config_dsaname_textfield");
	put_textfield_resource("*config_dsaptailor_textfield");
	
	set_properties((Widget)NULL);
}


/*
 *	Put single Boolean Toggle Button Value resource to config_database
 */
/***************************************************************
 *
 * Procedure put_toggle_resource
 *
 ***************************************************************/
#ifdef __STDC__

static
void put_toggle_resource(
	char	 *widget_name
)

#else

static
void put_toggle_resource(
	widget_name
)
char	 *widget_name;

#endif

{
	char			resource_name[256];
	XrmValue		value;	

		
	if (!widget_name) return;
	
	sprintf(resource_name, "XMst%s.set", widget_name);
	
	strcpy(value_string, XmToggleButtonGetState(STWIDGET(widget_name)) ? "true" : "false");
	value.size = strlen(value_string) + 1;
	value.addr = value_string;
	
	XrmPutResource(&config_database, resource_name, "String", &value);		
}

	

/*
 *	Put single Textfield String Value resource to config_database
 */
/***************************************************************
 *
 * Procedure put_textfield_resource
 *
 ***************************************************************/
#ifdef __STDC__

static
void put_textfield_resource(
	char	 *widget_name
)

#else

static
void put_textfield_resource(
	widget_name
)
char	 *widget_name;

#endif

{
	char			resource_name[256];
	XrmValue		value;
	

	if (!widget_name) return;
	
	sprintf(resource_name, "XMst%s.value", widget_name);
	
	strcpy(value_string, XmTextGetString(STWIDGET(widget_name)));
	value.size = strlen(value_string) + 1;
	value.addr = value_string;
	
	XrmPutResource(&config_database, resource_name, "String", &value);		
		
}


/*
 *	Put single Geometry String Value resource in config_database
 */
/***************************************************************
 *
 * Procedure put_geometry_resource
 *
 ***************************************************************/
#ifdef __STDC__

static
void put_geometry_resource(
	Widget	  widget,
	char	 *widget_name,
	Boolean   managed,
	char	 *geometry
)

#else

static
void put_geometry_resource(
	widget,
	widget_name,
	managed,
	geometry
)
Widget	  widget;
char	 *widget_name;
Boolean   managed;
char	 *geometry;

#endif

{
	char			resource_name[256];
	char			*type;
	XrmValue		value;
	XWindowAttributes 	win_attributes;
      	XWindowAttributes 	frame_attr;
	XVisualInfo 		vistemplate, *vinfo;
	XSizeHints 		hints;
	int 			dw = DisplayWidth (display, DefaultScreen(display));
	int 			dh = DisplayHeight (display, DefaultScreen(display));
	int 			rx, ry, xright, ybelow;
	int 			showright = 0, showbelow = 0;
	Status 			status;
	Window 			wmframe;
	int 			junk;
	long 			longjunk;
	Window 			junkwin;
	Window			window;
		
		
	
	sprintf(resource_name, "XMst%s.geometry", widget_name);
	
	if (widget == stMainShell) {
		
		window = XtWindow(widget);
	
	} else {

		window = XtWindow(XtParent(widget));
	}
		
	if (managed && (status = XGetWindowAttributes(	display,
							window,
							&win_attributes))) {
						
		if (widget == stMainShell) {
					
			/******************************************
			 ***	This part is taken from:	***
			 ***/
				
				/* Copyright 1987, Massachusetts Institute of Technology */
				
				/*
				 * xwininfo.c	- MIT Project Athena, X Window system window
				 *		  information utility.
				 *
				 * $XConsortium: xwininfo.c,v 1.52 91/05/11 22:32:49 gildea Exp $
				 *
				 *	This program will report all relevant information
				 *	about a specific window.
				 *
				 *  Author:	Mark Lillibridge, MIT Project Athena
				 *		16-Jun-87
				 */
				
			  /* compute size in appropriate units */
			  status = XGetWMNormalHints(display, window, &hints, &longjunk);
			  if (status  &&  hints.flags & PResizeInc  &&
			              hints.width_inc != 0  &&  hints.height_inc != 0) {
			      if (hints.flags & (PBaseSize|PMinSize)) {
				  if (hints.flags & PBaseSize) {
				      win_attributes.width -= hints.base_width;
				      win_attributes.height -= hints.base_height;
				  } else {
				      /* ICCCM says MinSize is default for BaseSize */
				      win_attributes.width -= hints.min_width;
				      win_attributes.height -= hints.min_height;
				  }
			      }
			      sprintf(value_string,	"%dx%d",
			      				win_attributes.width/hints.width_inc,
				     			win_attributes.height/hints.height_inc);
			  } else
			      sprintf(value_string,	"%dx%d",
			      				win_attributes.width,
			      				win_attributes.height);
			  if (!(hints.flags&PWinGravity))
			      hints.win_gravity = NorthWestGravity; /* per ICCCM */
			  /* find our window manager frame, if any */
			  wmframe = window;
			  while (True) {
			      Window root, parent;
			      Window *childlist;
			      unsigned int ujunk;
			
			      status = XQueryTree(display, wmframe, &root, &parent, &childlist, &ujunk);
			      if (parent == root || !parent || !status)
				  break;
			      wmframe = parent;
			      if (status && childlist)
				  XFree((char *)childlist);
			  }
			  if (wmframe != window) {
			      /* WM reparented, so find edges of the frame */
			      /* Only works for ICCCM-compliant WMs, and then only if the
			         window has corner gravity.  We would need to know the original width
				 of the window to correctly handle the other gravities. */
			
			      if (!XGetWindowAttributes(display, wmframe, &frame_attr)) {
			      
				  fprintf(stderr, "Can't get frame attributes.");
				  return;
			      }
			  
			      sprintf(value_string, "%s+%d", value_string, frame_attr.x);
			      sprintf(value_string, "%s+%d", value_string, frame_attr.y);
			  }
						
							
			/***
			 ***	Thanks to Mark Lillibridge.	***
			 ******************************************/
		 
		} else {
												
			sprintf(value_string,	"%dx%d",
			      			win_attributes.width,
			      			win_attributes.height);
			sprintf(value_string, "%s+%d", value_string, win_attributes.x);
			sprintf(value_string, "%s+%d", value_string, win_attributes.y);
      
		}
		      
		value.size = strlen(value_string) + 1;
		value.addr = value_string;
		
		XrmPutResource(&config_database, resource_name, "String", &value);
			
	} else {
	
		if (geometry) {
		
			value.size = strlen(geometry) + 1;
			value.addr = geometry;
			
			XrmPutResource(&config_database, resource_name, "String", &value);
		}
	}
}





/*
 *	get all geometry entries from the resource database
 *	and set widget resources
 */
/***************************************************************
 *
 * Procedure get_geometry_resources
 *
 ***************************************************************/
#ifdef __STDC__

void get_geometry_resources(
)

#else

void get_geometry_resources(
)

#endif

{
	int		i;
	
	
	for (i=0; xmstshells[i].name; i++) {
	
		xmstshells[i].geometry = get_geometry_resource(	xmstshells[i].widget,
		              					xmstshells[i].name,
		              					xmstshells[i].resizable);
	}
}

	
/*
 *	put all shell widget geometry resources into the resource database
 */
/***************************************************************
 *
 * Procedure put_geometry_resources
 *
 ***************************************************************/
#ifdef __STDC__

void put_geometry_resources(
)

#else

void put_geometry_resources(
)

#endif

{
	int		i;
	
	
	for (i=0; xmstshells[i].name; i++)
		put_geometry_resource(	xmstshells[i].widget,
		              		xmstshells[i].name,			              
		              		xmstshells[i].managed,			              
		              		xmstshells[i].geometry);		              
}

/*
 *	save resource database to XMST resource file
 *	write_current = TRUE: do NOT put actual resources into current database, ignore geometry
 *	geometry = TRUE: save geometry of each shell (which has to be realized)
 */
/***************************************************************
 *
 * Procedure save_configuration
 *
 ***************************************************************/
#ifdef __STDC__

void save_configuration(
)

#else

void save_configuration(
)

#endif

{

	XrmDatabase		save_database;
	

	save_database = config_database;
	config_database = (XrmDatabase)NULL;
	
	put_geometry_resources();
	put_resources();
	
	XrmPutFileDatabase(config_database, config_rcfile);

	XFree(config_database);

	config_database = save_database;
	
	backup_configuration();	
	
	/* Disable Auto save and Undo */
	auto_save_configuration = FALSE;
	
	XtVaSetValues(	STWIDGET("*config_undo_pushbutton"),
			XmNsensitive,	FALSE,
			NULL);
	
}


	
/*
 *	backup configuration values (for Undo)
 */
/***************************************************************
 *
 * Procedure backup_configuration
 *
 ***************************************************************/
#ifdef __STDC__

void backup_configuration(
)

#else

void backup_configuration(
)

#endif

{

	
	/* Drop old configuration, save actual one */
	
	XtFree(save_config_psename_textfield);
	XtFree(save_config_caname_textfield);
	XtFree(save_config_editor_textfield);
	XtFree(save_config_printcmd_textfield);
	XtFree(save_config_guide_textfield);
	XtFree(save_config_dsaname_textfield);
	XtFree(save_config_dsaptailor_textfield);
	
	save_config_psename_textfield = XmTextGetString(STWIDGET("*config_psename_textfield"));
	save_config_caname_textfield = XmTextGetString(STWIDGET("*config_caname_textfield"));
	save_config_editor_textfield = XmTextGetString(STWIDGET("*config_editor_textfield"));
	save_config_printcmd_textfield = XmTextGetString(STWIDGET("*config_printcmd_textfield"));
	save_config_guide_textfield = XmTextGetString(STWIDGET("*config_guide_textfield"));
	save_config_dsaname_textfield = XmTextGetString(STWIDGET("*config_dsaname_textfield"));
	save_config_dsaptailor_textfield = XmTextGetString(STWIDGET("*config_dsaptailor_textfield"));
	
}


	
	
/*
 *	Set widget's XmNdeleteResponse to XmDO_NOTHING, add WM Protocol callback to parent
 */
/***************************************************************
 *
 * Procedure add_destroy_callback
 *
 ***************************************************************/
#ifdef __STDC__

void add_destroy_callback(
	Widget	  widget,
	caddr_t	  callback
)

#else

void add_destroy_callback(
	widget,
	callback
)
Widget	  widget;
caddr_t	  callback;

#endif

{
	Atom		WM_DELETE_WINDOW = 	XmInternAtom(	display,
								"WM_DELETE_WINDOW",
								FALSE);
	XtVaSetValues(	widget,
			XmNdeleteResponse,	XmDO_NOTHING,
			NULL);

	XmAddWMProtocolCallback(	XtParent(widget) ? XtParent(widget)
							 : widget,
					WM_DELETE_WINDOW,
					(XtCallbackProc)callback,
					(XtPointer)widget);
}
				

	
/*
 *	Add get/loose focus callbacks
 */
/***************************************************************
 *
 * Procedure add_focus_callbacks
 *
 ***************************************************************/
#ifdef __STDC__

void add_focus_callbacks(
	Widget	  widget
)

#else

void add_focus_callbacks(
	widget
)
Widget	  widget;

#endif

{

    	XtAddCallback(	widget,
			XmNfocusCallback, 	(XtCallbackProc)textfield_focus_cb,
			NULL);
    	XtAddCallback(	widget,
			XmNlosingFocusCallback,	(XtCallbackProc)textfield_focus_cb,
			NULL);
}
				

	
/*
 *	Add check password callbacks
 */
/***************************************************************
 *
 * Procedure add_password_callbacks
 *
 ***************************************************************/
#ifdef __STDC__

void add_password_callbacks(
	Widget	  widget
)

#else

void add_password_callbacks(
	widget
)
Widget	  widget;

#endif

{

    	XtAddCallback(	widget,
			XmNmodifyVerifyCallback,	(XtCallbackProc)check_passwd_cb,
			NULL);
    	XtAddCallback(	widget,
			XmNactivateCallback, 		(XtCallbackProc)check_passwd_cb,
			NULL);
}
				

	
/*
 *	Enable/Disable iconification for complex dialog (that is not transient)
 */
/***************************************************************
 *
 * Procedure change_WM_behavior
 *
 ***************************************************************/
#ifdef __STDC__

static
void change_WM_behavior(
	Widget	  	dialog,
	Boolean		transient
)

#else

static
void change_WM_behavior(
	dialog,
	transient
)
Widget		dialog;
Boolean		transient;

#endif

{
	int		decor;
	int		func;
	Boolean		no_resize;

	XtVaGetValues(	dialog,
			XmNnoResize, 	&no_resize,
			NULL);
			
	if (XmIsMotifWMRunning(applicationShell)) {
	
		decor = MWM_DECOR_BORDER | MWM_DECOR_TITLE | MWM_DECOR_MENU;
		if (!no_resize)	decor |= MWM_DECOR_RESIZEH | MWM_DECOR_MAXIMIZE;
		func = MWM_FUNC_MOVE | MWM_FUNC_CLOSE;
		if (!no_resize) func |= MWM_FUNC_RESIZE | MWM_FUNC_MAXIMIZE;
				
		XtVaSetValues(	XtParent(dialog),
				XmNmwmDecorations, 	decor,
				XmNmwmFunctions, 	func,
				NULL);
	}
			
	XtVaSetValues(	dialog,
			XmNtransient, 	transient,
			NULL);
	XtVaSetValues(	XtParent(dialog),
			XmNtransient, 	transient,
			NULL);
			
}
				

/*
 *	Enable/Disable iconification for all complex dialogs
 */
/***************************************************************
 *
 * Procedure change_WM_behaviors
 *
 ***************************************************************/
#ifdef __STDC__

void change_WM_behaviors(
	Boolean	  transient
)

#else

void change_WM_behaviors(
	transient
)
Boolean	  transient;

#endif

{
	int		i;
	
	
	for (i=0; xmstshells[i].name; i++)
		if (xmstshells[i].widget != stMainShell)
			change_WM_behavior(	xmstshells[i].widget,
			              		transient);			              
}
				



/**************************************************************************
 *
 * Procedure text_wrap_RDN
 *
 **************************************************************************/
#ifdef __STDC__

String text_wrap_RDN(
	String	name
)

#else

String text_wrap_RDN(
	name
)
String	name;

#endif

{
	register int	i;

	for (i=0; i <= (int)strlen(name); i++) {
		if (name[i] == ',') name[++i]='\n';
	}
	
	return(name);
}



/**************************************************************************
 *
 * Procedure text_unwrap_RDN
 *
 **************************************************************************/
#ifdef __STDC__

String text_unwrap_RDN(
	String	name
)

#else

String text_unwrap_RDN(
	name
)
String	name;

#endif

{
	register int	i;

	for (i=0; i <= (int)strlen(name); i++) {
		if (name[i] == '\n') name[i]=' ';
	}
	
	return(name);
}




/**************************************************************************
 *
 * Procedure setCursor
 *
 **************************************************************************/
#ifdef __STDC__

void setCursor(
	Boolean	 		on,
	char			cuswitch,
	Widget			widget
	)
	
#else

void setCursor(
	on,
	cuswitch,
	widget
	)
Boolean			on;
char			cuswitch;
Widget			widget;

#endif

{
	static 	Cursor	busy_cursor  = (Cursor)NULL;
	static	Cursor	think_cursor = (Cursor)NULL;
	static 	int 	busy = 0;
	static	int	think= 0;
	Cursor	cursor;
	int	i;

	if( !busy_cursor )  busy_cursor  = applResources.busycursor;
	if( !think_cursor ) think_cursor = applResources.thinkcursor;
	
	switch(cuswitch){
		case 'b':
			if(on) 		  busy++;
			else if( busy> 0) busy--;
			cursor = ( busy>0 ) ? busy_cursor : (( think>0 ) ? think_cursor : None);
			break;
		case 't':
			if(on) 		   think++;
			else if( think>0 ) think--;
			cursor = ( think>0 ) ? think_cursor : (( busy>0 ) ? busy_cursor : None);
			break;
	}		
	
	if( !widget ){
		for(i=0; xmstshells[i].name; i++)
			if( xmstshells[i].cursor )
				XDefineCursor(display, 
				              XtWindow(xmstshells[i].widget),
				              cursor);			              
 	}
 	else{
 		XDefineCursor(display, XtWindow(widget), cursor);
 	}
 	
	XFlush(display);
}



/**************************************************************************
 *
 * Procedure setManaged
 *
 **************************************************************************/
#ifdef __STDC__

void setManaged(
	Widget			widget
	)
	
	
#else

void setManaged(
	widget
	)
Widget			widget;

#endif

{
	int	i;

	
	if( !widget ) return;
	
	for(i=0; xmstshells[i].name; i++)
		if( xmstshells[i].widget == widget ) {
			xmstshells[i].managed = TRUE;
			break;
		}
}



/**************************************************************************
 *
 * Procedure util_XmStringTableCreate
 *
 * Last modified: 15.12.94
 *
 **************************************************************************/
#ifdef __STDC__

XmStringTable util_XmStringTableCreate(
	int		count
	)
	
#else

XmStringTable util_XmStringTableCreate(
	count
	)
int		count;

#endif

{
	String		proc = "util_XmStringTableCreate";
	XmStringTable	new;
	
	if( !(new = (XmStringTable) XtCalloc((count+1), sizeof(XmString))) ){
		fprintf(stderr, "Can't allocate memory for XmStringTable in %s!\n", proc);	
		exit(-1);
	}
	else{
		new[0] = (XmString)count;
		return &new[1];
	}
}



/**************************************************************************
 *
 * Procedure util_XmStringTableDelete
 *
 * Last modified: 15.12.94
 *
 **************************************************************************/
#ifdef __STDC__

void util_XmStringTableDelete(
	XmStringTable		*strtable
	)
	
#else

void util_XmStringTableDelete(
	strtable
	)
XmStringTable		*strtable;

#endif

{
	int count;
	int i = 0;
	
	if( *strtable ){
		count = (int)(*strtable)[-1];
		while( i<count )
			XmStringFree( (*strtable)[i++] );
		XtFree((char *)&(*strtable)[-1]);
		*strtable = NULL;
	}
}



/**************************************************************************
 *
 * Procedure util_XmStringTableCopy
 *
 * Last modified: 15.12.94
 *
 **************************************************************************/
#ifdef __STDC__

XmStringTable util_XmStringTableCopy(
	XmStringTable		strtable
	)
	
#else

XmStringTable util_XmStringTableCopy(
	strtable
	)
XmStringTable		strtable;

#endif

{
	int 		count;
	XmStringTable	new;
	int 		i = 0;
	
	if( strtable ){
		count = (int)strtable[-1];
		new   = util_XmStringTableCreate(count);
		for(i=0; i<count; i++)
			new[i] = XmStringCopy(strtable[i]);
		return new;
	}
	else	return NULL;
}



/**************************************************************************
 *
 * Procedure util_XmStringTableInsert
 *
 * Last modified: 28.11.94
 *
 **************************************************************************/
#ifdef __STDC__

void util_XmStringTableInsert(
	XmStringTable		strtable,
	int			number,
	String			string
	)
	
#else

void util_XmStringTableInsert(
	strtable,
	number,
	string
	)
XmStringTable		strtable;
int			number;
String			string;
#endif

{
	strtable[number] = XmStringCreateLocalized(string);
}



/**************************************************************************
 *
 * Procedure BitStr2decOctStr
 *
 * Last modified: 02.03.95
 *
 **************************************************************************/
#ifdef __STDC__

OctetString *BitStr2decOctStr(
	BitString	*bitstr
	)
	
#else

OctetString *BitStr2decOctStr(
	bitstr
	)
BitString	*bitstr;

#endif

{
	OctetString *octetstr;
	
	octetstr	  = (OctetString *)malloc(sizeof(OctetString));
	octetstr->noctets = 0;
	octetstr->octets  = (char *)malloc(sizeof(char) * (int)(bitstr->nbits / 8));
	
	if(des_decrypt(	bitstr,
			octetstr,
			SEC_END,
			&session_key) < 0){
		/*** error ***/
	}
	return(octetstr);
}



/**************************************************************************
 *
 * Procedure OctStr2encBitStr
 *
 * Last modified: 02.03.95
 *
 **************************************************************************/
#ifdef __STDC__

BitString *OctStr2encBitStr(
	OctetString	*octetstr
	)
	
#else

BitString *OctStr2encBitStr(
	octetstr
	)
OctetString	*octetstr;

#endif

{
	BitString *bitstr;

	bitstr        = (BitString *)malloc(sizeof(BitString));
	bitstr->nbits = 0;
	bitstr->bits  = (char *)malloc(sizeof(char) * (octetstr->noctets + 8));
	
	if(des_encrypt(	octetstr,
			bitstr,
			SEC_END,
			&session_key) < 0){
		/*** error ***/
	}
	return(bitstr);
}



/**************************************************************************
 *
 * Procedure set_pse_ca
 *
 **************************************************************************/
#ifdef __STDC__

void set_pse_ca(
	)
	
#else

void set_pse_ca(
	)
#endif

{

	if (aux_set_pse(pse_name, ca_dir) < 0) {
	
		fprintf(stderr, "Can't set PSE!\n");
		exit_sectool;
	}
	
	last_pse_name = pse_name ? strdup(pse_name)
				 : CNULL;
	last_ca_dir = ca_dir ? strdup(ca_dir)
			     : CNULL;
	
	if (pse_path) free(pse_path);
	pse_path = aux_cpy_String(AF_pse.app_name);

}













