/* ./src/util/xmsectool/dialogs.c */

static char *rcsid = "$Id: dialogs.c,v 1.18 1995/03/16 14:42:30 koletzki Exp $";

/*
 * $Id: dialogs.c,v 1.18 1995/03/16 14:42:30 koletzki Exp $
 *
 * $Log: dialogs.c,v $
 * 	configuration
 * 	properties
 * 	clipboard
 *
 * Revision 1.8  1994/12/09  17:02:33  koletzki
 * clipboard copy/retrieve/swap
 * object copy/cut
 *
 * Revision 1.7  1994/11/24  18:15:56  koletzki
 * *** empty log message ***
 *
 * Revision 1.6  1994/11/14  18:28:35  koletzki
 * Color & font resources
 *
 * Revision 1.5  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.4  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/






/*
 ************************
 *	INCLUDES	*
 ************************
 */

#include "xmst.h"
#include "dialogs.h"


/*
 ************************
 *	STATICS		*
 ************************
 */

#ifdef __STDC__

       static RC	file2object	(Widget dialog, char *object_name, char *file_name);
       static RC	object2file	(Widget dialog, char *object_name, char *file_name);
       static void	backup_config_values	(Boolean restore);
#else

	static RC	file2object();
	static RC	object2file();
       static void	backup_config_values	();
#endif



/*
 *	Loop until dialog is finished
 */
/***************************************************************
 *
 * Procedure dialog_loop
 *
 ***************************************************************/
#ifdef __STDC__

void dialog_loop(
)

#else

void dialog_loop(
)

#endif

{

	dialog_finished = FALSE;
	while (!dialog_finished) XtAppProcessEvent(applicationContext, XtIMAll);
}


/*
 *	Import object from file to PSE
 */
/***************************************************************
 *
 * Procedure file2object
 *
 ***************************************************************/
#ifdef __STDC__

static
RC file2object(
	Widget	  dialog,
	char	 *object_name,
	char	 *file_name
)

#else

static
RC file2object(
	dialog,
	object_name,
	file_name
)
Widget	  dialog;
char	 *object_name;
char	 *file_name;

#endif

{
	char			*proc = "file2object";
	OctetString		*PSEcontent;
	ObjId			PSEoid;
	OctetString		*content;
	void			*opaque;
	ObjId			*object_type;
	char			*ron;
	char			*rfn;

	
	if (!object_name || !(ron = aux_cpy_ReducedString(object_name))
	    || !file_name || !(rfn = aux_cpy_ReducedString(file_name))
	    || (file_name[strlen(file_name) - 1] == PATH_SEPARATION_CHAR)) {
	
		ALARM();
		
		if (ron) free(ron);
		if (rfn) free(rfn);
		
		return(-1);
	}
	
	free(ron);
	free(rfn);
	
	BUSY_CURSOR();
	
        if (! (content = aux_file2OctetString(file_name)) ) {
        
		sprintf(dialog_message, "Unable to read from file:\n\"%s\"", file_name);
		ok_dialog_open(dialog, dialog_message);
		IDLE_CURSOR();
		
		return(-1);
        }
        
        /* PSEObject wrapper found */
        if (PSEcontent = d_PSEObject(&PSEoid, content)) {
        
        	aux_free_OctetString(&content);
        	content = PSEcontent;
        }
        
        object_oid = &oid;
	if (! (opaque = af_pse_decode(object_name, content, object_oid)) ) {
        
        	object_type = af_get_objoid(object_name);
        	
        	/* standard object was selected */
        	if (aux_cmp_ObjId(object_type, Uid_OID)) {
        	
	        	if (PSEcontent) aux_free2_ObjId(&PSEoid);
	        	aux_free_OctetString(&content);
	        	aux_free2_ObjId(object_oid);
	        	aux_free_ObjId(&object_type);
			sprintf(dialog_message,
				"Object in file has not the type\nof selected standard object:\n\"%s\"",
				file_name);
			ok_dialog_open(dialog, dialog_message);
			IDLE_CURSOR();
			
			return(-1);
		
		} else {
		
	        	if (PSEcontent) aux_free2_ObjId(&PSEoid);
	        	aux_free_OctetString(&content);
	        	aux_free2_ObjId(object_oid);
	        	aux_free_ObjId(&object_type);
			sprintf(dialog_message, "Unable to decode content of file:\n\"%s\"", file_name);
			ok_dialog_open(dialog, dialog_message);
			IDLE_CURSOR();
			
			return(-1);
		}
        }
        
        /* non-standard object: OID for single key pair PSE is returned for some objects */
 	if (!onekeypaironly) {
 	
 		if (!aux_cmp_ObjId(object_oid, Cert_OID)) {
 		
 			aux_free2_ObjId(object_oid);
 			sprintf(dialog_message, "Select the type of Certificate:\n\"%s\"", object_name);
 			if (signature_dialog_open(dialog, dialog_message))
 				aux_cpy2_ObjId(object_oid, SignCert_OID);
 			else
 				aux_cpy2_ObjId(object_oid, EncCert_OID);
 				
 		} else if (!aux_cmp_ObjId(object_oid, CSet_OID)) {
 		
 			aux_free2_ObjId(object_oid);
 			sprintf(dialog_message, "Select the type of Certificates:\n\"%s\"", object_name);
 			if (signature_dialog_open(dialog, dialog_message))
 				aux_cpy2_ObjId(object_oid, SignCSet_OID);
 			else
 				aux_cpy2_ObjId(object_oid, EncCSet_OID);
 				
 		} else if (!aux_cmp_ObjId(object_oid, PKList_OID)) {
 		
 			aux_free2_ObjId(object_oid);
 			sprintf(dialog_message, "Select the type of Trusted Key List:\n\"%s\"", object_name);
 			if (signature_dialog_open(dialog, dialog_message))
 				aux_cpy2_ObjId(object_oid, PKList_OID);
 			else
 				aux_cpy2_ObjId(object_oid, EKList_OID);
 				
 		}
 	}
 	
 	if (af_pse_update(	object_name,
 				opaque,
 				PSEcontent ? &PSEoid : object_oid)) {
        
		sprintf(dialog_message, "Unable to update object:\n\"%s\"", object_name);
		ok_dialog_open(dialog, dialog_message);
 		af_pse_free(&opaque, object_oid);
	        aux_free_OctetString(&content);
		IDLE_CURSOR();
		
		return(-1);
	}
	
        if (PSEcontent) aux_free2_ObjId(&PSEoid);
 	af_pse_free(&opaque, object_oid);
        aux_free_OctetString(&content);
	IDLE_CURSOR();
	
	
	return(0);
 }


/*
 *	Export object from PSE to file
 */
/***************************************************************
 *
 * Procedure object2file
 *
 ***************************************************************/
#ifdef __STDC__

static
RC object2file(
	Widget	  dialog,
	char	 *object_name,
	char	 *file_name
)

#else

static
RC object2file(
	dialog,
	object_name,
	file_name
)
Widget	  dialog;
char	 *object_name;
char	 *file_name;

#endif

{
	char			*proc = "object2file";
	char			*new_file_name;
	void			*opaque;
	ObjId			opaque_oid;
	OctetString		*content;
	char			*ron;
	char			*rfn;

	
	if (!object_name || !(ron = aux_cpy_ReducedString(object_name))
	    || !file_name || !(rfn = aux_cpy_ReducedString(file_name))) {
	
		ALARM();
		
		if (ron) free(ron);
		if (rfn) free(rfn);
		
		return(-1);
	}
	
	free(ron);
	free(rfn);
	
	BUSY_CURSOR();

	if (file_name[strlen(file_name) - 1] != PATH_SEPARATION_CHAR) new_file_name = aux_cpy_String(file_name);
	else new_file_name = CATNSTR(file_name, object_name, strlen(object_name));
	
	if (! (opaque = af_pse_get(object_name, &opaque_oid)) ) {
	
        	free(new_file_name);
		sprintf(dialog_message,"Object contains no data or unable to open:\n\"%s\"", object_name);
		ok_dialog_open(dialog, dialog_message);
		IDLE_CURSOR();

		return(-1);
	}
	
	if (! (content = af_pse_encode(object_name, opaque, &opaque_oid)) ) {
	
        	free(new_file_name);
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
		sprintf(dialog_message, "Unable to encode object:\n\"%s\"", object_name);
		ok_dialog_open(dialog, dialog_message);
		IDLE_CURSOR();

		return(-1);
        }
       
        if (aux_OctetString2file(content, new_file_name, 2) < 0) {
        
		sprintf(dialog_message, "Unable to write to file:\n\"%s\"", new_file_name);
		ok_dialog_open(dialog, dialog_message);
        }
        
        free(new_file_name);
	af_pse_free(&opaque, &opaque_oid);
	aux_free2_ObjId(&opaque_oid);
 	aux_free_OctetString(&content);
	IDLE_CURSOR();


	return(0);
}


/*
 *	Get XmStringTable of PSE-object names
 */
/***************************************************************
 *
 * Procedure get_object_table
 *
 ***************************************************************/
#ifdef __STDC__

XmStringTable get_object_table(
)

#else

XmStringTable get_object_table(
)

#endif

{
	char				*proc = "get_object_table";
	int				items;
	XmStringTable			object_table;


	items = count_clientdata(pselist_clientdata);
	
	object_table = (XmStringTable) XtMalloc ((items + 1) * sizeof (XmString));
	object_table[items] = (XmString)NULL;
	while (--items >= 0)
		object_table[items] = XmStringCreateLocalized((char *)get_clientdata(pselist_clientdata, (items + 1)));
	
	
	return(object_table);
}
	

/*
 *	Get XmStringTable of Algorithm names
 */
/***************************************************************
 *
 * Procedure get_alg_table
 *
 ***************************************************************/
#ifdef __STDC__

XmStringTable get_alg_table(
)

#else

XmStringTable get_alg_table(
)

#endif

{
	char				*proc = "get_alg_table";
	AlgList 			*alge = &alglist[0];
	int				items = no_of_algorithms;
	XmStringTable			object_table;


	
	object_table = (XmStringTable) XtMalloc ((items + 1) * sizeof(XmString));
	object_table[items] = (XmString)NULL;

	while (--items >= 0)
		object_table[items] = XmStringCreateLocalized(alglist[items].name);
	

	return(object_table);
}
	
	
	
	
/*
 *	Free XmStringTable of PSE-objects
 */
/***************************************************************
 *
 * Procedure free_table
 *
 ***************************************************************/
#ifdef __STDC__

void free_table(
	XmStringTable	  object_table
)

#else

void free_table(
	object_table
)
XmStringTable	  object_table;

#endif

{
	char				*proc = "free_table";
	int				items;


	for (items = 0; object_table[items]; items++)
		XmStringFree(object_table[items]);
		
	XtFree((char *)object_table);
}




/*
 *	PIN dialog
 */
/***************************************************************
 *
 * Procedure pin_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void pin_dialog_open(
	int	  pin_failure_count_init
)

#else

void pin_dialog_open(
	pin_failure_count_init
)
int	  pin_failure_count_init;

#endif

{
	char		*proc = "pin_dialog_open";
	Widget 		dialog = STWIDGET("*pin_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	sprintf(dialog_message, "Enter PIN for PSE\n\"%s\"", pse_path);
	XtVaSetValues(	dialog,
			XmNselectionLabelString, 	cmpd_message = CPDSTRING(dialog_message),
			NULL);
	XmStringFree(cmpd_message);

	MANAGE_DIALOG(dialog);

	passwd = aux_cpy_String("");
	XmTextSetString(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT), "");

	pin_failure_count = pin_failure_count_init;

	ALARM();

	dialog_loop();
}


/***************************************************************
 *
 * Procedure pin_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void pin_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void pin_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> pin_dialog_cb\n");

	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
			/* get pin */
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			exit_sectool();
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

	/*
	 *	empty PIN: wait for next event
	 */
	strcpy(dialog_pin, passwd);
	if (!strcmp(dialog_pin, ""))  {		/* btw.: PIN with blank margins is allowed */

		MANAGE_DIALOG(widget);
		ALARM();

		return;
	}

	/* XMST does not check for USERPIN / CAPIN in environment! */
	
	if (aux_create_AFPSESel(pse_path, dialog_pin) < 0)  {

		fprintf(stderr, "%s: ", xmst_argv[0]);
		fprintf(stderr, "Cannot create AFPSESel.\n"); 
		if (verbose) aux_fprint_error(stderr, 0);

		abort_dialog_open(applicationShell, "Cannot create AFPSESel.");
	}

	if (verbose) fprintf(stderr, "  aux_create_AFPSESel() OK\n");

	if(! (pse_sel = af_pse_open((ObjId *)0, FALSE)) || !sec_pin_check(pse_sel, "pse", dialog_pin) )  {

		if (verbose) aux_fprint_error(stderr, 0);

		if (verbose) fprintf(stderr, "%s: unable to open PSE %s\n", xmst_argv[0], AF_pse.app_name);

		++pin_failure_count;
		if (pin_failure_count >= XMST_PIN_FAILURES)  {

			abort_dialog_open(applicationShell, "Seems as if you don't know\nthe magic word...");
		}
		else {

			passwd = aux_cpy_String("");
			XmTextSetString(XmSelectionBoxGetChild(widget, XmDIALOG_TEXT), "");

			MANAGE_DIALOG(widget);
			ALARM3();
		}
	
		return;
	}

	dialog_finished = TRUE;
}


/*
 *	Change PIN dialog
 */
/***************************************************************
 *
 * Procedure chpin_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void chpin_dialog_open(
)

#else

void chpin_dialog_open(
)

#endif

{
	char		*proc = "chpin_dialog_open";
	Widget 		dialog = STWIDGET("*chpin_dialog");
	XmString	cmpd_message;
	char		new_pin[XMST_PIN_LENGTH + 1];


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	BUSY_CURSOR();

#ifdef SCA

        if(sec_psetest(std_pse.app_name) == SCpse) goto re_encrypt;

#endif

	/*
	 *	OLD pin
	 */
	sprintf(dialog_message, "Enter Old PIN for PSE\n\"%s\"", pse_path);
	XtVaSetValues(	dialog,
			XmNselectionLabelString, 	cmpd_message = CPDSTRING(dialog_message),
			NULL);
	XmStringFree(cmpd_message);
	XmTextSetString(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT), "");
	passwd = aux_cpy_String("");

	MANAGE_DIALOG(dialog);
	dialog_loop();

	if (strcmp(dialog_pin, std_pse.pin)) {

		ALARM();
		IDLE_CURSOR();

		return;
	}

	/*
	 *	NEW pin
	 */
	sprintf(dialog_message, "Enter New PIN for PSE\n\"%s\"", pse_path);
	XtVaSetValues(	dialog,
			XmNselectionLabelString, 	cmpd_message = CPDSTRING(dialog_message),
			NULL);
	XmStringFree(cmpd_message);
	XmTextSetString(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT), "");
	passwd = aux_cpy_String("");

	MANAGE_DIALOG(dialog);
	dialog_loop();

	if (!strcmp(dialog_pin, "")) {

		ALARM();
		IDLE_CURSOR();

		return;
	}

	strcpy(new_pin, dialog_pin);

	/*
	 *	REENTER NEW pin
	 */
	sprintf(dialog_message, "Re-Enter New PIN for PSE\n\"%s\"", pse_path);
	XtVaSetValues(	dialog,
			XmNselectionLabelString, 	cmpd_message = CPDSTRING(dialog_message),
			NULL);
	XmStringFree(cmpd_message);
	XmTextSetString(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT), "");
	passwd = aux_cpy_String("");

	MANAGE_DIALOG(dialog);
	dialog_loop();

	if (strcmp(new_pin, dialog_pin)) {

		ALARM();
		IDLE_CURSOR();

		return;
	}

re_encrypt:

	std_pse.object.name = CNULL;
	/* Re-encrypt PSE-toc and all PSE-objects */
	if (sec_chpin(&std_pse, new_pin) != 0) {

		sprintf(dialog_message, "Can't change PIN for PSE\n\"%s\"", pse_path);
		cont_quit_dialog_open(dialog, dialog_message);

		IDLE_CURSOR();

		return;
	}
	/* Free obsolete pins */
	if(AF_pse.pin) strzfree(&(AF_pse.pin));
	for (i = 0; i < PSE_MAXOBJ; i++) {
		if(AF_pse.object[i].pin) strzfree(&(AF_pse.object[i].pin));
	}

	/* Assign new pin-values to AFPSESel */
	if (aux_create_AFPSESel(pse_path, new_pin) < 0) {

		aux_fprint_error(stderr, verbose);

		sprintf(dialog_message, "Can't change PIN for PSE\n\"%s\"", pse_path);
		cont_quit_dialog_open(dialog, dialog_message);

		IDLE_CURSOR();

		return;
	}
	std_pse.app_name = aux_cpy_String(AF_pse.app_name);
	std_pse.object.pin = aux_cpy_String(AF_pse.pin);
	std_pse.pin = aux_cpy_String(AF_pse.pin);
	std_pse.app_id = AF_pse.app_id;

	IDLE_CURSOR();
}


/***************************************************************
 *
 * Procedure chpin_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void chpin_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void chpin_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> chpin_dialog_cb\n");

	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
			/* get pin */

			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:
			/* cancel change pin */
			if (passwd) free(passwd);
			passwd = aux_cpy_String("");

			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

	strcpy(dialog_pin, passwd);

	dialog_finished = TRUE;

	return;
}






/*
 *	Add Alias dialog
 */
/***************************************************************
 *
 * Procedure addalias_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void addalias_dialog_open(
	char	 *message
)

#else

void addalias_dialog_open(
	message
)
char	 *message;

#endif

{
	char		*proc = "addalias_dialog_open";
	Widget 		dialog = STWIDGET("*addalias_dialog");
	XmString	cmpd_message;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNselectionLabelString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmTextSetString(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT), "");
	MANAGE_DIALOG(dialog);
	XmStringFree(cmpd_message);


	dialog_loop();
}


/***************************************************************
 *
 * Procedure addalias_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void addalias_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void addalias_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;
	char				*alias;
	char				*name;


	if (sectool_verbose) fprintf(stderr, "--> addalias_dialog_cb\n");

	XmUpdateDisplay(applicationShell);
 
	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:

			alias_to_add = aux_cpy_ReducedString(XmTextGetString(
						XmSelectionBoxGetChild(widget, XmDIALOG_TEXT)));
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			dialog_finished = TRUE;

			return;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

	if (alias_to_add)  {

		if (aux_alias(alias_to_add) != notstored)  {
	
			ok_dialog_open(applicationShell, "Alias already exists.");
			dialog_finished = FALSE;
			free(alias_to_add);
			alias_to_add = CNULL;
			MANAGE_DIALOG(widget);

			return;

		} else dialog_finished = TRUE;

	} else MANAGE_DIALOG(widget);
}



/*
 *	Prompt dialog
 */
/***************************************************************
 *
 * Procedure prompt_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

char *prompt_dialog_open(
	Widget	  parent,
	char	 *message,
	char	 *text
)

#else

char *prompt_dialog_open(
	parent,
	message,
	text
)
Widget	  parent;
char	 *message;
char	 *text;

#endif

{
	char			*proc = "addalias_dialog_open";
	Widget 			dialog = STWIDGET("*prompt_dialog");
	XmString		cmpd_message;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNselectionLabelString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmTextSetString(XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT), text ? text : "");
	MANAGE_DIALOG(dialog);
	XmStringFree(cmpd_message);

	dialog_loop();
	
	if (dialog_ok) return( aux_cpy_ReducedString(XmTextGetString(
						XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT))) );
	else return(CNULL);
}



/*
 *	OK dialog
 */
/***************************************************************
 *
 * Procedure ok_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void ok_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

void ok_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "ok_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*ok_dialog");
	XmString	cmpd_message;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	
	BUSY_CURSOR();
	MANAGE_DIALOG(dialog);

	dialog_loop();
	IDLE_CURSOR();
}


/***************************************************************
 *
 * Procedure ok_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void ok_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void ok_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> ok_dialog_cb\n");

	XmUpdateDisplay(applicationShell);
	
	dialog_finished = TRUE;
}




/*
 *	Error dialogs
 */
/***************************************************************
 *
 * Procedure abort_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void abort_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

void abort_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "abort_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*abort_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);


	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();
}

/***************************************************************
 *
 * Procedure retr_abort_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean retr_abort_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean retr_abort_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "retr_abort_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*retr_abort_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}


/***************************************************************
 *
 * Procedure cont_quit_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void cont_quit_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

void cont_quit_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "cont_quit_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*cont_quit_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);


	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();
}


/***************************************************************
 *
 * Procedure cont_canc_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean cont_canc_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean cont_canc_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "cont_canc_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*cont_canc_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}



/***************************************************************
 *
 * Procedure question_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean question_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean question_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "question_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*question_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}




/***************************************************************
 *
 * Procedure repl_canc_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean repl_canc_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean repl_canc_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "repl_canc_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*repl_canc_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}




/***************************************************************
 *
 * Procedure retr_canc_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean retr_canc_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean retr_canc_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "retr_canc_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*retr_canc_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}


/***************************************************************
 *
 * Procedure toolquit_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void toolquit_dialog_open(
	Widget	  parentShell
)

#else

void toolquit_dialog_open(
	parentShell
)
Widget	  parentShell;

#endif

{
	char		*proc = "toolquit_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*toolquit_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	cmpd_message = CPDSTRING("Confirm termination of SecTool\n  or just close this subtool.");
	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message,
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();
}

/***************************************************************
 *
 * Procedure toolquit_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void toolquit_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void toolquit_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs = (XmSelectionBoxCallbackStruct *)callback_data;


	if (sectool_verbose) fprintf(stderr, "--> toolquit_dialog_cb\n");

	XmUpdateDisplay(applicationShell);

	switch (cbs->reason) {

		case XmCR_OK:		/* Quit */

			exit_sectool();
			break;

		case XmCR_CANCEL:	/* Close Tool */
		case XmCR_PROTOCOLS:

			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

	dialog_finished = TRUE;
}




/***************************************************************
 *
 * Procedure error_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void error_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void error_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> error_dialog_cb\n");

	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
		
			dialog_finished = TRUE;
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:
		
			exit_sectool();
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
}


/*
 *	Warning dialogs
 */
/***************************************************************
 *
 * Procedure warning_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void warning_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void warning_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> warning_dialog_cb\n");

	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
		
			dialog_ok = TRUE;
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:
		
			dialog_ok = FALSE;
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

	dialog_finished = TRUE;
}


/*
 *	Question dialogs
 */
/***************************************************************
 *
 * Procedure question_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void question_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void question_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> question_dialog_cb\n");

	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
		
			dialog_ok = TRUE;
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:
		
			dialog_ok = FALSE;
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

	dialog_finished = TRUE;
}



/*
 *	Debug dialog
 */
/***************************************************************
 *
 * Procedure debug_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void debug_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void debug_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> debug_dialog_cb\n");

	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:

			XtUnmanageChild(widget);
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			aux_free_error();
			XmTextSetString(STWIDGET("*debug_text"), "");
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
}



/*
 *	Guide dialog
 */
/***************************************************************
 *
 * Procedure guide_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void guide_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void guide_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			XtUnmanageChild(widget);
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason %d!\n", cbs->reason);
	}
}


/*
 *	Viewer dialog
 */
/***************************************************************
 *
 * Procedure viewer_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void viewer_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void viewer_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:
		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			XtUnmanageChild(widget);
			XtUnmanageChild(name2widget(widget, "*ok_dialog"));
			XtUnmanageChild(name2widget(widget, "*printing_dialog"));
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason %d!\n", cbs->reason);
	}
}



/*
 *	Viewer clear
 */
/***************************************************************
 *
 * Procedure viewer_clear_cb
 *
 ***************************************************************/
#ifdef __STDC__

void viewer_clear_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void viewer_clear_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{

	XmTextSetString(STWIDGET("*viewer_text"), "");
}



/*
 *	Viewer print
 */
/***************************************************************
 *
 * Procedure viewer_print_cb
 *
 ***************************************************************/
#ifdef __STDC__

void viewer_print_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void viewer_print_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	Widget				dialog = STWIDGET("*viewer_dialog");
	char				*string;
		
		
	print_string(dialog, (string = XmTextGetString(STWIDGET("*viewer_text"))));
	
	XtFree(string);

	XmUpdateDisplay(applicationShell);
}



/*
 *	Configuration dialog
 */
/***************************************************************
 *
 * Procedure config_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean config_dialog_open(
)

#else

Boolean config_dialog_open(
)

#endif

{

	
	/* save config dialog values */
	backup_config_values(FALSE);
	
	MANAGE_DIALOG(STWIDGET("*config_dialog"));
	
	dialog_loop();
	
	IDLE_CURSOR();
	
	return(dialog_ok);
}



/***************************************************************
 *
 * Procedure config_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void config_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void config_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		/* Undo pushbutton */
		case XmCR_ACTIVATE:

			undo_configuration();
			
			return;

		/* defaults buttons */
		case XmCR_OK:

			set_properties(widget);
			
			dialog_ok = TRUE;
			XtUnmanageChild(widget);
			break;

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			/* restore config dialog values */
			backup_config_values(TRUE);
			dialog_ok = FALSE;
			XtUnmanageChild(widget);
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
	
	dialog_finished = TRUE;
}


/*
 *	Save / Restore config dialog values
 */
/***************************************************************
 *
 * Procedure backup_config_values
 *
 ***************************************************************/
#ifdef __STDC__

static void backup_config_values(
	Boolean		restore
)

#else

static void backup_config_values(
	restore
)
Boolean		restore;

#endif

{
	static char		*save_psename = CNULL;
	static char		*save_caname = CNULL;
	static char		*save_editor = CNULL;
	static char		*save_printcmd = CNULL;
	static char		*save_guide = CNULL;
	static char		*save_dsaname = CNULL;
	static char		*save_dsaptailor = CNULL;


	if (restore) {
	
		/*
		 *	Fill config dialog widgets with saved values
		 */
		XmTextSetString(STWIDGET("*config_psename_textfield"), save_psename);
		XmTextSetString(STWIDGET("*config_caname_textfield"), save_caname);
		XmTextSetString(STWIDGET("*config_editor_textfield"), save_editor);
		XmTextSetString(STWIDGET("*config_printcmd_textfield"), save_printcmd);
		XmTextSetString(STWIDGET("*config_guide_textfield"), save_guide);
		XmTextSetString(STWIDGET("*config_dsaname_textfield"), save_dsaname);
		XmTextSetString(STWIDGET("*config_dsaptailor_textfield"), save_dsaptailor);
		
		if (save_psename) free(save_psename);
		if (save_caname) free(save_caname);
		if (save_editor) free(save_editor);
		if (save_printcmd) free(save_printcmd);
		if (save_guide) free(save_guide);
		if (save_dsaname) free(save_dsaname);
		if (save_dsaptailor) free(save_dsaptailor);
		
		
	} else {
	
		/*
		 *	Fill config dialog widgets with saved values
		 */
		save_psename = XmTextGetString(STWIDGET("*config_psename_textfield"));
		save_caname = XmTextGetString(STWIDGET("*config_caname_textfield"));
		save_editor = XmTextGetString(STWIDGET("*config_editor_textfield"));
		save_printcmd = XmTextGetString(STWIDGET("*config_printcmd_textfield"));
		save_guide = XmTextGetString(STWIDGET("*config_guide_textfield"));
		save_dsaname = XmTextGetString(STWIDGET("*config_dsaname_textfield"));
		save_dsaptailor = XmTextGetString(STWIDGET("*config_dsaptailor_textfield"));
	}
}	
			



/***************************************************************
 *
 * Procedure clipboard_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void clipboard_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void clipboard_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	static Boolean			first = TRUE;
	static Boolean			last_af_verbose;
	static unsigned char		last_print_keyinfo_flag;
	static unsigned int		last_print_cert_flag;
	
	XmSelectionBoxCallbackStruct	*cbs;
	void				*data_id = NULL;
	void				*opaque = NULL;
	ObjId				opaque_oid;
	Boolean				save_af_verbose;
	unsigned char			save_print_keyinfo_flag;
	unsigned int			save_print_cert_flag;
	ClipboardSource			source;
	
	
	BUSY_CURSOR();
	
	if (first) {
		last_af_verbose = (int)af_verbose;
		last_print_keyinfo_flag = print_keyinfo_flag;
		last_print_cert_flag = print_cert_flag;
		first = FALSE;
	}
	save_af_verbose = af_verbose;
	save_print_keyinfo_flag = print_keyinfo_flag;
	save_print_cert_flag = print_cert_flag;
	
	if (widget == STWIDGET("*clipboard_dialog")) {

		cbs = (XmSelectionBoxCallbackStruct *)callback_data;
	
		switch (cbs->reason) {
	
			case XmCR_OK:
			case XmCR_CANCEL:
			case XmCR_PROTOCOLS:
	
				XtUnmanageChild(widget);
				break;
			default:
		 		if (sectool_verbose)
		 			fprintf(stderr, "Oops - unknown callback reason!\n");
		}
		
	} else if (widget == STWIDGET("*clipboard_swap_drawnbutton")) {
	
		af_verbose = last_af_verbose;
        	print_keyinfo_flag = last_print_keyinfo_flag;
        	print_cert_flag = last_print_cert_flag;
        	
		clipboard_swap(STWIDGET("*clipboard_dialog"));
		
		source = clipboard_retrieve(STWIDGET("*clipboard_dialog"), &data_id, &opaque, &opaque_oid);

		if (source <= CB_PSE) goto clipboard_error;
		
	} else if (widget == STWIDGET("*clipboard_nicelow_drawnbutton")) {
		
		last_af_verbose = af_verbose = FALSE;
        	last_print_keyinfo_flag = print_keyinfo_flag = ALGID;
        	last_print_cert_flag = print_cert_flag = (TBS | ALG);
		
		source = clipboard_retrieve(STWIDGET("*clipboard_dialog"), &data_id, &opaque, &opaque_oid);

		if (source <= CB_PSE) goto clipboard_error;
		
	} else if (widget == STWIDGET("*clipboard_nicehigh_drawnbutton")) {
		
		last_af_verbose = af_verbose = TRUE;
		last_print_keyinfo_flag = print_keyinfo_flag |= (KEYBITS | BSTR);
		last_print_cert_flag = print_cert_flag |= (SIGNAT |  VER | HSH);
		
		source = clipboard_retrieve(STWIDGET("*clipboard_dialog"), &data_id, &opaque, &opaque_oid);

		if (source <= CB_PSE) goto clipboard_error;
	}


	if (opaque) {
		af_pse_free(&opaque, &opaque_oid);
		aux_free2_ObjId(&opaque_oid);
	}
	if (data_id) free(data_id);
	
clipboard_error:
	af_verbose = save_af_verbose;
	print_keyinfo_flag = save_print_keyinfo_flag;
	print_cert_flag = save_print_cert_flag;
	
	IDLE_CURSOR();
	
	XmUpdateDisplay(applicationShell);

}


/***************************************************************
 *
 * Procedure clipboard_dialog_refresh
 *
 ***************************************************************/
#ifdef __STDC__

void clipboard_dialog_refresh(
	Widget			widget,
	char			*report,
	char			*object
)

#else

void clipboard_dialog_refresh(
	widget,
	report,
	object
)
Widget			widget;
char			*report;
char			*object;

#endif

{
	XmString	cmpd_string;


        XtVaSetValues(	STWIDGET("*clipboard_report_label"),
        		XmNlabelString,	cmpd_string = CPDSTRINGFIXED( report ? report : "No XMST data!"),
        		NULL);
        		
	XmTextSetString(	STWIDGET("*clipboard_object_text"),
				object ? object : "");
        		
        XmStringFree(cmpd_string);
        		
	XmUpdateDisplay(widget);
	
}



/*
 *	Save dialog
 */
/***************************************************************
 *
 * Procedure save_loose_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean save_loose_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean save_loose_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "save_loose_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*save_loose_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}


/*
 *	Signature/Encryption object dialog
 */
/***************************************************************
 *
 * Procedure signature_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean signature_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean signature_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "signature_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*signature_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}


/*
 *	Show dialog
 */
/***************************************************************
 *
 * Procedure cont_show_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

Boolean cont_show_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

Boolean cont_show_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "cont_show_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*cont_show_dialog");
	XmString	cmpd_message;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);

	XmUpdateDisplay(applicationShell);

	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
	XmStringFree(cmpd_message);
	MANAGE_DIALOG(dialog);

	dialog_loop();

	return(dialog_ok);
}








/*
 *	File Selection dialog
 */
/***************************************************************
 *
 * Procedure file_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void file_dialog_open(
)

#else

void file_dialog_open(
)

#endif

{
	char				*proc = "file_dialog_open";
	Widget				fileObjectSelectionBox;
	char				*data;
	XmString			selection;


	if (!fileDialog) {
	
		fileDialog = STWIDGET("*file_dialog");
		
		MANAGE_MODELESS_DIALOG(fileDialog);
	
		add_destroy_callback(name2widget(fileDialog, "*ok_dialog"), (caddr_t)ok_dialog_cb);			
		add_destroy_callback(name2widget(fileDialog, "*signature_dialog"), (caddr_t)question_dialog_cb);
	
	} else MANAGE_MODELESS_DIALOG(fileDialog);
	
	file_dialog_refresh();
	
	XtVaGetValues(	pseList,
			XmNuserData, 	&data,
			NULL);
			
	selection = XmStringCreateLocalized(data ? data : "");

	fileObjectSelectionBox = name2widget(fileDialog, "*file_object_selection_box");
	
	XmListSelectItem(	XmSelectionBoxGetChild(fileObjectSelectionBox, XmDIALOG_LIST),
				selection,
				FALSE);
	if (data) XmListSetBottomItem(	XmSelectionBoxGetChild(	fileObjectSelectionBox,
								XmDIALOG_LIST),
					selection);
	else XmListDeselectAllItems(	XmSelectionBoxGetChild(	fileObjectSelectionBox,
								XmDIALOG_LIST));
		
	XtVaSetValues(	fileObjectSelectionBox,
			XmNlistItemCount,	count_clientdata(pselist_clientdata),
			XmNtextString, 		selection,
			NULL);
			
	XmStringFree(selection);
	
/***	dialog_loop();
***/
}

/***************************************************************
 *
 * Procedure file_dialog_refresh
 *
 ***************************************************************/
#ifdef __STDC__

void file_dialog_refresh(
)

#else

void file_dialog_refresh(
)

#endif

{
	char				*proc = "file_dialog_refresh";
	Widget				fileObjectSelectionBox;
	XmStringTable			object_table;


	if (fileDialog) {
	
		fileObjectSelectionBox = name2widget(fileDialog, "*file_object_selection_box");
		
		XtVaSetValues(	fileObjectSelectionBox,
				XmNlistItemCount,	count_clientdata(pselist_clientdata),
				XmNlistItems, 		object_table = get_object_table(),
				NULL);
				
		free_table(object_table);
				
	}
}

/***************************************************************
 *
 * Procedure file_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void file_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void file_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> file_dialog_cb\n");

	XmUpdateDisplay(applicationShell);
	
	cbs = (XmSelectionBoxCallbackStruct *)callback_data;
	
	switch (cbs->reason) {

		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			XtUnmanageChild(widget);
			XtUnmanageChild(name2widget(widget, "*ok_dialog"));
			XtUnmanageChild(name2widget(widget, "*signature_dialog"));
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

}



/***************************************************************
 *
 * Procedure file_selection_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void file_selection_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void file_selection_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char					*proc = "file_selection_dialog_cb";
	Widget					fileObjectSelectionBox = name2widget(fileDialog,
								"*file_object_selection_box");
	XmStringTable				object_table;
	XmFileSelectionBoxCallbackStruct	*cbs;


	XmUpdateDisplay(applicationShell);

	cbs = (XmFileSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:	/* write to PSE */
		
			if (!file2object(	fileDialog,
						XmTextGetString(XmSelectionBoxGetChild(
							fileObjectSelectionBox, XmDIALOG_TEXT)),
						XmTextGetString(XmSelectionBoxGetChild(widget, XmDIALOG_TEXT))	)) {
					
	        		st_fill_widgets();
	        		
				XtVaSetValues(	fileObjectSelectionBox,
						XmNlistItemCount,	count_clientdata(pselist_clientdata),
						XmNlistItems, 		object_table = get_object_table(),
						NULL								);
				
				free_table(object_table);
	        	}
	        	
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
}

/***************************************************************
 *
 * Procedure file_object_selection_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void file_object_selection_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void file_object_selection_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	char					*proc = "file_object_selection_dialog_cb";
	Widget					fileSelectionBox = name2widget(fileDialog,
								"*file_selection_box");
	XmSelectionBoxCallbackStruct		*cbs;
	XmString				dir_mask;


	XmUpdateDisplay(applicationShell);

	cbs = (XmSelectionBoxCallbackStruct *)callback_data;

	switch (cbs->reason) {

		case XmCR_OK:	/* read to File */
					
			if (!object2file(	fileDialog,
						XmTextGetString(XmSelectionBoxGetChild(widget, XmDIALOG_TEXT)),
						XmTextGetString(XmSelectionBoxGetChild(
							fileSelectionBox, XmDIALOG_TEXT))	)) {
						
			        XtVaGetValues(	fileSelectionBox,
			        		XmNdirMask, 	&dir_mask,
			        		NULL);
			        XmFileSelectionDoSearch(fileSelectionBox, dir_mask);
	        	}
	        	
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
}


/*
 *	Help dialog for Objects
 */
/***************************************************************
 *
 * Procedure help_object_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void help_object_dialog_open(
	Widget	  parentShell,
	char	 *label
)

#else

void help_object_dialog_open(
	parentShell,
	label
)
Widget	  parentShell;
char	 *label;

#endif

{
	char			*proc = "help_object_dialog_open";
	Widget 			dialog = name2widget(parentShell, "*ok_dialog");
	char			*message;
	XmString		cmpd_message;
	MrmCode			mrm_type;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	if (MrmFetchLiteral(	applicationHierarchy,
				label,
				display,
				(XtPointer) &message,
				&mrm_type) != MrmSUCCESS) {

		sprintf(dialog_message, "xmst.uid: Can't find help for:\n\"%s\"", label);
		message = aux_cpy_String(dialog_message);
		
	} else if (mrm_type != MrmRtypeChar8) {
	
		fprintf(stderr, "Error in xmst.uid: Value of %s is no string!\n", label);
		
		exit_sectool();
	}
	
	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
			
	XmStringFree(cmpd_message);
	free(message);

	MANAGE_DIALOG(dialog);

	dialog_loop();
	
}




/*
 *	Help dialog for Types
 */
/***************************************************************
 *
 * Procedure help_type_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void help_type_dialog_open(
	Widget	  parentShell,
	ObjId	 *objid
)

#else

void help_type_dialog_open(
	parentShell,
	objid
)
Widget	  parentShell;
ObjId	 *objid;

#endif

{
	char			*proc = "help_type_dialog_open";
	Widget 			dialog = name2widget(parentShell, "*ok_dialog");
	char			*label;
	char			*message;
	XmString		cmpd_message;
	MrmCode			mrm_type;


	if (sectool_verbose)  fprintf(stderr, "--> %s\n", proc);

	if (MrmFetchLiteral(	applicationHierarchy,
				label = af_get_oidname(objid),
				display,
				(XtPointer) &message,
				&mrm_type) != MrmSUCCESS) {

		free(message);
		sprintf(dialog_message, "xmst.uid: Can't find help for:\n\"%s\"", label);
		message = aux_cpy_String(dialog_message);
		
	} else if (mrm_type != MrmRtypeChar8) {
	
		fprintf(stderr, "Error in xmst.uid: Value %s is no string!\n", label);
		free(label);
		
		exit_sectool();
	}
	
	XtVaSetValues(	dialog,
			XmNmessageString, 	cmpd_message = CPDSTRING(message),
			NULL);
			
	XmStringFree(cmpd_message);
	free(message);
	free(label);

	MANAGE_DIALOG(dialog);

	dialog_loop();
	
}




/*
 *	Generate object dialog
 */
/***************************************************************
 *
 * Procedure crypt_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void crypt_dialog_open(
)

#else

void crypt_dialog_open(
)

#endif

{
	char				*proc = "crypt_dialog_open";
	Widget 				algList;
	Widget				algtypeLabel;
	Widget				sctToggle;
	Widget				symRowColumn;
	Widget				asymRowColumn;
	Widget				keysizeRowColumn;
	Widget				keysizeScale;
	Widget				testButton;
	Widget				generateButton;
	XmStringTable			alg_table;
	XmString			cmpd_string;


	if (sectool_verbose) fprintf(stderr, "--> %s\n", proc);
	
	if (!cryptDialog) {
	
		cryptDialog = STWIDGET("*crypt_dialog");
		algList = name2widget(cryptDialog, "*crypt_alg_list");
		algtypeLabel = name2widget(cryptDialog, "*crypt_algtype_label");
		sctToggle = name2widget(cryptDialog, "*crypt_sct_toggle");
		keysizeRowColumn = name2widget(cryptDialog, "*crypt_keysize_rowcolumn");
		keysizeScale = name2widget(cryptDialog, "*crypt_keysize_scale");
		testButton = name2widget(cryptDialog, "*crypt_test_button");
		generateButton = name2widget(cryptDialog, "*crypt_generate_button");
		
		XtVaSetValues(	algList,
				XmNitemCount,	no_of_algorithms,
				XmNitems, 	alg_table = get_alg_table(),
				NULL);
		free_table(alg_table);
	
	        XtVaSetValues(	algtypeLabel,
	        		XmNlabelString,	cmpd_string = CPDSTRING("          No algorithm selected.\n"),
	        		NULL);
	        XmStringFree(cmpd_string);
	        
		MANAGE_MODELESS_DIALOG(cryptDialog);
	
		XtSetSensitive(keysizeRowColumn , FALSE);
	        XtVaSetValues(	keysizeScale,
	        		XmNshowValue,	FALSE,
	        		NULL);
		XtSetSensitive(testButton , FALSE);
		XtSetSensitive(generateButton , FALSE);
	
#ifdef SCA
		XtManageChild(sctToggle);
		XtSetSensitive(sctToggle, (SC_encrypt && SC_verify));
#endif
	
		add_destroy_callback(name2widget(cryptDialog, "*ok_dialog"), (caddr_t)ok_dialog_cb);			
		add_destroy_callback(name2widget(cryptDialog, "*repl_canc_dialog"), (caddr_t)warning_dialog_cb);			
		add_destroy_callback(name2widget(cryptDialog, "*question_dialog"), (caddr_t)warning_dialog_cb);			
		add_destroy_callback(name2widget(cryptDialog, "*processing_dialog"), (caddr_t)processing_dialog_cb);

	} else MANAGE_MODELESS_DIALOG(cryptDialog);			

/***	dialog_loop();
***/

	return;
}


/***************************************************************
 *
 * Procedure crypt_selection_cb
 *
 ***************************************************************/
#ifdef __STDC__

void crypt_selection_cb(
	Widget			  widget,
	char			 *tag,
	XmListCallbackStruct	 *callback_data
)

#else

void crypt_selection_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmListCallbackStruct	 *callback_data;

#endif

{
	Widget				algtypeLabel = name2widget(cryptDialog, "*crypt_algtype_label");
	Widget				sctToggle = name2widget(cryptDialog, "*crypt_sct_toggle");
	Widget				symRowColumn = name2widget(cryptDialog, "*crypt_sym_rowcolumn");
	Widget				asymRowColumn = name2widget(cryptDialog, "*crypt_asym_rowcolumn");
	Widget				keysizeRowColumn = name2widget(cryptDialog, "*crypt_keysize_rowcolumn");
	Widget				keysizeScale = name2widget(cryptDialog, "*crypt_keysize_scale");
	Widget				testButton = name2widget(cryptDialog, "*crypt_test_button");
	Widget				generateButton = name2widget(cryptDialog, "*crypt_generate_button");
	char				*alg_name;
	ObjId				*alg_oid;
	AlgType				alg_type;
	unsigned char			save_print_flags;
	char				*alg_info;
	XmString			cmpd_string;
	char				*data;
	

	switch (callback_data->reason) {

		case XmCR_BROWSE_SELECT:

			XmStringGetLtoR(callback_data->item, XmFONTLIST_DEFAULT_TAG, &alg_name);
			
			switch (alg_type = aux_Name2AlgType(alg_name)) {
			
				/* OK */
			        case SYM_ENC:
			        
					XtUnmanageChild(asymRowColumn);
					XtManageChild(symRowColumn);
					XtSetSensitive(generateButton , TRUE);
					
			        	break;
			        
			        case ASYM_ENC:
			        
					XtUnmanageChild(symRowColumn);
					XtManageChild(asymRowColumn);
					XtSetSensitive(generateButton , TRUE);
			        		
			        	break;
			        
			        case SIG:
			        	
					XtUnmanageChild(symRowColumn);
					XtManageChild(asymRowColumn);
					XtSetSensitive(generateButton , TRUE);
			        		
			        	break;
			        
			        /* DH-Algo */
			        /* n.i.y. */
			        case KEY_AGREEMENT:
			        
					XtUnmanageChild(symRowColumn);
					XtUnmanageChild(asymRowColumn);
					XtSetSensitive(generateButton , FALSE);
				        XtVaSetValues(	keysizeScale,
				        		XmNshowValue,	FALSE,
				        		NULL);
					XtSetSensitive(generateButton , FALSE);
			        	
			        	break;
			        	
			        case HASH:
			        
					XtUnmanageChild(symRowColumn);
					XtUnmanageChild(asymRowColumn);
					XtSetSensitive(generateButton , FALSE);
			        	
			        	break;
			        	
			        /* Error */
			        case NoAlgType:
			        default:
			        
			        	XtVaSetValues(	algtypeLabel,
			        			XmNlabelString,	cmpd_string =
			        			   CPDSTRING("          No algorithm selected.\n"),
			        			NULL);
			        	XmStringFree(cmpd_string);
			        	
			        	XtFree(alg_name);
			        	
					XtUnmanageChild(symRowColumn);
					XtUnmanageChild(asymRowColumn);
					XtSetSensitive(keysizeRowColumn , FALSE);
				        XtVaSetValues(	keysizeScale,
				        		XmNshowValue,	FALSE,
				        		NULL);
					XtSetSensitive(testButton , FALSE);
					XtSetSensitive(generateButton , FALSE);
					
			        	ALARM();
			        	
			        	return;
			}
			
		        switch (aux_Name2ParmType(alg_name)) {
		        
		        	case PARM_INTEGER:
		        	
					XtSetSensitive(keysizeRowColumn , TRUE);
				        XtVaSetValues(	keysizeScale,
				        		XmNshowValue,	TRUE,
				        		NULL);
		        		
		                 	break;
		                                                
		/***            case PARM_OctetString:
		                                        
		                 	filen("File: ");
		                 	if(filename) ostr = aux_file2OctetString(filename);
		                 	if(ostr) algid->param = (char *)ostr;
		                 	break;
		***/                                                
				default:
				
					XtSetSensitive(keysizeRowColumn, (aux_Name2AlgEnc(alg_name) == DSA));
		        		XtVaSetValues(	keysizeScale,
		        				XmNshowValue,	(aux_Name2AlgEnc(alg_name) == DSA),
		        				NULL);
			}
			
			XtVaGetValues(	widget,
					XmNuserData,	&data,
					NULL);
			XtFree(data);
			XtVaSetValues(	widget,
					XmNuserData,	alg_name,
					NULL);
					
			save_print_flags = print_keyinfo_flag;
			print_keyinfo_flag |= ALGINFO;
			alg_oid = aux_Name2ObjId(alg_name);
	        	alg_info = aux_sprint_algorithm(CNULL, alg_oid, alg_name);
			
	        	XtVaSetValues(	algtypeLabel,
	        			XmNlabelString,	cmpd_string = CPDSTRINGFIXED(alg_info),
	        			NULL);
	        	XmStringFree(cmpd_string);
	        	free(alg_info);
	        	aux_free_ObjId(&alg_oid);
			print_keyinfo_flag = save_print_flags;
			
			XtSetSensitive(testButton, TRUE);
			
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
 
}




/***************************************************************
 *
 * Procedure crypt_keysize_arrow_cb
 *
 ***************************************************************/
#ifdef __STDC__

void crypt_keysize_arrow_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void crypt_keysize_arrow_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	Widget				keysizeScale = name2widget(cryptDialog, "*crypt_keysize_scale");
	int				keysize;
	
	
	XmScaleGetValue(keysizeScale, &keysize);
	
	/* Thanx. Tom... */
	if (*((int *)tag) > 0) 	keysize = (keysize + *((int *)tag) & (-*((int *)tag)));
	else 			keysize = (keysize - 1) & *((int *)tag);

	if (keysize < *keysizeScaleMinimum) keysize = *keysizeScaleMinimum;
	if (keysize > *keysizeScaleMaximum) keysize = *keysizeScaleMaximum;
	
	XmScaleSetValue(keysizeScale, keysize);
}



/***************************************************************
 *
 * Procedure crypt_sct_toggle_cb
 *
 ***************************************************************/
#ifdef __STDC__

void crypt_sct_toggle_cb(
	Widget				  widget,
	char				 *tag,
	XmToggleButtonCallbackStruct	 *callback_data
)

#else

void crypt_sct_toggle_cb(
	widget,
	tag,
	callback_data
)
Widget				  widget;
char				 *tag;
XmToggleButtonCallbackStruct	 *callback_data;

#endif

{
	Widget				symkeyRowColumn = name2widget(cryptDialog, "*crypt_symkey_rowcolumn");

	XtSetSensitive(symkeyRowColumn, callback_data->set ? FALSE : TRUE);

}



/***************************************************************
 *
 * Procedure crypt_generate_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void crypt_generate_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void crypt_generate_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	Widget				algList = name2widget(cryptDialog, "*crypt_alg_list");
	Widget				sctToggle = name2widget(cryptDialog, "*crypt_sct_toggle");
	Widget				symkeyTextfield = name2widget(cryptDialog, "*crypt_symkey_textfield");
	Widget				publicTextfield = name2widget(cryptDialog, "*crypt_public_textfield");
	Widget				secretTextfield = name2widget(cryptDialog, "*crypt_secret_textfield");
	Widget				keysizeScale = name2widget(cryptDialog, "*crypt_keysize_scale");
	char				*symkey_name = CNULL;
	char				*public_name = CNULL;
	char				*secret_name = CNULL;
	char				*public_key_object_name = CNULL;
	char				*secret_key_object_name = CNULL;
	int				key_size;
	char				*outtext;
	char				*textvalue;
	int				save_sec_dsa_keysize = sec_dsa_keysize;
	AlgId				*save_algid = (AlgId *)NULL;
	AlgList				*alge = &alglist[0];
	

	BUSY_CURSOR();

	replace = FALSE;
	
	XtVaGetValues(	algList,
			XmNuserData,	&algname,
			NULL);
				
	/* Get algorithm parameter from widgets */	
	algid = (AlgId *)NULL;
	while (alge->name) {
	
		if (!strcmp(algname, alge->name)) {
		
			algid = alge->algid;
			break;
		}
		alge++;
	}
        if (algid) switch(aux_Name2ParmType(algname)) {
        
        	case PARM_INTEGER:
        	
			save_algid = aux_cpy_AlgId(algid);
                	rsaparm = (rsa_parm_type *)(algid->param);
                 	XmScaleGetValue(keysizeScale, (int *)rsaparm);
                 	break;
                                                
/***            case PARM_OctetString:
                                        
                 	filen("File: ");
                 	if(filename) ostr = aux_file2OctetString(filename);
                 	if(ostr) algid->param = (char *)ostr;
                 	break;
***/                                                
		default:
		
			if (aux_Name2AlgEnc(algname) == DSA)
			XmScaleGetValue(keysizeScale, &sec_dsa_keysize);
	}

        algenc = aux_Name2AlgEnc(algname);
        
        if (algenc == DES || algenc == DES3 || algenc == IDEA) {
        
        	textvalue = XmTextGetString(symkeyTextfield);
        	symkey_name = aux_cpy_ReducedString(textvalue);
        	XtFree(textvalue);
        
		if (! (secretkey = build_key(	cryptDialog,
						GENKEY,
						GEN_SYM,
						symkey_name,
						XmToggleButtonGetState(sctToggle),
						OPEN_TO_WRITE))) {
			
			if (symkey_name) free(symkey_name);
			
			sec_dsa_keysize = save_sec_dsa_keysize;
			if (save_algid) {
				*rsaparm = *save_algid->param;
				aux_free_AlgId(&save_algid);
			}
			
			IDLE_CURSOR();
						
			return;
		}
		
	} else {
	
        	textvalue = XmTextGetString(publicTextfield);
        	public_name = aux_cpy_ReducedString(textvalue);
        	XtFree(textvalue);
		publickey = (Key *)0;
		
        	textvalue = XmTextGetString(secretTextfield);
        	secret_name = aux_cpy_ReducedString(textvalue);
        	XtFree(textvalue);
 		secretkey = (Key *)0;
		
                if (! (publickey = build_key(	cryptDialog,
						GENKEY,
						GEN_PUBLIC,
						public_name,
						FALSE,
						OPEN_TO_WRITE))) {
			
			if (public_name) free(public_name);
			if (secret_name) free(secret_name);
						
			sec_dsa_keysize = save_sec_dsa_keysize;
			if (save_algid) {
				*rsaparm = *save_algid->param;
				aux_free_AlgId(&save_algid);
			}
			
			IDLE_CURSOR();
						
			return;
		}
		
 		
                if (! (secretkey = build_key(	cryptDialog,
						GENKEY,
						GEN_SECRET,
						secret_name,
						FALSE,
						OPEN_TO_WRITE))) {
			
			aux_free_Key(&publickey);
			if (public_name) free(public_name);
			if (secret_name) free(secret_name);
						
			sec_dsa_keysize = save_sec_dsa_keysize;
			if (save_algid) {
				*rsaparm = *save_algid->param;
				aux_free_AlgId(&save_algid);
			}
			
			IDLE_CURSOR();
						
			return;
		}
        }
         
        time(&atime);
        
        THINK_CURSOR();
        processing_dialog_open(	cryptDialog,
        			"        Wait a minute:\nKey generation is in progress.");
        			
	/* Generate key */
        if (sec_gen_key(secretkey, replace)) {

        	processing_dialog_open(cryptDialog, CNULL);
		READY_CURSOR();
		ok_dialog_open(cryptDialog, "Unable to generate new key.");
		IDLE_CURSOR();
		
		sec_dsa_keysize = save_sec_dsa_keysize;
		if (save_algid) {
			*rsaparm = *save_algid->param;
			aux_free_AlgId(&save_algid);
		}
			
		return;
	}
	aux_free_error();

        etime = time((time_t *)0) - atime;
        
	sec_dsa_keysize = save_sec_dsa_keysize;
	
	if (save_algid) {
	
		*rsaparm = *save_algid->param;
		aux_free_AlgId(&save_algid);
	}
			
        if (algenc == RSA || algenc == DSA) outtext = CATSPRINTF(CNULL, "Secret Key stored ");
        else if(algenc == IDEA) outtext = CATSPRINTF(CNULL, "IDEA Key stored ");
        else outtext = CATSPRINTF(CNULL, "DES Key stored ");
        
        if (secretkey->pse_sel) {
        
		secret_key_object_name = aux_cpy_String(secretkey->pse_sel->object.name);
       		outtext = CATSPRINTF(	outtext, "in object %s.", secret_key_object_name);
        	
        } else {

#ifdef SCA
		if ((secretkey->keyref & SC_KEY) == SC_KEY) {
		
			secretkey->keyref = secretkey->keyref & ~SC_KEY;
			outtext = CATSPRINTF(outtext, "in the SmartCard ");
			
		} else if ((secretkey->keyref & SCT_KEY) == SCT_KEY) {
		
			secretkey->keyref = secretkey->keyref & ~SCT_KEY;
			outtext = CATSPRINTF(outtext, "in the SCT ");
		}
#endif
		outtext = CATSPRINTF(outtext, "in Keypool under reference %d.", secretkey->keyref);
	}
	
        if (algenc == RSA || algenc == DSA) {
        
		if (algenc == RSA) object_oid = RSA_PK_OID;
		else object_oid = DSA_PK_OID;
		
                /* store public key */
                if (publickey->pse_sel) {
                
                	if (! (ostr = e_KeyInfo(secretkey->key))) {
                	
				aux_free_Key(&secretkey);
				aux_free_Key(&publickey);
				free(outtext);
				
        			processing_dialog_open(cryptDialog, CNULL);
				READY_CURSOR();
				ok_dialog_open(cryptDialog, "Unable to encode KeyInfo.");
				IDLE_CURSOR();
					
				return;
			}
			aux_free_Key(&secretkey);
			
                        if (sec_write_PSE(publickey->pse_sel, object_oid, ostr) < 0) {
                        
				aux_free_OctetString(&ostr);
				aux_free_Key(&publickey);
				free(outtext);
				
        			processing_dialog_open(cryptDialog, CNULL);
				READY_CURSOR();
				ok_dialog_open(cryptDialog, "Unable to write key to PSE.");
				IDLE_CURSOR();
						
                                return;
                        }
			aux_free_error();
			aux_free_OctetString(&ostr);
			public_key_object_name = aux_cpy_String(publickey->pse_sel->object.name);
       			outtext = CATSPRINTF(outtext, "\nPublic key stored in object %s.",
       							public_key_object_name);
			
                } else {
                
                	if ((keyref = sec_put_key(secretkey->key, publickey->keyref)) < 0) {
                	
				aux_free_Key(&secretkey);
				free(outtext);
				
        			processing_dialog_open(cryptDialog, CNULL);
				READY_CURSOR();
				ok_dialog_open(cryptDialog, "Unable to write key to Key Pool.");
				IDLE_CURSOR();
						
                                return;
                        }
                	
			outtext = CATSPRINTF(outtext, "\nPublic key stored in Keypool under reference %d.",
							keyref);
			aux_free_Key(&secretkey);
                }
                
		aux_free_Key(&publickey);
        }
        
	if (public_key_object_name) {
	
		st_toc_widgets_update(public_key_object_name);
		free(public_key_object_name);
	}
 	if (secret_key_object_name) {
	
		st_toc_widgets_update(secret_key_object_name);
		free(secret_key_object_name);
	}
                        	
	processing_dialog_open(cryptDialog, CNULL);
	READY_CURSOR();
        sprintf(	dialog_message,
        		"Key generation was successful.\n\n%s\n\nCalculation time: %ld sec",
        		outtext,
        		etime);
	ok_dialog_open(cryptDialog, dialog_message);
	
	if (symkey_name) free(symkey_name);
	if (public_name) free(public_name);
	if (secret_name) free(secret_name);
	free(outtext);


	IDLE_CURSOR();
}


/***************************************************************
 *
 * Procedure crypt_test_button_cb
 *
 ***************************************************************/
#ifdef __STDC__

void crypt_test_button_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void crypt_test_button_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	Widget				algList = name2widget(cryptDialog, "*crypt_alg_list");
	AlgList				*alge = &alglist[0];
	

	BUSY_CURSOR();

	XtVaGetValues(	algList,
			XmNuserData,	&algname,
			NULL);
				
	/* Get algorithm parameter from widgets */	
	while (alge->name) {
	
		if (!strcmp(algname, alge->name)) {
		
 			THINK_CURSOR();

			sec_time = TRUE;
			
			if (open_write_tempfile(cryptDialog) >= 0)  {
		
				test_alg(cryptDialog, logfile, alge);
				
				close_tempfile();
					
				/* manage viewer to avoid usage of external editor */
				MANAGE_MODELESS_DIALOG(STWIDGET("*viewer_dialog"));
				start_editor();
				remove_tempfile();
		
			} else test_alg(cryptDialog, stderr, alge);
			
			sec_time = FALSE;
		
 			READY_CURSOR();
 			
			break;
		}
		alge++;
	}

	IDLE_CURSOR();
}




/***************************************************************
 *
 * Procedure crypt_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void crypt_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void crypt_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs;


	if (sectool_verbose) fprintf(stderr, "--> crypt_dialog_cb\n");

	XmUpdateDisplay(applicationShell);
	
	cbs = (XmSelectionBoxCallbackStruct *)callback_data;
	
	switch (cbs->reason) {

		case XmCR_OK:
		case XmCR_CANCEL:
		case XmCR_PROTOCOLS:

			XtUnmanageChild(widget);
			XtUnmanageChild(name2widget(widget, "*ok_dialog"));
			XtUnmanageChild(name2widget(widget, "*repl_canc_dialog"));
			XtUnmanageChild(name2widget(widget, "*question_dialog"));
			XtUnmanageChild(name2widget(widget, "*processing_dialog"));
			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}

/***	dialog_finished = TRUE;
***/
}



/*
 *	Processing dialog (message != CNULL: open, message == CNULL: close);
 */
/***************************************************************
 *
 * Procedure processing_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void processing_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

void processing_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "processing_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*processing_dialog");
	XmString	cmpd_message;

	
	if (message) {

		XtVaSetValues(	dialog,
				XmNmessageString, 	cmpd_message = CPDSTRING(message),
				NULL);
		XmStringFree(cmpd_message);
	
		MANAGE_DIALOG(dialog);
		XmUpdateDisplay(applicationShell);
	
	} else XtUnmanageChild(dialog);
}


/*
 *	Printing dialog (message != CNULL: open, message == CNULL: close);
 */
/***************************************************************
 *
 * Procedure printing_dialog_open
 *
 ***************************************************************/
#ifdef __STDC__

void printing_dialog_open(
	Widget	  parentShell,
	char	 *message
)

#else

void printing_dialog_open(
	parentShell,
	message
)
Widget	  parentShell;
char	 *message;

#endif

{
	char		*proc = "printing_dialog_open";
	Widget 		dialog = name2widget(parentShell, "*printing_dialog");
	XmString	cmpd_message;


	if (message) {

		XtVaSetValues(	dialog,
				XmNmessageString, 	cmpd_message = CPDSTRING(message),
				NULL);
		XmStringFree(cmpd_message);
	
		MANAGE_DIALOG(dialog);
		XmUpdateDisplay(applicationShell);
	
	} else XtUnmanageChild(dialog);
}


/***************************************************************
 *
 * Procedure processing_dialog_cb
 *
 ***************************************************************/
#ifdef __STDC__

void processing_dialog_cb(
	Widget			  widget,
	char			 *tag,
	XmAnyCallbackStruct	 *callback_data
)

#else

void processing_dialog_cb(
	widget,
	tag,
	callback_data
)
Widget			  widget;
char			 *tag;
XmAnyCallbackStruct	 *callback_data;

#endif

{
	XmSelectionBoxCallbackStruct	*cbs = (XmSelectionBoxCallbackStruct *)callback_data;


	if (sectool_verbose) fprintf(stderr, "--> processing_dialog_cb\n");

	switch (cbs->reason) {

		case XmCR_PROTOCOLS:

			break;

		default:
	 		if (sectool_verbose) fprintf(stderr, "Oops - unknown callback reason!\n");
	}
}








