/* ./src/util/secxlock/usleep.c */

static char *rcsid = "$Id: usleep.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: usleep.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: usleep.c,v $
 *
 */
 
#ifndef lint
static char sccsid[] = "@(#)usleep.c	1.2 90/10/28 XLOCK SMI";
#endif
/*-
 * usleep.c - OS dependant implementation of usleep().
 *
 * Copyright (c) 1990 by Patrick Naughton and Sun Microsystems, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Comments and additions should be sent to the author:
 *
 *		       naughton@eng.sun.com
 *
 *		       Patrick J. Naughton
 *		       MS 14-01
 *		       Windows and Graphics Group
 *		       Sun Microsystems, Inc.
 *		       2550 Garcia Ave
 *		       Mountain View, CA  94043
 *
 * Revision History:
 * 30-Aug-90: written.
 *
 */

#include "xlock.h"

int
usleep(usec)
    unsigned long usec;
{
#ifdef SYSV
    poll((struct poll *) 0, (size_t) 0, usec / 1000);	/* ms resolution */
#else
    struct timeval timeout;
    timeout.tv_usec = usec % (unsigned long) 1000000;
    timeout.tv_sec = usec / (unsigned long) 1000000;
    select(0, (void *) 0, (void *) 0, (void *) 0, &timeout);
#endif
    return 0;
}

/*
 * returns the number of seconds since 01-Jan-70.
 * This is used to control rate and timeout in many of the animations.
 */
long
seconds()
{
    struct timeval now;

    gettimeofday(&now, (struct timezone *) 0);
    return now.tv_sec;
}
