/* ./src/util/scpsemaint.c */

static char *rcsid = "$Id: scpsemaint.c,v 1.8 1995/03/01 15:02:01 viebeg Exp $";

/* 
 *
 * $Id: scpsemaint.c,v 1.8 1995/03/01 15:02:01 viebeg Exp $
 *
 * $Log: scpsemaint.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1994, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>

#include "af.h"

#ifdef SCA

#ifndef MAC
#include <sys/types.h>
#include <sys/stat.h>
#else
#include <unix.h>
#include <console.h>
#include "Mac.h"
#endif


/*
 *    Be careful when changing  enum {...} commands  and struct {...} cmds[]:
 *    They must be in the same order. commands is the index of cmds[].
 */

enum {
       SCTTEST, SHOW, CHECK, REPLACEPSE, NEWPSE, CHPIN, UNBLOCKPIN, 
       EJECT, VERBOSE, ERROR, RESETERROR, HELPCMD, QM, ENDE, EXIT, QUIT
} commands;

struct {
        char *cmd;
        char *parms;
        char *text;
        char *longtext;
} cmds[] = {
{ "scttest",
        "<sctid> ",
        "Check whether specified SCT <sctid> is available",
        "" } ,
{ "show",
        "",
        "Show configuration for given SC-PSE",
        "" } ,
{ "check",
        "",
        "Check configuration for given SC-PSE",
        "" } ,
{ "replacepse",
        "<newname> ",
        "Replace SC-PSE by a new frame (without user data), keep PIN for PSE extension",
        "" } ,
{ "newpse",
        "<newname> ",
        "Install a new SC-PSE frame (without user data), all existing data are deleted ",
        "" } ,
{ "chpin",
        "",
        "Change PIN for given SC-PSE",
        "" } ,
{ "unblockpin",
        "",
        "Unblock a blocked PIN with the PUK (Personal Unblocking Key)",
        "" } ,
{ "eject",
        "<sctid>",
        "Eject smartcard <sct-id>.",
        "" } ,
{ "verbose",
        "<level>",
        "Change verbose level",
        "" } ,
{ "error",
        "", 
        "Print error stack",
        "" } ,
{ "reseterror",
        "",
        "Reset error stack",
        "" } ,
{ "helpcmd",
        "<cmd>",
        "Show helptext for <cmd>",
        "" } ,
{ "?",
        "<cmd>", 
        "Show helptext for cmd",
        "" } ,
{ "end",
        "",
        "Exit program",
        "" } ,
{ "exit",
        "",
        "Exit program",
        "" } ,
{ "quit",
        "",
        "Exit program",
        "" } ,
{ CNULL }
};


int     	cmd;
char    	inp[256];
char    	* cmdname, * helpname, * filename, * objtype;
PSELocation 	pse_location;
SCTDevice	SCT_available;
int		save_sct_id;


static int	getsctid	();
static char	*getnewpsename	();
static int 	helpcmd();


#ifdef __STDC__
static void     usage		(int help);
static char 	*nxtpar		(char *search);
static char 	*strmtch	(char *a, char *b);
static int 	check_if_number	(char *number);
static Boolean 	getboolresponse	(char *question);
#else
static void     usage		();
static char 	*nxtpar		();
static char 	*strmtch	();
static int 	check_if_number	();
static Boolean 	getboolresponse	();
#endif


int             verbose = 0;


Boolean interactive = TRUE;
Boolean display_errstack = TRUE;

/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{
	char			* proc = "main (scpsemaint)";
	char			* newstring;
	extern char		* optarg;
	extern int		  optind, opterr;
        int                       opt;
	char            	* psename = CNULL;
	char			* new_psename = CNULL;
        char            	* par, *dd, *cc;
        RC              	  rcode;
        int             	  i, anz, n;
	int			  sct_id;
	PSESel			  pse;
	Boolean			  onekeypair;
	char			* SCT_inst_file;
	Boolean			  response;





/*
 *      get args
 */

	optind = 1;
	opterr = 0;

	MF_check = FALSE;
	while ( (opt = getopt(cnt, parm, "p:hvVW")) != -1 ) {
		switch(opt) {

                case 'p':
                        psename = optarg;
                        continue;
		case 'v':
			verbose = 1;
			continue;
		case 'V':
			af_verbose = TRUE;
			verbose = 2;
			continue;
		case 'W':
			verbose = 2;
			af_verbose = TRUE;
			sec_verbose = TRUE;
			continue;
		case 'h':
			usage(LONG_HELP);
			continue;

		default:
		case '?':
			usage(SHORT_HELP);
		}
	}                    

	while (optind < cnt) {
                if(strlen(inp)) strcat(inp, " ");
                strcat(inp, parm[optind++]);
                interactive = FALSE;
        }


        if(strncmp(inp, "helpcmd", 4) == 0) {
                par = nxtpar(CNULL);
                helpcmd();
                exit(0);
        }


	if (!psename) {
		psename = getenv("PSE");
		if(!psename) psename = DEF_PSE;
	}


        if(strlen(inp)) goto entr;

        while(1) {
                if(interactive == FALSE) {
			exit(rcode);
		}
		fprintf(stderr, "scpsemaint> ");
                if(!gets(inp)) exit(0);
entr:

                if(!(par = nxtpar(CNULL))) continue;

                anz = 0;
                for(i = 0; cmds[i].cmd; i++) {
                        if(!strncmp(cmds[i].cmd, par, strlen(par))) {
                                cmd = i;
                                cmdname = cmds[i].cmd;
                                anz++;
                        }
                }
		if(par) free(par);
                if(anz > 1) {
                        fprintf(stderr, "Ambiguous cmd\n");
                        rcode = 1;
                        continue;
                }
                if(anz == 0) {
                        fprintf(stderr, "unknown cmd\n");
                        rcode = 1;
                        continue;
                }

                rcode = 0;

                switch(cmd) {
			case SCTTEST:

				/*
				 *  Check whether specified SCT (sct_id) is available
				 */

				sct_id = getsctid();
				if (sct_id < 0) {
					fprintf(stderr, "\nInvalid sctid\n");
					rcode = -1;
					break;
				}

				save_sct_id = sc_sel.sct_id;
				sc_sel.sct_id = sct_id;
				SCT_available = sec_scttest();
				if (SCT_available < 0) {
					fprintf(stderr, "\nError during SCTTEST\n");
					rcode = -1;
					break;
				}

    				if ((SCT_inst_file = getenv("STAMOD")) != CNULL)  {
					fprintf(stderr, "\n\nUsed SCT installation file:      %s\n", SCT_inst_file);
				}

				if (SCT_available == SCTDev_not_avail) 
					fprintf(stderr, "\nSCT %d is not available\n", sc_sel.sct_id);
				else 
				if (SCT_available == SCTDev_avail)
					fprintf(stderr, "\nSCT %d is available\n", sc_sel.sct_id);
				else 
				if (SCT_available == SCTDev_lock)
					fprintf(stderr, "\nPort to SCT %d is locked (used by another process)\n", sc_sel.sct_id);
				else 
				if (SCT_available == SCTDev_not_config)
					fprintf(stderr, "\nSCT installation file missing or something wrong with it.\n");

				sc_sel.sct_id = save_sct_id;
					
				break;


			case SHOW:

				/*
				 *  Show SC configuration for given PSE
				 */

				if ((pse_location = sec_psetest(psename)) == ERR_in_psetest) {
					fprintf(stderr, "\nError during PSETEST\n");
					rcode = -1;
					break;
				}
				if (pse_location == SWpse) {
					/* display used configuration file */
					rcode = display_SC_configuration(psename);
					if ((rcode == -1) && (LASTERROR == ECONFIG)) {
						fprintf(stderr, "\nNo SC configuration file available, PSE %s is assumed to be an SW-PSE\n\n", psename);
					}
					else
						fprintf(stderr, "\nPSE %s is an SW-PSE\n\n", psename);
					display_errstack = FALSE;

					break;
				}

				rcode = display_SC_configuration(psename);
				if (rcode < 0) 
					fprintf(stderr, "\nConfiguration for SC-PSE %s is invalid\n\n", psename);
				break;


			case CHECK:

				/*
				 *  Check SC configuration for given PSE
				 */

				if ((pse_location = sec_psetest(psename)) == ERR_in_psetest) {
					fprintf(stderr, "\nError during PSETEST\n");
					rcode = -1;
					break;
				}
				if (pse_location == SWpse) {
					fprintf(stderr, "\nPSE %s is not an SC-PSE \n", psename);
					break;
				}

				rcode = check_SCPSE_configuration(psename, &onekeypair);
				if (rcode < 0) 
					fprintf(stderr, "\nConfiguration data for SC-PSE %s are invalid.\n\n", psename);
				else {
					fprintf(stderr, "\nConfiguration data for SC-PSE %s are correct.\n\n", psename);
				}
				break;


			case REPLACEPSE:

				/*
				 *  This command only works, if there is a PSE to be replaced.
				 *
				 *  The existing PSE is deleted, but the PIN for the PSE 
				 *  extension is kept.
				 */

				/*
				 *  Is the PSE an SC-PSE?
				 */
				if ((pse_location = sec_psetest(psename)) == ERR_in_psetest) {
					fprintf(stderr, "\nError during PSETEST for PSE: %s\n", psename);
					rcode = -1;
					break;
				}
				if (pse_location == SWpse) {
					fprintf(stderr, "\nPSE %s is not an SC-PSE \n", psename);
					break;
				}

				new_psename = getnewpsename();
				if (!new_psename) {
					new_psename = aux_cpy_String(psename);
					if (!new_psename) {
						fprintf(stderr, "Can't allocate memory for new psename\n");
						rcode = -1;
						break;
					}
				}
				else {
					if ((pse_location = sec_psetest(new_psename)) == ERR_in_psetest) {
						fprintf(stderr, "\nError during PSETEST for PSE: %s\n", new_psename);
						rcode = -1;
						break;
					}
					if (pse_location == SWpse) {
						fprintf(stderr, "\nPSE %s is not an SC-PSE \n", new_psename);
						break;
					}
				}
				
				rcode = check_SCPSE_configuration(new_psename, &onekeypair);
				if (rcode < 0) {
					fprintf(stderr, "\nConfiguration data for SC-PSE %s are invalid.\n\n", new_psename);
					break;
				}

				sec_onekeypair = onekeypair;
				rcode = secsc_replace_SCPSE(psename, new_psename);
				if (rcode < 0) {
					if (LASTERROR == EAPPNAME)
						fprintf(stderr, "\nPSE to be replaced does not exist\n\n", psename);
					else 
						fprintf(stderr, "\nCannot reset SC-PSE: %s\n\n", psename);
				}
				else  {
					if (onekeypair == TRUE)
						fprintf(stderr, "\n\nExisting SC-PSE has been deleted, a frame for an SC-PSE with one keypair has been installed, this includes:\n");
					else 
						fprintf(stderr, "\n\nExisting SC-PSE has been deleted, a frame for an SC-PSE with two keypairs has been installed, this includes:\n");
						fprintf(stderr, "   - reservation of space on the SC,\n");
						fprintf(stderr, "   - the PIN for the PSE extension has been taken from the old PSE,\n");
						fprintf(stderr, "   - installation of the SC-PIN (value: %s)\n\n", DEFAULT_PIN);
						fprintf(stderr, "Please change the value of this SC-PIN as soon as possible (command: chpin).\n\n");
				

				}

				break;


			case NEWPSE:

				/*
				 *  A new PSE frame is installed, existing data is deleted
				 */


				/*
				 *  Is the PSE an SC-PSE?
				 */

				if ((pse_location = sec_psetest(psename)) == ERR_in_psetest) {
					fprintf(stderr, "\nError during PSETEST\n");
					rcode = -1;
					break;
				}
				if (pse_location == SWpse) {
					fprintf(stderr, "\nPSE %s is not an SC-PSE \n", psename);
					break;
				}

				
				/*
				 *  An SC-PSE (frame) already installed? If so, warn the user.
				 */

				rcode = secsc_is_SCPSE_inst(psename); 
				if ((rcode < 0) || (rcode == TRUE)) {
					if (rcode < 0) {
						fprintf(stderr, "\nCannot check whether data on the SC.\n", psename);
                				if (verbose){
							aux_fprint_error(stderr, verbose);
						}
					}
					else 
						fprintf(stderr, "\nA PSE (frame) is stored on the SC!\n", psename);
					response = getboolresponse("Do you really want to delete these data? (y,n):");
					if (response != TRUE) {
						fprintf(stderr, "\nNo data have been deleted .\n\n", psename);
						break;
					}				
				}
				
					
				/*
				 *  Delete all existing data on the SC.
				 */

				fprintf(stderr, "\n\nDuring the deletion and the installation of an SC-PSE frame the SC is ejected and again requested twice.\n\n", psename);
				
				rcode = delete_SC();
				if (rcode < 0) {
					fprintf(stderr, "\nCannot delete content of the SC.\n\n", psename);
				}	
				else {
					fprintf(stderr, "\nExisting data on the SC have been deleted.\n", new_psename);
				}	
				

				
				rcode = check_SCPSE_configuration(psename, &onekeypair);
				if (rcode < 0) {
					fprintf(stderr, "\nConfiguration data for SC-PSE %s are invalid.\n\n", psename);
					break;
				}

				sec_onekeypair = onekeypair;
				rcode = secsc_install_SCPSE(psename, CNULL);
				if (rcode < 0) {
					fprintf(stderr, "\nCannot install SC-PSE %s.\n\n", psename);
				}
				else {
					if (onekeypair == TRUE)
						fprintf(stderr, "\nFrame for an SC-PSE with one keypair has been installed, this includes:\n");
					else 
						fprintf(stderr, "\nFrame for an SC-PSE with two keypairs has been installed, this includes:\n");

					fprintf(stderr, "   - reservation of space on the SC,\n");
					fprintf(stderr, "   - installation of the PIN for the PSE extension,\n");
					fprintf(stderr, "   - installation of the PIN for the SC (value: %s).\n\n", DEFAULT_PIN);
					fprintf(stderr, "Please change the value of the SC-PIN as soon as possible (command: chpin).\n\n");
				}

				
				break;

			case CHPIN:

				/*
				 *  Change PIN for the given SC-PSE
				 */

				if ((pse_location = sec_psetest(psename)) == ERR_in_psetest) {
					fprintf(stderr, "\nError during PSETEST\n");
					rcode = -1;
					break;
				}
				if (pse_location == SWpse) {
					fprintf(stderr, "\nPSE %s is not an SC-PSE \n", psename);
					break;
				}

				pse.app_name = psename;
				pse.pin	     = CNULL;
				pse.object.name = CNULL;
				pse.object.pin = CNULL;
				pse.app_id = 0;

				fprintf(stderr, "\nThe SCT will ask for the old PIN and then twice for the new PIN\n\n");
				rcode = sec_chpin(&pse, CNULL);
				if (rcode < 0) {
					fprintf(stderr, "Cannot change PIN\n\n");
				}
				else {
					fprintf(stderr, "PIN for the SC-PSE has been changed\n\n");
				}

				
				break;

			case UNBLOCKPIN:

				/*
				 *  Unblock a blocked PIN for the given SC-PSE
				 */

				if ((pse_location = sec_psetest(psename)) == ERR_in_psetest) {
					fprintf(stderr, "\nError during PSETEST\n");
					rcode = -1;
					break;
				}
				if (pse_location == SWpse) {
					fprintf(stderr, "\nPSE %s is not an SC-PSE \n", psename);
					break;
				}

				pse.app_name = psename;
				pse.pin	     = CNULL;
				pse.object.name = CNULL;
				pse.object.pin = CNULL;
				pse.app_id = 0;

				fprintf(stderr, "\nThe SCT will ask for the PUK and then twice for the new PIN\n\n");
				rcode = sec_unblock_SCpin(&pse);
				if (rcode < 0) {
					fprintf(stderr, "Cannot unblock PIN\n\n");
				}
				else {
					fprintf(stderr, "PIN for the SC-PSE has been unblocked\n\n");
				}

				
				
				break;


                        case EJECT:
			        save_sct_id = sc_sel.sct_id;
                                if(dd = nxtpar("")) {
					n = atoi(dd);
					free(dd);
					sc_sel.sct_id = n;
				}
                                else 	sc_sel.sct_id = 1;

                                rcode = sec_sc_eject(CURRENT_SCT);
				sc_sel.sct_id = save_sct_id;
                                break;
                        case EXIT:
                        case ENDE:
                        case QUIT:
                                exit(0);
                        case HELPCMD:
                        case QM:
                                helpcmd();
                                break;
                                
			case VERBOSE:
				dd = nxtpar(CNULL);
				if(dd) i = atoi(dd);
				else i = -1;
				if(i >= 0 && i < 4) verbose = i;
				if(verbose < 2) af_verbose = sec_verbose = FALSE;
				else if(verbose == 2) {
					af_verbose = TRUE;
					sec_verbose = FALSE;
				}
				else af_verbose = sec_verbose = TRUE;
				fprintf(stderr, "Verbose level is %d\n", verbose);
				break;
			case ERROR:
				aux_fprint_error(stderr, verbose);
				break;
			case RESETERROR:
				aux_free_error();
				break;
                        default:
                                break;
                }

                if((rcode < 0) && (display_errstack == TRUE)){
			aux_fprint_error(stderr, verbose);
		}
		display_errstack = TRUE;

		if (new_psename) free (new_psename);

/*		aux_free_error(); */
        }
}

/***************************************************************
 *
 * Procedure num
 *
 ***************************************************************/
static
num(par)
register char *par;
{
        while(*par) {
                if(*par < '0' || *par > '9') return(FALSE);
                par++;
        }
        return(TRUE);
}





  

/***************************************************************
 *
 * Procedure getsctid
 *
 ***************************************************************/
static
int getsctid() {
	char *proc = "getsctid";
	char *newstring;
	int sct_id = 0;

        if(!(objtype = nxtpar("sctid"))) {
                fprintf(stderr, "\nsctid  [CR for 1]: ");
 		newstring = (char *)malloc(16);
 		if( !newstring ) {
			aux_add_error(EMALLOC, "newstring", CNULL, 0, proc);
			fprintf(stderr, "Can't allocate memory\n");
			return(-1);
		}
                objtype = gets(newstring);
	}
                
	if(!objtype || strlen(objtype) == 0) {
                sct_id = 1;
        }
	else {
		if (check_if_number(objtype)){
			fprintf(stderr, "sctid must be a digit\n");
                        if (newstring) free(newstring);
			return(-1);				
		}
		else {
			sct_id = atoi(objtype);
			if ((sct_id >= MAX_SCTNO) || (sct_id <= 0)) {
				fprintf(stderr, "Invalid value for sctid: %s", newstring);
                        	if (newstring) free(newstring);
				return (-1);
			}			
		}
	}
        if (newstring) free(newstring);


	return(sct_id);
}



/***************************************************************
 *
 * Procedure getnewpsename
 *
 ***************************************************************/
static
char *getnewpsename() {
        char *dd, name[512];
	char *proc = "getnewpsename";

        if(!(dd = nxtpar("newname"))) {
                fprintf(stderr, "New pse name or CR: ");
                dd = aux_cpy_String(gets(name));
        }
	if(!dd) return(CNULL);
	if(strlen(dd) == 0) {
		free(dd);
		return(CNULL);
	}
        return(dd);
}


/***************************************************************
 *
 * Procedure check_if_number
 *
 ***************************************************************/
#ifdef __STDC__

static int check_if_number(
	char 	*number
)
#else
static int check_if_number(
	number
)
char 	*number;

#endif
{
	int len, i;

	len = strlen(number);
	for(i = 0; i < len; i++){
		if(!isdigit(number[i])){
			fprintf(stderr, "'%c' is not a digit[0-9]!\n", number[i]);
			return(-1);
		}
	}
	return(0);
}

/***************************************************************
 *
 * Procedure getboolresponse
 *
 ***************************************************************/
#ifdef __STDC__

static Boolean getboolresponse(
	char	 *question
)

#else

static Boolean getboolresponse(
	question
)
char	 *question;

#endif
{
	char *proc = "getboolresponse";
	char *newstring;
	Boolean answer;

        fprintf(stderr, "\n%s ", question);
 	newstring = (char *)malloc(16);
 	if( !newstring ) {
		aux_add_error(EMALLOC, "newstring", CNULL, 0, proc);
		fprintf(stderr, "Can't allocate memory\n");
		return(-1);
	}
        objtype = gets(newstring);
               
	if(!objtype || strlen(objtype) == 0) {
         	answer = FALSE;
        }
	else {
		if((*objtype == 'Y') || (*objtype == 'y')) 
			answer = TRUE;
		else
                	answer = FALSE;
	}
        if (newstring) free(newstring);

	return(answer);
}




/***************************************************************
 *
 * Procedure nxtpar
 *
 ***************************************************************/
#ifdef __STDC__

static char *nxtpar(
	char	 *search
)

#else

static char *nxtpar(
	search
)
char	 *search;

#endif
{
        char *dd, *cc, *ret, *pp, *prm;
	char *proc = "nxtpar";

        int len_excl, len_incl, gl;
		/* len_incl: Argument-Laenge inklusive moeglicher Blanks */
		/* len_excl: Argument-Laenge ohne Blanks */
	int inword = 0;

        if(search) {
                dd = inp;
                while((dd = strchr(dd, '='))) {
                        cc = dd - 1;
                        *dd = '\0';
                        while(*cc && *cc != ' ') cc--;
                        cc++;
			ret = cc;
                        if(strncmp(search, cc, strlen(cc)) == 0) {
				*dd++ = '=';
                                pp = prm = (char *)malloc(128);
                                while (*dd && ( (*dd != ' ') || ((*dd == ' ') && inword) ) ) { 
					if (*dd == '"') {
						inword = 1 - inword;
						dd++;
					}
					else *pp++ = *dd++;
				} 
                                *pp = '\0';
				/* Remove keyword 'search' and parameter 'prm' from input line */
				while (ret < dd) {
					*ret++ = ' ';
				}
                                return(prm);
                        }
                        *dd++ = '=';
                }
                if(!strcmp(search, "pse") || !strcmp(search, "ppin")) return(CNULL);
        }
        dd = inp;
again:
        while(*dd && *dd == ' ') dd++;
        if(*dd) ret = dd;
        else return(CNULL);
        gl = FALSE;
	while (*dd && ( (*dd != ' ') || ((*dd == ' ') && inword) ) ) {
		if (*dd == '"') inword = 1 - inword;
                if ((*dd == '=') && !inword) gl = TRUE;
                dd++;
        }
        if (gl) goto again;
	len_incl = dd - ret;   
	if (*ret == '"') len_excl = dd - ret - 2;  /* Blanks vorne und hinten */ 
        else len_excl = len_incl;
        cc = (char *)malloc(len_excl+1);
 	if( !cc ) {
		aux_add_error(EMALLOC, "cc", CNULL, 0, proc);
		fprintf(stderr, "Can't allocate memory\n");
		return(CNULL);
	}
	if (*ret == '"') strncpy(cc, ret+1, len_excl);
        else strncpy(cc, ret, len_excl);
        cc[len_excl] = '\0';
        dd = ret;
        while (len_incl) {
                *dd++ = ' ';
                len_incl--;
        }
        return(cc);
}


/***************************************************************
 *
 * Procedure strmtch
 *
 ***************************************************************/
#ifdef __STDC__

static char *strmtch(
	char	 *a,
	char	 *b
)

#else

static char *strmtch(
	a,
	b
)
char	 *a;
char	 *b;

#endif

{
	register char *aa, *bb;
	while(*a) {
		aa = a;
		bb = b;
		while(*aa) {
			if(*aa != *bb) break;
                        bb++;
			if(*bb == '\0') return(aa + 1);
                        aa++;
		}
		a++;   
	}
	return(CNULL);
}



/***************************************************************
 *
 * Procedure helpcmd
 *
 ***************************************************************/
static
helpcmd() {
        int i;

        if((helpname = nxtpar(CNULL))) {
                for(i = 0; cmds[i].cmd; i++) {
                        if(strncmp(cmds[i].cmd, helpname, strlen(helpname)) == 0) {
                                fprintf(stderr, "Command:     %s %s\n", cmds[i].cmd, cmds[i].parms);
                                fprintf(stderr, "Description: %s\n", cmds[i].text);
                                fprintf(stderr, "%s\n", cmds[i].longtext);
                        }
                }
                return(0);
        }

        fprintf(stderr, "Command      Description\n");
        fprintf(stderr, "-------------------------------------------------------------------------\n");
        for(i = 0; cmds[i].cmd; i++) fprintf(stderr, "%-12s %s\n", cmds[i].cmd, cmds[i].text);
        fprintf(stderr, "-------------------------------------------------------------------------\n");
        fprintf(stderr, "Command and parameter names may be abbreviated, parameters may be omitted\n");
	return(0);
}






/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static void usage(
	int	  help
)

#else

static void usage(
	help
)
int	  help;

#endif

{

	if(help == LONG_HELP) {
		aux_fprint_version(stderr);

		fprintf(stderr, "scpsemaint: Maintain a PSE on a smartcard (SC)\n\n\n");
		fprintf(stderr, "Description:\n\n"); 
		fprintf(stderr, "'scpsemaint' can be used to maintain an SC-PSE. \n");
		fprintf(stderr, "This includes: \n");
		fprintf(stderr, "	- checking, whether a specified SCT is available,\n");
		fprintf(stderr, "	- displaying and checking the SC-PSE configuration,\n");
		fprintf(stderr, "	- replacing an existing SC-PSE by a new SC-PSE frame\n");
		fprintf(stderr, "	  (without user data). From the PSE to be replaced \n");
		fprintf(stderr, "	  only the PIN for the extension is kept.\n");
		fprintf(stderr, "	- installing a new SC-PSE frame, i.e. all existing\n");
		fprintf(stderr, "	  data on the SC are deleted.\n");
		fprintf(stderr, "	- changing and unblocking PIN for the given SC-PSE,\n");
	}

        fprintf(stderr, "usage:\n\n");
	fprintf(stderr, "scpsemaint [-hvVW]\n");
	fprintf(stderr, "           [-p <pse>]\n");

        if(help == LONG_HELP) {

        fprintf(stderr, "with:\n\n");
        fprintf(stderr, "-p <psename>        PSE name (default: environment variable PSE or %s)\n", DEF_PSE);
        fprintf(stderr, "-h                  write this help text\n");
        fprintf(stderr, "-v                  verbose\n");
        fprintf(stderr, "-V                  Verbose\n");
        fprintf(stderr, "-W                  Grand Verbose (for testing only)\n");
	fprintf(stderr, "<cmd>               Single command that shall be executed by 'scpsemaint'\n");
	fprintf(stderr, "                    (otherwise, commands can be provided interactively\n");
        }

        exit(-1);                                /* IRREGULAR EXIT FROM SCPSEMAINT */
}




#else

/* 
 *	If SCA is not defined, this utility is not available.
 */

/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{

	fprintf(stderr, "\n\nUtility scpsemaint is not available (Identifier SCA is not set)\n\n\n");


}

#endif
