/* ./src/util/psemaint.c */

static char *rcsid = "$Id: psemaint.c,v 1.26 1995/03/07 10:55:54 surkau Exp surkau $";

/* 
 *
 * $Id: psemaint.c,v 1.26 1995/03/07 10:55:54 surkau Exp surkau $
 *
 * $Log: psemaint.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#define NL '\012'
#define ALL 6
#define ENC 5

#include "af.h"
#include "cadb.h"
#ifndef MAC
#include <sys/types.h>
#include <sys/stat.h>
#else
#include <unix.h>
#include <console.h>
#include "Mac.h"
#endif
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>



static CertificatePair *compose_CertificatePair();
static CertificatePair * specify_CertificatePair();
static int incorrectName();
static int incorrectSerialNumber();
static Key *object();
static int storeinfo();
static OctetString * getserial();
static AliasFile getaliasfile();
static Name *gettargetname();
static char *getalgname();
static int store_objpin();
static int helpcmd();
static int str2key();
static int new_pin();
static int keytype();

#ifdef __STDC__
static void     usage(int help);
static Key	*build_key	(char *s, int flag);
static DName	*getdname	(char *s);
static Name	*getalias	(char *dirname, Boolean MUST_PARAM);
static int	printfile	(OctetString *ostring, char *fname);
static int	filen	(char *output);
static char	*nxtpar	(char *search);
static RC	store_certificate	(Certificate *cert, Boolean onekeyonly);
static char	*getattrtype	(char x500);
static int	ack	(PSESel *pse_sel, char *txt);
static int	num	(register char *par);
static int	getsize	(char *par);
static int	psesel	(int option);
#else
static void     usage();
static Key	*build_key	();
static DName	*getdname	();
static Name	*getalias	();
static int	printfile	();
static int	filen	();
static char	*nxtpar	();
static RC	store_certificate	();
static char	*getattrtype	();
static int	ack	();
static int	num	();
static int	getsize	();
static int	psesel	();
#endif


/*
 *    Be careful when changing  enum {...} commands  and struct {...} cmds[]:
 *    They must be in the same order. commands is the index of cmds[].
 */

enum {
       ADDALIAS, ADDEK, ADDGROUPALIAS, ADDPCA, ADDPK, ALGS, ALIAS2DNAME, ALIASES,
#ifdef X500
       AUTHNONE, AUTHSIMPLE,
#ifdef STRONG
       AUTHSTRONG,
#endif
#endif
       CAUCERT2DIR, CACERTIFY, CACRL, CAINITCRL, CAISSUEDCERTIFICATE, CAPRINTLOG, CAPROLONG, CASERIALNUMBERS, 
       CASETSERIAL, CAUSERS, CERT2KEYINFO, CERT2PKROOT, CHECK, CHPIN, CLOSE, CREATE, DELALIAS, DELEK, DELETE,
       DELGROUPALIAS, DELKEY, DELPCA, DELCRL, DELPK, DH1, DH2, DHINIT, DHMAKEENCRYPTIONKEY, DNAME2ALIAS,
#ifdef SCA
       EJECT,
#endif
       ENDE, ENTER, ERROR, EXIT, GENKEY, HELPCMD, KEYTOC,
       MFLIST,
       OPEN, OWNER, PROTOTYPE, QM, QUIT, READ, REMOVE,
       RENAME, RESETERROR, RETRIEVE, REVOKE, SETPARM, SHOW,
       SPLIT, STRING2KEY, TOC,
#ifdef SCA
       TOGGLE,
#endif
       TRUSTPATH, VERBOSE, VERIFY, WRITE, XDUMP
} commands;

struct {
        char *cmd;
        char *parms;
        char *text;
        char *longtext;
} cmds[] = {
{ "addalias",
        "target=<dname or alias> file=<User/System> alias=<alias1> alias=<alias2> ...",
        "Add alias entries with target <dname/alias> to alias file <User/System>",
        "" } ,
{ "addek",
        "<certificate>",
        "The ToBeSigned part of <certificate> is added to EKList",
        "" } ,
{ "addgroupalias",
        "target=<dname or alias> file=<User/System> alias=<alias1> alias=<alias2> ...",
        "Add alias entries with target <dname/alias> to alias file <User/System>",
        "" } ,
{ "addpca",
        "<certificate> ",
        "The ToBeSigned part of <certificate> is added to PCAList",
        "" } ,
{ "addpk",
        "<certificate> ",
        "The ToBeSigned part of <certificate> is added to PKList",
        "" } ,
{ "algs",
        "<algname> or <algtype>",
        "Show parameters of given algorithm or algorithm type",
        "" } ,
{ "alias2dname",
        "<alias>",
        "Search alias and print corresponding DName",
        "" } ,
{ "aliases",
        "<pattern>",
        "Search aliases containing <pattern> and print corresponding DName",
        "" } ,
#ifdef X500
{ "authnone",
        "", 
        "Bind to X.500 Directory without using any authentication", 
        "" } ,
{ "authsimple",
        "", 
        "Use simple DSA authentication ", 
        "" } ,
#ifdef STRONG
{ "authstrong",
        "", 
        "Use strong DSA authentication ", 
        "" } ,
#endif
#endif
{ "caucert2dir",
        "<name>", 
        "CA-cmd: Enters certificate of user <name> with serial number <serial> in directory", 
        "" } ,
{ "cacertify",
        "<certificate>", 
        "CA-cmd: Certify the public key contained in <certificate>", 
        "" } ,
{ "cacrl",
        "",
        "CA-cmd: List all CRLs stored in local database",
        "" } ,
{ "cainitcrl",
        "",
        "CA-cmd: Create an empty CRL",
        "" } ,
{ "caissuedcertificate",
        "<serial>",
        "CA-cmd: Show issued certificate with serial number <serial>",
        "" } ,
{ "calog",
        "",
        "CA-cmd: Show CA log-file",
        "" } ,
{ "caprolong",    
        "", 
        "CA-cmd: Prolong the validity of the own CRL",
        "" } ,
{ "caserialnumbers",    
        "<name>", 
        "CA-cmd: Show all serialnumbers and dates of issue of certificates issued for user <name>",
        "" } ,
{ "casetserial",
        "",
        "Set SerialNumber to new value (CA only)",
        "" } ,
{ "causers",
        "", 
        "CA-cmd: List all users who have been certified", 
        "" } ,

{ "cert2keyinfo",
        "<certificate> <object or keyref>", 
        "Take public key from certificate and store it as KeyInfo in object or under keyref",
        "" } ,
{ "cert2pkroot",
        "<certificate> <object>", 
        "Take public key from certificate and store it as PKRoot in <object>",
        "" } ,
{ "check",
        "", 
        "Check content of PSE for consistency",
        "" } ,
{ "chpin",
        "", 
        "Change all PINs for PSE",
        "" } ,
{ "close",   
        "", 
        "Close PSE",
        "" } ,
{ "create",
        "<object>", 
        "Create <object> on PSE",
        "" } ,
{ "delalias",
        "alias=<alias> file=<User/System>", 
        "Remove alias <alias> from alias file <User/System>",
        "" } ,
{ "delek",
        "<issuer> <serialnumber> or <subject>",
        "The ToBeSigned identified by either <issuer> and <serialnumber> or <subject> is deleted from EKList",
        "" } ,
{ "delete",
        "<object>", 
        "Delete PSE or <object> on PSE",
        "" } ,
{ "delgroupalias",
        "target=<dname or alias> alias=<alias> file=<User/System>", 
        "Remove target <dname/alias> with group alias <alias> from alias file <User/System>.\nWith no target the whole group alias is removed",
        "" } ,
{ "delkey",
        "<keyref>", 
        "Remove key with given <keyref>",
        "" } ,
{ "delpca",
        "<issuer> <serialnumber> or <subject>",
        "The ToBeSigned identified by either <issuer> and <serialnumber> or <subject> is deleted from PCAList",
        "" } ,
{ "delcrl",
        "<issuer>",
        "Remove revoction list of <issuer> from set of locally stored revocation lists",
        "" } ,
{ "delpk",
        "<issuer> <serialnumber> or <subject>",
        "The ToBeSigned identified by either <issuer> and <serialnumber> or <subject> is deleted from PKList",
        "" } ,
{ "dh1",
        "(\"temp\" <size> <pr_val_lgth> | \"peer\" <peers_public_y> | \"def\" <with_pg>) <own_private_key> <own_public_key>",
        "Phase 1 of DH key agreement generates <own_private_key> and writes the public key to file <own_public_key>",
        "The DH Parameter could be generated temporary with prime modulus length <size> and <pr_val_lgth>,\nit could be extracted from file <peers_public_y> or it could be got from default PSE object.\nIf <with_pg> is \"common\" the AlgId dhWithCommonModulus is used."
 } ,
{ "dh2",
        "<private_key> <peers_public_key> agreed_key>",
        "Phase 2 of DH key agreement reads <peers_public_key> from file and creates <agreed_key> with <private_key>",
        "" } ,
{ "dhinit",
        "<size> <private_value_length>",
        "The PSE object for DH Parameter is generated with modulus length <size> and <private_value_length>",
        "" } ,
{ "dhmakeencryptionkey",
        "<agreed_key> <key> <alg>",
        "The PSE object <agreed_key> holding the agreed DH key is converted to the symmetric encryption key <key> of algorithm <alg>",
        "" } ,
{ "dname2alias",
        "<pattern>",
        "Search DName containing <pattern> and print corresponding alias names",
        "" } ,
#ifdef SCA
{ "eject",
        "<sct-id>",
        "Eject smartcard <sct-id>. If sct-id is 0 or omitted, eject all smartcards",
        "" } ,
#endif
{ "end",
        "",
        "Exit program",
        "" } ,
{ "enter",
        "attrtype=<attrtype> keytype=<keytype>", 
        "Enter security attribute into Directory",
        "" } ,
{ "error",
        "", 
        "print error stack",
        "" } ,
{ "exit",
        "",
        "Exit program",
        "" } ,
{ "genkey",
        "<algname> <object or keyref>", 
        "Generate key and store in <object> or under <keyref>",
        "" } ,
{ "helpcmd",
        "<cmd>",
        "Show helptext for <cmd>",
        "" } ,
{ "keytoc",  
        "", 
        "Show table of contents (toc) of all keys (keyref's)",
        "" } ,
{ "mflist",
        "<cmd>",
        "Show list of malloc'd addresses",
        "" } ,
{ "open",    
        "<pse>", 
        "Open PSE",
        "" } ,
{ "owner",    
        "", 
        "Display name of PSE owner",
        "" } ,
{ "prototype",    
        "", 
        "Create a self-signed prototype-certificate of the own public signature key",
        "" } ,
{ "?",
        "<cmd>", 
        "show helptext for cmd",
        "" } ,
{ "quit",
        "",
        "Exit program",
        "" } ,
{ "read",
        "<object> <destination>", 
        "Read <object> into file <destination>",
        "" } ,
{ "remove",
        "attrtype=<attrtype> keytype=<keytype> cert=<serial,issuer> for=<serial,issuer> rev=<serial,issuer> replace=<TRUE/FALSE>", 
        "Remove security attribute from own directory entry",
        "" } ,
{ "rename",
        "<object> <newname>", 
        "Rename <object> to <newname>",
        "" } ,
{ "reseterror",
        "", 
        "free error stack",
        "" } ,
{ "retrieve",
        "target=<dname> attrtype=<attrtype> keytype=<keytype> update=<TRUE/FALSE>", 
        "Retrieve security attribute from directory entry identified by <dname>",
        "" } ,
{ "revoke",
        "",
        "Revoke one or more certificates",
        "" } ,
{ "setparm",
        "<algname>",
        "Set parameters of algorithm <algname>",
        "" } ,
{ "show",
        "<object or keyref>",
        "Show object or keyref in suitable form",
        "" } ,
{ "split",
        "for=<serial,issuer> rev=<serial,issuer>",
        "Split a Cross Certificate Pair into its components",
        "" } ,
{ "string2key", 
        "<string>", 
        "Generate DES key from string and store in object or under keyref",
        "" } ,
{ "toc",
        "", 
        "Show table of contents (toc) of PSE)", 
        "" } ,
#ifdef SCA
{ "toggle",
        "", 
        "Toggle verification/encryption tool from SC to SW and vice versa", 
        "" } ,
#endif
{ "trustpath",
        "", 
        "Show owner of the PSE and certification path up to the Root-CA", 
        "" } ,
{ "verbose",
        "",
        "Change verbose level",
        "" } ,
{ "verify",
        "certificate=<cert> fcpath=<fcpath> pkroot=<pkroot>",
        "Verify digital signatures",
        "" } ,
{ "write",
        "<object> <source>", 
        "Write object from file", 
        "" } ,
{ "xdump",
        "<object or keyref>", 
        "xdump object or keyref",
        "" } ,
{ CNULL }
};


int     cmd;
Boolean replace;
char    inp[256], prompt[256], answ[256];
char    * cmdname, * helpname, * filename, * pin, * newpin, * algname, * objtype, * attrname;
CertificateType certtype;
KeyRef  keyref;
PSESel  std_pse;
Key     *key, *publickey, *privatekey;
PSELocation pse_location;



int             verbose = 0;


Boolean interactive = TRUE;
char *pname, *ppin;
int pkeyref;

/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{
	char			* proc = "main (psemaint)";
	extern char		* optarg;
	extern int		  optind, opterr;
        int             	  fdin;
        int             	  i, anz, n, algtype, found;
        int                       opt;
        time_t          	  atime, etime;
	char	        	  x500 = TRUE;
	char	        	* calogfile;
        Boolean         	  update, create;
        char            	* ii, *xx;
        char            	* par, *dd, *ptr, *cc, *newname, *attrtype, *objname;
	char	        	* pgm_name = *parm;
	char            	* psename = CNULL, *cadir = CNULL, * notbefore = CNULL, * notafter = CNULL;
        RC              	  rcode;
        OctetString     	  octetstring, *ostr, *objectvalue, *tmp_ostr;
        ObjId    		  objecttype, object_oid, *oid;
	AlgId           	* algid;
        BitString       	* bstr;
        KeyInfo         	  tmpkey, * keyinfo = (KeyInfo *)0, * signpk, * encpk;
        FCPath          	* fcpath = (FCPath *)0;
        PKList          	* pklist = (PKList *)0;
        PKRoot          	* pkroot = (PKRoot *)0;
        Certificate     	* certificate = (Certificate *)0, * fcpath_cert;
        Certificates    	* certs = (Certificates *)0;
	ToBeSigned 		* tbs;
        SET_OF_Certificate 	* certset, * soc, * tmp_soc;
	CRLEntry     		* crlentry;
	CertificatePair 	* cpair;
	SET_OF_CertificatePair  * cpairset;
	CRLWithCertificates         * crlwithcerts;
	SET_OF_CRLWithCertificates  * setofcrlwithcerts;
	SEQUENCE_OF_CRLEntry  * crlentryseq;
	Crl			* crlpse;
	CrlSet      		* crlset;
	CRL			* crl;
        Name            	* name, * alias, * issuer, * subject;
	DName			* dname, * issuer_dn = NULLDNAME, * subject_dn = NULLDNAME, * own_dname, * signsubject, * encsubject;
        rsa_parm_type   	* rsaparm;
	KeyType         	  ktype;
        AlgEnc          	  algenc;
        PSESel          	* pse_sel, *psesel_zw;
	OctetString		* serial;
	SET_OF_IssuedCertificate *isscertset;
	SET_OF_Name		* nameset;
	AlgList         	* a;
	AlgId           	* algorithm = (AlgId *)0;
	Name			* printrepr;
	Boolean         	  onekeypaironly = FALSE;
	Boolean			  from_script = FALSE;
	Boolean			  retvalue;
	char			* outtext;
	AliasFile		  aliasfile;
	AliasList               * aliaslist;
	int			  cmd_count = 1;
	int			  dh_keysize, dh_privatevalue;
	Boolean			  dh_with_pg;
	Key			 *dh_private;
        KeyInfo         	 *dh_own_public_y, *dh_peer_public_y, *dh_private_keyinfo;
        OctetString         	 *dh_own_public_y_encoded, *dh_peer_public_y_encoded;
	BitString		 *dh_agreed_key;
	ObjId			 *dh_agreed_key_oid;
	AlgId			 *dh_parm;
	Validity		  validity;
	Certificate    		 *new_cert;
	

#ifdef X500
	char	        * env_af_dir_authlevel;
#endif

#ifdef MS_DOS
	_fmode = O_BINARY;
#endif

	logfile = (FILE * )0;

/*
 *      get args
 */

	optind = 1;
	opterr = 0;

	MF_check = FALSE;
	af_access_directory = FALSE;
	chk_PEM_subordination = TRUE;

#ifdef X500
	af_dir_authlevel = DBA_AUTH_NONE;
#endif

#ifdef X500
#ifdef SCA
	while ( (opt = getopt(cnt, parm, "a:i:c:p:y:f:l:A:d:t:hzvCFRDOVWXYT")) != -1 ) {
#else
	while ( (opt = getopt(cnt, parm, "a:i:c:p:y:f:l:A:d:t:hzvCFRDOVWXY")) != -1 ) {
#endif
#else
#ifdef SCA
	while ( (opt = getopt(cnt, parm, "a:i:c:p:y:f:l:hzvCFRDOTVWXYT")) != -1 ) {
#else
	while ( (opt = getopt(cnt, parm, "a:i:c:p:y:f:l:hzvCFRDOTVWXY")) != -1 ) {
#endif
#endif
		switch(opt) {

		case 'z':
			MF_check = TRUE;
			break;
		case 'y':
			sec_debug = atoi(optarg);
			break;
                case 'i':
                        if((fdin = open(optarg, O_RDONLY)) < 0) {
                                fprintf(stderr, "Can't open %s \n", optarg);
                                exit(1);
                        }
                        close(0);
                        dup(fdin);
                        close(fdin);
			interactive = FALSE;
			from_script = TRUE;
                        continue;
                case 'c':
                        cadir = optarg;
                        continue;
		case 'a':
                        oid = aux_Name2ObjId(optarg);
                        if (aux_ObjId2AlgType(oid) != SIG) usage(SHORT_HELP);
			algorithm = aux_ObjId2AlgId(oid);
			continue;
		case 'f':
			if (notbefore) usage(SHORT_HELP);
			else notbefore = optarg;
			continue;
		case 'l':
			if (notafter) usage(SHORT_HELP);
			else notafter = optarg;
			continue;
                case 'R':
                        af_chk_crl = TRUE;
                        continue;
                case 'p':
                        psename = optarg;
                        continue;
                case 'F':
                        af_FCPath_is_trusted = TRUE;
                        continue;
                case 'O':
                        chk_PEM_subordination = FALSE;
                        continue;
		case 'D':
			af_access_directory = TRUE;
			continue;
                case 'C':
                        strcpy(inp, "helpcmd");
                        continue;
		case 'v':
			verbose = 1;
			continue;
		case 'V':
			af_verbose = TRUE;
			verbose = 2;
			continue;
		case 'W':
			verbose = 2;
			af_verbose = TRUE;
			sec_verbose = TRUE;
			continue;
                case 'X':
 		 	random_from_pse = TRUE;
                        break;
                case 'Y':
 			sec_init_random_seed_from_keyboard();
                        break;
		case 'h':
			usage(LONG_HELP);
			continue;
#ifdef X500
		case 'A':
			if (! strcasecmp(optarg, "STRONG"))
				af_dir_authlevel = DBA_AUTH_STRONG;
			else if (! strcasecmp(optarg, "SIMPLE"))
				af_dir_authlevel = DBA_AUTH_SIMPLE;
			break;
		case 'd':
			af_dir_dsaname = aux_cpy_String(optarg);
			continue;
		case 't':
			af_dir_tailor = aux_cpy_String(optarg);
			continue;
#endif

#ifdef SCA
		case 'T':
			SC_verify = TRUE;
			SC_encrypt = TRUE;
			continue;
#endif

		default:
		case '?':
			usage(SHORT_HELP);
		}
	}                    

	while (optind < cnt) {
                if(strlen(inp)) strcat(inp, " ");
                strcat(inp, parm[optind++]);
                interactive = FALSE;
        }

	aux_set_pse(psename, cadir);

        if(strncmp(inp, "helpcmd", 4) == 0) {
                par = nxtpar(CNULL);
                helpcmd();
                exit(0);
        }

        ii = inp;


#ifdef X500
	if (af_dir_authlevel == DBA_AUTH_NONE) {
		env_af_dir_authlevel = getenv("AUTHLEVEL");
		if (env_af_dir_authlevel) {
			if (! strcasecmp(env_af_dir_authlevel, "STRONG"))
				af_dir_authlevel = DBA_AUTH_STRONG;
			else if (! strcasecmp(env_af_dir_authlevel, "SIMPLE"))
				af_dir_authlevel = DBA_AUTH_SIMPLE;
		}
	}
#endif

        if(strncmp(inp, "create", 5)) {
        	if(!(pse_sel = af_pse_open(NULLOBJID, FALSE))) {
			aux_fprint_error(stderr, verbose);
			exit(-1);
        	}

		if(af_check_if_onekeypaironly(&onekeypaironly)){
			aux_fprint_error(stderr, verbose);
			exit(- 1);
		}

                aux_free_PSESel(&pse_sel);
        }

        std_pse.app_name = aux_cpy_String(AF_pse.app_name);
        std_pse.object.name = CNULL;
        std_pse.object.pin = aux_cpy_String(AF_pse.pin);
        std_pse.pin = aux_cpy_String(AF_pse.pin);
	std_pse.app_id = AF_pse.app_id;

#ifdef AFDBFILE
	/* Determine whether X.500 directory shall be accessed */
	x500 = af_x500_check();
#endif

	if (af_access_directory == TRUE) directory_user_dname = af_pse_get_Name();

        if(strlen(inp)) goto entr;

        while(1) {
		if(key) aux_free_Key(&key);
		if(certificate) aux_free_Certificate(&certificate);
		if(pkroot) aux_free_PKRoot(&pkroot);
		if(fcpath) aux_free_FCPath(&fcpath);
		if(certs) aux_free_Certificates(&certs);
		if(keyinfo) aux_free_KeyInfo(&keyinfo);
                if(interactive == FALSE && from_script == FALSE) {
			exit(rcode);
		}
		if(interactive == TRUE) {
			if(AF_pse.app_name) fprintf(stderr, "PSE %s> ", AF_pse.app_name);
			else fprintf(stderr, "psemaint> ");
		}
                std_pse.object.name = CNULL;
                if(!aux_fgets ((char *)0, inp, sizeof(inp), stderr, stdin)) exit(0);
entr:
                ii = inp;

		if(interactive == FALSE && ii && strlen(ii)){
			if(verbose) fprintf(stderr, "%d. cmd: <%s>\n", cmd_count, ii);
			cmd_count++;
		}

                if(!(par = nxtpar(CNULL))) continue;

                anz = 0;
                for(i = 0; cmds[i].cmd; i++) {
                        if(!strncmp(cmds[i].cmd, par, strlen(par))) {
                                cmd = i;
                                cmdname = cmds[i].cmd;
                                anz++;
                        }
                }
		if(par) free(par);
                if(anz > 1) {
                        fprintf(stderr, "Ambiguous cmd\n");
                        rcode = 1;
                        continue;
                }
                if(anz == 0) {
                        fprintf(stderr, "unknown cmd\n");
                        rcode = 1;
                        continue;
                }

                rcode = 0;

                switch(cmd) {
			case ADDALIAS:
			case ADDGROUPALIAS:
				name = gettargetname();
				if(!name) {
					fprintf(stderr, "target name missing\n");
					break;
				}
				else dname = aux_Name2DName(name);
				aliasfile = getaliasfile();
				if(aliasfile == notstored) {
					fprintf(stderr, "AliasFile missing for target <%s>\n", name);
					aux_free_DName(&dname);
					free(name);
					break;
				}

				alias = getalias(name, TRUE);

				if(alias) {
					if(cmd == ADDALIAS) {
						if(aux_add_alias(alias, dname, aliasfile, TRUE, TRUE) < 0) {
							fprintf(stderr, "Couldn't add alias %s for target <%s>\n", alias, name);
							aux_fprint_error(stderr, verbose);
						}
					}
					else if(aux_add_group_alias(alias, dname, aliasfile, TRUE, TRUE) < 0) {
						fprintf(stderr, "Couldn't add alias %s for target <%s>\n", alias, name);
						aux_fprint_error(stderr, verbose);
					}
					free(alias);
					alias = CNULL;
				}
				else {
					fprintf(stderr, "alias missing for target <%s>\n", name);
					aux_free_DName(&dname);
					free(name);
					break;
				}

				while((alias = getalias(name, FALSE))) {
					if(cmd == ADDALIAS) {
						if(aux_add_alias(alias, dname, aliasfile, TRUE, TRUE) < 0) {
							fprintf(stderr, "Couldn't add alias %s for target <%s>\n", alias, name);
							aux_fprint_error(stderr, verbose);
						}
					}
					else if(aux_add_group_alias(alias, dname, aliasfile, TRUE, TRUE) < 0) {
						fprintf(stderr, "Couldn't add alias %s for target <%s>\n", alias, name);
						aux_fprint_error(stderr, verbose);
					}
					free(alias);
					alias = CNULL;
				}
				aux_free_DName(&dname);
				free(name);
				break;
                        case ADDEK:
                                if(!(key = build_key("Certificate from PSE object", 0))) {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                ostr = &octetstring;
                                if(sec_read_PSE(key->pse_sel, &object_oid, ostr) < 0)  {
					fprintf(stderr, "Can't read object  %s  from PSE\n", key->pse_sel->object.name);
					aux_free2_ObjId(&object_oid);
					break;
				}
				aux_free2_ObjId(&object_oid);
                                if(!(certificate = d_Certificate(ostr))) {
					fprintf(stderr,"Can't decode Certificate\n");
					free(ostr->octets);
					break;
				}
				free(ostr->octets);
				aux_free_Key(&key);
				rcode = af_pse_add_PK(ENCRYPTION, certificate->tbs);
				if(rcode < 0) fprintf(stderr, "Can't add cert to EKList\n");
				aux_free_Certificate(&certificate);
                                break;
                        case ADDPCA:
                                if(!(key = build_key("Certificate from PSE object", 0))) {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                ostr = &octetstring;
                                if(sec_read_PSE(key->pse_sel, &object_oid, ostr) < 0)  {
					fprintf(stderr,"Can't read object  %s  from PSE\n", key->pse_sel->object.name);
					aux_free2_ObjId(&object_oid);
					break;
				}
				aux_free2_ObjId(&object_oid);
                                if(!(certificate = d_Certificate(ostr))) {
					fprintf(stderr,"Can't decode Certificate\n");
					free(ostr->octets);
					break;
				}
				free(ostr->octets);
				rcode = af_pse_add_PCA(certificate->tbs);
				if(rcode < 0) fprintf(stderr, "Can't add cert to PCAList\n");
				aux_free_Certificate(&certificate);
                                break;
                        case ADDPK:
                                if(!(key = build_key("Certificate from PSE object", 0))) {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                ostr = &octetstring;
                                if(sec_read_PSE(key->pse_sel, &object_oid, ostr) < 0)  {
					fprintf(stderr,"Can't read object  %s  from PSE\n", key->pse_sel->object.name);
					aux_free2_ObjId(&object_oid);
					break;
				}
				aux_free2_ObjId(&object_oid);
                                if(!(certificate = d_Certificate(ostr))) {
					fprintf(stderr,"Can't decode Certificate\n");
					free(ostr->octets);
					break;
				}
				free(ostr->octets);
				rcode = af_pse_add_PK(SIGNATURE, certificate->tbs);
				if(rcode < 0) fprintf(stderr, "Can't add cert to PKList\n");
				aux_free_Certificate(&certificate);
                                break;
                        case ALGS:
                                strrep(&algname, getalgname());
                                algtype = 0;
                                if(!strcmp(algname, "ASYM_ENC")) algtype = ASYM_ENC;
                                else if(!strcmp(algname, "SYM_ENC")) algtype = SYM_ENC;
                                else if(!strcmp(algname, "HASH")) algtype = HASH;
                                else if(!strcmp(algname, "SIG")) algtype = SIG;
                                else if(!strcmp(algname, "ENC")) algtype = ENC;
                                else if(!strcmp(algname, "ALL")) algtype = ALL;

                                for(i = 0; TRUE; i++) {
                                        if(!alglist[i].name) break;
                                        if(algtype == 0) {
                                                if(!strcmp(alglist[i].name, algname)) {
                                                        aux_fprint_AlgId(stderr, alglist[i].algid);
                                                }
                                        }
                                        else {
                                                if(algtype == ALL || 
                                                   ((algtype == ASYM_ENC || algtype == SYM_ENC || algtype == HASH || algtype == SIG) 
                                                     && algtype == alglist[i].algtype) ||
                                                   ((algtype == ENC) && (alglist[i].algtype == ASYM_ENC || alglist[i].algtype == SYM_ENC))) {
                                                        aux_fprint_AlgId(stderr, alglist[i].algid);
                                                }
                                        }
                                }
                                break;
                        case ALIAS2DNAME:
                                alias = (Name *)nxtpar("pattern");
                                aux_fprint_alias2dname(stderr, (char *)alias);
				if(alias) free(alias);
                                break;
                        case ALIASES:
                                alias = (Name *)nxtpar("pattern");
                                aux_fprint_alias2dnames(stderr, (char *)alias);
				if(alias) free(alias);
                                break;
#ifdef X500
			case AUTHNONE:
				af_dir_authlevel = DBA_AUTH_NONE;
				af_dir_dsabound = FALSE;
				break;
			case AUTHSIMPLE:
				af_dir_authlevel = DBA_AUTH_SIMPLE;
				af_dir_dsabound = FALSE;
				break;
#ifdef STRONG
			case AUTHSTRONG:
				af_dir_authlevel = DBA_AUTH_STRONG;
				af_dir_dsabound = FALSE;
				break;
#endif
#endif
			case CAUCERT2DIR:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				if (af_access_directory == FALSE) {
					fprintf(stderr, "af_access_directory is set to FALSE!\n");
					fprintf(stderr, "If you want to access the Directory, you should invoke ");
					fprintf(stderr, "the 'psemaint' command with the -D option.\n");
					break;
				}
				if(!af_x500 && !af_afdb){
					fprintf(stderr, "No directory flags (AFDBFILE or X500) have been compiled.\n");
					fprintf(stderr, "Therfore, no directory access is provided.\n");
					break;
				}
			/*****************/
				name = gettargetname();
				if(!name) break;
				isscertset = af_cadb_get_user(name, cadir);
				if(isscertset) {
					fprintf(stderr, "Certificates issued for <%s>:\n", name);
					aux_fprint_SET_OF_IssuedCertificate(stderr, isscertset);
				}
				else {
					fprintf(stderr, "No certificates issued for this user\n");
					break;
				}
				fprintf(stderr, "\nTo choose first Serialnumber press <return>, else..\n\n");

				if((serial = getserial()) == NULLOCTETSTRING){
					if (isscertset->element) {
						serial = isscertset->element->serial;
					}
					else {
						fprintf(stderr, "No certificates issued for this user\n");
						break;
					} 
				}

				certificate = af_cadb_get_Certificate(serial, cadir);
				if (!certificate) {
					fprintf(stderr, "\nNo certificate with serial number ");
					aux_fprint_Serialnumber(stderr, serial);
					fprintf(stderr, "in CA database!\n");
					break;
				}
#ifdef X500
				attrtype = getattrtype(x500);
				if (   !strncasecmp(attrtype, "CACertificate", 2) 
				    || !strncasecmp(attrtype, "UserCertificate", 1)){
					if (x500) {
						if(!strncasecmp(attrtype, "UserCertificate", 1)) 
							certtype = userCertificate;
						else 
							certtype = cACertificate;
						}
				}
#endif

#ifdef AFDBFILE
				keytype();
				if(*objtype == 'S') {
					std_pse.object.name = aux_cpy_String(SignCert_name);
					ktype = SIGNATURE;
				}
				else 
					if(*objtype == 'E') {
						std_pse.object.name = aux_cpy_String(EncCert_name);
						ktype = ENCRYPTION;
					}
                 			else {
                    				fprintf(stderr, "Type must be either 'S' or 'E'\n");
                        			break;
                  			}
#endif
						
#ifdef X500
				if ( x500 ) {
					fprintf(stderr, "\nAccessing your X.500 directory entry ...\n\n");
					if ( af_dir_enter_Certificate(certificate, certtype) == 0 )
						fprintf(stderr, "Directory entry (X.500) succeeded.\n");
					else {
						fprintf(stderr, "Directory entry (X.500) f a i l e d.\n");
						aux_fprint_error(stderr, verbose);
					}
				}
#endif

#ifdef AFDBFILE
				fprintf(stderr, "\nAccessing your AF-DB directory entry ...\n\n");
				if ( af_afdb_enter_Certificate(certificate, ktype) == 0 )
					fprintf(stderr, "Directory entry (AF-DB) succeeded.\n");
	      			else {
	              			fprintf(stderr, "Directory entry (AF-DB) f a i l e d.\n");
	              			aux_fprint_error(stderr, verbose);
	              		}
#endif
				aux_free_Certificate(&certificate);
				/*******************/
				break;

			case CACERTIFY:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
                                if(!(key = build_key("Certificate from", 0))) {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                ostr = &octetstring;
                                if(sec_read_PSE(key->pse_sel, &object_oid, ostr) < 0)  {
					fprintf(stderr,"Can't read object  %s  from PSE\n", key->pse_sel->object.name);
					break;
				}
                                if(!(certificate = d_Certificate(ostr))) {
					fprintf(stderr,"Can't decode Certificate\n");
					aux_free_Key(&key);
					aux_free2_ObjId(&object_oid);
					free(ostr->octets);
					break;
				}
				aux_free2_ObjId(&object_oid);
				free(ostr->octets);
				aux_free_Key(&key);
                                if(!(key = build_key("Certified public key to", 1)))  {
					fprintf(stderr,"Can't build key\n");
					aux_free_Certificate(&certificate);
					break;
				}
				if(!(calogfile = aux_get_abs_path(cadir, CALOG))) {
					AUX_ADD_ERROR;
					return(-1);
				}
				logfile = fopen(calogfile, LOGFLAGS);
				free(calogfile);
				if(logfile == (FILE * ) 0) {
					fprintf(stderr, "%s: Can't open %s\n", pgm_name, CALOG);
					break;
				}
				validity.notbefore = notbefore;
				validity.notafter = notafter;

				new_cert = af_certify (certificate, 
							&validity,
							algorithm);

				if (new_cert == (Certificate *) 0) {
                			LOGERR("AF Error with CA Certify");
					fprintf(stderr, "%s: ",pgm_name);
                			fprintf(stderr, "AF Error with CA Certify\n");
                			break;
				}

				aux_free_Certificate(&certificate);
				certificate = new_cert;

				if (notbefore) 
					free(notbefore);
				if (notafter)
					free(notafter);



				printrepr = aux_DName2Name(certificate->tbs->subject);
        			if(af_cadb_add_user(printrepr, cadir) < 0) {
                			LOGERR("can't access user db");
					fprintf(stderr, "%s: ",pgm_name);
                			fprintf(stderr, "Can't access user db\n");
                			break;
        			}
				free(printrepr);
				
				if (af_cadb_add_Certificate(0, certificate, cadir)) {
					LOGERR("Can't access cert db");
					break;
				}
                                if(key->pse_sel) {
                                        if(!(ostr = e_Certificate(certificate)))  {
						fprintf(stderr,"Can't encode new Certificate\n");
						aux_free_Certificate(&certificate);
  						break;
					}
					aux_free_Certificate(&certificate);
					if(onekeypaironly == TRUE)
						oid = af_get_objoid(Cert_name);
					else {
                                        	keytype();
                                        	if(*objtype == 'S') oid = af_get_objoid(SignCert_name);
                                        	else if(*objtype == 'E') oid = af_get_objoid(EncCert_name);
                                        	else {
                                                	fprintf(stderr, "Type must me either 'S' or 'E'\n");
                                                	break;
                                        	}
					}
                                        if(sec_write_PSE(key->pse_sel, oid, ostr) < 0)  {
						fprintf(stderr,"Can't write to PSE\n");
						aux_free_OctetString(&ostr);
 						break;
					}
                                        fprintf(stderr, "New certificate stored in object %s\n", key->pse_sel->object.name);
					aux_free_OctetString(&ostr);
                                }
				fclose(logfile);
				logfile = (FILE * )0;
				break;
			case CACRL:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				setofcrlwithcerts = af_cadb_list_CRLWithCertificates(cadir);
                                fprintf(stderr, "The following revocation lists, each accompanied by its issuer's certification path\n");
				fprintf(stderr, "(which is OPTIONAL), have been stored in your CA's local database:\n\n\n\n");
				aux_fprint_SET_OF_CRLWithCertificates(stderr, setofcrlwithcerts);
				aux_free_SET_OF_CRLWithCertificates(&setofcrlwithcerts);
				break;
			case CAINITCRL:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				crl = (CRL * )malloc(sizeof(CRL));
				if (! crl) {
					fprintf(stderr, "%s: ", pgm_name);
  	        			fprintf(stderr, "Can't allocate memory\n");
					break;
				}

				crl->tbs = (CRLTBS * )malloc(sizeof(CRLTBS));
				if (! crl->tbs) {
					fprintf(stderr, "%s: ", pgm_name);
  	        			fprintf(stderr, "Can't allocate memory\n");
					break;
				}

				if (!(crl->tbs->issuer = af_pse_get_Name())) {
					break;
				}

				crl->tbs->lastUpdate = aux_current_UTCTime();
				crl->tbs->nextUpdate = (UTCTime *)0;
				crl->tbs->nextUpdate = aux_get_nextUpdate(crl->tbs->lastUpdate);

				crl->tbs->revokedCertificates = (SEQUENCE_OF_CRLEntry * )0;

				crl->sig = (Signature * )malloc(sizeof(Signature));
				if (! crl->sig) {
					fprintf(stderr, "%s: ", pgm_name);
  	        			fprintf(stderr, "Can't allocate memory\n");
					break;
				}
				crl->sig->signature.nbits = 0;
				crl->sig->signature.bits = CNULL;

				/*
				 * CA's signature algorithm : - either default value  
				 *			      - or     issueralg (option -a)
				 */
				crl->tbs->signatureAI = af_get_signature_alg(algorithm, (AlgId *)0);
				crl->sig->signAI = aux_cpy_AlgId(crl->tbs->signatureAI);

				if ((crl->tbs_DERcode = e_CRLTBS(crl->tbs)) == NULLOCTETSTRING) {
					fprintf(stderr, "%s: ", pgm_name);
  	        			fprintf(stderr, "e_CRLTBS failed\n");
					break;
				}

				if ((crl->tbs_DERcode = e_CRLTBS(crl->tbs)) == NULLOCTETSTRING) {
					fprintf(stderr, "Can't encode crl->tbs\n");
					break;
				}

				fprintf(stderr, "\nThe following Crl is to be signed. ");
				fprintf(stderr, "Please check it:\n\n");
				aux_fprint_CRLTBS(stderr, crl->tbs);
				fprintf(stderr, "\nDo you want to sign the displayed ");
				fprintf(stderr, "revocation list ?\n");
				fprintf(stderr, "If you want to sign it, (re)enter the PIN of your PSE:\n\n");
				af_pse_close(NULLOBJID);
				if ( af_sign(crl->tbs_DERcode, crl->sig, SEC_END) < 0 ) {
					fprintf(stderr, "Signature of revocation list failed\n");
					break;
				}
				/* Update on Directory entry, PSE, and CA directory: */
#ifdef X500
				if (x500 && af_access_directory == TRUE) {
					/* update X.500 directory entry */
					fprintf(stderr, "\n**********************************************\n");
					fprintf(stderr, "\nTrying to update your X.500 directory entry ...\n\n");
					if ( af_dir_enter_CRL(crl) < 0 ) 
						fprintf(stderr, "\n Directory entry (X.500) f a i l e d !\n");
					else fprintf(stderr, "\n Done!\n");
				}
#endif
#ifdef AFDBFILE
				if(af_access_directory == TRUE){
					/* update AF-DB directory entry */
					fprintf(stderr, "\n**********************************************\n");
					fprintf(stderr, "\nTrying to update your AF-DB directory entry ...");
					if ( af_afdb_enter_CRL(crl) < 0 ) 
						fprintf(stderr, "\n Directory entry (AF-DB) f a i l e d !\n");
					else fprintf(stderr, "\n Done!\n");
				}
#endif

				/* update PSE object CrlSet, even if the directory entry failed */
				crlpse = CRL2Crl (crl);
				fprintf(stderr, "\n**********************************************\n");
				fprintf(stderr, "\nUpdating PSE object CrlSet ...\n");
				rcode = af_pse_add_CRL(crlpse);
				if (rcode != 0) {
					fprintf(stderr, "\n Cannot update PSE object CrlSet.\n");
					aux_free_Crl (&crlpse);
				}
				else fprintf(stderr, "\n Done!\n");
				aux_free_Crl (&crlpse);

				/* update 'crlwithcerts' database in CA directory, even if the directory entry failed */
				fprintf(stderr, "\n**********************************************\n");
				fprintf(stderr, "\nUpdating 'crlwithcerts' database in CA directory \"%s\" ...\n", cadir);
				if(!(calogfile = aux_get_abs_path(cadir, CALOG))) {
					AUX_ADD_ERROR;
					return(-1);
				}
				logfile = fopen(calogfile, LOGFLAGS);
				free(calogfile);
				if(logfile == (FILE * ) 0) {
					fprintf(stderr, "%s: Can't open %s\n", pgm_name, CALOG);
					break;
				}
				crlwithcerts = (CRLWithCertificates * )malloc(sizeof(CRLWithCertificates));
				crlwithcerts->crl = crl;
				crlwithcerts->certificates = (Certificates * )0;
				rcode = af_cadb_add_CRLWithCertificates(crlwithcerts, cadir);
				if(rcode != 0){
					fprintf(stderr, "%s: ", pgm_name);
					fprintf(stderr, "Cannot store your updated CRL in your 'crlwithcerts' database!\n");
					aux_fprint_error(stderr, verbose);
					aux_free_CRLWithCertificates(&crlwithcerts);
					break;
				}
				fprintf(stderr, "\nMost current version of CRL stored in 'crlwithcerts' database in ");
				fprintf(stderr, "CA directory \"%s\".\n\n", cadir);
				aux_free_CRLWithCertificates(&crlwithcerts);
				fclose(logfile);
				logfile = (FILE * )0;
				break;
			case CAISSUEDCERTIFICATE:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
                                if((dd = nxtpar(""))) {
					serial = aux_create_SerialNo(dd);
					free(dd);
				}
                                else if((serial = getserial()) == NULLOCTETSTRING){
					fprintf(stderr, "No serial number specified!\n");
					break;
				}
				certificate = af_cadb_get_Certificate(serial, cadir);
				if(certificate) {
					aux_fprint_Certificate(stderr, certificate);
					store_certificate(certificate, onekeypaironly);
				}
                                else {
					fprintf(stderr, "No certificate issued with SerialNo ");
					aux_fprint_Serialnumber(stderr, serial);
				}
				break;
			case CAPRINTLOG:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				if(!(calogfile = aux_get_abs_path(cadir, CALOG))) {
					AUX_ADD_ERROR;
					return(-1);
				}
				logfile = fopen(calogfile, "r");
				free(calogfile);
				if(logfile == (FILE * ) 0) {
					fprintf(stderr, "%s: Can't open %s\n", pgm_name, CALOG);
					break;
				}
				while ((n = getc(logfile)) != EOF) putchar(n);
				fclose(logfile);
				logfile = (FILE * )0;
				break;
			case CAPROLONG:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				dname = af_pse_get_Name();
				name = aux_DName2Name(dname);
				aux_free_DName(&dname);
				crlwithcerts = af_cadb_get_CRLWithCertificates(name, cadir);
				if(! crlwithcerts || ! crlwithcerts->crl){
					fprintf(stderr, "WARNING: Your own CRL is NOT stored in your local database!\n");
					break;
				}
				fprintf(stderr, "\nThis is your locally stored revocation list:\n\n");
				aux_fprint_CRL(stderr, crlwithcerts->crl);
				fprintf(stderr, "\n\nVerifying your locally stored CRL ...\n\n");
				certs = af_pse_get_Certificates(SIGNATURE, NULLDNAME); 
				rcode = af_verify(crlwithcerts->crl->tbs_DERcode, crlwithcerts->crl->sig, SEC_END, certs, (UTCTime * )0, (PKRoot * )0);
				aux_free_Certificates(&certs);
				aux_fprint_VerificationResult(stderr, verifresult);
				aux_free_VerificationResult(&verifresult);
				if (rcode == 0) {
					fprintf(stderr, "Verification of locally stored ");
					fprintf(stderr, "CRL s u c c e e d e d!\n\n");
				}
				else {
					fprintf(stderr, "WARNING: Verification of locally ");
					fprintf(stderr, "stored CRL f a i l e d!\n");
					break;
				}
				crlwithcerts->crl->tbs->lastUpdate = aux_current_UTCTime();
				crlwithcerts->crl->tbs->nextUpdate = (UTCTime *)0;
				crlwithcerts->crl->tbs->nextUpdate = aux_get_nextUpdate(crlwithcerts->crl->tbs->lastUpdate);
				if ((crlwithcerts->crl->tbs_DERcode = e_CRLTBS(crlwithcerts->crl->tbs)) == NULLOCTETSTRING) {
					fprintf(stderr, "Can't encode crlwithcerts->crl->tbs\n");
					break;
				}

				fprintf(stderr, "\nThe following Crl is to be signed. ");
				fprintf(stderr, "Please check it:\n\n");
				aux_fprint_CRLTBS(stderr, crlwithcerts->crl->tbs);
				fprintf(stderr, "\nDo you want to sign the displayed ");
				fprintf(stderr, "revocation list ?\n");
				fprintf(stderr, "If you want to sign it, (re)enter the PIN of your PSE:\n\n");
				af_pse_close(NULLOBJID);
				if ( af_sign(crlwithcerts->crl->tbs_DERcode, crlwithcerts->crl->sig, SEC_END) < 0 ) {
					fprintf(stderr, "Signature of revocation list failed\n");
					break;
				}

				/* Update on Directory entry, PSE, and CA directory: */
#ifdef X500
				if (x500 && af_access_directory == TRUE) {
					fprintf(stderr, "\n**********************************************\n");
					/* update X.500 directory entry */
					fprintf(stderr, "\nTrying to update your X.500 directory entry ...");
					if ( af_dir_enter_CRL(crlwithcerts->crl) < 0 ) 
						fprintf(stderr, "\n Directory entry (X.500) f a i l e d !\n");
					else fprintf(stderr, "\n Done!\n");
					fprintf(stderr, "\n**********************************************\n");
				}
#endif
#ifdef AFDBFILE
				if (af_access_directory == TRUE) {
					fprintf(stderr, "\n**********************************************\n");
					/* update AF-DB directory entry */
					fprintf(stderr, "\nTrying to update your AF-DB directory entry ...");
					if ( af_afdb_enter_CRL(crlwithcerts->crl) < 0 ) 
						fprintf(stderr, "\n Directory entry (AF-DB) f a i l e d !\n");
					else fprintf(stderr, "\n Done!\n");
					fprintf(stderr, "\n**********************************************\n");
				}
#endif

				/* update PSE object CrlSet, even if the directory entry failed */
				crlpse = CRL2Crl (crlwithcerts->crl);
				fprintf(stderr, "\nUpdating PSE object CrlSet ...\n");
				rcode = af_pse_add_CRL(crlpse);
				if (rcode != 0) {
					fprintf(stderr, "\n Cannot update PSE object CrlSet.\n");
					aux_free_Crl (&crlpse);
				}
				else fprintf(stderr, "\n Done!\n");
				aux_free_Crl (&crlpse);
				fprintf(stderr, "\n**********************************************\n");

				/* update 'crlwithcerts' database in CA directory, even if the directory entry failed */
				fprintf(stderr, "\nUpdating 'crlwithcerts' database in CA directory \"%s\" ...\n", cadir);
				if(!(calogfile = aux_get_abs_path(cadir, CALOG))) {
					AUX_ADD_ERROR;
					return(-1);
				}
				logfile = fopen(calogfile, LOGFLAGS);
				free(calogfile);
				if(logfile == (FILE * ) 0) {
					fprintf(stderr, "%s: Can't open %s\n", pgm_name, CALOG);
					break;
				}
				rcode = af_cadb_add_CRLWithCertificates(crlwithcerts, cadir);
				if(rcode != 0){
					fprintf(stderr, "%s: ", cmdname);
					fprintf(stderr, "Cannot store your updated CRL in your 'crlwithcerts' database!\n");
					aux_fprint_error(stderr, verbose);
					aux_free_CRLWithCertificates(&crlwithcerts);
					break;
				}
				fprintf(stderr, "\nMost current version of CRL stored in 'crlwithcerts' database in ");
				fprintf(stderr, "CA directory \"%s\".\n\n", cadir);
				aux_free_CRLWithCertificates(&crlwithcerts);
				fclose(logfile);
				logfile = (FILE * )0;
				break;
			case CASERIALNUMBERS:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				name = gettargetname();
                                if(!name) break;
				isscertset = af_cadb_get_user(name, cadir);
				if(isscertset) {
                                        fprintf(stderr, "Certificates issued for <%s>:\n", name);
                                        aux_fprint_SET_OF_IssuedCertificate(stderr, isscertset);
                                }
                                else fprintf(stderr, "No certificates issued for this user\n");
				break;
			case CASETSERIAL:
				serial = getserial();
				psesel_zw = af_pse_open(SerialNumber_OID, TRUE);
				if(psesel_zw) aux_free_PSESel(&psesel_zw);
				af_pse_update_SerialNumber(serial);
				break;
			case CAUSERS:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				nameset = af_cadb_list_user(cadir);
                                fprintf(stderr, "The following users are registered:\n");
				aux_fprint_SET_OF_Name(stderr, nameset);
				break;
                        case CERT2KEYINFO:
                                if(!(key = build_key("Certificate from ", 0))) {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                ostr = &octetstring;
                                if(sec_read_PSE(key->pse_sel, &object_oid, ostr) < 0)  {
					fprintf(stderr,"Can't read object  %s  from PSE\n", key->pse_sel->object.name);
					aux_free2_ObjId(&object_oid);
					break;
				}
				aux_free2_ObjId(&object_oid);
                                if(!(certificate = d_Certificate(ostr))) {
					fprintf(stderr,"Can't decode Certificate\n");
					free(ostr->octets);
					break;
				}
				free(ostr->octets);
                                if(!(key = build_key("KeyInfo to ", 1)))  {
					fprintf(stderr,"Can't build key\n");
					aux_free_Certificate(&certificate);
					break;
				}
                                keyinfo = aux_cpy_KeyInfo(certificate->tbs->subjectPK);
				aux_free_Certificate(&certificate);
                                if(key->pse_sel) {
                                        if(!(ostr = e_KeyInfo(keyinfo)))  {
						fprintf(stderr,"Can't encode KeyInfo\n");
						aux_free_KeyInfo(&keyinfo);
						break;
					}
					aux_free_KeyInfo(&keyinfo);
					if(onekeypaironly == TRUE){
                                        	if(sec_write_PSE(key->pse_sel, SKnew_OID, ostr) < 0)  {
							fprintf(stderr,"Can't write to PSE\n");
							aux_free_OctetString(&ostr);
							break;
						}
					}
					else{
                                        	if(sec_write_PSE(key->pse_sel, SignSK_OID, ostr) < 0)  {
							fprintf(stderr,"Can't write to PSE\n");
							aux_free_OctetString(&ostr);
							break;
						}
					}
					aux_free_OctetString(&ostr);
                                        fprintf(stderr, "Public Key stored in object %s\n", key->pse_sel->object.name);
                                }
                                else {
                                        keyref = sec_put_key(keyinfo, key->keyref);
                                        fprintf(stderr, "Public Key stored under keyref %d\n", keyref);
					aux_free_KeyInfo(&keyinfo);
                                }
                                break;
                        case CERT2PKROOT:
                                if(!(key = build_key("Certificate from", 0))) {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                ostr = &octetstring;
                                if(sec_read_PSE(key->pse_sel, &object_oid, ostr) < 0)  {
					fprintf(stderr,"Can't read object  %s  from PSE\n", key->pse_sel->object.name);
					break;
				}
                                if(!(certificate = d_Certificate(ostr))) {
					fprintf(stderr,"Can't decode Certificate\n");
					aux_free2_ObjId(&object_oid);
					free(ostr->octets);
					break;
				}
				aux_free2_ObjId(&object_oid);
				free(ostr->octets);
				if(key) aux_free_Key(&key);
                                if(!(key = build_key("PKRoot to", 1)))  {
					fprintf(stderr,"Can't build key\n");
					aux_free_Certificate(&certificate);
					break;
				}
                                keyinfo = aux_cpy_KeyInfo(certificate->tbs->subjectPK);
                                pkroot = (PKRoot *)calloc(1, sizeof(PKRoot));
				if(!pkroot) {
					fprintf(stderr, "Can't allocate memory");
					aux_free_KeyInfo(&keyinfo);
					aux_free_Certificate(&certificate);
	                                break;
				}
                                pkroot->ca = aux_cpy_DName(certificate->tbs->issuer);
                                pkroot->newkey = (struct Serial *)calloc(1, sizeof(struct Serial));
				if(!pkroot->newkey) {
					fprintf(stderr, "Can't allocate memory");
					aux_free_PKRoot(&pkroot);
	                                break;
				}
                                pkroot->newkey->serial = aux_cpy_OctetString(certificate->tbs->serialnumber);
				pkroot->newkey->version = certificate->tbs->version;
				pkroot->newkey->valid = aux_cpy_Validity(certificate->tbs->valid);
                                pkroot->newkey->key = aux_cpy_KeyInfo(keyinfo);

				if (cadir)
					pkroot->newkey->sig = aux_cpy_Signature(certificate->sig);
				else
					pkroot->newkey->sig = (Signature * )0;

				aux_free_KeyInfo(&keyinfo);
				aux_free_Certificate(&certificate);

                                if(key->pse_sel) {
                                        if(!(ostr = e_PKRoot(pkroot)))  {
						fprintf(stderr,"Can't encode PKRoot\n");
						aux_free_PKRoot(&pkroot);
  						break;
					}
					aux_free_PKRoot(&pkroot);
                                        if(sec_write_PSE(key->pse_sel, PKRoot_OID, ostr) < 0)  {
						fprintf(stderr,"Can't write to PSE\n");
						aux_free_OctetString(&ostr);
 						break;
					}
                                        fprintf(stderr, "PKRoot stored in object %s\n", key->pse_sel->object.name);
					aux_free_OctetString(&ostr);
                                }
				if(pkroot) aux_free_PKRoot(&pkroot);
                                break;
			case CHECK:
			case TRUSTPATH:
				privatekey = (Key *)malloc(sizeof(Key));
				if(!privatekey) {
					fprintf(stderr, "Can't malloc memory for privatekey\n");
					break;
				}
				privatekey->key = (KeyInfo *)0;
				privatekey->keyref = 0;
				privatekey->alg = (AlgId *)0;
				privatekey->pse_sel = &std_pse;
				signpk = (KeyInfo *)0;
				encpk = (KeyInfo *)0;
				signsubject = NULLDNAME;
				encsubject = NULLDNAME;

				certs = af_pse_get_Certificates(SIGNATURE, NULLDNAME);
				if(!certs) {
					if(onekeypaironly == TRUE) {
						fprintf(stderr, "Can't read certificate from PSE\n");
						free(privatekey);
						break;
					}
					else {
						fprintf(stderr, "Can't get SIGNATURE certificate from PSE\n");
						goto enccert;
					}
				}
				signpk = aux_cpy_KeyInfo(certs->usercertificate->tbs->subjectPK);
				signsubject = aux_cpy_DName(certs->usercertificate->tbs->subject);
				if(cmd == CHECK) {
					if(onekeypaironly == TRUE)
						fprintf(stderr, "\nVerifying Cert with FCPath and PKRoot ... ");
					else
						fprintf(stderr, "\nVerifying SignCert with FCPath and PKRoot ... ");
				}
				else af_verbose = sec_verbose = FALSE;
                                rcode = af_verify_Certificates(certs, (UTCTime *)0, (PKRoot *)0);
				aux_free_Certificates(&certs);
				if(verbose && cmd == CHECK) aux_fprint_VerificationResult(stderr, verifresult);
				if(cmd == TRUSTPATH) aux_fprint_TrustPath(stderr, verifresult);
				aux_free_VerificationResult(&verifresult);
				if(cmd == CHECK) {
					if(rcode == 0) fprintf(stderr, "O.K.\n");
					else fprintf(stderr, "failed\n");
					if(onekeypaironly == TRUE)
						fprintf(stderr, "\nChecking whether the keys in Cert and SKnew are an RSA or DSA key pair ... ");
					else
						fprintf(stderr, "\nChecking whether the keys in SignCert and SignSK are an RSA or DSA key pair ... ");
				}
				if(onekeypaironly == TRUE)
					std_pse.object.name = aux_cpy_String(SKnew_name);
				else
					std_pse.object.name = aux_cpy_String(SignSK_name);
				rcode = sec_checkSK(privatekey, signpk);
				if(rcode < 0) {
					if(onekeypaironly == TRUE)
						fprintf(stderr, "\nkeys in SKnew and Cert do not fit\n");
					else
						fprintf(stderr, "\nkeys in SignSK and SignCert do not fit\n");
				}
				else if(cmd == CHECK) fprintf(stderr, "O.K.\n");
				if(cmd == TRUSTPATH) {
					if(verbose == 2) af_verbose = TRUE;
					if(verbose == 3) af_verbose = sec_verbose = TRUE;
				}
				if(onekeypaironly == TRUE  || cmd == TRUSTPATH) break;
enccert:
				certs = af_pse_get_Certificates(ENCRYPTION, NULLDNAME);
				if(!certs) {
					fprintf(stderr, "Can't get ENCRYPTION Certificates from PSE (EncCert and/or FCPath missing)\n");
					if(signpk) aux_free_KeyInfo(&signpk);
					if(signsubject) aux_free_DName(&signsubject);
					free(privatekey);
					break;
				}
				encpk = aux_cpy_KeyInfo(certs->usercertificate->tbs->subjectPK);
				encsubject = aux_cpy_DName(certs->usercertificate->tbs->subject);
				if(signsubject) if(aux_cmp_DName(signsubject, encsubject)) {
					fprintf(stderr, "SignCert and EncCert have different subject names\n");
				}
				if(signsubject) aux_free_DName(&signsubject);
				aux_free_DName(&encsubject);
                                if(aux_cmp_DName(certs->usercertificate->tbs->issuer, certs->usercertificate->tbs->subject)) {
					fprintf(stderr, "\nVerifying EncCert with FCPath and PKRoot ... ");
					rcode = af_verify_Certificates(certs, (UTCTime *)0, (PKRoot *)0);
					aux_free_Certificates(&certs);
					if(rcode == 0) fprintf(stderr, "O.K.\n");
					else fprintf(stderr, "failed\n");
				}
				else fprintf(stderr, "\nCan't verify EncCert with FCPath and PKRoot. It seems to be a prototype certificate.\n");
				if(verbose) aux_fprint_VerificationResult(stderr, verifresult);
				aux_free_VerificationResult(&verifresult);
				fprintf(stderr, "\nChecking whether the keys in EncCert and DecSKnew are an RSA key pair ... ");
				std_pse.object.name = aux_cpy_String(DecSKnew_name);
				rcode = sec_checkSK(privatekey, encpk);
				if(rcode < 0) fprintf(stderr, "\nRSA keys in DecSKnew and EncCert do not fit\n");
				else fprintf(stderr, "O.K.\n");
				aux_free_KeyInfo(&signpk);
				aux_free_KeyInfo(&encpk);
				free(privatekey);
				break;

                        case CHPIN:
#ifdef SCA
				if ((pse_location = sec_psetest(std_pse.app_name)) == ERR_in_psetest) {
					fprintf(stderr, "Error during test for pse: %s\n", std_pse.app_name);
					break;
				}
				if (pse_location == SWpse) new_pin();
#else
				new_pin();
#endif
				std_pse.object.name = CNULL;
				/* Re-encrypt PSE-toc and all PSE-objects */
				rcode = sec_chpin(&std_pse, newpin);

				/* Free obsolete pins */
				if(AF_pse.pin) strzfree(&(AF_pse.pin));
				for (i = 0; i < PSE_MAXOBJ; i++){
					if(AF_pse.object[i].pin) strzfree(&(AF_pse.object[i].pin));
				}

				/* Assign new pin-values to AF_pse */

				AF_pse.pin = aux_cpy_String(newpin);
                                break;

                        case CLOSE:	/* whole PSE to be closed */
                                if (psesel(1) < 0)  {
/*                                        fprintf(stderr, "psesel failed \n"); */
                                        break;
                                }
close:

				if(af_pse_close (NULLOBJID) == 0) ack(&std_pse, "closed");
				else fprintf(stderr, "No PSE open\n");
				AF_pse.app_name = CNULL;
				if(std_pse.app_name) {
					free (std_pse.app_name);
					std_pse.app_name = CNULL;
				}
				if(std_pse.pin) strzfree (&(std_pse.pin));
				std_pse.app_id = 0;
				if ( std_pse.object.name ) {
					free (std_pse.object.name);
					std_pse.object.name = CNULL;
				}
				if(std_pse.object.pin) strzfree (&(std_pse.object.pin));
                                break;
                        case CREATE:
                                if(interactive == TRUE) psesel(1);
                                if(!(rcode = sec_create(&std_pse))) {
                                        ack(&std_pse, "created");
                                        AF_pse.app_name = std_pse.app_name;
                                        AF_pse.pin = std_pse.pin;
                                        AF_pse.app_id = std_pse.app_id;
                                        if (std_pse.object.name) {
                                                for (i = 0; i < PSE_MAXOBJ; i++) 
							if (strcmp(AF_pse.object[i].name, std_pse.object.name) == 0) {
								if(std_pse.object.pin) {
									AF_pse.object[i].pin = (char *) malloc (strlen(std_pse.object.pin) + 1);
									if ( !AF_pse.object[i].pin ) {
										fprintf(stderr, "Can't allocate memory\n");
										break;
									}
									strcpy (AF_pse.object[i].pin, std_pse.object.pin);
								}
								else AF_pse.object[i].pin = (char *)0;
                                                        	break;
                                                        }  
                                        }
                                } 
				else {
					fprintf(stderr, "Can't create object\n");
                                        break;
                                }

                                break;
			case DELALIAS:
				alias = getalias(CNULL, TRUE);
				if(!alias){
					fprintf(stderr, "No alias name specified!\n");
					break;
				}
				aliasfile = getaliasfile();
				if(aliasfile == notstored) {
					fprintf(stderr, "AliasFile missing for alias %s\n", alias);
					break;
				}
				if(aux_delete_alias(alias, aliasfile, TRUE) < 0) {
					fprintf(stderr, "Could not remove alias %s\n", alias);
					aux_fprint_error(stderr, verbose);
					break;
				}
				break;
			case DELGROUPALIAS:
				name = gettargetname();
				if(name) dname = aux_Name2DName(name);
				else dname = (DName *)0;

				alias = getalias(CNULL, TRUE);
				if(!alias){
					fprintf(stderr, "No alias name specified!\n");
					break;
				}
				aliasfile = getaliasfile();
				if(aliasfile == notstored) {
					fprintf(stderr, "AliasFile missing for alias %s\n", alias);
					break;
				}
				if(aux_delete_group_alias(alias, dname, aliasfile, TRUE) < 0) {
					fprintf(stderr, "Could not remove alias %s\n", alias);
					aux_fprint_error(stderr, verbose);
					break;
				}
				break;
			case DELEK:
				subject_dn = getdname("Owner");
				if(! subject_dn){
					issuer_dn = getdname("Issuer");
					if(! issuer_dn){
						fprintf(stderr, "Neither Owner nor Issuer has been specified!\n");
						break;
					}
					if ((serial = getserial()) == NULLOCTETSTRING) {
						fprintf(stderr, "No serial number specified!\n");
						break;
					}
				}
				if(subject_dn){
					subject = aux_DName2Name(subject_dn);
					if(! subject){
						fprintf(stderr, "Cannot transform DName-structure into Name!\n");
						break;
					}
					rcode = af_pse_delete_PK(ENCRYPTION, subject_dn, NULLDNAME, 0);
				}
				else{
					issuer = aux_DName2Name(issuer_dn);
					if(! issuer){
						fprintf(stderr, "Cannot transform DName-structure into Name!\n");
						break;
					}
					rcode = af_pse_delete_PK(ENCRYPTION, NULLDNAME, issuer_dn, serial);
				}
				if ( rcode < 0 ) {
					if (err_stack && (err_stack->e_number == EOBJNAME)) {
		        			fprintf(stderr, "\nThere is no ToBeSigned with\n");
						if (issuer_dn && serial) {
		        				fprintf(stderr, " issuer \"%s\"\n and serial number ", issuer);
							aux_fprint_Serialnumber(stderr, serial);
						}
						else
			        			fprintf(stderr, " owner \"%s\"\n", subject);

						fprintf(stderr, "stored in your EKList. No update done!\n");
					}
				}
				else {
					fprintf(stderr, "\nToBeSigned with\n");
					if (issuer_dn && serial) {
		        			fprintf(stderr, " issuer \"%s\"\n and serial number ", issuer);
		       				aux_fprint_Serialnumber(stderr, serial);
					}
					else
						fprintf(stderr, " owner \"%s\"\n", subject);

					fprintf(stderr, "removed from your EKList.\n");

					fprintf(stderr, "\nYour updated EKList now looks like this:\n\n");
					pklist = af_pse_get_PKList(ENCRYPTION);
					if ( !pklist )
						fprintf(stderr, "Your EKList is EMPTY!\n");
					else {
						fprintf(stderr, " ****************** EKList ******************\n");
						aux_fprint_PKList (stderr, pklist);
						aux_free_PKList(& pklist);				
					}
				}
				if(subject_dn) aux_free_DName(& subject_dn);
				if(issuer_dn) aux_free_DName(& issuer_dn);
				if(subject) free(subject);
				if(issuer) free(issuer);
				break;
                        case DELETE:
                                psesel(1);
                                if(!std_pse.object.name || !strlen(std_pse.object.name)) {
                                        sprintf(prompt, "Do you really want to delete %s ? [yes/no]: ", std_pse.app_name);
                                        if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
					else strcpy(answ, "yes");
                                        if(strcmp(answ, "yes")) {
                                                fprintf(stderr, "%s not deleted\n", std_pse.app_name);
                                                break;
                                        }
                                }
                                if(!(rcode = sec_delete(&std_pse))) {
					ack(&std_pse, "deleted");
					if(std_pse.object.name && strlen(std_pse.object.name) && !strcmp(std_pse.object.name, "AliasList"))
						retvalue = aux_get_AliasList();
				}
                                else ack(&std_pse, "does not exist");
                                break;
                        case DELKEY:
                                if(!(key = build_key("", 1)))  {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                if(!(rcode = sec_del_key(key->keyref))) {
					outtext = "";
#ifdef SCA
					if ((key->keyref & SC_KEY) == SC_KEY) {
						key->keyref =  key->keyref & ~SC_KEY;
						outtext = "in the smartcard";
						
					} 
					else if ((key->keyref & SCT_KEY) == SCT_KEY) {
						outtext = "in the SCT";
						key->keyref = key->keyref & ~SCT_KEY;
					}
					
#endif
					fprintf(stderr, "Key %s under keyref %d deleted\n", outtext, key->keyref);
				}
				else {
					aux_fprint_error(stderr, verbose);
				}

                                break;
			case DELPCA:
				subject_dn = getdname("PCA DName");
				if(! subject_dn){
					fprintf(stderr, "PCA DName has not been specified!\n");
					break;
				}
				subject = aux_DName2Name(subject_dn);
				if(! subject){
					fprintf(stderr, "Cannot transform DName-structure into Name!\n");
					break;
				}
				rcode = af_pse_delete_PCA(subject_dn);
				if ( rcode < 0 ) {
					if (err_stack && (err_stack->e_number == EOBJNAME)) {
			        		fprintf(stderr, "\nThere is no PCA with DName \"%s\"\n", subject);

						fprintf(stderr, "stored in your PCAList. No update done!\n");
					}
				}
				else {
					fprintf(stderr, "\nPCA with DName \"%s\"\n", subject);
					fprintf(stderr, "removed from your PCAList.\n");
					fprintf(stderr, "\nYour updated PCAList now looks like this:\n\n");
					pklist = af_pse_get_PCAList();
					if ( !pklist )
						fprintf(stderr, "Your PCAList is EMPTY!\n");
					else {
						fprintf(stderr, " ****************** PCAList ******************\n");
						aux_fprint_PKList(stderr, pklist);
						aux_free_PKList(& pklist);				
					}
				}
				if(subject_dn) aux_free_DName(&subject_dn);
				if(subject) free(subject);
				break;
 			case DELCRL:
 				issuer_dn = getdname("Issuer");
 				if(! issuer_dn){
 					fprintf(stderr, "No issuer specified!\n");
 					break;
 				}
 				issuer = aux_DName2Name(issuer_dn);
 				if(! issuer){
 					fprintf(stderr, "Cannot transform DName-structure into Name!\n");
 					break;
 				}
 				rcode = af_pse_delete_CRL(issuer_dn);
 				if ( rcode < 0 ) {
 					if (err_stack && (err_stack->e_number == EOBJNAME)) {
 		        			fprintf(stderr, "\nThere is no revocation list with ");
 		        			fprintf(stderr, "issuer \"%s\"\n", issuer);
 						fprintf(stderr, "stored in your PSE. No update done!\n");
 					}
 				}
 				else {
 					fprintf(stderr, "\nRevocation list issued by \"%s\" ", issuer);
 					fprintf(stderr, "removed from your PSE.\n\n");
 
 					fprintf(stderr, "Your updated set of locally stored revocation lists "); 
 					fprintf(stderr, "now looks like this:\n\n");
 					crlset = af_pse_get_CrlSet();
 					if (! crlset )
 						fprintf(stderr, "            E  M  P  T  Y  !\n\n");
 					else {
 						fprintf(stderr, " ****************** Set of Locally Stored Revocation Lists ******************\n");
 						aux_fprint_CrlSet (stderr, crlset);
 						aux_free_CrlSet(&crlset);				
 					}
 				}
 				if(issuer_dn) aux_free_DName(& issuer_dn);
 				if(issuer) free(issuer);
 				break;
			case DELPK:
				subject_dn = getdname("Owner");
				if(! subject_dn){
					issuer_dn = getdname("Issuer");
					if(! issuer_dn){
						fprintf(stderr, "Neither Owner nor Issuer has been specified!\n");
						break;
					}
					if ((serial = getserial()) == NULLOCTETSTRING) {
						fprintf(stderr, "No serial number specified!\n");
						break;
					}
				}
				if(subject_dn){
					subject = aux_DName2Name(subject_dn);
					if(! subject){
						fprintf(stderr, "Cannot transform DName-structure into Name!\n");
						break;
					}
					rcode = af_pse_delete_PK(SIGNATURE, subject_dn, NULLDNAME, 0);
				}
				else{
					issuer = aux_DName2Name(issuer_dn);
					if(! issuer){
						fprintf(stderr, "Cannot transform DName-structure into Name!\n");
						break;
					}
					rcode = af_pse_delete_PK(SIGNATURE, NULLDNAME, issuer_dn, serial);
				}
				if ( rcode < 0 ) {
					if (err_stack && (err_stack->e_number == EOBJNAME)) {
		        			fprintf(stderr, "\nThere is no ToBeSigned with\n");
						if (issuer_dn && serial) {
		        				fprintf(stderr, " issuer \"%s\"\n and serial number ", issuer);
		       					aux_fprint_Serialnumber(stderr, serial);
						}
						else
			        			fprintf(stderr, " owner \"%s\"\n", subject);

						fprintf(stderr, "stored in your PKList. No update done!\n");
					}
				}
				else {
					fprintf(stderr, "\nToBeSigned with\n");
					if (issuer_dn && serial) {
		        			fprintf(stderr, " issuer \"%s\"\n and serial number ", issuer);
		       				aux_fprint_Serialnumber(stderr, serial);
					}
					else
						fprintf(stderr, " owner \"%s\"\n", subject);

					fprintf(stderr, "removed from your PKList.\n");

					fprintf(stderr, "\nYour updated PKList now looks like this:\n\n");
					pklist = af_pse_get_PKList(SIGNATURE);
					if ( !pklist )
						fprintf(stderr, "Your PKList is EMPTY!\n");
					else {
						fprintf(stderr, " ****************** PKList ******************\n");
						aux_fprint_PKList(stderr, pklist);
						aux_free_PKList(& pklist);				
					}
				}
				if(subject_dn) aux_free_DName(&subject_dn);
				if(issuer_dn) aux_free_DName(&issuer_dn);
				if(subject) free(subject);
				if(issuer) free(issuer);
				break;
                        case DH1:
                                if(!(cc = nxtpar(CNULL))) {
                                        sprintf(prompt, "Use DH Parameter of default PSE object, peers public value or create temporary one? (d,p,t): ");
                                        if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
					else strcpy(answ, "default");
				}
				if(!strncasecmp(answ, "default", strlen(answ))) {
					dh_with_pg = DH_ALG_WITHOUT_PARAM;
				    	if(!(cc = nxtpar(""))) {
					    sprintf(prompt, "Use dhWithCommonModulus OID (without DH parameters)? (y/n): ");
					    if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
					    else strcpy(answ, "yes");
					    if(!strcasecmp(answ, "no")) dh_with_pg = DH_ALG_WITH_PARAM;
					    if(!strcasecmp(answ, "n")) dh_with_pg = DH_ALG_WITH_PARAM;
				   	}
				    	else if(strcasecmp(cc, "common")) dh_with_pg = DH_ALG_WITH_PARAM;

					if(!(dh_parm = af_pse_get_DHparam())) {
						fprintf(stderr,"There is no DH Parameter object on PSE, use dhinit before\n");
						break;
					}

				}
				else if(!strncasecmp(answ, "peer", strlen(answ))) {
					dh_with_pg = DH_ALG_WITH_PARAM;

					filen("File with peer's public DH key y: ");
					if(!(dh_peer_public_y_encoded = aux_file2OctetString(filename))) {
						fprintf(stderr,"Can't read file %s\n", filename);
						break;
					}
					if(!(dh_peer_public_y = d_KeyInfo(dh_peer_public_y_encoded))) {
						aux_free_OctetString(&dh_peer_public_y_encoded);
						fprintf(stderr,"Can't decode file %s\n", filename);
						break;
					}
					aux_free_OctetString(&dh_peer_public_y_encoded);
				
					if(!(dh_parm = dh_peer_public_y->subjectAI)) {
						aux_free_KeyInfo(&dh_peer_public_y);
						fprintf(stderr,"There is no DH Parameter added to peers key\n");
						break;
					}

					if(dh_peer_public_y->subjectkey.nbits) free(dh_peer_public_y->subjectkey.bits);
					free(dh_peer_public_y);
				}
				else if(!strncasecmp(answ, "temporary", strlen(answ))) {
					dh_with_pg = DH_ALG_WITH_PARAM;
					dh_keysize = getsize("Length of prime modulus p in bits");
					dh_privatevalue = getsize("Length of private values x in bits");
	    
					if(!dh_keysize) dh_keysize = 512;
	    
					fprintf(stderr, "Generating prime p and base g ...\n");
					if(!(dh_parm = dh_init((dh_keysize + 7) / 8, dh_privatevalue))) {
						aux_fprint_error(stderr, verbose);
						fprintf(stderr,"Generating a DH Parameter failed\n");
						break;
					}
				}
				else break;

                                if(!(dh_private = build_key("private DH ", 1))) break;
                                filen("File for own public DH key y: ");

				if(!(dh_own_public_y = dh_phase1(dh_parm, &dh_private_keyinfo, dh_with_pg))) {
					aux_fprint_error(stderr, verbose);
					fprintf(stderr,"Phase 1 failed\n");
					aux_free_AlgId(&dh_parm);
					aux_free_Key(&dh_private);
					break;
				}
				/* store the keyinfo for X */
				if(put_keyinfo_according_to_key(dh_private_keyinfo, dh_private, DHprivate_OID) < 0) {
					aux_fprint_error(stderr, verbose);
					fprintf(stderr,"Phase 1 failed\n");
					aux_free_KeyInfo(&dh_private_keyinfo);
					break;
				}
				bzero(dh_private_keyinfo->subjectkey.bits, dh_private_keyinfo->subjectkey.nbits / 8);
			
				aux_free_KeyInfo(&dh_private_keyinfo);
				aux_free_Key(&dh_private);
				aux_free_AlgId(&dh_parm);
				if(!(dh_own_public_y_encoded = e_KeyInfo(dh_own_public_y))) {
					fprintf(stderr,"Encoding of public keyinfo failed\n");
					aux_free_KeyInfo(&dh_own_public_y);
					break;
				}
				aux_free_KeyInfo(&dh_own_public_y);
				if(aux_OctetString2file(dh_own_public_y_encoded, filename, 2) < 0) {
					fprintf(stderr,"Can't write DH public key y to file %s\n", filename);
							aux_free_OctetString(&dh_own_public_y_encoded);
					break;
				}
				aux_free_OctetString(&dh_own_public_y_encoded);
                                break;
                        case DH2:
                                if(!(dh_private = build_key("private DH ", 0))) break;
                                filen("File of peer's public DH key y: ");
                                psesel(2);

				if(!(dh_peer_public_y_encoded = aux_file2OctetString(filename))) {
					fprintf(stderr,"Can't read DH public key y from file %s\n", filename);
					aux_free_Key(&dh_private);
					break;
				}
				if(!(dh_peer_public_y = d_KeyInfo(dh_peer_public_y_encoded))) {
					fprintf(stderr,"Can't decode DH public key y %s\n", filename);
					aux_free_OctetString(&dh_peer_public_y_encoded);
					break;
				}
				
				aux_free_OctetString(&dh_peer_public_y_encoded);

				if(!(dh_parm = af_pse_get_DHparam())) {
					fprintf(stderr,"Can't read DH parameters (PSE object DHparam)\n");
					aux_free_Key(&dh_private);
					aux_free_KeyInfo(&dh_peer_public_y);
					break;
				}

				/* get keyinfo for X from PSE, keypool or memory */
				if(!(dh_private_keyinfo = get_keyinfo_from_key(dh_private))) {
					aux_fprint_error(stderr, verbose);
					fprintf(stderr,"DH phase 2 failed\n");
					aux_free_Key(&dh_private);
					aux_free_KeyInfo(&dh_private_keyinfo);
					break;
				}
				if(!(dh_agreed_key = dh_phase2(dh_parm, dh_private_keyinfo, dh_peer_public_y))) {
					aux_fprint_error(stderr, verbose);
					fprintf(stderr,"DH phase 2 failed\n");
					aux_free_AlgId(&dh_parm);
					aux_free_Key(&dh_private);
					aux_free_KeyInfo(&dh_peer_public_y);
					break;
				}

				aux_free_AlgId(&dh_parm);
				aux_free_Key(&dh_private);
				aux_free_KeyInfo(&dh_peer_public_y);

                                if(sec_open(&std_pse) < 0) 
					if(sec_create(&std_pse) < 0) {
						fprintf(stderr,"Can't create object on PSE\n");
						aux_free_BitString(&dh_agreed_key);
						break;
					}


	                        dh_agreed_key_oid = aux_cpy_ObjId(DHkey_OID);

				ostr = e_BitString(dh_agreed_key);

				if(sec_write_PSE(&std_pse, dh_agreed_key_oid, ostr) < 0) {
					fprintf(stderr,"Can't write agreed key to PSE\n");
					aux_free_BitString(&dh_agreed_key);
					aux_free_ObjId(&dh_agreed_key_oid);
					aux_free_OctetString(&ostr);
					break;
				}
				aux_free_BitString(&dh_agreed_key);
				aux_free_ObjId(&dh_agreed_key_oid);
				aux_free_OctetString(&ostr);
                                break;
                        case DHINIT:
				if((algid = af_pse_get_DHparam())) {
					sprintf(prompt, "DHparam exists already. Overwrite? (y/n): ");
					if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
					else strcpy(answ, "yes");
					if(*answ != 'y') break;
				}
				dh_keysize = getsize("Length of prime modulus p in bits");
				dh_privatevalue = getsize("Length of private values x in bits");

				if(!dh_keysize) dh_keysize = 512;
			
				fprintf(stderr, "Generating prime p and base g ...\n");

				if(!(dh_parm = dh_init(dh_keysize, dh_privatevalue))) {
					fprintf(stderr,"Generating DH Parameter failed\n");
					break;
				}
				if(af_pse_update_DHparam(dh_parm) < 0) {
					fprintf(stderr,"Can't write DH Parameter to PSE object %s\n", DHparam_name);
					aux_free_AlgId(&dh_parm);
					break;
				}

				aux_free_AlgId(&dh_parm);
                                break;
                        case DHMAKEENCRYPTIONKEY:
                                psesel(2);
                                strrep(&algname, getalgname());
				if(!(key = build_key("generated encryption ", 1))) break;
				key->alg = aux_Name2AlgId(algname);	
		
                                if(sec_open(&std_pse) < 0) {
					fprintf(stderr,"Can't open agreed key.\n");
					break;
				}
				ostr = &octetstring;
				if(sec_read_PSE(&std_pse, &object_oid, ostr) < 0) {
					fprintf(stderr,"Can't read object  %s  from PSE\n", std_pse.object.name);
					break;
				}
                                if(aux_cmp_ObjId(&object_oid, DHkey_OID)) { 
					fprintf(stderr,"Object is not an agreed DH key.\n");
					break;
				}
				dh_agreed_key = d_BitString(ostr);
				keyinfo = aux_BitString2EncryptionKey(key->alg, dh_agreed_key);

				free(dh_agreed_key);

				if(put_keyinfo_according_to_key(keyinfo, key, KeyInfo_OID) < 0) {
					aux_fprint_error(stderr, verbose);
					fprintf(stderr,"Writing keyinfo failed\n");
					aux_free_KeyInfo(&keyinfo);
					break;
				}
				bzero(keyinfo->subjectkey.bits, keyinfo->subjectkey.nbits / 8);
				aux_free_KeyInfo(&keyinfo);
			
                                break;

                        case DNAME2ALIAS:
                                name = (Name *)nxtpar("pattern");
                                aux_fprint_dname2alias(stderr, (char *)name);
				if(name) free(name);
                                break;
#ifdef SCA
                        case EJECT:
                                sec_sc_eject(ALL_SCTS);
				if (!AF_pse.app_name)
					break;
				if ((pse_location = sec_psetest(AF_pse.app_name)) == ERR_in_psetest) {
					fprintf(stderr, "Error during test for pse: %s\n", AF_pse.app_name);
					break;
				}
				if (pse_location == SCpse) {
					/* application is not longer open */
					af_pse_close (NULLOBJID);
					AF_pse.app_name = CNULL;
					if(std_pse.app_name) {
						free (std_pse.app_name);
						std_pse.app_name = CNULL;
					}
					if(std_pse.pin) strzfree (&(std_pse.pin));
					std_pse.app_id = 0;
					if ( std_pse.object.name ) {
						free (std_pse.object.name);
						std_pse.object.name = CNULL;
					}
					if(std_pse.object.pin) strzfree (&(std_pse.object.pin));
				}
                                break;
#endif
			case ENTER:
				if (af_access_directory == FALSE) {
					fprintf(stderr, "af_access_directory is set to FALSE!\n");
					fprintf(stderr, "If you want to access the Directory, you should invoke ");
					fprintf(stderr, "the 'psemaint' command with the -D option.\n");
					break;
				}
				if(!af_x500 && !af_afdb){
					fprintf(stderr, "No directory flags (AFDBFILE or X500) have been compiled.\n");
					fprintf(stderr, "Therfore, no directory access is provided.\n");
					break;
				}
				attrtype = getattrtype(x500);
				if (!strncasecmp(attrtype, "Certificate", 2) || !strncasecmp(attrtype, "UserCertificate", 1) || !strncasecmp(attrtype, "CACertificate", 2)){
#ifdef X500
					if (x500) {
						if(!strncasecmp(attrtype, "UserCertificate", 1)) 
							certtype = userCertificate;
                                       	        else certtype = cACertificate;
					}
#endif
#ifdef AFDBFILE
					if(onekeypaironly == TRUE){
						std_pse.object.name = aux_cpy_String(Cert_name);
						ktype = SIGNATURE;  /* ktype is not relevant in this case, but should have an acceptable value */
					}
					else{
                                        	keytype();
                                        	if(*objtype == 'S') {
							std_pse.object.name = aux_cpy_String(SignCert_name);
							ktype = SIGNATURE;
						}
                                        	else if(*objtype == 'E') {
							std_pse.object.name = aux_cpy_String(EncCert_name);
							ktype = ENCRYPTION;
						}
                                        	else {
                                                	fprintf(stderr, "Type must be either 'S' or 'E'\n");
                                                	break;
                                        	}
					}
#endif
					fprintf(stderr, "\nEnter name of PSE object which contains ");
					fprintf(stderr, "certificate\n");
					fprintf(stderr, " to be entered into the directory:\n");
					i = psesel(2);
                               		if(i < 0)  {
						fprintf(stderr,"psesel failed\n");
						break;
					}
					ostr = &octetstring;
                                	if(sec_read_PSE(&std_pse, &object_oid, ostr) < 0)  {
						fprintf(stderr,"Can't read object  %s  from PSE\n", std_pse.object.name);
						break;
					}
					store_objpin();
                                	if(! aux_cmp_ObjId(&object_oid, SignCert_OID) || ! aux_cmp_ObjId(&object_oid, EncCert_OID) || ! aux_cmp_ObjId(&object_oid, Cert_OID)) { 
						if(!(certificate = d_Certificate(ostr))) {
                                        		fprintf(stderr, "Can't decode %s\n", std_pse.object.name);
                                        		free(ostr->octets);
 							aux_free2_ObjId(&object_oid);
                                      			break;
					        }
					aux_free2_ObjId(&object_oid);
					free(ostr->octets);	
                                        }
				}
				else if (!strncasecmp(attrtype,"CrossCertificatePair", 2)) {
					if(!cadir) {
						fprintf(stderr, "%s: CrossCertificatePairs are for CAs only\n", pgm_name);
						break;
					}	
					cpair = compose_CertificatePair();
					if (!cpair) {
						fprintf(stderr, "%s: No CrossCertificatePair specified\n", pgm_name);
						break;
					}
				}
				else {
					if(!cadir) {
						fprintf(stderr, "%s: Revocation lists are for CAs only\n", pgm_name);
						break;
					}
					dname = af_pse_get_Name();
					name = aux_DName2Name(dname);
					aux_free_DName(&dname);
					crlwithcerts = af_cadb_get_CRLWithCertificates(name, cadir);
					if(! crlwithcerts || ! crlwithcerts->crl){
						fprintf(stderr, "WARNING: Your own CRL is NOT stored in your local database!\n");
						break;
					}
					fprintf(stderr, "\nThis is your locally stored revocation list:\n\n");
					aux_fprint_CRL(stderr, crlwithcerts->crl);
					fprintf(stderr, "\n\nVerifying your locally stored CRL ...\n\n");
					certs = af_pse_get_Certificates(SIGNATURE, NULLDNAME); 
					rcode = af_verify(crlwithcerts->crl->tbs_DERcode, crlwithcerts->crl->sig, SEC_END, certs, (UTCTime * )0, (PKRoot * )0);
					aux_free_Certificates(&certs);
					aux_fprint_VerificationResult(stderr, verifresult);
					aux_free_VerificationResult(&verifresult);
					if (rcode == 0) {
						fprintf(stderr, "Verification of locally stored ");
						fprintf(stderr, "CRL s u c c e e d e d!\n\n");
					}
					else {
						fprintf(stderr, "WARNING: Verification of locally ");
						fprintf(stderr, "stored CRL f a i l e d!\n");
						break;
					}
				}
				if (!strncasecmp(attrtype, "Certificate", 2) || !strncasecmp(attrtype, "UserCertificate", 1) || !strncasecmp(attrtype, "CACertificate", 2)) {
#ifdef X500
					if ( x500 ) {
						fprintf(stderr, "\nAccessing your X.500 directory entry ...\n\n");
						if ( af_dir_enter_Certificate(certificate, certtype) == 0 )
							fprintf(stderr, "Directory entry (X.500) succeeded.\n");
                               			else fprintf(stderr, "Directory entry (X.500) f a i l e d.\n");
					}
#endif
#ifdef AFDBFILE
					fprintf(stderr, "\nAccessing your AF-DB directory entry ...\n\n");
					if ( af_afdb_enter_Certificate(certificate, ktype) == 0 )
						fprintf(stderr, "Directory entry (AF-DB) succeeded.\n");
                               		else fprintf(stderr, "Directory entry (AF-DB) f a i l e d.\n");
#endif
					aux_free_Certificate(&certificate);
				}
				else if (!strncasecmp(attrtype,"CrossCertificatePair", 2)) {
#ifdef X500
					if ( x500 ) {
						fprintf(stderr, "\nAccessing your X.500 directory entry ...\n\n");
						if ( af_dir_enter_CertificatePair(cpair) == 0 )
							fprintf(stderr, "Directory entry (X.500) succeeded.\n");
                               			else fprintf(stderr, "Directory entry (X.500) f a i l e d.\n");
					}
#endif
#ifdef AFDBFILE
					own_dname = af_pse_get_Name();
					fprintf(stderr, "\nAccessing your AF-DB directory entry ...\n\n");
					if ( af_afdb_enter_CertificatePair(cpair) == 0 )
						fprintf(stderr, "Directory entry (AF-DB) succeeded.\n");
                               		else fprintf(stderr, "Directory entry (AF-DB) f a i l e d.\n");
#endif
					aux_free_CertificatePair(&cpair);
				}
				else {   /* attrtype = CertificateRevocationList */
#ifdef X500
					if ( x500 ) {
						fprintf(stderr, "\nAccessing your X.500 directory entry ...\n\n");
						if ( af_dir_enter_CRL(crlwithcerts->crl) == 0 )
							fprintf(stderr, "Directory entry (X.500) succeeded.\n");
                               			else fprintf(stderr, "Directory entry (X.500) f a i l e d.\n");
					}
#endif
#ifdef AFDBFILE
					fprintf(stderr, "\nAccessing your AF-DB directory entry ...\n\n");
					if ( af_afdb_enter_CRL(crlwithcerts->crl) == 0 )
						fprintf(stderr, "Directory entry (AF-DB) succeeded.\n");
                               		else fprintf(stderr, "Directory entry (AF-DB) f a i l e d.\n");
#endif
					aux_free_CRLWithCertificates(&crlwithcerts);
				}
                                break;
                        case EXIT:
                        case ENDE:
                        case QUIT:
                                exit(0);
                        case GENKEY:
                                replace = FALSE;
                                strrep(&algname, getalgname());
                                algenc = aux_Name2AlgEnc(algname);
                                if(algenc == DES || algenc == DES3) {
					if(!(privatekey = build_key("generated DES ", 1))) break;
				}
                                else {
					publickey = (Key *)0;
					privatekey = (Key *)0;
                                        if(!(publickey = build_key("generated public ", 1))) break;
                                        if(!(privatekey = build_key("generated private ", 1))) break;
                                }
                                time(&atime);

				sec_gen_verbose = TRUE;
                                if(algenc == DSA && aux_Name2ParmType(algname) == PARM_NULL) {
					privatekey->alg = af_pse_get_DSAcommon();
					if(!privatekey->alg) {
 		                        	fprintf(stderr, "Creating PSE object for DSA common integers\n");
						privatekey->alg = aux_cpy_AlgId(dsa);
						privatekey->alg->param = (char *)dsa_gen_common(sec_dsa_keysize);
						af_pse_update_DSAcommon(privatekey->alg);
					}
				}

                                if((rcode = sec_gen_key(privatekey, replace)) < 0)  {
					aux_fprint_error(stderr, 2);
					break;
				}

                                etime = time((time_t *)0) - atime;
                                if(algenc == RSA || algenc == DSA) fprintf(stderr, "Privat Key stored ");
                                else if(algenc == IDEA) fprintf(stderr, "IDEA Key stored ");
                                else fprintf(stderr, "DES Key stored ");
                                if (privatekey->pse_sel) 
					fprintf(stderr, " in object %s\n", privatekey->pse_sel->object.name);
                                else {
					outtext = "";

#ifdef SCA
					if ((privatekey->keyref & SC_KEY) == SC_KEY) {
						privatekey->keyref =  privatekey->keyref & ~SC_KEY;
						outtext = "in the smartcard ";
						
					} 
					else if ((privatekey->keyref & SCT_KEY) == SCT_KEY) {
						outtext = "in the SCT ";
						privatekey->keyref = privatekey->keyref & ~SCT_KEY;
					}
					
#endif
					fprintf(stderr, "%sunder keyref %d \n", outtext, privatekey->keyref);

				}
                                if(algenc == RSA || algenc == DSA) {
					if(algenc == RSA) oid = RSA_PK_OID;
					else oid = DSA_PK_OID;
                                        /* store public key */
                                        if(publickey->pse_sel) {
                                                if(!(ostr = e_KeyInfo(privatekey->key)))  {
							fprintf(stderr,"Can't encode KeyInfo\n");
							aux_free_Key(&privatekey);
							aux_free_Key(&publickey);
							break;
						}
						aux_free_Key(&privatekey);
                                                if(sec_write_PSE(publickey->pse_sel, oid, ostr) < 0)  {
                                                        fprintf(stderr, "sec_write failed\n");
							aux_free_OctetString(&ostr);
							aux_free_Key(&publickey);
                                                        break;
                                                }
						aux_free_OctetString(&ostr);
                                                fprintf(stderr, "Public Key stored in object %s\n", publickey->pse_sel->object.name);
                                        }
                                        else {
                                                keyref = sec_put_key(privatekey->key, publickey->keyref);
                                                fprintf(stderr, "Public Key stored under keyref %d\n", keyref);
						aux_free_Key(&privatekey);
                                        }
					aux_free_Key(&publickey);
                                }
                                fprintf(stderr, "Time for key generation: %ld sec\n", etime);
                                break;
                        case HELPCMD:
                        case QM:
                                helpcmd();
                                break;
                                
                        case KEYTOC:
                                rcode = sec_print_toc(stderr, (PSESel *)0);
				if(rcode < 0) fprintf(stderr, "Can't read TOC of key_pool\n");
                                break;
			case MFLIST:
				MF_fprint(stderr);
				break;
                        case OPEN:
                                if (psesel(1) < 0)  {
/*                                        fprintf(stderr, "psesel failed \n"); */
                                        break;
                                }

                                AF_pse.app_id = std_pse.app_id;
				strrep(&(AF_pse.app_name), std_pse.app_name);
				if(AF_pse.pin) strzfree(&(AF_pse.pin));
                                if(std_pse.pin) strzfree(&(std_pse.pin));

                                pse_sel = af_pse_open((ObjId *)0, FALSE);
				if ( ! pse_sel ) {
                                	fprintf(stderr, "Can't open PSE %s\n", AF_pse.app_name);
					goto close;
                                	break;
                                }
				if(af_check_if_onekeypaironly(&onekeypaironly)){
					aux_fprint_error(stderr, verbose);
					break;
				}
				ack(pse_sel, "opened");
				aux_free_PSESel(& pse_sel);
				strrep(&(std_pse.pin), AF_pse.pin);

				if(AF_pse.pin) {
					for(i = 0; i < PSE_MAXOBJ; i++) {
						strrep(&(AF_pse.object[i].pin), AF_pse.pin);
						if(!AF_pse.object[i].pin) {
							fprintf(stderr, "Can't allocate memory\n");
							exit(1);
						}
					}
				}
				else {
					for (i = 0; i < PSE_MAXOBJ; i++) 
						if(AF_pse.object[i].pin) strzfree(&(AF_pse.object[i].pin)); 
				}
                                break;
                        case OWNER:
				certificate = af_pse_get_Certificate(SIGNATURE, NULLDNAME, 0);
				if(!certificate){
					fprintf(stderr, "Can't read own certificate from PSE\n");
					break;
				}
				name = aux_DName2Name(certificate->tbs->subject);
				if(!name){
					fprintf(stderr, "Cannot transform DName into printable representation\n");
					break;
				}
				fprintf(stderr, "PSE Owner:  %s\n", name);
				aux_free_Certificate(&certificate);
				free(name);
                                break;
			case PROTOTYPE:
				certificate = af_pse_get_Certificate(SIGNATURE, NULLDNAME, 0);
				if(! certificate){
					fprintf(stderr,"Can't read own certificate from PSE\n");
					break;
				}
                                if(!(key = build_key("Self-signed prototype certificate to", 1)))  {
					fprintf(stderr,"Can't build key\n");
					aux_free_Certificate(&certificate);
					break;
				}
				aux_free_DName(&certificate->tbs->issuer);
				certificate->tbs->issuer = af_pse_get_Name();
				if (certificate->tbs->valid->notbefore) {
					free(certificate->tbs->valid->notbefore);
					certificate->tbs->valid->notbefore = CNULL;
				}
				if (certificate->tbs->valid->notafter) {
					free(certificate->tbs->valid->notafter);
					certificate->tbs->valid->notafter = CNULL;
				}
				if (! notbefore) {
					certificate->tbs->valid->notbefore = aux_current_UTCTime();
					certificate->tbs->valid->notafter = aux_delta_UTCTime(certificate->tbs->valid->notbefore, 0);
				}
				else {
					certificate->tbs->valid->notbefore = (UTCTime *)malloc(40);
					strcpy(certificate->tbs->valid->notbefore, notbefore);
					free(notbefore);
					certificate->tbs->valid->notafter = (UTCTime *)malloc(40);
					strcpy(certificate->tbs->valid->notafter, notafter);
					free(notafter);
				}
				certificate->tbs->serialnumber = aux_new_OctetString(1);
				certificate->tbs->serialnumber->octets[0] = 0x00;
				certificate->tbs->version = 0;           /* default version */
				aux_free_OctetString(&certificate->tbs_DERcode);
				aux_free_Signature(&certificate->sig);
				certificate->sig = (Signature * )malloc(sizeof(Signature));
 				if(! certificate->sig) {
					fprintf(stderr, "%s: ",pgm_name);
                			fprintf(stderr, "Can't allocate memory\n");
					break;
				}
				/*
				 * CA's signature algorithm : - either default value  
				 *			      - or     issueralg (option -a)
				 */
				certificate->tbs->signatureAI = af_get_signature_alg(algorithm, (AlgId *)0);
				certificate->sig->signAI = aux_cpy_AlgId(certificate->tbs->signatureAI);

				certificate->tbs_DERcode = e_ToBeSigned(certificate->tbs);
				if (! certificate->tbs_DERcode || (af_sign(certificate->tbs_DERcode, certificate->sig, SEC_END) < 0)) {
					fprintf(stderr, "%s: ",pgm_name);
                			fprintf(stderr, "AF Error with CA Signature\n");
					LOGAFERR;
					break;
				}
                                if(key->pse_sel) {
                                        if(!(ostr = e_Certificate(certificate)))  {
						fprintf(stderr,"Can't encode new Certificate\n");
						aux_free_Certificate(&certificate);
  						break;
					}
					aux_free_Certificate(&certificate);
					if(onekeypaironly == TRUE)
						oid = af_get_objoid(Cert_name);
					else {
                                        	keytype();
                                        	if(*objtype == 'S') oid = af_get_objoid(SignCert_name);
                                        	else if(*objtype == 'E') oid = af_get_objoid(EncCert_name);
                                        	else {
                                                	fprintf(stderr, "Type must me either 'S' or 'E'\n");
                                                	break;
                                        	}
					}
                                        if(sec_write_PSE(key->pse_sel, oid, ostr) < 0)  {
						fprintf(stderr,"Can't write to PSE\n");
						aux_free_OctetString(&ostr);
 						break;
					}
                                        fprintf(stderr, "Self-signed prototype-certificate stored in object %s\n", key->pse_sel->object.name);
					aux_free_OctetString(&ostr);
                                }
				break;
                        case READ:
                                psesel(2);
                                filen(CNULL);
                                ostr = &octetstring;
                                if((rcode = sec_read_PSE(&std_pse, &objecttype, ostr)) == 0) {
					store_objpin();
					if (aux_cmp_ObjId(&objecttype, Uid_OID) == 0) {
						tmp_ostr = aux_cpy_OctetString(ostr);
						ostr = d_OctetString(tmp_ostr);
						aux_free_OctetString(&tmp_ostr);
					}
                                        if(printfile(ostr, filename) < 0) {
						fprintf(stderr,"Can't write file\n");
					}

                                        free(ostr->octets);
                                } 
				else   {
					fprintf(stderr,"Can't read object  %s  from PSE\n", std_pse.object.name);
					break;
				}

                                break;
			case REMOVE:
				if (af_access_directory == FALSE) {
					fprintf(stderr, "af_access_directory is set to FALSE!\n");
					fprintf(stderr, "If you want to access the Directory, you should invoke ");
					fprintf(stderr, "the 'psemaint' command with the -D option.\n");
					break;
				}
				if(!af_x500 && !af_afdb){
					fprintf(stderr, "No directory flags (AFDBFILE or X500) have been compiled.\n");
					fprintf(stderr, "Therfore, no directory access is provided.\n");
					break;
				}
				attrtype = getattrtype(x500);
				if (!strncasecmp(attrtype, "Certificate", 2) || !strncasecmp(attrtype, "UserCertificate", 1) || !strncasecmp(attrtype, "CACertificate", 2)){

					if (!(dd = nxtpar("cert"))) {
						if ((serial = getserial()) == NULLOCTETSTRING) {
							fprintf(stderr, "No serial number specified!\n");
							break;
						}
						issuer_dn = getdname("Issuer");
					}
					else {
						if (!strchr( dd, ',' )) {
							serial = aux_create_SerialNo(dd);
							issuer_dn = NULLDNAME;
						}
						else {
							ptr = strchr(dd, ',');
							*ptr = '\0';
							ptr++;
							serial = aux_create_SerialNo(dd);
							dd = ptr;
							issuer_dn = aux_alias2DName(dd);
							if (!issuer_dn) {
								fprintf(stderr, "Cannot transform alias <%s> into a Distinguished Name!\n", dd);
								if(dd){
									free(dd);
									dd = CNULL;
								}
								break;
							}
						}
					}
#ifdef X500
					if(x500){
						if(!strncasecmp(attrtype, "UserCertificate", 1)) 
							certtype = userCertificate;
						else
							certtype = cACertificate;
	
						if ( af_dir_delete_Certificate(serial, issuer_dn, certtype)  == 0 )
							fprintf(stderr, "\nDirectory operation (X.500) succeeded.\n");
						       else {
							fprintf(stderr, "\nDirectory operation (X.500) f a i l e d.\n");
							aux_fprint_error(stderr, verbose);
						}
					}
#endif
#ifdef AFDBFILE
					if(onekeypaironly == TRUE)
						ktype = SIGNATURE;  /* ktype is not relevant in this case, but should have an acceptable value */
					else{
                                        	keytype();
                                        	if(*objtype == 'S') 
							ktype = SIGNATURE;
                                        	else if (*objtype == 'E') 
							ktype = ENCRYPTION;
                                        	else {
                                                	fprintf(stderr, "Type must me either 'S' or 'E'\n");
                                                	break;
                                        	}
					}
					if ( af_afdb_delete_Certificate(serial, issuer_dn, ktype) == 0 )
						fprintf(stderr, "\nDirectory operation (AF-DB) succeeded.\n");
                               		else {
						fprintf(stderr, "\nDirectory operation (AF-DB) f a i l e d.\n");
						aux_fprint_error(stderr, verbose);
					}
#endif
				}
				else {    /* attrtype = CrossCertificatePair */
					cpair = specify_CertificatePair();
					if (! cpair) {
						aux_fprint_error(stderr, verbose);
                               			fprintf(stderr, "%s: unable to create Cross Certificate Pair\n", parm[0]);
                 				break;
					}
					if (! cpair->forward && ! cpair->reverse) {
						fprintf(stderr, "\n");
						fprintf(stderr, "ERROR: At least one component (forward or reverse) must be present.\n");
						aux_free_CertificatePair(&cpair);
						break;
					}
#ifdef X500
					if ( x500 ) {
						if ( af_dir_delete_CertificatePair(cpair) == 0 )
							fprintf(stderr, "\nDirectory operation (X.500) succeeded.\n");
                               			else {
							fprintf(stderr, "\nDirectory operation (X.500) f a i l e d.\n");
							aux_fprint_error(stderr, verbose);
						}
					}
#endif
#ifdef AFDBFILE 	
					if ( af_afdb_delete_CertificatePair(cpair) == 0 )
						fprintf(stderr, "\nDirectory operation (AF-DB) succeeded.\n");
                               		else {
						fprintf(stderr, "\nDirectory operation (AF-DB) f a i l e d.\n");
						aux_fprint_error(stderr, verbose);
					}
#endif
					aux_free_CertificatePair(&cpair);
				}
				break;
                        case RENAME:
                                psesel(2);
                                if(!(newname = nxtpar("newname"))) {
                                        while(!newname) {
                                                sprintf(prompt, "Enter new name of object on %s: ", std_pse.app_name);
                                                if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
						else {
							newname = (char *)0;
							break;
						}
						if(strlen(answ)) newname = aux_cpy_String(answ);
                                        }
                                }
				if(newname) {
                                	if((rcode = af_pse_rename(std_pse.object.name, newname)) < 0) {
						fprintf(stderr, "Can't rename %s\n", std_pse.object.name);
						aux_fprint_error(stderr, verbose);
                                        	break;
                                	}
					free(newname);
				}
                                break;
			case RETRIEVE:
				if (af_access_directory == FALSE) {
					fprintf(stderr, "af_access_directory is set to FALSE!\n");
					fprintf(stderr, "If you want to access the Directory, you should invoke ");
					fprintf(stderr, "the 'psemaint' command with the -D option.\n");
					break;
				}
				if(!af_x500 && !af_afdb){
					fprintf(stderr, "No directory flags (AFDBFILE or X500) have been compiled.\n");
					fprintf(stderr, "Therfore, no directory access is provided.\n");
					break;
				}
				dname = getdname(CNULL);
				if(!dname) break;
				if ((dd = nxtpar("update"))) {
					if (!strcmp(dd,"TRUE")) update = TRUE;
					else if (!strcmp(dd,"FALSE")) update = FALSE;
					else {
						fprintf(stderr, "Update must be either 'TRUE' or 'FALSE'\n");
						break;
					}
				}
				else update = FALSE;
				attrtype = getattrtype(x500);
				if (!strncasecmp(attrtype, "Certificate", 2) || !strncasecmp(attrtype, "UserCertificate", 1) || !strncasecmp(attrtype, "CACertificate", 2)){
#ifdef X500
					if ( x500 ) {
						if(!strncasecmp(attrtype, "UserCertificate", 1)) 
							certtype = userCertificate;
                                        	else
							certtype = cACertificate;

						fprintf(stderr, "\nAccessing the X.500 directory entry of \"%s\" ...\n", aux_DName2Name(dname));
						certset = af_dir_retrieve_Certificate(dname,certtype);
					}
#endif
#ifdef AFDBFILE	
					if (!x500 || !af_x500) {
						keytype();
						if(*objtype == 'S') ktype = SIGNATURE;
						else if(*objtype == 'E') ktype = ENCRYPTION;
						else {
							fprintf(stderr, "Type must me either 'S' or 'E'\n");
							break;
						}
						fprintf(stderr, "\nAccessing the AF-DB directory entry of \"%s\" ...\n", aux_DName2Name(dname));			
						certset = af_afdb_retrieve_Certificate(dname,ktype);
					}
#endif
					aux_fprint_CertificateSet(stderr, certset);
					if(!certset) {
						fprintf(stderr, "No certificates returned from Directory.\n");
						break;
					}

					if (update == FALSE) break;

					if (certset->next) {
						fprintf(stderr, "\nSpecify the certificate (within the returned");
						fprintf(stderr, " SET_OF_Certificate) whose DER-code is needed:\n");
						if ((serial = getserial()) == NULLOCTETSTRING) {
							fprintf(stderr, "No serial number specified!\n");
							break;
						}

						/* examine if there is more than one certificate with 
					           the specified serial number: */

						soc = (SET_OF_Certificate *)0;
						while (certset) {
							if (!aux_cmp_OctetString(certset->element->tbs->serialnumber, serial)) {
								if (!soc) {
									soc = (SET_OF_Certificate *)malloc(sizeof(SET_OF_Certificate));
									tmp_soc = soc;
								}
								else {
									tmp_soc->next = (SET_OF_Certificate *)malloc(sizeof(SET_OF_Certificate));
									tmp_soc = tmp_soc->next;
								}
								tmp_soc->element = certset->element;
								tmp_soc->next = (SET_OF_Certificate *)0;	
							}			
							certset = certset->next;
						}
			
						if (!soc) {
							fprintf(stderr,"No such serial number!\n");
							break;
						}

						if (soc->next) { /*more than one certificate with 
							                  specified serial number*/
							issuer_dn = getdname("Issuer");
							if(!issuer_dn) break;
							found = 0;
							while ( soc && !found ) {
								if (!aux_cmp_DName(soc->element->tbs->issuer,issuer_dn)) {
									found = 1;
									certificate = aux_cpy_Certificate(soc->element);
									break;
								}
								soc = soc->next;
							}
							if ( !found ) {
								fprintf(stderr, "The specified certificate does not exist ");
								fprintf(stderr, "in the returned SET_OF_Certificate !\n");
								break;
							}
						}
						else certificate = soc->element;	
					}
					else certificate = certset->element;

					store_certificate(certificate, onekeypaironly);
				}
				else if (!strncasecmp(attrtype,"CrossCertificatePair", 2)) {
#ifdef X500
					if ( x500 ) {
						fprintf(stderr, "\nAccessing the X.500 directory entry of \"%s\" ...\n", aux_DName2Name(dname));
						cpairset = af_dir_retrieve_CertificatePair(dname);
					}
#endif
#ifdef AFDBFILE
					if (!x500 || !af_x500) {
						fprintf(stderr, "\nAccessing the AF-DB directory entry of \"%s\" ...\n", aux_DName2Name(dname));
						cpairset = af_afdb_retrieve_CertificatePair(dname);
					}
#endif
					aux_fprint_CertificatePairSet(stderr, cpairset);
					if(! cpairset) {
						fprintf(stderr, "No SET OF Cross Certificate Pairs returned from Directory.\n");
						break;
					}

					if (update == TRUE) {
						rcode = 0;
						rcode = af_pse_add_CertificatePairSet(cpairset);
						if (!rcode)
							fprintf(stderr, "\nUpdate done on object CrossCSet.\n");
						else
							fprintf(stderr, "\nNo update done on object CrossCSet.\n");
					}
				}
				else {
#ifdef X500
					if ( x500 ) {
						fprintf(stderr, "\nAccessing the X.500 directory entry of \"%s\" ...\n", aux_DName2Name(dname));
						crl = af_dir_retrieve_CRL(dname);
					}
#endif
#ifdef AFDBFILE
					if (!x500 || !af_x500) {
						fprintf(stderr, "\nAccessing the AF-DB directory entry of \"%s\" ...\n", aux_DName2Name(dname));
						crl = af_afdb_retrieve_CRL(dname);
					}
#endif
					fprintf(stderr, "\n");
					aux_fprint_CRL(stderr, crl);
					if(! crl) {
						fprintf(stderr, "No revocation list returned from Directory.\n");
						break;
					}
				}
				if (strncasecmp(attrtype,"RevocationList", 1)) break;

				/* Verifying the returned revocation list: */

				fprintf(stderr, "\nVerifying the returned revocation list ...\n\n");

				own_dname = af_pse_get_Name();
				if (!aux_cmp_DName(dname, own_dname)) {
					certs = af_pse_get_Certificates(SIGNATURE, NULLDNAME);
					rcode = af_verify(crl->tbs_DERcode, crl->sig, SEC_END, certs, (UTCTime * )0, (PKRoot * )0);
					aux_free_Certificates(&certs);
					aux_fprint_VerificationResult(stderr, verifresult);
					aux_free_VerificationResult(&verifresult);
				}
				else {
					if ( !(tbs = af_pse_get_TBS(SIGNATURE, dname, NULLDNAME, 0))) {
#ifdef X500
						if(x500) {
 							if(!(certset = af_dir_retrieve_Certificate(dname, cACertificate)) ) {
								fprintf(stderr, "Verification f a i l e d\n");
                        	                    	        break;
							}
						}
#endif
#ifdef AFDBFILE
						if(!x500 || !af_x500) {
							ktype = SIGNATURE;
	 						if(!(certset = af_afdb_retrieve_Certificate(dname,ktype)) ) {
								fprintf(stderr, "Verification f a i l e d\n");
	                                             	        break;
							}
						}
#endif
					}
  
					pkroot = (PKRoot *)malloc(sizeof(PKRoot));
					if( !pkroot ) {
						fprintf(stderr, "Can't allocate memory\n");
						break;
					}
					pkroot->oldkey = (struct Serial *)0;
					pkroot->newkey = (struct Serial *)malloc(sizeof(struct Serial));

					if (tbs) {
						pkroot->ca = aux_cpy_DName(tbs->subject);
						pkroot->newkey->key = aux_cpy_KeyInfo(tbs->subjectPK);
						pkroot->newkey->serial = aux_cpy_OctetString(tbs->serialnumber);
						pkroot->newkey->valid = aux_cpy_Validity(tbs->valid);
						rcode = af_verify(crl->tbs_DERcode, crl->sig, SEC_END, (Certificates *)0, (UTCTime * )0, pkroot);
						aux_free_PKRoot(&pkroot);
						aux_fprint_VerificationResult(stderr, verifresult);
						aux_free_VerificationResult(&verifresult);
						if (rcode == 0) fprintf(stderr, "Verification s u c c e e d e d\n");
						else{
							fprintf(stderr, "Verification f a i l e d\n");
							break;
						}
					}
					else {		
						while (certset) {
							/* compare, if ENCRYPTION or SIGNATURE object identifier: */
							algtype = aux_ObjId2AlgType(certset->element->tbs->subjectPK->subjectAI->objid);
							if ((algtype == SIG) || (algtype == ASYM_ENC)){
								pkroot->ca = aux_cpy_DName(certset->element->tbs->subject);
								pkroot->newkey->key = aux_cpy_KeyInfo(certset->element->tbs->subjectPK);
								pkroot->newkey->serial = aux_cpy_OctetString(certset->element->tbs->serialnumber);
								pkroot->newkey->valid = aux_cpy_Validity(certset->element->tbs->valid);
								rcode = af_verify(crl->tbs_DERcode, crl->sig, SEC_END, (Certificates *)0, (UTCTime * )0, pkroot);
								aux_fprint_VerificationResult(stderr, verifresult);
								aux_free_VerificationResult(&verifresult);
								if (rcode == 0){
									fprintf(stderr, "Verification s u c c e e d e d\n");
									aux_free_PKRoot(&pkroot);
									break;
								}
								aux_free_DName(&pkroot->ca);
								aux_free_KeyInfo(&pkroot->newkey->key);
							};
							certset = certset->next;
						} /*while*/
						if (! certset) {
							fprintf(stderr, "Verification f a i l e d\n");
                                               		break;
						}
					}
				}
				if (update == TRUE) {
					crlpse = CRL2Crl(crl);
					rcode = af_pse_add_CRL(crlpse);
					if (rcode == 0)
						fprintf(stderr, "\nInstallation of revocation list on PSE s u c c e e d e d\n");
					else {
						fprintf(stderr, "\nInstallation of revocation list on PSE f a i l e d\n");
					}
				}
				break;	
			case REVOKE:
				if(!cadir) {
					fprintf(stderr, "%s: This command is for CAs only\n", pgm_name);
					break;
				}
				dname = af_pse_get_Name();
				name = aux_DName2Name(dname);
				aux_free_DName(&dname);
				crlwithcerts = af_cadb_get_CRLWithCertificates(name, cadir);
				if(! crlwithcerts || ! crlwithcerts->crl){
					fprintf(stderr, "WARNING: Your own CRL is NOT stored in your local database!\n");
					break;
				}
				fprintf(stderr, "\nThis is your locally stored revocation list:\n\n");
				aux_fprint_CRL(stderr, crlwithcerts->crl);
				fprintf(stderr, "\n\nVerifying your locally stored CRL ...\n\n");
				certs = af_pse_get_Certificates(SIGNATURE, NULLDNAME); 
				rcode = af_verify(crlwithcerts->crl->tbs_DERcode, crlwithcerts->crl->sig, SEC_END, certs, (UTCTime * )0, (PKRoot * )0);
				aux_free_Certificates(&certs);
				aux_fprint_VerificationResult(stderr, verifresult);
				aux_free_VerificationResult(&verifresult);
				if (rcode == 0) {
					fprintf(stderr, "Verification of locally stored ");
					fprintf(stderr, "CRL s u c c e e d e d!\n\n");
				}
				else {
					fprintf(stderr, "WARNING: Verification of locally ");
					fprintf(stderr, "stored CRL f a i l e d!\n");
					break;
				}
				xx = "y";
				update = 0;
				while (strcmp(xx, "n")) {
					fprintf(stderr, "\nEnter serial number of certificate which ");
					fprintf(stderr, "is to be revoked:\n");
					serial = getserial();
					i = 0;
					while (!serial && i < 3) {
						fprintf(stderr, "Serial number must be a positive integer!\n");
						serial = getserial();
						i++;
					}
					if (i == 3) break;
					certificate = af_cadb_get_Certificate(serial, cadir);
					if (!certificate) {
						fprintf(stderr, "\nNo certificate with serial number ");
						aux_fprint_Serialnumber(stderr, serial);
						fprintf(stderr, "in CA database!\n");
						fprintf(stderr, "\nNew choice? [y/n]: ");
					}
					else {	
						crlentry = af_create_CRLEntry(serial);
						if (!af_search_CRLEntry(crlwithcerts->crl, crlentry)) { 
							fprintf(stderr, "\nThe following certificate with serial number ");
							aux_fprint_Serialnumber(stderr, serial);
							fprintf(stderr, "is being revoked:\n\n");
							aux_fprint_Certificate(stderr, certificate);
							crlentryseq = (SEQUENCE_OF_CRLEntry * )malloc(sizeof(SEQUENCE_OF_CRLEntry));
							if (!crlentryseq) {
								fprintf(stderr, "Can't allocate memory\n");
								aux_free_CRLEntry(&crlentry);
								aux_free_CRLWithCertificates(&crlwithcerts);
								break;
							}

							crlentryseq->element = aux_cpy_CRLEntry(crlentry);
							aux_free_CRLEntry(&crlentry);

							crlentryseq->next = crlwithcerts->crl->tbs->revokedCertificates;
							/* existing or NULL pointer */

							crlwithcerts->crl->tbs->revokedCertificates = crlentryseq;
							update = 1;
							fprintf(stderr, "\nMore certificates to be revoked? [y/n]: ");
						}
						else {
							fprintf(stderr, "\nCertificate with serial number ");
							aux_fprint_Serialnumber(stderr, serial);
							fprintf(stderr, "already revoked !\n");
							fprintf(stderr, "\nNew choice? [y/n]: ");
						}
					}
					if(interactive) aux_fgets((char *)0, answ, sizeof(answ), stderr, stdin);
					else strcpy(answ, "n");
					xx = answ;
					while ( strcmp(xx, "y") && strcmp(xx, "n") ) {
						fprintf(stderr, "\nAnswer must be 'y' or 'n' !\n\n");
						fprintf(stderr, "\nNew choice? [y/n]: ");
						if(interactive) aux_fgets((char *)0, answ, sizeof(answ), stderr, stdin);
						else strcpy(answ, "n");
						xx = answ;
					}
				}  /*while*/
		
				if (!update) {
					fprintf(stderr, "No update done on revocation list!\n");
					aux_free_CRLWithCertificates(&crlwithcerts);
					break;
				}

				if (create == FALSE) {
					crlwithcerts->crl->tbs->lastUpdate = aux_current_UTCTime();
					crlwithcerts->crl->tbs->nextUpdate = (UTCTime *)0;
					crlwithcerts->crl->tbs->nextUpdate = aux_get_nextUpdate(crlwithcerts->crl->tbs->lastUpdate);
				}

				if ((crlwithcerts->crl->tbs_DERcode = e_CRLTBS(crlwithcerts->crl->tbs)) == NULLOCTETSTRING) {
					fprintf(stderr, "Can't encode crlwithcerts->crl->tbs\n");
					break;
				}

				fprintf(stderr, "\nThe following Crl is to be signed. ");
				fprintf(stderr, "Please check it:\n\n");
				aux_fprint_CRLTBS(stderr, crlwithcerts->crl->tbs);
				fprintf(stderr, "\nDo you want to sign the displayed ");
				fprintf(stderr, "revocation list ?\n");
				fprintf(stderr, "If you want to sign it, (re)enter the PIN of your PSE:\n\n");
				af_pse_close(NULLOBJID);
				if ( af_sign(crlwithcerts->crl->tbs_DERcode, crlwithcerts->crl->sig, SEC_END) < 0 ) {
					fprintf(stderr, "Signature of revocation list failed\n");
					break;
				}

				/* Update on Directory entry, PSE, and CA directory: */
#ifdef X500
				if (x500 && af_access_directory == TRUE) {
					fprintf(stderr, "\n**********************************************\n");
					/* update X.500 directory entry */
					fprintf(stderr, "\nTrying to update your X.500 directory entry ...");
					if ( af_dir_enter_CRL(crlwithcerts->crl) < 0 ) 
						fprintf(stderr, "\n Directory entry (X.500) f a i l e d !\n");
					else fprintf(stderr, "\n Done!\n");
					fprintf(stderr, "\n**********************************************\n");
				}
#endif
#ifdef AFDBFILE
				if (af_access_directory == TRUE) {
					fprintf(stderr, "\n**********************************************\n");
					/* update AF-DB directory entry */
					fprintf(stderr, "\nTrying to update your AF-DB directory entry ...");
					if ( af_afdb_enter_CRL(crlwithcerts->crl) < 0 ) 
						fprintf(stderr, "\n Directory entry (AF-DB) f a i l e d !\n");
					else fprintf(stderr, "\n Done!\n");
					fprintf(stderr, "\n**********************************************\n");
				}
#endif

				/* update PSE object CrlSet, even if the directory entry failed */
				crlpse = CRL2Crl (crlwithcerts->crl);
				fprintf(stderr, "\nUpdating PSE object CrlSet ...\n");
				rcode = af_pse_add_CRL(crlpse);
				if (rcode != 0) {
					fprintf(stderr, "\n Cannot update PSE object CrlSet.\n");
					aux_free_Crl (&crlpse);
				}
				else fprintf(stderr, "\n Done!\n");
				aux_free_Crl (&crlpse);
				fprintf(stderr, "\n**********************************************\n");

				/* update 'crlwithcerts' database in CA directory, even if the directory entry failed */
				fprintf(stderr, "\nUpdating 'crlwithcerts' database in CA directory \"%s\" ...\n", cadir);
				if(!(calogfile = aux_get_abs_path(cadir, CALOG))) {
					AUX_ADD_ERROR;
					return(-1);
				}
				logfile = fopen(calogfile, LOGFLAGS);
				free(calogfile);
				if(logfile == (FILE * ) 0) {
					fprintf(stderr, "%s: Can't open %s\n", pgm_name, CALOG);
					break;
				}
				rcode = af_cadb_add_CRLWithCertificates(crlwithcerts, cadir);
				if(rcode != 0){
					fprintf(stderr, "%s: ", cmdname);
					fprintf(stderr, "Cannot store your updated CRL in your 'crlwithcerts' database!\n");
					aux_fprint_error(stderr, verbose);
					aux_free_CRLWithCertificates(&crlwithcerts);
					break;
				}
				fprintf(stderr, "\nMost current version of CRL stored in 'crlwithcerts' database in ");
				fprintf(stderr, "CA directory \"%s\".\n\n", cadir);
				aux_free_CRLWithCertificates(&crlwithcerts);
				fclose(logfile);
				logfile = (FILE * )0;
				break;
                        case SETPARM:
				a = alglist;
				algid = (AlgId *)0;
                                strrep(&algname, getalgname());
				while (a->name) {
					if (strcmp(algname, a->name) == 0) {
						algid = a->algid;
						break;
					}
					a++;
				}

                                if(algid) switch(aux_Name2ParmType(algname)) {
                                        case PARM_INTEGER:
                                                rsaparm = (rsa_parm_type *)(algid->param);
                                                *rsaparm = getsize("keysize");
                                                break;
                                        case PARM_OctetString:
                                                filen("File: ");
                                                if(filename) ostr = aux_file2OctetString(filename);
                                                if(ostr) algid->param = (char *)ostr;
                                                break;
					default:
						if(aux_Name2AlgEnc(algname) == DSA) sec_dsa_keysize = getsize("keysize");
						else fprintf(stderr, "algorithm has no parameter\n");
                                }
                                break;
                        case SHOW:
                                if(!(key = build_key("", 0))) break;
                                print_keyinfo_flag = ALGID;
                                print_cert_flag = TBS | ALG;
                                opt = 0;
                                while((cc = nxtpar(CNULL))) {
                                        if(!strncasecmp(cc, "TBS", 3)) opt |= TBS;
                                        else if(!strncasecmp(cc, "HAS", 3)) opt |= HSH;
                                        else if(!strncasecmp(cc, "VER", 3)) print_cert_flag |= VER;
                                        else if(!strncasecmp(cc, "ALG", 3)) opt |= ALG;
                                        else if(!strncasecmp(cc, "VAL", 3)) opt |= VAL;
                                        else if(!strncasecmp(cc, "DER", 3)) opt |= DER;
                                        else if(!strncasecmp(cc, "SIG", 3)) opt |= SIGNAT | ALG;
                                        else if(!strncasecmp(cc, "KEY", 3)) opt |= KEYINFO;
                                        else if(!strncasecmp(cc, "ISS", 3)) opt |= ISSUER;
                                        else if(!strncasecmp(cc, "SUB", 3)) opt |= SUBJECT;
                                        else if(!strncasecmp(cc, "BIT", 3)) print_keyinfo_flag |= BSTR;
                                        else if(!strncasecmp(cc, "COM", 3)) print_keyinfo_flag |= KEYBITS;
                                        else if(!strncasecmp(cc, "ALL", 3)) {
						print_keyinfo_flag |= KEYBITS;
						print_cert_flag |= SIGNAT | VER | HSH;
					}
					free(cc);
                                }
                                if(opt && opt != DER) print_cert_flag = opt;
                                else print_cert_flag |= opt;
                                if(key->pse_sel) {
					objname = key->pse_sel->object.name;
                                        if(strcmp(objname, SerialNumber_name) == 0){
                                                if(! (serial = af_pse_get_SerialNumber())) goto noobject;
						aux_fprint_Serialnumber(stderr, serial);
						aux_free_OctetString(&serial);
                                        }
                                        else if(strcmp(objname, SignCert_name) == 0
					   || strcmp(objname, Cert_name) == 0) { 
                                                if(!(certificate = af_pse_get_Certificate(SIGNATURE, (DName *)0, (OctetString *)0))) goto noobject;
                                                print_keyinfo_flag |= PK;
						print_indent += 4;
                                                aux_fprint_Certificate(stderr, certificate);
						print_indent -= 4;
                                                aux_free_Certificate(&certificate);
                                        }
                                        else if(strcmp(objname, EncCert_name) == 0) {
                                                if(!(certificate = af_pse_get_Certificate(ENCRYPTION, (DName *)0, (OctetString *)0))) goto noobject;
                                                print_keyinfo_flag |= PK;
						print_indent += 4;
                                                aux_fprint_Certificate(stderr, certificate);
						print_indent -= 4;
                                                aux_free_Certificate(&certificate);
                                        }
                                        else if(strcmp(objname, SignCSet_name) == 0
					   || strcmp(objname, CSet_name) == 0) { 
                                                if(!(certset = af_pse_get_CertificateSet(SIGNATURE))) goto noobject;
                                                print_keyinfo_flag |= PK;
                                                aux_fprint_CertificateSet(stderr, certset);
                                                aux_free_CertificateSet(&certset);
                                        }
                                        else if(strcmp(objname, EncCSet_name) == 0) {
                                                if(!(certset = af_pse_get_CertificateSet(ENCRYPTION))) goto noobject;
                                                print_keyinfo_flag |= PK;
                                                aux_fprint_CertificateSet(stderr, certset);
                                                aux_free_CertificateSet(&certset);
                                        }
                                        else if(strcmp(objname, FCPath_name) == 0) {
                                                if(!(fcpath = af_pse_get_FCPath((DName *)0))) goto noobject;
                                                print_keyinfo_flag |= PK;
                                                aux_fprint_FCPath(stderr, fcpath);
                                                aux_free_FCPath(&fcpath);
                                        }
                                        else if(strcmp(objname, PKRoot_name) == 0) {
                                                if(!(pkroot = af_pse_get_PKRoot())) goto noobject;
                                                print_keyinfo_flag |= PK;
						print_indent += 4;
                                                aux_fprint_PKRoot(stderr, pkroot);
						print_indent -= 4;
						aux_free_PKRoot(&pkroot);
                                        }
                                        else if(strcmp(objname, PKList_name) == 0) {
                                                if(!(pklist = af_pse_get_PKList(SIGNATURE))) goto noobject;
                                                print_keyinfo_flag |= PK;
                                                aux_fprint_PKList(stderr, pklist);
						aux_free_PKList(&pklist);
                                        }
                                        else if(strcmp(objname, EKList_name) == 0) {
                                                if(!(pklist = af_pse_get_PKList(ENCRYPTION))) goto noobject;
                                                print_keyinfo_flag |= PK;
                                                aux_fprint_PKList(stderr, pklist);
						aux_free_PKList(&pklist);
                                        }
                                        else if(strcmp(objname, PCAList_name) == 0) {
                                                if(!(pklist = af_pse_get_PCAList())) goto noobject;
                                                print_keyinfo_flag |= PK;
                                                aux_fprint_PKList(stderr, pklist);
						aux_free_PKList(&pklist);
                                        }
                                        else if(strcmp(objname, CrossCSet_name) == 0) {
                                                if(!(cpairset = af_pse_get_CertificatePairSet())) goto noobject;
                                                print_keyinfo_flag |= PK;
                                                aux_fprint_CertificatePairSet(stderr, cpairset);
						aux_free_CertificatePairSet(&cpairset);
                                        }
                                        else if(strcmp(objname, CrlSet_name) == 0) {
                                                if(!(crlset = af_pse_get_CrlSet())) goto noobject;
                                                aux_fprint_CrlSet(stderr, crlset);
                                                aux_free_CrlSet(&crlset);
                                        }
                                        else if(strcmp(objname, AliasList_name) == 0) {
                                                if(!(aliaslist = af_pse_get_AliasList())) goto noobject;
                                                aux_fprint_AliasList(stderr, aliaslist);
                                                aux_free_AliasList(&aliaslist);
                                        }
                                        else if(strcmp(objname, QuipuPWD_name) == 0) {
                                                if(!(dd = af_pse_get_QuipuPWD())) goto noobject;
                                                fprintf(stderr, "X.500 Password: %s\n", dd);
                                                if (dd) free(dd);
                                        }
                                        else if(strcmp(objname, DHparam_name) == 0) {
                                                if(!(algid = af_pse_get_DHparam())) goto noobject;
						print_indent += 4;
                                                FPRINTF(stderr, "DHParameter:  ");
						aux_fprint_AlgId(stderr, algid);
						print_indent -= 4;
                                                aux_free_AlgId(&algid);;
                                        }
                                        else if(strcmp(objname, DSAcommon_name) == 0) {
                                                if(!(algid = af_pse_get_DSAcommon())) goto noobject;
						print_indent += 4;
                                                FPRINTF(stderr, "DSA common Parameter:  ");
						aux_fprint_AlgId(stderr, algid);
						print_indent -= 4;
                                                aux_free_AlgId(&algid);;
                                        }
					else {
                                        	ostr = &octetstring;
                                        	if(sec_read_PSE(key->pse_sel, &object_oid, ostr) < 0)  {
							fprintf(stderr,"Can't read object  %s  from PSE\n", key->pse_sel->object.name);
							break;
						}
						if(aux_cmp_ObjId(&object_oid, SignSK_OID) == 0
						   || aux_cmp_ObjId(&object_oid, DecSKnew_OID) == 0 
						   || aux_cmp_ObjId(&object_oid, DecSKold_OID) == 0
						   || aux_cmp_ObjId(&object_oid, SKnew_OID) == 0 
						   || aux_cmp_ObjId(&object_oid, RSA_SK_OID) == 0 
						   || aux_cmp_ObjId(&object_oid, DSA_SK_OID) == 0 
						   || aux_cmp_ObjId(&object_oid, SKold_OID) == 0) {
							if(!(keyinfo = d_KeyInfo(ostr))) goto decodeerr;
							print_indent += 4;
							FPRINTF(stderr, "Privat Key: ");
							print_keyinfo_flag |= SK;
							aux_fprint_KeyInfo(stderr, keyinfo);
							print_indent -= 4;
							aux_free_KeyInfo(&keyinfo);
						}
						else if(aux_cmp_ObjId(&object_oid, RSA_PK_OID) == 0
						   || aux_cmp_ObjId(&object_oid, DSA_PK_OID) == 0) {
							if(!(keyinfo = d_KeyInfo(ostr))) goto decodeerr;
							print_indent += 4;
							FPRINTF(stderr, "Public Key: ");
							print_keyinfo_flag |= PK;
							aux_fprint_KeyInfo(stderr, keyinfo);
							print_indent -= 4;
							aux_free_KeyInfo(&keyinfo);
						}
						else if(aux_cmp_ObjId(&object_oid, DHkey_OID) == 0) {
							bstr = d_BitString(ostr);
							print_indent += 4;
							FPRINTF(stderr, "DH agreed key: ");
							aux_fprint_BitString(stderr, bstr);
							print_indent -= 4;
							aux_free_BitString(&bstr);
						}
						else if(aux_cmp_ObjId(&object_oid, DHprivate_OID) == 0) {
							if(!(keyinfo = d_KeyInfo(ostr))) goto decodeerr;
							print_indent += 4;
							FPRINTF(stderr, "DHPrivateKey: ");
							print_keyinfo_flag |= SK;
							aux_fprint_KeyInfo(stderr, keyinfo);
							print_indent -= 4;
							aux_free_KeyInfo(&keyinfo);
						}
						else {
							fprintf(stderr, "Object OID { ");
							for(i = 0; i < object_oid.oid_nelem; i++) fprintf(stderr, "%d ", object_oid.oid_elements[i]);
							fprintf(stderr, " }\n");
	
							if((certificate = d_Certificate(ostr))) {
								print_keyinfo_flag |= PK;
								print_indent += 4;
								   aux_fprint_Certificate(stderr, certificate);
								print_indent -= 4;
								aux_free_Certificate(&certificate);
							}
							else if((dname = d_DName(ostr))) {
								if(!(name = aux_DName2Name(dname))) {
									       fprintf(stderr, "Can't build printable repr. of %s\n", key->pse_sel->object.name);
								}
								else fprintf(stderr, "%s\n", name);
								aux_free_DName(&dname);
							}
							else if((fcpath = d_FCPath(ostr))) {
								aux_fprint_FCPath(stderr, fcpath);
								aux_free_FCPath(&fcpath);
							}
							else if((pkroot = d_PKRoot(ostr))) {
								print_indent += 4;
								aux_fprint_PKRoot(stderr, pkroot);
								print_indent -= 4;
								aux_free_PKRoot(&pkroot);
							}
							else if((certset = d_CertificateSet(ostr))) {
								aux_fprint_CertificateSet(stderr, certset);
								aux_free_CertificateSet(&certset);
							}
							else if((pklist = d_PKList(ostr))) {
								aux_fprint_PKList(stderr, pklist);
								aux_free_PKList(&pklist);
							}
							else if((keyinfo = d_KeyInfo(ostr))) {
								print_indent += 4;
								FPRINTF(stderr, "PublicKey:    ");
								print_keyinfo_flag |= PK;
								aux_fprint_KeyInfo(stderr, keyinfo);
								print_indent -= 4;
								aux_free_KeyInfo(&keyinfo);
							}
							else if ((cpairset = d_CertificatePairSet(ostr))) {
								aux_fprint_CertificatePairSet(stderr, cpairset);
								aux_free_CertificatePairSet(&cpairset);
							}
							else if((crlset = d_CrlSet(ostr))) {
								aux_fprint_CrlSet(stderr, crlset);
								aux_free_CrlSet(&crlset);
							}
							else if((aliaslist = d_AliasList(ostr))) {
								aux_fprint_AliasList(stderr, aliaslist);
								aux_free_AliasList(&aliaslist);
							}
							else if((dd = d_GRAPHICString(ostr))) {
								fprintf(stderr, "X.500 Password: %s\n", dd);
								if (dd) free(dd);
							}
							else aux_xdump(ostr->octets, ostr->noctets, 0);
							if(ostr->octets) free(ostr->octets);
							aux_free2_ObjId(&object_oid);
						}
					}
                                        print_keyinfo_flag = ALGID;
                                        print_cert_flag = TBS | ALG | SIGNAT;
                                        break;
                                }
                                else {
                                        if((rcode = sec_get_key(&tmpkey, key->keyref, (Key *)0)) < 0)  {
						fprintf(stderr,"Can't get key\n");
						break;
					}
                                        fprintf(stderr, "    KeyAid: ");
                                        aux_fprint_KeyInfo(stderr, &tmpkey);
                                        print_keyinfo_flag = ALGID;
                                        print_cert_flag = TBS | ALG | SIGNAT;
					aux_free2_KeyInfo(&tmpkey);
                                        break;
                                }
decodeerr:
                                fprintf(stderr, "Can't decode %s\n", key->pse_sel->object.name);
				if(ostr->octets) free(ostr->octets);
                                break;
noobject:
                                aux_fprint_error(stderr, verbose);
                                break;

                        case SPLIT:
				cpairset = af_pse_get_CertificatePairSet();
				if (! cpairset) {
					fprintf(stderr,"No Cross Certificate Pairs stored in PSE\n");
					break;
				}
				cpair = specify_CertificatePair();
				if (! cpair) {
					aux_fprint_error(stderr, verbose);
                               		fprintf(stderr, "%s: unable to create Cross Certificate Pair\n", parm[0]);
                 			break;
				}
				if (! cpair->forward && ! cpair->reverse) {
					fprintf(stderr, "\n");
					fprintf(stderr, "ERROR: At least one component (forward or reverse) must be present.\n");
					aux_free_CertificatePair(&cpair);
					break;
				}
				while (cpairset) {
					if (! aux_cmp_CertificatePair(cpair, cpairset->element))
						break;
					cpairset = cpairset->next;
				}
				if (! cpairset) {
					fprintf(stderr, "Specified Cross Certificate Pair NOT found\n");
					break;
				}
				fprintf(stderr,"\n");
				if (cpairset->element && cpairset->element->forward) {
					if(!(key = build_key("F O R W A R D  certificate to", 1)))  {
						fprintf(stderr,"Cannot build key\n");
						aux_free_CertificatePairSet(&cpairset);
						break;
					}
					if(key->pse_sel) {
						if(!(ostr = e_Certificate(cpairset->element->forward)))  {
							fprintf(stderr,"Cannot encode forward certificate\n");
							aux_free_CertificatePairSet(&cpairset);
							aux_free_Key(&key);
							break;
						}
						if(onekeypaironly == TRUE)
							oid = af_get_objoid(Cert_name);
						else{
							keytype();
							if(*objtype == 'S') oid = af_get_objoid(SignCert_name);
							else if(*objtype == 'E') oid = af_get_objoid(EncCert_name);
							else {
								fprintf(stderr, "Type must me either 'S' or 'E'\n");	
								aux_free_OctetString(&ostr);
								aux_free_CertificatePairSet(&cpairset);
								aux_free_Key(&key);
								break;
							}
						}
						if(sec_write_PSE(key->pse_sel, oid, ostr) < 0)  {
							fprintf(stderr,"Can't write to PSE\n");
							aux_free_OctetString(&ostr);
							aux_free_CertificatePairSet(&cpairset);
							aux_free_Key(&key);
							break;
						}
						fprintf(stderr, "Forward stored in object %s\n", key->pse_sel->object.name);
						aux_free_OctetString(&ostr);
						aux_free_Key(&key);
					}
				}

				if (cpairset->element && cpairset->element->reverse) {
					if(!(key = build_key("R E V E R S E  certificate to", 1)))  {
						fprintf(stderr,"Cannot build key\n");
						aux_free_CertificatePairSet(&cpairset);
						break;
					}
					if(key->pse_sel) {
						if(!(ostr = e_Certificate(cpairset->element->reverse)))  {
							fprintf(stderr,"Cannot encode reverse certificate\n");
							aux_free_CertificatePairSet(&cpairset);
							aux_free_Key(&key);
							break;
						}
						if(onekeypaironly == TRUE)
							oid = af_get_objoid(Cert_name);
						else{
							keytype();
							if(*objtype == 'S') oid = af_get_objoid(SignCert_name);
							else if(*objtype == 'E') oid = af_get_objoid(EncCert_name);
							else {
								fprintf(stderr, "Type must me either 'S' or 'E'\n");	
								aux_free_OctetString(&ostr);
								aux_free_CertificatePairSet(&cpairset);
								aux_free_Key(&key);
								break;
							}
						}
						if(sec_write_PSE(key->pse_sel, oid, ostr) < 0)  {
							fprintf(stderr,"Can't write to PSE\n");
							aux_free_OctetString(&ostr);
							aux_free_CertificatePairSet(&cpairset);
							aux_free_Key(&key);
							break;
						}
						fprintf(stderr, "Forward stored in object %s\n", key->pse_sel->object.name);
						aux_free_OctetString(&ostr);
						aux_free_Key(&key);
					}
				}

				aux_free_CertificatePairSet(&cpairset);
                                break;
                        case STRING2KEY:
                                str2key();
                                if(!(key = build_key("", 1)))  {
					fprintf(stderr,"Can't build key\n");
					break;
				}
                                sec_string_to_key(pin, key);
                                fprintf(stderr, "DES key stored ");
                                if(key->pse_sel) fprintf(stderr, " in object %s\n", key->pse_sel->object.name);
                                else fprintf(stderr, "under keyref %d\n", key->keyref);
				aux_free_Key(&key);
                                break;
                        case TOC:
				rcode = sec_print_toc(stderr, &std_pse);
				if(rcode < 0) fprintf(stderr, "No PSE open\n");
                                break;
#ifdef SCA
                        case TOGGLE:
				SC_verify = 1 - SC_verify;
				SC_encrypt = 1 - SC_encrypt;
				if(SC_verify) fprintf(stderr, "Verification/Encryption in SCT\n");
				else fprintf(stderr, "Verification/Encryption with SW\n");
                                break;
#endif
			case VERBOSE:
				dd = nxtpar(CNULL);
				if(dd) i = atoi(dd);
				else i = -1;
				if(i >= 0 && i < 4) verbose = i;
				if(verbose < 2) af_verbose = sec_verbose = FALSE;
				else if(verbose == 2) {
					af_verbose = TRUE;
					sec_verbose = FALSE;
				}
				else af_verbose = sec_verbose = TRUE;
				fprintf(stderr, "Verbose level is %d\n", verbose);
				break;
                        case VERIFY:
                                ostr = &octetstring;

                                if((dd = nxtpar("certificate"))) {
					strrep(&(std_pse.object.name), dd);
					free(dd);

					if(sec_read_PSE(&std_pse, &object_oid, ostr) < 0) {
						fprintf(stderr,"Can't read object  %s  from PSE\n", std_pse.object.name);
						break;
					}
					store_objpin();
	
					if(aux_cmp_ObjId(&object_oid, SignCert_OID) && aux_cmp_ObjId(&object_oid, EncCert_OID) && aux_cmp_ObjId(&object_oid, Cert_OID)) { 
						fprintf(stderr, "%s is not a certificate\n", std_pse.object.name);
						free(ostr->octets);
						free(object_oid.oid_elements);
						break;
					}
					free(object_oid.oid_elements);
					if(!(certificate = d_Certificate(ostr))) {
						fprintf(stderr, "Can't decode %s\n", std_pse.object.name);
						free(ostr->octets);
						break;
					}
					free(ostr->octets);
				}
                                else certificate = af_pse_get_Certificate(SIGNATURE, (DName *)0, (OctetString *)0);
				if(!certificate) {
					fprintf(stderr, "Can't read certificate\n");
					break;
				}

				std_pse.object.name = CNULL;
                                if((dd = nxtpar("fcpath"))) {
					if(*dd != '-') strrep(&(std_pse.object.name), dd);
					free(dd);

					ostr = &octetstring;
					fcpath = (FCPath *)0;
					
					if(std_pse.object.name && strlen(std_pse.object.name)) {
						if(sec_read_PSE(&std_pse, &object_oid, ostr) == 0) {
							store_objpin();
							if(aux_cmp_ObjId(&object_oid, FCPath_OID) && 
							   aux_cmp_ObjId(&object_oid, SignCert_OID) && 
							   aux_cmp_ObjId(&object_oid, EncCert_OID) && 
							   aux_cmp_ObjId(&object_oid, Cert_OID)) { 
								fprintf(stderr, "%s is neither a FCPath nor a Certificate\n", std_pse.object.name);
								free(ostr->octets);
								free(object_oid.oid_elements);
								aux_free_Certificate(&certificate);
								break;
							}
							free(object_oid.oid_elements);
							if(!(fcpath = d_FCPath(ostr))) {
								if(!(fcpath_cert = d_Certificate(ostr))){
									fprintf(stderr, "Can't decode %s\n", std_pse.object.name);
									free(ostr->octets);
									aux_free_Certificate(&certificate);
										break;
								}
								free(ostr->octets);
								fcpath = aux_create_FCPath(fcpath_cert);
								if(! fcpath){
									fprintf(stderr, "Cannot transform Certificate into FCPath.\n");
									aux_free_Certificate(&fcpath_cert);
									break;
								}
							}
							else free(ostr->octets);
						}
						else{
							fprintf(stderr, "Can't read object  %s  from PSE\n", std_pse.object.name);
							break;
						}
					}
				}
				else fcpath = af_pse_get_FCPath((DName *)0);
                                certs = aux_create_Certificates(certificate, fcpath);
				if(!certs) {
					fprintf(stderr, "Can't allocate memory\n");
					aux_free_Certificate(&certificate);
					aux_free_FCPath(&fcpath);
					break;
				}
				aux_free_Certificate(&certificate);
				aux_free_FCPath(&fcpath);
                                if((dd = nxtpar("pkroot"))) {
                                        strrep(&(std_pse.object.name), dd);
					free(dd);
                                        ostr = &octetstring;
                                        if(sec_read_PSE(&std_pse, &object_oid, ostr) < 0)  {
        					fprintf(stderr,"Can't read object  %s  from PSE\n", std_pse.object.name);
        					break;
        				}
					store_objpin();
                                        if(aux_cmp_ObjId(&object_oid, PKRoot_OID)) { 
                                                fprintf(stderr, "%s is not a PKRoot\n", std_pse.object.name);
						free(object_oid.oid_elements);
                                                free(ostr->octets);
						aux_free_Certificates(&certs);
                                                break;
                                        }
					free(object_oid.oid_elements);
                                        if(!(pkroot = d_PKRoot(ostr))) {
                                                fprintf(stderr, "Can't decode %s\n", std_pse.object.name);
                                                free(ostr->octets);
                                                break;
                                        }
                                        free(ostr->octets);
                                }
                                else pkroot = (PKRoot *)0;
/*                                af_verbose = TRUE; */
                                print_keyinfo_flag = ALGID;

                                rcode = af_verify_Certificates(certs, (UTCTime *)0, pkroot);
				if(rcode < 0 ) {
					fprintf(stderr, "Verification  f a i l e d\n");
					aux_fprint_error(stderr, verbose);
				}
                                aux_free_Certificates(&certs);
                                if(pkroot) aux_free_PKRoot(&pkroot);
				aux_fprint_VerificationResult(stderr, verifresult);
				aux_free_VerificationResult(&verifresult);
                                break;
                        case WRITE:
                                psesel(2);
                                filen("File: ");
                                if(!(ostr = aux_file2OctetString(filename)))  {
					fprintf(stderr,"Can't read file\n");
					break;
				}
                                if((certificate = d_Certificate(ostr))) {
					if(onekeypaironly == TRUE)
						oid = af_get_objoid(Cert_name);
					else{
                                        	keytype();
                                        	if(*objtype == 'S') oid = af_get_objoid(SignCert_name);
                                        	else if(*objtype == 'E') oid = af_get_objoid(EncCert_name);
                                        	else {
                                                	fprintf(stderr, "Type must me either 'S' or 'E'\n");
                                                	break;
                                        	}
					}
                                        aux_free_Certificate(&certificate);
                                }
                                else if((fcpath = d_FCPath(ostr))) {
                                        oid = af_get_objoid(FCPath_name);
                                        aux_free_FCPath(&fcpath);
                                }
                                else if((pkroot = d_PKRoot(ostr))) {
                                        oid = af_get_objoid(PKRoot_name);
                                        aux_free_PKRoot(&pkroot);
                                }
                                else if((certset = d_CertificateSet(ostr))) {
					if(onekeypaironly == TRUE)
						oid = af_get_objoid(CSet_name);
					else{
                                        	keytype();
                                        	if(*objtype == 'S') oid = af_get_objoid(SignCSet_name);
                                        	else if(*objtype == 'E') oid = af_get_objoid(EncCSet_name);
                                        	else {
                                               		fprintf(stderr, "Type must me either 'S' or 'E'\n");
                                                	break;
                                        	}
					}
                                        aux_free_CertificateSet(&certset);
                                }
                                else if((pklist = d_PKList(ostr))) {
					if(onekeypaironly == TRUE)
						oid = af_get_objoid(PKList_name);
					else {
                                        	keytype();
                                        	if(*objtype == 'S') oid = af_get_objoid(PKList_name);
                                        	else if(*objtype == 'E') oid = af_get_objoid(EKList_name);
                                        	else {
                                                	fprintf(stderr, "Type must me either 'S' or 'E'\n");
                                                	break;
                                        	}
					}
                                        aux_free_PKList(&pklist);
                                }
                                else if((keyinfo = d_KeyInfo(ostr))) {
                                        oid = af_get_objoid(DecSKnew_name);
                                        aux_free_KeyInfo(&keyinfo);
                                }
				else if ((cpairset = d_CertificatePairSet(ostr))) {
					oid = af_get_objoid(CrossCSet_name);
					aux_free_CertificatePairSet(&cpairset);
				}
                                else if((crlset = d_CrlSet(ostr))) {
                                        oid = af_get_objoid(CrlSet_name);
                                        aux_free_CrlSet(&crlset);
                                }
                                else if((aliaslist = d_AliasList(ostr))) {
                                        oid = af_get_objoid(AliasList_name);
                                        aux_free_AliasList(&aliaslist);
                                }
                                else if((serial = d_OctetString(ostr))) {
                                        oid = af_get_objoid(SerialNumber_name);
                                        aux_free_OctetString(&serial);
                                }
                                else if(!strcmp(std_pse.object.name, QuipuPWD_name)) {
					QuipuPWD pwd;
					if(!(pwd = (QuipuPWD)d_GRAPHICString(ostr))) {
						pwd = CATNSTR(CNULL, ostr->octets, ostr->noctets);
						aux_free_OctetString(&ostr);
						ostr = e_GRAPHICString(pwd);
					}
					free(pwd);
                                        oid = af_get_objoid(QuipuPWD_name);
                                }
				else {
					tmp_ostr = aux_cpy_OctetString(ostr);
					aux_free_OctetString(&ostr);
					ostr = e_OctetString(tmp_ostr);
	                                oid = aux_cpy_ObjId(Uid_OID);
					aux_free_OctetString(&tmp_ostr);
				}
                                rcode = 0;

                                if(sec_open(&std_pse) < 0) rcode = sec_create(&std_pse);

                                if(!rcode) {
					rcode = sec_write_PSE(&std_pse, oid, ostr);
                       	                if(rcode) fprintf(stderr,"Can't write to PSE\n");
					af_pse_reset(std_pse.object.name);
				}
				else fprintf(stderr,"Can't create PSE\n");
 
                                aux_free_OctetString(&ostr);
				aux_free_ObjId(&oid);

                                break;
                        case XDUMP:
                                key = object();
				if(!key) break;
                                if(key->pse_sel) {
                                        ostr = &octetstring;
                                        if(sec_read(key->pse_sel, ostr) < 0)   {
						fprintf(stderr,"Can't read object  %s  from PSE\n", key->pse_sel->object.name);
						aux_free_Key(&key);
						break;
					}
					aux_free_Key(&key);
                                	if((objectvalue = d_PSEObject(&objecttype, ostr)) == (OctetString *)0 ) {
                                                dd = ostr->octets;          
                                                n = ostr->noctets;
                                	}
                                        else {
						free(ostr->octets);
                                                fprintf(stderr, "Object OID { ");
                                                for(i = 0; i < objecttype.oid_nelem; i++) {
     	                                                fprintf(stderr, "%d ", objecttype.oid_elements[i]);
                                                }
                                                fprintf(stderr, " }\n");
						free(objecttype.oid_elements);
                                                dd = objectvalue->octets; 
                                                n  = objectvalue->noctets;
                                        }
                                }
                                else {
                                        if((rcode = sec_get_key(&tmpkey, key->keyref, (Key *)0)) < 0)  {
						fprintf(stderr,"Can't get key\n");
						aux_free_Key(&key);
						free(dd);
						break;
					}
                                        dd = tmpkey.subjectkey.bits;
                                        n = (tmpkey.subjectkey.nbits + 7)/ 8;
					aux_free_AlgId(&(tmpkey.subjectAI));
                                }
                                aux_xdump(dd, n, 0);
				aux_free_Key(&key);
				free(dd);
                                break;
			case ERROR:
				aux_fprint_error(stderr, verbose);
				break;
			case RESETERROR:
				aux_free_error();
				break;
                        default:
                                break;
                }
                if(rcode < 0) {
			if(verbose) aux_fprint_error(stderr, verbose);
			aux_free_error();
		}

        }
}

/***************************************************************
 *
 * Procedure num
 *
 ***************************************************************/
#ifdef __STDC__

static int num(
	register char	 *par
)

#else

static int num(
	par
)
register char	 *par;

#endif

{
        while(*par) {
                if(*par < '0' || *par > '9') return(FALSE);
                par++;
        }
        return(TRUE);
}

/***************************************************************
 *
 * Procedure ack
 *
 ***************************************************************/
#ifdef __STDC__

static int ack(
	PSESel	 *pse_sel,
	char	 *txt
)

#else

static int ack(
	pse_sel,
	txt
)
PSESel	 *pse_sel;
char	 *txt;

#endif

{
        if(!(pse_sel->object.name) || !strlen(pse_sel->object.name)) fprintf(stderr, "PSE %s %s\n", pse_sel->app_name, txt);
        else fprintf(stderr, "PSE object %s %s\n", pse_sel->object.name, txt);
        return(0);
}

/***************************************************************
 *
 * Procedure psesel
 *
 ***************************************************************/
#ifdef __STDC__

static int psesel(
	int	  option
)

#else

static int psesel(
	option
)
int	  option;

#endif

{             

/*
 * psesel(option) sets std_pse according to values given via command-line.
 * option  1: objectname is optional; 2: objectname must be given
 * psesel returns 0 if object was selected, 1 if PSE was selected
 */
	char *proc = "psesel";
        char *dd;

        if(cmd == OPEN || cmd == CLOSE) {
                if(!(dd = nxtpar(""))) {
                        if(cmd == OPEN) {
				if(!interactive) return(-1);
                                sprintf(prompt, "Enter PSE name: ");
                                aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
				dd = aux_cpy_String(answ);
                        }
                        else dd = aux_cpy_String(std_pse.app_name);
                }

                if(cmd == OPEN) {
                        if(std_pse.app_name) {
                                if(strcmp(dd, std_pse.app_name) == 0) {
                                        fprintf(stderr, "PSE %s is already open\n", dd);
					free(dd);
                                        return(-1);
                                }
                                if(std_pse.app_name) if(af_pse_close((ObjId *)0) == 0) ack(&std_pse, "closed");
                        }
                        if(std_pse.pin) strzfree(&(std_pse.pin));
                }
                else {
                        if(!std_pse.app_name || strcmp(dd, std_pse.app_name)) {
				if (!dd)
                                	fprintf(stderr, "No pse open\n");
                                else	fprintf(stderr, "%s not open\n", dd);
				free(dd);
                                return(-1);
                        }
                }
                strrep(&(std_pse.app_name), dd);
                if(std_pse.object.name) free(std_pse.object.name);
                std_pse.object.name = CNULL;
                if(std_pse.object.pin) strzfree(&(std_pse.object.pin));
                return(1);
        }

        if(std_pse.object.name) free(std_pse.object.name);
        if(!(std_pse.object.name = nxtpar(""))) {
                while(!std_pse.object.name) {
			if(!interactive) return(-1);
			if(cmd == DH2) sprintf(prompt, "Enter name of PSE object for the agreed key: ");
                        else sprintf(prompt, "Enter name of object on %s: ", std_pse.app_name);
			aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
                        std_pse.object.name = aux_cpy_String(answ);
                        if(strlen(std_pse.object.name) == 0) {
                                free(std_pse.object.name);
                                std_pse.object.name = CNULL;
                        }
                        if(option == 1) break;
                }
        }
        return(0);
}

/***************************************************************
 *
 * Procedure getsize
 *
 ***************************************************************/
#ifdef __STDC__

static int getsize(
	char	 *par
)

#else

static int getsize(
	par
)
char	 *par;

#endif

{
        int size = 0;
        char *dd;
        if(!(dd = nxtpar(par)))  {
		if(!interactive) return(0);
                sprintf(prompt, "%s: ", par);
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
		if(!strlen(answ)) return(0);
                dd = aux_cpy_String(answ);
        }
        sscanf(dd, "%d", &size);
	free(dd);
        return(size);
}

/***************************************************************
 *
 * Procedure filen
 *
 ***************************************************************/
#ifdef __STDC__

static int filen(
	char	 *output
)

#else

static int filen(
	output
)
char	 *output;

#endif

{

	char *proc = "filen";

        if(!(filename = nxtpar("file"))) {
		if(!interactive) return(-1);
                if(output) strcpy(prompt, output);
                else sprintf(prompt, "File [CR for stderr]: ");
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
                filename = aux_cpy_String(answ);
                if(!filename || strlen(filename) == 0) {
                        free(filename);
                        filename = CNULL;
                }
        }

	return(0);
}

/***************************************************************
 *
 * Procedure keytype
 *
 ***************************************************************/
static int keytype()
{
	char *proc = "keytype";

        if(!(objtype = nxtpar("keytype"))) {
		if(!interactive) return(-1);
                sprintf(prompt, "SIGNATURE or ENCRYPTION type (S/E) [CR for S]: ");
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
                objtype = aux_cpy_String(answ);
                if(strlen(objtype) == 0) strcpy(objtype, "S");
        }

	return(0);
}

/***************************************************************
 *
 * Procedure printfile
 *
 ***************************************************************/
#ifdef __STDC__

static int printfile(
	OctetString	 *ostring,
	char		 *fname
)

#else

static int printfile(
	ostring,
	fname
)
OctetString	 *ostring;
char		 *fname;

#endif

{
        register int i, j;
        register char *dd;
        if(!fname || !strlen(fname)) {
                dd = ostring->octets;
                i = ostring->noctets;
                while(i > 0) {
                	j = (i < 1024) ? i : 1024;
                        write(1, dd, j);
                        i -= j;
                        dd += j;
                }
        }
        else return(aux_OctetString2file(ostring, fname, 2));

	return(0);
}

/***************************************************************
 *
 * Procedure new_pin
 *
 ***************************************************************/
static int new_pin()
{
        if(!(newpin = nxtpar("newpin"))) newpin = sec_read_pin("New PIN", std_pse.object.name, TRUE);

	return(0);
}        

/***************************************************************
 *
 * Procedure str2key
 *
 ***************************************************************/
static int str2key()
{
        if(!(pin = nxtpar("pin"))) pin = sec_read_pin("PIN", "", TRUE);

	return(0);
}        

/***************************************************************
 *
 * Procedure helpcmd
 *
 ***************************************************************/
static int helpcmd()
{
        int i;

        if((helpname = nxtpar(CNULL))) {
                for(i = 0; cmds[i].cmd; i++) {
                        if(strncmp(cmds[i].cmd, helpname, strlen(helpname)) == 0) {
                                fprintf(stderr, "Command:     %s %s\n", cmds[i].cmd, cmds[i].parms);
                                fprintf(stderr, "Description: %s\n", cmds[i].text);
                                fprintf(stderr, "%s\n", cmds[i].longtext);
                        }
                }
                return(0);
        }

        fprintf(stderr, "Command      Description\n");
        fprintf(stderr, "-------------------------------------------------------------------------\n");
        for(i = 0; cmds[i].cmd; i++) fprintf(stderr, "%-12s %s\n", cmds[i].cmd, cmds[i].text);
        fprintf(stderr, "-------------------------------------------------------------------------\n");
        fprintf(stderr, "Command and parameter names may be abbreviated, parameters may be omitted\n");
	return(0);
}

/***************************************************************
 *
 * Procedure store_objpin
 *
 ***************************************************************/
static int store_objpin()
/* stores object pin returned from "pin_check()" in AF_pse */
{
	int    i;
	char * proc = "store_objpin";

	for (i = 0; i < PSE_MAXOBJ; i++) 
		if (strcmp(AF_pse.object[i].name, std_pse.object.name) == 0) {
			strrep(&(AF_pse.object[i].pin), std_pse.object.pin);
		}

	return(0);
}


#define OPEN_TO_READ 0
#define OPEN_TO_WRITE 1
/* 0: read,  1: write */

/***************************************************************
 *
 * Procedure build_key
 *
 ***************************************************************/
#ifdef __STDC__

static Key *build_key(
	char	 *s,
	int	  flag
)

#else

static Key *build_key(
	s,
	flag
)
char	 *s;
int	  flag;

#endif

{
        char *dd;
	int i;
        KeyInfo zwkey;
	char *proc = "build_key";
	Key *newkey;
	PSEConfig pse_config;
	AlgEnc   algenc;
	int	 keyref;


	newkey = (Key *)calloc(1, sizeof(Key));
	if(!newkey) return((Key *)0);

        if(cmd == GENKEY) {
                newkey->key = (KeyInfo *)calloc(1, sizeof(KeyInfo));
 		if(!newkey->key) {
			return((Key *)0);
		}
                newkey->key->subjectAI = aux_Name2AlgId(algname);
                if(!newkey->key->subjectAI) {
			free(newkey->key);
			free(newkey);
                        return((Key *)0);
                }
        }
nk:
        if(!(dd = nxtpar(CNULL))) {
		if(!interactive) return((Key *)0);
                if(cmd == DELKEY) sprintf(prompt, "Keyref: %s", s);
                else if(cmd == CERT2KEYINFO || cmd == CACERTIFY || cmd == CERT2PKROOT || cmd == PROTOTYPE || cmd == ADDEK || cmd == ADDPK || cmd == ADDPCA || cmd == SPLIT) sprintf(prompt, "%s: ", s);
                else sprintf(prompt, "Name or ref of %skey: ", s);
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
                dd = aux_cpy_String(answ);
        }
        if(strcmp(dd, "replace") == 0) {
                replace = TRUE;
                goto nk;
        }
        if(num(dd)) {
                if(strlen(dd) == 0) {
			newkey->keyref = -1;
		}
                else sscanf(dd, "%d", &(newkey->keyref));
		free(dd);
		if (newkey->keyref == 0) 
			newkey->keyref = -1;
#ifdef SCA
		else {
			/*
			 * GENKEY: 
			 *   check whether a DES/DES3 key shall be generated in SCT/SC 
			 * DELKEY: 
			 *   check whether a key stored in the SCT shall be deleted
			 */
		
			if (cmd == GENKEY) {
				algenc = aux_ObjId2AlgEnc(newkey->key->subjectAI->objid);
				if ((algenc == DES) || (algenc == DES3)) {
					sprintf	(prompt, "Store key in KeyPool (0), in the SCT (1), in the Smartcard (2):");
					if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
					else answ[0] = '0';
					if ((answ[0] == '1') || (answ[0] == '2')) {

						/*
						 *  Store key in SCT/SC
						 */

						if (answ[0] == '1') {
							 keyref = newkey->keyref | SCT_KEY;
                               				 newkey->keyref = keyref;
						}
						else {
							/*
							 * Check whether pse = pse on SC
							 */
							if ((pse_location = sec_psetest(std_pse.app_name)) == ERR_in_psetest) {
								fprintf(stderr, "Error during test for pse: %s\n", std_pse.app_name);
								aux_free_Key(&newkey);
								return((Key *)0);
							}

							if (pse_location == SWpse) {
                       						fprintf(stderr, "\nCannot generate a key on the smartcard:\n");
                       						fprintf(stderr, "PSE %s is not a smartcard PSE\n", std_pse.app_name);
								aux_free_Key(&newkey);
								return((Key *)0);
							}
                               				keyref = newkey->keyref | SC_KEY;
                               				newkey->keyref = keyref;
						}
						return (newkey);
					}
				}
			
			}
			if (cmd == DELKEY) {
				sprintf	(prompt, "Delete key in KeyPool (0), in the SCT (1):");
				if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
				else answ[0] = '0';
				if (answ[0] == '1') {

					/*
					 *  Delete key in SCT
					 */

                               		keyref = newkey->keyref | SCT_KEY;
                               		newkey->keyref = keyref;
					return (newkey);

				}
			}
			
		}
#endif
		if(cmd == GENKEY && publickey && newkey->keyref != -1) if(newkey->keyref == publickey->keyref) {
                       	fprintf(stderr, "Public key and private key must have different keyrefs\n");
			aux_free_Key(&newkey);
			return((Key *)0);
		}
		if(newkey->keyref > 0 && cmd == GENKEY && replace == FALSE) {
			if(sec_get_key(&zwkey, newkey->keyref, (Key *)0) == 0) {
				aux_free2_KeyInfo(&zwkey);
                               	sprintf(prompt, "Keyref %d exists already. Replace? (y/n): ", newkey->keyref);
                               	if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
				else answ[0] = 'n';
                               	if(answ[0] == 'y') {
					sec_del_key(newkey->keyref);
					if(strcmp(s, "generated private ") == 0) replace = TRUE;
				}
				else {
					aux_free_Key(&newkey);
					return((Key *)0);
				}
			} 
		}
        }
        else {
                newkey->pse_sel = aux_cpy_PSESel(&std_pse);
		strrep(&(newkey->pse_sel->object.name), dd);
		free(dd);
		for (i = 0; i < PSE_MAXOBJ; i++) 
			if(strcmp(AF_pse.object[i].name, newkey->pse_sel->object.name) == 0) {
				strrep(&(newkey->pse_sel->object.pin), AF_pse.object[i].pin);
				break;
               		}
		if(cmd == GENKEY) {
			if(publickey && newkey->pse_sel && publickey->pse_sel
			   && strcmp(newkey->pse_sel->object.name, publickey->pse_sel->object.name) == 0) {
	                       	fprintf(stderr, "Public key and private key must be stored in different objects\n");
				aux_free_Key(&newkey);
				return((Key *)0);
			}
#ifdef SCA

			if ((pse_location = sec_psetest(newkey->pse_sel->app_name)) == ERR_in_psetest) {
				fprintf(stderr, "Error during test for pse: %s\n", newkey->pse_sel->app_name);
				aux_free_Key(&newkey);
				return((Key *)0);
			}

			if((pse_location == SCpse) && (!sec_open(newkey->pse_sel))) {
				if(strcmp(s, "generated private ") == 0) {
                                	sprintf(prompt, "Replace existing private key? (y/n): ");
                                	if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
					else answ[0] = 'y';
                                	if(answ[0] == 'y') replace = TRUE;  /* replace is global */
				}
				if ((pse_config = sec_pse_config(newkey->pse_sel)) == ERR_in_pseconfig) {
	                       		fprintf(stderr, "Error in PSE configuration (SCCONFFILE)\n");
					aux_free_Key(&newkey);
					return((Key *)0);
				}
				if (pse_config != NOT_ON_SC) {
					if(strcmp(s, "generated DES ") == 0) {
                                		sprintf(prompt, "Replace existing DES key? (y/n): ");
                                		if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
						else answ[0] = 'y';
                                		if(answ[0] == 'y') replace = TRUE;  /* replace is global */
					}
				}
				return(newkey);
                        }
#endif
		}
                if(sec_open(newkey->pse_sel) < 0) {
                        if(flag == OPEN_TO_READ) {
                                fprintf(stderr, "Can't open Object %s\n", newkey->pse_sel->object.name);
				aux_add_error(EINVALID, "sec_open failed", CNULL, 0, proc);
				aux_free_Key(&newkey);
                                return((Key *)0);
                        }

			/*
			 *  Open (object) failed => object doesn't exist.
			 *    
			 *  If object to be generated is a key on the SC => no creation of object.
			 *      
			 */

			if ((pse_config = sec_pse_config(newkey->pse_sel)) == ERR_in_pseconfig) {
	                       	fprintf(stderr, "Error in PSE configuration (SCCONFILE)\n");
				aux_free_Key(&newkey);
				return((Key *)0);
			}
			if (pse_config != KEY_ON_SC) {

                        	strrep(&(newkey->pse_sel->object.pin), newkey->pse_sel->pin);
                        	if(sec_create(newkey->pse_sel) < 0) {
                                	fprintf(stderr, "Can't create Object %s\n", newkey->pse_sel->object.name);
					aux_add_error(EINVALID, "sec_open failed", CNULL, 0, proc);
					aux_free_Key(&newkey);
                                	return((Key *)0);
                        	}
                        	fprintf(stderr, "PSE object %s created\n", newkey->pse_sel->object.name);
				if(strcmp(s, "generated public ")) replace = TRUE;
				for (i = 0; i < PSE_MAXOBJ; i++) {
					if (!strcmp(AF_pse.object[i].name, newkey->pse_sel->object.name)) {
						strrep(&(AF_pse.object[i].pin), newkey->pse_sel->object.pin);
						break;
                      	      		}
				}
			}
                        return(newkey);
                }
 
		for (i = 0; i < PSE_MAXOBJ; i++) {
			if (!strcmp(AF_pse.object[i].name, newkey->pse_sel->object.name)) {
				strrep(&(AF_pse.object[i].pin), newkey->pse_sel->object.pin);
				break;
                        }
                        else if(flag == OPEN_TO_WRITE) {
				if(cmd == GENKEY && replace == TRUE) return(newkey);
                                sprintf(prompt, "Object %s already exists. Overwrite? (y/n): ", newkey->pse_sel->object.name);
                        	if(interactive) aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
				else answ[0] = 'y';
                                if(*answ != 'y') {
					aux_free_Key(&newkey);
					return((Key *)0);
				}
				if(strcmp(s, "generated public ")) replace = TRUE;
                                return(newkey);
                        }
                }
        }
        return(newkey);
}

/***************************************************************
 *
 * Procedure getalgname
 *
 ***************************************************************/
static char *getalgname()
{
        char *dd, *ee;
        if(!(dd = nxtpar("algorithm"))) {
                if(cmd == ALGS) strcpy(answ, "ALL");
                else {
			if(!interactive) return(CNULL);
                        if(cmd == SETPARM) sprintf(prompt, "Algorithm name [CR for rsa]: ");
                        else sprintf(prompt, "Algorithm name [CR for desCBC]: ");
                        aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
                }
       	 	if(strlen(answ) == 0) {
                	if(cmd == SETPARM) strcpy(answ, "rsa");
                	else if(cmd == ALGS) strcpy(answ, "ALL");
                	else strcpy(answ, "desCBC");
        	}
		dd = aux_cpy_String(answ);
	}
        return(dd);
}

/***************************************************************
 *
 * Procedure getdname
 *
 ***************************************************************/
#ifdef __STDC__

static DName *getdname(
	char	 *s
)

#else

static DName *getdname(
	s
)
char	 *s;

#endif

{
	DName *dname;
	char *dd;

	if(!s) {
        	if(!(dd = nxtpar("target"))) {
			if(!interactive) return(NULLDNAME);
			sprintf(prompt, "Target Directory Entry [CR for your own Entry]: ");
			aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
			dd = aux_cpy_String(answ);
        	}
        	if (strlen(dd) == 0) {
			free(dd);
			return(af_pse_get_Name());
		}
	}
	else {
		if(!interactive) return(NULLDNAME);
		sprintf(prompt, "%s's Distinguished Name [CR for NULLDNAME]: ", s);
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
		dd = aux_cpy_String(answ);
		if (strlen(dd) == 0) {
			free(dd);
			return (NULLDNAME);
		}
	}
	dname = aux_alias2DName(dd);
	if (!dname){
		fprintf(stderr, "Cannot transform alias name <%s> into a Distinguished Name!\n", dd);
	}
	free(dd);

        return(dname);
}


static Name *gettargetname()
{
	DName *dname;
        char *dd;
	char *proc = "gettargetname";


username:
        if(!(dd = nxtpar("target"))) {
		if(!interactive) return((Name *)0);
                sprintf(prompt, "Target name: ");
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
                dd = aux_cpy_String(answ);
        }
	if(strlen(dd) == 0) {
		free(dd);
		return((Name *)0);
	}
	dname = aux_alias2DName(dd);
	free(dd);
	if (!dname) {
                incorrectName();
                goto username;
        }
        dd = aux_DName2Name(dname);
        aux_free_DName(&dname);
        return(dd);
}


/***************************************************************
 *
 * Procedure getalias
 *
 ***************************************************************/
#ifdef __STDC__

static Name *getalias(
	char	 *dirname,
	Boolean	  MUST_PARAM
)

#else

static Name *getalias(
	dirname,
	MUST_PARAM
)
char	 *dirname;
Boolean	  MUST_PARAM;

#endif

{
        char *dd;
	char *proc = "getalias";

	if(!(dd = nxtpar("alias")) && MUST_PARAM) {
		if(!interactive) return((Name *)0);
		if(dirname) sprintf(prompt, "Alias name for target <%s>: ", dirname);
	    	else sprintf(prompt, "Alias name: ");
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
	    	dd = aux_cpy_String(answ);
    	}
	if(!dd) return((Name *)0);
	if(strlen(dd) == 0) {
		free(dd);
		return((Name *)0);
	}
        return(dd);
}


/***************************************************************
 *
 * Procedure getserial
 *
 ***************************************************************/
static OctetString * getserial() 
{

	char        * dd, number[512];
	OctetString * ret;

	char        * proc = "getserial";

	if(!interactive) return(NULLOCTETSTRING);
	sprintf(prompt, "Serial number (0x* for hex, 0* for octal): ");
	aux_fgets(prompt, number, sizeof(number), stderr, stdin);
	dd = aux_cpy_String(number);
	if (strlen(dd) == 0) {
		free(dd);
		return(NULLOCTETSTRING);
	}

	ret = aux_String2SerialNumber(dd);
	free(dd);

        return(ret);
}


static AliasFile getaliasfile()
{
	AliasFile aliasfile;
	char    * dd;

	dd = nxtpar("file");
sourcetype:
	if(!dd){
		if(!interactive) return(notstored);
		sprintf(prompt, "USER/SYSTEM Alias File ? [ U[ser] / S[ystem] ] [CR for exit]:  ");
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
       	 	if(strlen(answ) == 0) return(notstored);
		dd = aux_cpy_String(answ);
	}

	if (! strncasecmp(dd, "User", 1))
		aliasfile = useralias;
	else if (! strncasecmp(dd, "System", 1))
		aliasfile = systemalias;
	else {
		fprintf(stderr,"File must be either 'User' or 'System'\n");
		if(dd){
			free(dd);
			dd = CNULL;
		}
		goto sourcetype;
	}
	return(aliasfile);
}


/***************************************************************
 *
 * Procedure getattrtype
 *
 ***************************************************************/
#ifdef __STDC__

static char *getattrtype(
	char	  x500
)

#else

static char *getattrtype(
	x500
)
char	  x500;

#endif

{
        char *dd;


        dd = nxtpar("attrtype");
attrtype:
	if(!dd){
		if(!interactive) return(CNULL);
		fprintf(stderr, "Select one of the following attribute types:\n\n");
#ifdef X500
		if(x500){
			fprintf(stderr, "       U[serCertificate]\n");
			fprintf(stderr, "       CA[Certificate]\n");
		}
#endif
#ifdef AFDBFILE
		if(!af_x500 || !x500)
			fprintf(stderr, "       Ce[rtificate]\n");
#endif
		if(cmd != CAUCERT2DIR ) {
			fprintf(stderr, "       Cr[ossCertificatePair]\n");
			if(cmd == ENTER || cmd == RETRIEVE)
				fprintf(stderr, "       R[evocationList]\n");
		}
		fprintf(stderr, "\n");
#ifdef X500
		if(x500)
			fprintf(stderr, "[CR for UserCertificate]:  ");
#endif
#ifdef AFDBFILE
		if(!af_x500 || !x500)
			fprintf(stderr, "[CR for Certificate]:  ");
#endif
                aux_fgets((char *)0, answ, sizeof(answ), stderr, stdin);
       	 	if(strlen(answ) == 0){
#ifdef X500
			if(x500)
                		strcpy(answ, "UserCertificate");
#endif
#ifdef AFDBFILE
			if(!af_x500 || !x500)
				strcpy(answ, "Certificate");
#endif
		}
		dd = aux_cpy_String(answ);
	}

#ifdef X500
	if(x500){
		if((strncasecmp(dd, "UserCertificate", 1) && strncasecmp(dd, "CACertificate", 2) &&
		    strncasecmp(dd, "CrossCertificatePair", 2) && strncasecmp(dd, "RevocationList", 1) &&
		    (cmd == ENTER || cmd == RETRIEVE)) ||
		   (strncasecmp(dd, "UserCertificate", 1) && strncasecmp(dd, "CACertificate", 2) &&
		    strncasecmp(dd, "CrossCertificatePair", 2) && (cmd == REMOVE))) {
			fprintf(stderr, "\n");
			fprintf(stderr, "Wrong Attribute Type!\n");
			if(dd){
				free(dd);
				dd = CNULL;
			}
			goto attrtype;
		}
	}
#endif
#ifdef AFDBFILE
	if(!af_x500 || !x500){
		if((strncasecmp(dd, "Certificate", 2) && strncasecmp(dd, "CrossCertificatePair", 2) && 
		    strncasecmp(dd, "RevocationList", 1) && (cmd == ENTER || cmd == RETRIEVE)) ||
		   (strncasecmp(dd, "Certificate", 2) && strncasecmp(dd, "CrossCertificatePair", 2) && 
		    (cmd == REMOVE))) {
			fprintf(stderr, "\n");
			fprintf(stderr, "Wrong Attribute Type!\n");
			if(dd){
				free(dd);
				dd = CNULL;
			}
			goto attrtype;
		}
	}    
#endif
	fprintf(stderr, "\n");

	return(dd);
}


/***************************************************************
 *
 * Procedure storeinfo
 *
 ***************************************************************/
static int storeinfo()
{
	int  select;

	if(!interactive) return(0);
selection:
	fprintf(stderr, "\n\n");
        fprintf(stderr, " Where shall the certificate be stored:\n\n");
	fprintf(stderr, "       P[SE]\n");
	fprintf(stderr, "       F[ile]\n\n");
	fprintf(stderr, " [CR for NO STORAGE]:  ");
        aux_fgets((char *)0, answ, sizeof(answ), stderr, stdin);
       	if(strlen(answ) == 0) return(0);

	if(! strncasecmp(answ, "PSE", 1)) select = 1;
	else if (! strncasecmp(answ, "File", 1)) select = 2;
	else {
		fprintf(stderr, "\n");
		fprintf(stderr, " Wrong selection!\n");
		goto selection;
	}

	return(select);
}


/***************************************************************
 *
 * Procedure object
 *
 ***************************************************************/
static Key *object()
{
        char *dd;
	char *proc = "object";
	Key  *newkey;
	KeyRef keyref;


        keyref = 0;
        if(!(dd = nxtpar(CNULL))) {
		if(!interactive) return((Key *)0);
                sprintf(prompt, "Name or keyref: ");
		aux_fgets(prompt, answ, sizeof(answ), stderr, stdin);
                dd = aux_cpy_String(answ);
        }
        if(strlen(dd) == 0) keyref = -1;
        else sscanf(dd, "%d", &keyref);

	newkey = (Key *)calloc(1, sizeof(Key));
	if(!newkey) return(newkey);

        if(keyref != 0) {
                newkey->pse_sel = (PSESel *)0;
                newkey->keyref = keyref;
		free(dd);
        }
        else {
                newkey->pse_sel = aux_cpy_PSESel(&std_pse);
		if(newkey->pse_sel->object.name) free(newkey->pse_sel->object.name);
                newkey->pse_sel->object.name = dd;
                newkey->keyref = 0;
        }
	return(newkey);
}


/***************************************************************
 *
 * Procedure nxtpar
 *
 ***************************************************************/
#ifdef __STDC__

static char *nxtpar(
	char	 *search
)

#else

static char *nxtpar(
	search
)
char	 *search;

#endif

{
        char *dd, *cc, *ret, *pp, *prm;
	char *proc = "nxtpar";

        int len_excl, len_incl, gl;
		/* len_incl: Argument-Laenge inklusive moeglicher Blanks */
		/* len_excl: Argument-Laenge ohne Blanks */
	int inword = 0;

        if(search) {
                dd = inp;
                while((dd = strchr(dd, '='))) {
                        cc = dd - 1;
                        *dd = '\0';
                        while(*cc && *cc != ' ') cc--;
                        cc++;
			ret = cc;
                        if(strncmp(search, cc, strlen(cc)) == 0) {
				*dd++ = '=';
                                pp = prm = (char *)malloc(128);
                                while (*dd && ( (*dd != ' ') || ((*dd == ' ') && inword) ) ) { 
					if (*dd == '"') {
						inword = 1 - inword;
						dd++;
					}
					else *pp++ = *dd++;
				} 
                                *pp = '\0';
				/* Remove keyword 'search' and parameter 'prm' from input line */
				while (ret < dd) {
					*ret++ = ' ';
				}
                                return(prm);
                        }
                        *dd++ = '=';
                }
                if(!strcmp(search, "pse") || !strcmp(search, "ppin")) return(CNULL);
        }
        dd = inp;
again:
        while(*dd && *dd == ' ') dd++;
        if(*dd) ret = dd;
        else return(CNULL);
        gl = FALSE;
	while (*dd && ( (*dd != ' ') || ((*dd == ' ') && inword) ) ) {
		if (*dd == '"') inword = 1 - inword;
                if ((*dd == '=') && !inword) gl = TRUE;
                dd++;
        }
        if (gl) goto again;
	len_incl = dd - ret;   
	if (*ret == '"') len_excl = dd - ret - 2;  /* Blanks vorne und hinten */ 
        else len_excl = len_incl;
        cc = (char *)malloc(len_excl+1);
 	if( !cc ) {
		aux_add_error(EMALLOC, "cc", CNULL, 0, proc);
		fprintf(stderr, "Can't allocate memory\n");
		return(CNULL);
	}
	if (*ret == '"') strncpy(cc, ret+1, len_excl);
        else strncpy(cc, ret, len_excl);
        cc[len_excl] = '\0';
        dd = ret;
        while (len_incl) {
                *dd++ = ' ';
                len_incl--;
        }
        return(cc);
}




/***************************************************************
 *
 * Procedure compose_CertificatePair
 *
 ***************************************************************/
static CertificatePair *compose_CertificatePair()
{
	CertificatePair *cpair;
	OctetString     *ostr, octetstring;
	ObjId    	 object_oid;
	char            *proc = "compose_CertificatePair";

	if ( !(cpair = (CertificatePair *)malloc(sizeof(CertificatePair))) ) {
		aux_add_error(EMALLOC, "cpair", CNULL, 0, proc);
		return ((CertificatePair *)0);
	}
	cpair->forward = (Certificate *)0;
	cpair->reverse = (Certificate *)0;
	fprintf(stderr, "Composing the CrossCertificatePair...\n");

	fprintf(stderr, " PSE object containing forward certificate:\n");
	psesel(1);
	if (std_pse.object.name) {
		ostr = &octetstring;
		if(sec_read_PSE(&std_pse, &object_oid, ostr) < 0) {
			aux_add_error(EINVALID, "sec_read_PSE failed", (char *)&std_pse, PSESel_n, proc);
			return ((CertificatePair *)0);
		}
		if(aux_cmp_ObjId(&object_oid, SignCert_OID) && aux_cmp_ObjId(&object_oid, EncCert_OID) && aux_cmp_ObjId(&object_oid, Cert_OID)) { 
			aux_add_error(EINVALID, "Selected object on PSE is no certificate", (char *)&std_pse, PSESel_n, proc);
			free(ostr->octets);
			aux_free2_ObjId(&object_oid);
			return ((CertificatePair *)0);
                }	
		aux_free2_ObjId(&object_oid);
		if(!(cpair->forward = d_Certificate(ostr))) {
			aux_add_error(EDECODE, "Cannot decode forward certificate", CNULL, 0, proc);
			free(ostr->octets);
			return ((CertificatePair *)0);
                }
		free(std_pse.object.name);	
		free(ostr->octets);
	}

	fprintf(stderr, " PSE object containing reverse certificate:\n");
	psesel(1);
	if (std_pse.object.name) {
		ostr = &octetstring;
		if(sec_read_PSE(&std_pse, &object_oid, ostr) < 0) {
			aux_add_error(EINVALID, "sec_read_PSE failed", (char *)&std_pse, PSESel_n, proc);
			return ((CertificatePair *)0);
		}
		if(aux_cmp_ObjId(&object_oid, SignCert_OID) && aux_cmp_ObjId(&object_oid, EncCert_OID) && aux_cmp_ObjId(&object_oid, Cert_OID)) { 
			aux_add_error(EINVALID, "Selected object on PSE is no certificate", (char *)&std_pse, PSESel_n, proc);
			aux_free2_ObjId(&object_oid);
			free(ostr->octets);
			return ((CertificatePair *)0);
                }
		aux_free2_ObjId(&object_oid);
		if(!(cpair->reverse = d_Certificate(ostr))) {
			aux_add_error(EDECODE, "Cannot decode reverse certificate", CNULL, 0, proc);
			free(ostr->octets);
			return ((CertificatePair *)0);
                } 
		free(std_pse.object.name);   
		free(ostr->octets);
	}

	if (!cpair->forward && !cpair->reverse) {
		aux_add_error(EINVALID, "At least one component (forward or reverse) must be present", CNULL, 0, proc);
		return ((CertificatePair *)0);
	}

	return (cpair);
}



/* specify_CertificatePair() creates a CrossCertificatePair whose components
   (forward and reverse certificate) do only comprise a serial number and
   an issuer's distinguished name; this "incomplete" CrossCertificatePair
   universally identifies one "complete" CrossCertificatePair and is used to
   select that CrossCertificatePair by comparison */

 
/***************************************************************
 *
 * Procedure specify_CertificatePair
 *
 ***************************************************************/
static CertificatePair * specify_CertificatePair()
{
	CertificatePair * cpair;
	char            * dd, * ptr;
	OctetString	* serial;
	DName	        * issuer_dn;

	char 		* proc = "specify_CertificatePair";


	cpair = (CertificatePair *)malloc(sizeof(CertificatePair));
	if(! cpair){
		aux_add_error(EMALLOC, "cpair", CNULL, 0, proc);
		return ((CertificatePair *)0);
	}

	if (!(dd = nxtpar("for"))){
		fprintf(stderr, "Identify  F O R W A R D  certificate:\n");
		fprintf(stderr, "   (if forward certificate shall be empty, type CR when asked for serial number)\n\n");
		serial = getserial();
               	if(! serial) cpair->forward = (Certificate *)0;
		else{
			fprintf(stderr, "   ");
			issuer_dn = getdname("Issuer");
			if(! issuer_dn){
				aux_add_error(EINVALID, "Forward certificate insufficiently specified", CNULL, 0, proc);
				return ((CertificatePair *)0);
			}
			cpair->forward = (Certificate *)calloc(1, sizeof(Certificate));
			if( !cpair->forward ) {
				aux_add_error(EMALLOC, "cpair->forward", CNULL, 0, proc);
				return ((CertificatePair *)0);
			}
			cpair->forward->tbs = (ToBeSigned *)calloc(1, sizeof(ToBeSigned));
			if( !cpair->forward->tbs ) {
				aux_add_error(EMALLOC, "cpair->forward->tbs", CNULL, 0, proc);
				return ((CertificatePair *)0);
			}
			cpair->forward->tbs->serialnumber = aux_cpy_OctetString(serial);
			cpair->forward->tbs->issuer = aux_cpy_DName(issuer_dn);
			aux_free_DName(&issuer_dn);
			aux_free_OctetString(& serial);
		}
	}
	else {
		ptr = strchr( dd, ',' );
		if(! ptr){
			aux_add_error(EINVALID, "Forward certificate insufficiently specified", CNULL, 0, proc);
			return ((CertificatePair *)0);
		}
		cpair->forward = (Certificate *)calloc(1, sizeof(Certificate));
		if(! cpair->forward) {
			aux_add_error(EMALLOC, "cpair->forward", CNULL, 0, proc);
			return ((CertificatePair *)0);
		}
		cpair->forward->tbs = (ToBeSigned *)calloc(1, sizeof(ToBeSigned));
		if(! cpair->forward->tbs) {
			aux_add_error(EMALLOC, "cpair->forward->tbs", CNULL, 0, proc);
			return ((CertificatePair *)0);
		}
		*ptr = '\0';
		cpair->forward->tbs->serialnumber = aux_create_SerialNo(dd);
		if(! cpair->forward->tbs->serialnumber) incorrectSerialNumber();
		ptr++;
		cpair->forward->tbs->issuer = aux_alias2DName(ptr);
		if (! cpair->forward->tbs->issuer) incorrectName();
		free(dd);
	}

	if (!(dd = nxtpar("rev"))){
		fprintf(stderr, "\n");
		fprintf(stderr, "Identify  R E V E R S E  certificate:\n");
		fprintf(stderr, "   (if reverse certificate shall be empty, type CR when asked for serial number)\n\n");
		serial = getserial();
               	if(! serial) 
			cpair->reverse = (Certificate *)0;
		else{
			fprintf(stderr, "   ");
			issuer_dn = getdname("Issuer");
			if(! issuer_dn){
				aux_add_error(EINVALID, "Reverse certificate insufficiently specified", CNULL, 0, proc);
				return ((CertificatePair *)0);
			}
			cpair->reverse = (Certificate *)calloc(1, sizeof(Certificate));
			if( !cpair->reverse ) {
				aux_add_error(EMALLOC, "cpair->reverse", CNULL, 0, proc);
				return ((CertificatePair *)0);
			}
			cpair->reverse->tbs = (ToBeSigned *)calloc(1, sizeof(ToBeSigned));
			if( !cpair->reverse->tbs ) {
				aux_add_error(EMALLOC, "cpair->reverse->tbs", CNULL, 0, proc);
				return ((CertificatePair *)0);
			}
			cpair->reverse->tbs->serialnumber = aux_cpy_OctetString(serial);
			cpair->reverse->tbs->issuer = aux_cpy_DName(issuer_dn);
			aux_free_DName(&issuer_dn);
			aux_free_OctetString(& serial);
		}
	}
	else {
		ptr = strchr( dd, ',' );
		if(! ptr) {
			aux_add_error(EINVALID, "Reverse certificate insufficiently specified", CNULL, 0, proc);
			return ((CertificatePair *)0);
		}
		cpair->reverse = (Certificate *)calloc(1, sizeof(Certificate));
		if(! cpair->reverse) {
			aux_add_error(EMALLOC, "cpair->reverse", CNULL, 0, proc);
			return ((CertificatePair *)0);
		}
		cpair->reverse->tbs = (ToBeSigned *)calloc(1, sizeof(ToBeSigned));
		if(! cpair->reverse->tbs) {
			aux_add_error(EMALLOC, "cpair->reverse->tbs", CNULL, 0, proc);
			return ((CertificatePair *)0);
		}
		*ptr = '\0';
		cpair->reverse->tbs->serialnumber = aux_create_SerialNo(dd);
		if(! cpair->reverse->tbs->serialnumber) incorrectSerialNumber();
		ptr++;
		cpair->reverse->tbs->issuer = aux_alias2DName(ptr);
		if (! cpair->reverse->tbs->issuer) incorrectName();
		free(dd);
	}

	return (cpair);
}


/***************************************************************
 *
 * Procedure incorrectName
 *
 ***************************************************************/
static int incorrectName()
{
	fprintf(stderr, "Don't understand. Printable DName format required.\n");
	return(0);
}


/***************************************************************
 *
 * Procedure incorrectSerialNumber
 *
 ***************************************************************/
static int incorrectSerialNumber()
{
	fprintf(stderr, "Don't understand. String with hexadecimal digits required.\n");
	return(0);
}


/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static void usage(
	int	  help
)

#else

static void usage(
	help
)
int	  help;

#endif

{

	if(help == LONG_HELP) {
		aux_fprint_version(stderr);

		fprintf(stderr, "psemaint: Maintain PSE\n\n\n");
		fprintf(stderr, "Description:\n\n"); 
		fprintf(stderr, "'psemaint' is a maintenance program which can be used by both\n");
		fprintf(stderr, "certification authority administrators and users for the purpose\n");
		fprintf(stderr, "of maintaining their PSEs. This includes moving information (e.g. keys,\n");
		fprintf(stderr, "certificates, revocation lists etc.) from Unix files or a X.500 Directory\n");
		fprintf(stderr, "into the PSE and vice versa, generating keys, changing PINs and displaying\n"); 
		fprintf(stderr, "the content of the PSE.\n\n\n");
	}

        fprintf(stderr, "usage:\n\n");
#ifdef X500
#ifdef SCA
	fprintf(stderr, "psemaint [-hzvCFRDOVWXYT]\n");
#else
	fprintf(stderr, "psemaint [-hzvCFRDOVWXY]\n");
#endif
	fprintf(stderr, "         [-p <pse>] [-c <cadir>]\n");
	fprintf(stderr, "         [-a <issueralg>] [-f <notbefore>] [-l <notafter>]\n");
	fprintf(stderr, "         [-d <dsa name>] [-t <dsaptailor>] [-A <authlevel>]\n");
	fprintf(stderr, "         [-i <inputfile>] [cmd]\n");
#else 
#ifdef SCA
	fprintf(stderr, "psemaint [-hzvCFRDOVWXYT]\n");
#else
	fprintf(stderr, "psemaint [-hzvCFRDOVWXY]\n");
#endif
	fprintf(stderr, "         [-p <pse>] [-c <cadir>]\n");
	fprintf(stderr, "         [-a <issueralg>] [-f <notbefore>] [-l <notafter>]\n");
	fprintf(stderr, "         [-i <inputfile>] [cmd]\n");
#endif   

        if(help == LONG_HELP) {

        fprintf(stderr, "with:\n\n");
        fprintf(stderr, "-p <psename>        PSE name (default: environment variable PSE or %s)\n", DEF_PSE);
        fprintf(stderr, "-c <cadir>          Name of CA-directory (default: environment variable CADIR or %s)\n", DEF_CADIR);
	fprintf(stderr, "-i <inputfile>      Scriptfile containing the commands to be executed by 'psemaint'\n");
	fprintf(stderr, "-a <issueralg>      CA's signature algorithm (default: md2WithRsaEncryption)\n");
	fprintf(stderr, "-f <notbefore>      First date on which the certificate is valid\n");
	fprintf(stderr, "                    (evaluated by 'cacertify' command within 'psemaint')\n");
	fprintf(stderr, "-l <notafter>       Last date on which the certificate is valid\n");
	fprintf(stderr, "                    (evaluated by 'cacertify' command within 'psemaint')\n");
	fprintf(stderr, "-F                  consider own FCPath as trusted\n");
	fprintf(stderr, "-O                  RFC 1422 DName subordination not required\n");
	fprintf(stderr, "-R                  consult revocation lists during verification\n");
	fprintf(stderr, "-C                  show list of commands available with 'psemaint'\n");
	fprintf(stderr, "-D                  access Directory (X.500 or AF_DB)\n");
#ifdef SCA
        fprintf(stderr, "-T                  perform each public key RSA operation in the smartcard  terminal\n");
        fprintf(stderr, "                    instead of employing the software in the workstation (the latter is the default)\n");
#endif
        fprintf(stderr, "-h                  write this help text\n");
	fprintf(stderr, "-z                  control malloc/free behaviour\n");
        fprintf(stderr, "-v                  verbose\n");
        fprintf(stderr, "-V                  Verbose\n");
        fprintf(stderr, "-W                  Grand Verbose (for testing only)\n");
        fprintf(stderr, "-X                  Read random number generator seed from PSE-object Random\n");
        fprintf(stderr, "-Y                  Init random number generator seed through keyboard input\n");
#ifdef X500
	fprintf(stderr, "-d <dsa name>       Name of the DSA to be initially accessed (default: locally configured DSA)\n");
	fprintf(stderr, "-t <dsaptailor>     Location of dsaptailor file (default: dsaptailor in the ISODE ETCDIR directory)\n");
	fprintf(stderr, "-A <authlevel>      Level of authentication used for X.500 Directory access\n");
	fprintf(stderr, "                    <authlevel> may have one of the values 'SIMPLE' or 'STRONG'\n");
	fprintf(stderr, "                    (default: environment variable AUTHLEVEL or 'No authentication')\n");
	fprintf(stderr, "                    STRONG implies the use of signed DAP operations\n");
#endif
	fprintf(stderr, "<cmd>               Single command that shall be executed by 'psemaint'\n");
	fprintf(stderr, "                    (otherwise, commands can be provided interactively\n");
 	fprintf(stderr, "                    or are read from file <inputfile> (see option -i))\n");
        }

        if(MF_check) MF_fprint(stderr);

        exit(-1);                                /* IRREGULAR EXIT FROM PSEMAINT */
}


/***************************************************************
 *
 * Procedure store_certificate
 *
 ***************************************************************/
#ifdef __STDC__

static RC store_certificate(
	Certificate	 *cert,
	Boolean		  onekeyonly
)

#else

static RC store_certificate(
	cert,
	onekeyonly
)
Certificate	 *cert;
Boolean		  onekeyonly;

#endif

{
	static OctetString * ostr;
	static int i, rcode;
	static ObjId * oid;

	if(! cert){
		fprintf(stderr,"No certificate provided\n");
		return(- 1);
	}

	i = storeinfo();
	if (i != 1 && i != 2) return(- 1);

	ostr = e_Certificate(cert);
	if (! ostr) {
		fprintf(stderr,"Can't encode certificate\n");
		return(- 1);
	}

	if(i == 1){
		psesel(2);
		if(onekeyonly == TRUE) oid = af_get_objoid(Cert_name);
		else{
			keytype();
			if(*objtype == 'S') oid = af_get_objoid(SignCert_name);
			else if(*objtype == 'E') oid = af_get_objoid(EncCert_name);
			else {
				fprintf(stderr, "Type must me either 'S' or 'E'\n");
				return(- 1);
			}
		}
		rcode = 0;
		if(sec_open(&std_pse) < 0) rcode = sec_create(&std_pse);
		if(!rcode) {
			rcode = sec_write_PSE(&std_pse, oid, ostr);
			if(rcode) {
				fprintf(stderr,"Can't write to PSE\n");
				return(- 1);
			}
		} 
		else {
			fprintf(stderr,"Can't create PSE\n");
			return(- 1);
		}
		fprintf(stderr, "Specified certificate stored in object <%s> on PSE.\n", std_pse.object.name);
	}
	else {
		filen(CNULL);
		if(printfile(ostr, filename) < 0) {
			fprintf(stderr,"Can't write file\n");
			return(- 1);
		}

	}

	aux_free_OctetString(&ostr);
	aux_free_Certificate(&cert);

	return(0);
}



