#!/bin/csh -f -e

# $Id: inst_pse.sh,v 1.6 1995/03/06 16:24:04 koletzki Exp $

# $Log: inst_pse.sh,v $
 
#
#  
#
# inst_pse - installs a PSE which was previously generated with gen_pse

umask 0077
set cadir = $1			# CA directory
set secudebin =  $2		# SecuDE directory


if ( "$1" == "" || "$2" == "" ) then
	echo "ERROR: missing parameter"
	echo "       Syntax is: inst_pse <CA directory> <SecuDE directory>"
	exit
endif
	
#

#
# Check existance of SecuDE utilities (decode / psemaint)
#
if ( !(-r $secudebin/psemaint) || !(-r $secudebin/decode) ) then
	echo "ERROR: Can't find SecuDE utilities"
	echo "       Please check parameters"
	echo "       or contact your system manager"
	exit
endif


#
# get username (UNIX userid)
#
if ( $?LOGNAME != 0 ) then
	if ( "$LOGNAME" != "" ) then
        	set username=$LOGNAME
	else 
        	set username=$USER
	endif
else
        set username=$USER
endif



#
# get usertarpse = name of tarfile generated with gen_pse
#		   This tarfile contains the PSE of the user
#
set usertarpse = $cadir/genpse/$username

if ( !(-r $usertarpse) ) then
	echo "ERROR: No PSE generated for user $username"
	echo "       Please contact system manager"
	exit
endif


#
# Request transport PIN from user and set the env. var. USERPIN
#

echo Please enter transport PIN
#switch off echo tty
stty -echo
set userpin = $<
#switch on echo
stty echo
#check userpin (nicht leer, nicht > 8)
setenv USERPIN $userpin


#
# get name of user PSE
#
set userpsedir = `$secudebin/decode -r <"$usertarpse" | uncompress | tar tf - | line`
#result?
set userpse = `basename $userpsedir`



#
# goto HOME-directory of user
#
cd ~


#
# if userpse already exists, existing PSE is moved to userpse.BAK 
# (an existing userpse.BAK is removed)                          
#
if ( -f $userpse || -d $userpse ) then
	if ( -f $userpse.BAK || -d $userpse.BAK ) then
       		rm -rf $userpse.BAK
	endif

        mv $userpse $userpse.BAK
endif



#
# Transform encoded and compressed tar-file to a PSE (stored under the HOME-Dir)
#
$secudebin/decode -r <"$usertarpse" | uncompress | ( cd ~; tar xf - )


#
# Get PKList from CA
#
if (-f $cadir/genpse/PKList) then
	$secudebin/psemaint -p $userpse write  PKList $cadir/genpse/PKList 
endif 


#
# User should change the transport PIN
#
echo Please change the transport PIN to your personal PIN.
$secudebin/psemaint -p $userpse chpin

#
# User PSE has been installed
#
echo PSE $HOME/$userpse installed.
