#!/bin/csh -f -e

# $Id: inst_ca.sh,v 1.4 1994/11/02 10:44:39 surkau Exp $

# $Log: inst_ca.sh,v $
 
#
#  
#
# inst_pse - installs a CA directory which was previously generated with gen_pse

umask 0077

if ( "$1" != "" ) then
        set dir=`decode -r <"$1" | uncompress | tar tf - | line`
else
        echo Error: file argument missing
        exit
endif
echo $dir
if ( -f ~/$dir || -d ~/$dir ) then
        echo $dir exists already in the home directory
        echo -n Overwrite \? \(y/n\)': '
        set answer=$<
        if ( "$answer" != "y" ) then
                echo $dir unchanged
                exit
        endif
        rm -rf ~/$dir
endif

decode -r <"$1" | uncompress | ( cd ~; tar xvf - )

echo CA directory $dir installed in the home directory. 
echo Now change the transport PIN to your personal PIN
psemaint -c $dir challpin
