/* ./src/util/alias.c */

static char *rcsid = "$Id: alias.c,v 1.4 1994/11/02 16:38:51 schneiw Exp $";

/* 
 *
 * $Id: alias.c,v 1.4 1994/11/02 16:38:51 schneiw Exp $
 *
 * $Log: alias.c,v $
 *
 */
 
/*
 *  
 */

/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include <stdio.h>
#include "af.h"

#ifdef MS_DOS
#include <fcntl.h>
#endif

int             verbose = 0;

#ifdef __STDC__
static void     usage(int help);
#else
static void     usage();
#endif


/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	**parm
)

#else

int main(
	cnt,
	parm
)
int	  cnt;
char	**parm;

#endif

{
	char 			* proc = "main (alias)";
	int             opt;


#ifdef MS_DOS
	_fmode = O_BINARY;
#endif

	MF_check = FALSE;

nextopt:
	while ( (opt = getopt(cnt, parm, "hvzVW")) != -1 ) { 
		switch(opt) {
		case 'v':
			verbose = 1;
			continue;
		case 'V':
			verbose = 2;
			continue;
		case 'W':
			verbose = 2;
			af_verbose = TRUE;
			sec_verbose = TRUE;
			continue;
		case 'z':
			MF_check = TRUE;
			continue;
		case 'h':
			usage(LONG_HELP);
			continue;
		default:
		case '?':
			usage(SHORT_HELP);
		}
	}


        if(optind < cnt) {
		if(ostr){
			fprintf(stderr, "Input-file already specified!\n");
			exit(- 1);
		}
		file = parm[optind];
		ostr = aux_file2OctetString(file);
		optind++;
		goto nextopt;
	}
}



/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
#ifdef __STDC__

static void usage(
	int	  help
)

#else

static void usage(
	help
)
int	  help;

#endif

{
	aux_fprint_version(stderr);

        fprintf(stderr, "alias  Show aliases/name to the given name \n\n");
        fprintf(stderr, "usage:\n\n");
	fprintf(stderr,"alias [-] [name]\n\n");
 

        if(help == LONG_HELP) {
        	fprintf(stderr, "with:\n\n");
        	fprintf(stderr, "-h               write this help text\n");
        	fprintf(stderr, "-m               Show mail address\n");
        	fprintf(stderr, "-x               Show X.400 address\n");
        	fprintf(stderr, "-f               Show first alias\n");
        	fprintf(stderr, "-a               Show aliases\n");
		fprintf(stderr, "-d               Show dname\n");
		fprintf(stderr, "-s               Additionally search for aliases\n");
		fprintf(stderr, "                 that contains name as a substring.\n");
        	fprintf(stderr, "-p <psename>     PSE name (default: %s)\n", DEF_PSE);
        	fprintf(stderr, "-c <cadir>       name of CA-directory (default: %s)\n", DEF_CADIR);
		fprintf(stderr, "-U               Only search in user alias list\n");
		fprintf(stderr, "-S               Only search in system alias list\n");
		fprintf(stderr, "-l               Do not verify system alias list\n");

        }


        exit(-1);                                /* IRREGULAR EXIT FROM ALIAS */
}
