/* ./src/secure/starcos_man.c */

static char *rcsid = "$Id: starcos_man.c,v 1.4 1994/12/08 14:30:07 viebeg Exp $";

/* 
 *
 * $Id: starcos_man.c,v 1.4 1994/12/08 14:30:07 viebeg Exp $
 *
 * $Log: starcos_man.c,v $
 *
 */
 
/***************************************************************************
  *                                                                        *
  *  Install.c       1.1                  			Date: 9/94 *
  *                                                                        *
  *  Extrakt nur fuer pse-Umgebung                                         *
  *                                                                        *
  *                                                                        *
  *  Error-Handling:                rc=0	ok                         *
  *                                 rc=-1	error   see sca_errno      *
  *                                                                        *
  *                                 sca_errno=150	no *.icf           *
  *                                 sca_errno=151	no *.acf           *
  *                                           else	set by starmod     *
  *                                                                        *
  **************************************************************************/

#include "sec_config.h"

#include	<stdio.h>
#include	<string.h>

#ifdef SCA

#include	"starcos_man.h"

#ifdef __STDC__
static int      inst_Steuer     (int wInput, char *acString);
static int      inst_Lesen      (char *acName, p_Cmd **pCmd);
static int      inst_Gen        (char *acText, p_Cmd **pCmd);
static int      inst_Vorlauf    (p_Cmd *CmdList);
static int      inst_Exe        (p_Cmd *CmdList);
static p_Cmd    *alloc_pCmd     ();
static int      i_isf_units     (int no_des);
static int      i_xef_units     (int no_rsa);
static int      i_wef_units     ();
static int 	i_open_acf 	(char *name);
static int	i_ReadRecord    (FILE *fp, OctetString *pOstr);
static int      i_return        (int rc);
static int      i_errno 	();
#else
static int      inst_Steuer     ();
static int      inst_Lesen      ();
static int      inst_Gen        ();
static int      inst_Vorlauf    ();
static int      inst_Exe        ();
static p_Cmd    *alloc_pCmd     ();
static int      i_isf_units     ();
static int      i_xef_units     ();
static int      i_wef_units     ();
static int 	i_open_acf 	();
static int	i_ReadRecord    ();
static int      i_return        ();
static int      i_errno 	();
#endif


extern int      sca_auth ();
extern int      sca_close_file ();
extern int      sca_create_file ();
extern int      sca_delete_file ();
extern int      sca_gen_dev_key ();
extern int      sca_inst_dev_key ();
extern int      sca_inst_verification_data ();
extern int      sca_register ();
extern int      sca_select_file ();
extern int      sca_verify_pin ();
extern int      sca_write_binary ();
extern int      sca_write_record ();

extern unsigned int sca_errno;	/* error number set by STARMOD and install.c*/
extern char     *sca_errmsg;

/***************************************************************************
  *                                                                        *
  *  global Declarations                                                   *
  *                                                                        *
  **************************************************************************/

        FILE    	*g_fp;

        char    	g_acbuf [32];

	int		g_sct_id;
        char    	g_acPin [9];
        char    	g_acPuk [9];
        char    	g_pse_pin [9];

	OctetString	g_pse_os;
	OctetString	*g_appl_id;
	char		g_appl_MF [2]	= {0x3F, 0x00};
	char		g_xdata [3]	= {0x00, 0x03, 0x00};
	char		g_addinfo [4]	= {0x00, 0x00, 0x00, 0x00};

	int		g_isf_units;
	int		g_xef_units;
	int		g_wef_units	= 0;
	Boolean		g_close_MF 	= TRUE;		/* used during the installtion of an MF */
							/* TRUE means the MF shall be closed 	*/
	Boolean		g_create_DF	= FALSE;


	int		g_errno		= 0;	
	char		*g_errmsg	= CNULL;	

/***************************************************************
 *
 * Procedure inst_pse
 *
 ***************************************************************/
#ifdef __STDC__

int inst_pse(
	int		  sct_id,
	OctetString	 *appl_id,
	int		  n_des,
	int		  n_rsa,
	char		 *pin,
	char		 *puk,
	char		 *pse_pin
)

#else

int inst_pse(
	sct_id,
	appl_id,
	n_des,
	n_rsa,
	pin,
	puk,
	pse_pin
)
int		  sct_id;
OctetString	 *appl_id;
int		  n_des;
int		  n_rsa;
char		 *pin;
char		 *puk;
char		 *pse_pin;

#endif

{
	int		rc;
	char		acf_filename[256];
	char		icf_filename[256];

	strcpy(acf_filename, SCMANDIR);
	strcat(acf_filename, "pse.acf");

	rc	= i_open_acf	(acf_filename);
	if	(rc != 0)	return	(rc);	/* file *.acf not found	*/

	g_sct_id	= sct_id;
	g_appl_id	= appl_id;

	strcpy		(g_acPin, pin);
	strcpy		(g_acPuk, puk);
	strcpy		(g_pse_pin, pse_pin);
	
	g_pse_os.octets	= g_pse_pin;
	g_pse_os.noctets= strlen (g_pse_pin);

	g_isf_units	= i_isf_units	(n_des);
	g_xef_units	= i_xef_units	(n_rsa);


	strcpy(icf_filename, SCMANDIR);
	strcat(icf_filename, "pse.icf");

	rc	= inst_Steuer (0, icf_filename);

	return (rc);
}


/***************************************************************
 *
 * Procedure inst_MF
 *
 ***************************************************************/
#ifdef __STDC__

int inst_MF(
	int	  sct_id,
	Boolean	  close
)

#else

int inst_MF(
	sct_id,
	close
)
int	  sct_id;
Boolean	  close;

#endif

{
	int		rc;
	OctetString	appl_os;
	char		acf_filename[256];
	char		icf_filename[256];

	strcpy(acf_filename, SCMANDIR);
	strcat(acf_filename, "gmd.acf");
	
	rc	= i_open_acf	(acf_filename); 
        if	(rc != 0)	return (rc);	/* file *.acf not found	*/
	appl_os.octets	= g_appl_MF;
	appl_os.noctets	= 2;
	g_appl_id	= &appl_os;
	g_sct_id	= sct_id;

	strcpy(icf_filename, SCMANDIR);
	strcat(icf_filename, "gmd.icf");
	
	g_close_MF = close;

	rc	= inst_Steuer (0, icf_filename);

	g_close_MF = TRUE;
	return (rc);
}






/***************************************************************
 *
 * Procedure close_MF
 *
 ***************************************************************/
#ifdef __STDC__

int close_MF(
	int		  sct_id
)

#else

int close_MF(
	sct_id
)
int		  sct_id;

#endif

{
	int		rc;
	OctetString	appl_os;
	FileSel		file_sel;
	ICC_SecMess	sec_mess;



	appl_os.octets	= g_appl_MF;
	appl_os.noctets	= 2;
	g_appl_id	= &appl_os;
	file_sel.file_name = g_appl_id;
	sec_mess.command = ICC_SEC_NORMAL;
	sec_mess.response = ICC_SEC_NORMAL;

        rc = sca_close_file  (sct_id, 
			      MF, 
			      &file_sel,
			      CLOSE_CREATE,
			      &sec_mess);
	g_close_MF = TRUE;
	return (rc);
}


/***************************************************************
 *
 * Procedure del_MF
 *
 ***************************************************************/
#ifdef __STDC__

int del_MF(
	int	  sct_id
)

#else

int del_MF(
	sct_id
)
int	  sct_id;

#endif

{
 	int		rc;
	OctetString	appl_os;

	appl_os.octets	= g_appl_MF;
	appl_os.noctets	= 2;
	g_appl_id	= &appl_os;
	g_sct_id	= sct_id;

        rc	= inst_Steuer (1, "D");
	return (rc);
}


/***************************************************************
 *
 * Procedure del_pse
 *
 ***************************************************************/
#ifdef __STDC__

int del_pse(
	int		  sct_id,
	Boolean		  select,
	OctetString	 *appl_id
)

#else

int del_pse(
	sct_id,
	select,
	appl_id
)
int		  sct_id;
Boolean		  select;
OctetString	 *appl_id;

#endif

{
	int	rc;

	g_sct_id	= sct_id;
	g_appl_id	= appl_id;

 	if	(select == TRUE)	rc = inst_Steuer (1, "evd");
	else				rc = inst_Steuer (1, "d");
	return (rc);
}


/***************************************************************
 *
 * Procedure inst_Steuer
 *
 ***************************************************************/
#ifdef __STDC__

static int inst_Steuer(
	int	  wInput,
	char	 *acString
)

#else

static int inst_Steuer(
	wInput,
	acString
)
int	  wInput;
char	 *acString;

#endif

{
        p_Cmd   *First;
        p_Cmd   *CmdList;
	int	wReturn;

	if	(wInput == 0)
		wReturn	=	inst_Lesen	(acString, &CmdList);	/* read from file  */
	else	wReturn	=	inst_Gen	(acString, &CmdList);	/* get from string */

	if	(wReturn != 0)	return (-1);

        First	= CmdList; 	
        while   (CmdList != NULL)
                {
                wReturn = inst_Vorlauf (CmdList);
                CmdList = CmdList->next;
                }
	if	(wReturn != 0)	return (-1);

	wReturn = sca_activate_devkeyset	(g_sct_id, NULL, INITKEY);
	if	(wReturn != 0)	return (-1);


        CmdList = First;
        while   (CmdList != NULL)
                {
                wReturn = inst_Exe (CmdList);
                CmdList = CmdList->next;

		if      (wReturn != 0)
                        {
			if	((g_create_DF == TRUE) ||
				 (g_errno == ESPACE) || 
			 	 (g_errno == EFILE_ALREADY))	
			{
				CmdList	= NULL;
				g_create_DF = FALSE;
			}

                        while   ((CmdList != NULL) &&
                                 (CmdList->action != 'o') &&
                                 (CmdList->action != 's'))
                                CmdList = CmdList->next;
                        }
                }

	return (i_errno ());
}


/***************************************************************
 *
 * Procedure inst_Lesen
 *
 ***************************************************************/
#ifdef __STDC__

static int inst_Lesen(
	char	 *acName,
	p_Cmd	**pCmd
)

#else

static int inst_Lesen(
	acName,
	pCmd
)
char	 *acName;
p_Cmd	**pCmd;

#endif

{
        FILE    *fp;
        int     i;
        char    c;
        p_Cmd   *CmdList	= NULL;

        u_Cmd   CmdAkt;
	char	err_msg[256];


	fp	= fopen	(acName, "r");
	if	(fp == NULL)	{
				sca_errno = 150;	/* file *.icf not found	*/ 
				sprintf(err_msg, "STARCOS management file '%s' not found", acName);
				sca_errmsg = err_msg;
				return	(-1);
				}

        CmdList = alloc_pCmd ();
	*pCmd	= CmdList;

        CmdList->action	= fgetc (fp);
        while   (feof (fp) == 0)
                {
                for     (i=0; i<LNGUNION; i++)    if (feof (fp) == 0) CmdAkt.data[i]  = fgetc (fp);
				             	
                memcpy  (CmdList->cmd->data, CmdAkt.data, LNGUNION);

                c       = fgetc (fp);
                if      (feof (fp) == 0)
                        {
                        CmdList->next   = alloc_pCmd ();
                        CmdList         = CmdList->next;
                        CmdList->action = c;
                        }
                }
 
	return (0);
}


/***************************************************************
 *
 * Procedure inst_Gen
 *
 ***************************************************************/
#ifdef __STDC__

static int inst_Gen(
	char	 *acText,
	p_Cmd	**pCmd
)

#else

static int inst_Gen(
	acText,
	pCmd
)
char	 *acText;
p_Cmd	**pCmd;

#endif

{
        char	c;
        p_Cmd   *CmdList	= NULL;

        c	= *acText++;
	if	(c == 0x00)	return (-1);
	
	CmdList = alloc_pCmd ();
	*pCmd	= CmdList;

        CmdList->action = c;
        while   (c != 0x00)
                {
      		c	= *acText++;
		if	(c != 0x00)
			{
                	CmdList->next   = alloc_pCmd ();
                	CmdList         = CmdList->next;
			CmdList->action = c;
                        }
                }
 
	return (0);
}

/***************************************************************
 *
 * Procedure inst_Vorlauf
 *
 ***************************************************************/
#ifdef __STDC__

static int inst_Vorlauf(
	p_Cmd	 *CmdList
)

#else

static int inst_Vorlauf(
	CmdList
)
p_Cmd	 *CmdList;

#endif

{
	int		wRc	= 0;
        int             i;
        int             j;
        int             wSize;
        int             wStruct;

#ifdef SECSCTEST
        printf ("Vorlauf %c\n", CmdList->action);
#endif

        switch  (CmdList->action)
        {
        case    'l':
                CmdList->cmd->sCreate.FCI.file_sel  		= &CmdList->cmd->sCreate.file_sel;
                CmdList->cmd->sCreate.FCI.file_sel->file_name 	= g_appl_id;

                CmdList->cmd->sCreate.FCI.addinfo  		= &CmdList->cmd->sCreate.add_os;
                CmdList->cmd->sCreate.FCI.addinfo->octets 	= CmdList->cmd->sCreate.addinfo;
                break;

        case    'c':
                CmdList->cmd->sCreate.FCI.file_sel  		= &CmdList->cmd->sCreate.file_sel;
                CmdList->cmd->sCreate.FCI.file_sel->file_id 	= &CmdList->cmd->sCreate.file_id;

                CmdList->cmd->sCreate.FCI.addinfo  		= &CmdList->cmd->sCreate.add_os;
		CmdList->cmd->sCreate.FCI.addinfo->octets	= CmdList->cmd->sCreate.addinfo;

		if	(CmdList->cmd->sCreate.file_id.file_type == XEF)
			{
			CmdList->cmd->sCreate.FCI.units			= g_xef_units;
			CmdList->cmd->sCreate.FCI.addinfo->octets	= g_addinfo;
			}

		if	((CmdList->cmd->sCreate.file_id.file_type == ISF) &&
			 (CmdList->cmd->sCreate.file_id.file_level != MF))
			CmdList->cmd->sCreate.FCI.units	= g_isf_units;
		break;


        case    'o':
		CmdList->cmd->sClose.file_sel.file_name		= g_appl_id;
		break;

        case    's':
                CmdList->cmd->sClose.file_sel.file_id  		= &CmdList->cmd->sClose.file_id;
                break;

        case    'e':
                CmdList->cmd->sCreate.file_cat  		= PARENT_DF;
                CmdList->cmd->sCreate.file_sel.file_name  	= g_appl_id;
		break;

        case    'd':
		CmdList->cmd->sClose.file_cat			= PARENT_DF;
		CmdList->cmd->sClose.file_sel.file_name		= g_appl_id;
		break;

        case    'D':
		CmdList->cmd->sClose.file_cat			= MF;
		CmdList->cmd->sClose.file_sel.file_name		= g_appl_id;
		break;

        case    'i':
                CmdList->cmd->sInstPin.pin.VerifyDataBody.pin_info.pin  = &CmdList->cmd->sInstPin.info_os;
                CmdList->cmd->sInstPin.pin.VerifyDataBody.pin_info.pin->noctets	= strlen (g_acPin);
                CmdList->cmd->sInstPin.pin.VerifyDataBody.pin_info.pin->octets  = g_acPin;
                break;

        case    'q':
                CmdList->cmd->sInstPin.pin.VerifyDataBody.puk_info.puk 	= &CmdList->cmd->sInstPin.info_os;
                CmdList->cmd->sInstPin.pin.VerifyDataBody.puk_info.puk->noctets = strlen (g_acPuk);
                CmdList->cmd->sInstPin.pin.VerifyDataBody.puk_info.puk->octets  = g_acPuk;

                CmdList->cmd->sInstPin.pin.VerifyDataBody.puk_info.pin_key_id 	=
									  &CmdList->cmd->sInstPin.pin_key_id;
                break;

        case    'v':
                CmdList->cmd->sInstPin.key_id.key_level		= FILE_CURRENT;
                CmdList->cmd->sInstPin.key_id.key_number	= 30;
                break;

        default :
                break;
        }
	return	(wRc);
}

/***************************************************************
 *
 * Procedure inst_Exe
 *
 ***************************************************************/

#ifdef __STDC__

static int inst_Exe(
	p_Cmd	 *CmdList
)

#else

static int inst_Exe(
	CmdList
)
p_Cmd	 *CmdList;

#endif

{
        int             wRc = 0;
	int             i, j;

        FILE            fp;
	char		*pname;

	OctetString     *p_os;
        OctetString     os_data;

	OctetString     in_os;
        BitString       out_bs;
	AccessControlValue	create_sec_status;

#ifdef SECSCTEST
        printf ("Exe     %c  ", CmdList->action);
#endif


        switch  (CmdList->action)
        {

	/*******************************************************
	 *		files
	 *******************************************************/

        case    'l':
		if	(CmdList->cmd->sCreate.file_cat != MF)
			{
			create_sec_status.compare_mode = ST_GE;
			create_sec_status.state_number = 0;

                	wRc = sca_register	(g_sct_id,
        			 CmdList->cmd->sCreate.FCI.file_sel->file_name,
                              	 CmdList->cmd->sCreate.FCI.units,
                                 create_sec_status,
                                 &CmdList->cmd->sCreate.sec_mess);

			i_return (wRc);
			if	((g_errno == ESPACE))	break;
			else	wRc	= 0;
			}
		
		g_create_DF = FALSE;
                wRc = sca_create_file	(g_sct_id,
                                 CmdList->cmd->sCreate.file_cat,
                                 CmdList->cmd->sCreate.data_struc,
                                 &CmdList->cmd->sCreate.FCI,
                                 &CmdList->cmd->sCreate.sec_mess);
		/*
		 *  if create DF was successful,
		 *    errno and errmsg set by sca_register are reset
		 */
		if 	(wRc == 0)
			{
			g_errno = 0;
			g_errmsg = CNULL;
			}
		else 
			if 	(CmdList->cmd->sCreate.file_cat == PARENT_DF)
				/*
				 * If the DF-creation is not successful,
				 *    the DF must not be closed.
				 */
				g_create_DF = TRUE;

                break;

        case    'c':
                wRc = sca_create_file	(g_sct_id,
                                 CmdList->cmd->sCreate.file_cat,
                                 CmdList->cmd->sCreate.data_struc,
                                 &CmdList->cmd->sCreate.FCI,
                                 &CmdList->cmd->sCreate.sec_mess);

                                break;

        case    'o':
        case    's':

		if	((CmdList->cmd->sCreate.file_cat == MF) &&
			 (g_close_MF == FALSE) &&
			 (CmdList->cmd->sClose.file_close_context == CLOSE_CREATE))
			break;

              	wRc = sca_close_file  (g_sct_id,
                                 CmdList->cmd->sClose.file_cat,
                               	 &CmdList->cmd->sClose.file_sel,
				 CmdList->cmd->sClose.file_close_context,
                             	 &CmdList->cmd->sCreate.sec_mess);

                                break;

        case    'e':
                wRc = sca_select_file   (g_sct_id, 
				 PARENT_DF,
                                 CmdList->cmd->sCreate.file_sel, 	
                                 NONE_INFO, 
				 NULL,
                                 &CmdList->cmd->sCreate.sec_mess);
                                break;

        case    'd':
        case    'D':
                wRc = sca_delete_file   (g_sct_id,
				 CmdList->cmd->sClose.file_cat,
                                 &CmdList->cmd->sClose.file_sel,
                                 &CmdList->cmd->sRegister.sec_mess);
                                break;


	/*******************************************************
	 *		keys
	 *******************************************************/

        case    'i':
	case	'q':
                wRc = sca_inst_verification_data      (g_sct_id,
                                 &CmdList->cmd->sInstPin.key_id,
                                 &CmdList->cmd->sInstPin.pin,
                                 &CmdList->cmd->sInstPin.key_al);
                                break;

	case	'v':
                wRc = sca_verify_pin      (g_sct_id,
                                 &CmdList->cmd->sInstPin.key_id,
                                 &CmdList->cmd->sCreate.sec_mess);
                                break;

        case    'y':
                CmdList->cmd->sGenDevKey.key_dev_sel.key_id	= &CmdList->cmd->sGenDevKey.key_id;
                CmdList->cmd->sGenDevKey.key_dev_sel.key_algid	= desCBC_ISO1;
                CmdList->cmd->sGenDevKey.appl_id.octets		= CmdList->cmd->sGenDevKey.appl_name;

                wRc = sca_gen_dev_key (g_sct_id,
                                &CmdList->cmd->sGenDevKey.key_dev_sel,
                                &CmdList->cmd->sGenDevKey.appl_id);
                               break;

        case    'h':
                CmdList->cmd->sInstDevKey.key_dev_sel.key_id	= &CmdList->cmd->sInstDevKey.key_id;
                CmdList->cmd->sInstDevKey.appl_id.octets	= CmdList->cmd->sInstDevKey.appl_name;

		if	(CmdList->cmd->sInstDevKey.key_dev_sel.key_status == DEV_OWN)

               		wRc = sca_inst_dev_key	(g_sct_id,
                                &CmdList->cmd->sInstDevKey.key_dev_sel,
				NULL,
                                &CmdList->cmd->sInstDevKey.key_al);

               		else	wRc = sca_inst_dev_key	(g_sct_id,
                                &CmdList->cmd->sInstDevKey.key_dev_sel,
				&CmdList->cmd->sInstDevKey.appl_id,
                                &CmdList->cmd->sInstDevKey.key_al);
                                break;



	/*******************************************************
	 *		data
	 *******************************************************/

        case    'f':
                wRc     = sca_write_binary  (CmdList->cmd->sWrite.sct_id,
				0,
                          	CmdList->cmd->sWrite.offset,
                                &g_pse_os,
                                &CmdList->cmd->sWrite.sec_mess,
			 	&g_pse_os.noctets);
                                break;

        case    'w':
                while   ((feof (g_fp) == 0) && (wRc == 0))
                    	{
                        i_ReadRecord (g_fp, &os_data);

                        if      (feof (g_fp) == 0)
                                {
                               	wRc = sca_write_record  (g_sct_id,
                                	0,			/* short file_id */
                                        CmdList->cmd->sWrite.data_struc,
                                        CmdList->cmd->sWrite.offset,
					REC_APPEND,
                                        &os_data,
                                        &CmdList->cmd->sWrite.sec_mess);
                                CmdList->cmd->sWrite.offset++;
                                }
                        }
                                break;

	case	'x':
                os_data.noctets	= 3;
                os_data.octets 	= g_xdata;

		wRc     = sca_write_binary  (g_sct_id,
                                  0, 0,
                                  &os_data,
                                  &CmdList->cmd->sCreate.sec_mess,
			 	  &os_data.noctets);
                                break;

         case    'u':		break;

	} /* switch ->action */

	i_return (wRc);
        return (wRc);
}


/***************************************************************
 *
 * Procedure alloc_pCmd
 *
 ***************************************************************/
#ifdef __STDC__

static p_Cmd *alloc_pCmd(
)

#else

static p_Cmd *alloc_pCmd(
)

#endif

{
p_Cmd		*pCmd;
int		i;

pCmd		= (p_Cmd *) malloc (sizeof (p_Cmd));

pCmd->cmd	= (u_Cmd *) malloc (sizeof (u_Cmd));
for 		(i=0; i<LNGUNION; i++)	pCmd->cmd->data [i] = 0x00;

pCmd->action	= 'u';
pCmd->next	= NULL;	
return (pCmd);
}


/***************************************************************
 *
 * Procedure i_isf_units
 *
 ***************************************************************/
#ifdef __STDC__

static int i_isf_units(
	int	  no_des
)

#else

static int i_isf_units(
	no_des
)
int	  no_des;

#endif

{
	int	units;	
	int	bytes	= 40;			/* pin = 8(hdr) +9(pin) +3(rid) */
						/* puk = 8(hdr) +9(puk) +3(rid) */

	no_des	= no_des + 3;			/* 3 dev_keys			*/
	bytes	= bytes + no_des * 21;		/* des = 8(hdr) +8(des) +3(rid)	*/

	units	=  bytes >> 5;			/* auffuellen auf units (32)	*/
	if	((units << 5) < bytes)	units++;

	return (units);
}



/***************************************************************
 *
 * Procedure i_xef_units
 *
 ***************************************************************/
#ifdef __STDC__

static int i_xef_units(
	int	  no_rsa
)

#else

static int i_xef_units(
	no_rsa
)
int	  no_rsa;

#endif

{
	int	units;
	int	bytes	= 0;
		
	if	(no_rsa > 0)  	
		bytes	= no_rsa * 262 + 3;		/* +3: first 3 byte	*/

	units	=  bytes >> 5;				/* auffuellen auf units	*/			
	if	((units << 5) < bytes)	units++;

	if	(units > 0)				/* addinfo = bytes	*/	
		{
		g_addinfo [0]	= (char) (units >> 3);
		g_addinfo [1]	= (char) (units << 5);
		}

	return (units);
}


/***************************************************************
 *
 * Procedure i_wef_units
 *
 ***************************************************************/
#ifdef __STDC__

static int i_wef_units(
)

#else

static int i_wef_units(
)

#endif

{}


/***************************************************************
 *
 * Procedure i_open_acf
 *
 ***************************************************************/
#ifdef __STDC__

static 	int	i_open_acf (
		char	*name
)
#else
static 	int 	i_open_acf (
		name
)
		char	*name;
#endif

{
	char		err_msg[256];

	g_fp	= fopen (name, "rb");
        if      (g_fp == NULL)
		{	
		sca_errno	= 151;	/* file *.acf not found	*/
		sprintf(err_msg, "STARCOS management file '%s' not found", name);
		sca_errmsg = err_msg;
		return (-1);
		}
	return (0);
}


/***************************************************************
 *
 * Procedure i_ReadRecord
 *
 ***************************************************************/
#ifdef __STDC__

static int 	i_ReadRecord(
	FILE		 *fp,
	OctetString	 *pOstr
)

#else

static int 	i_ReadRecord(
	fp,
	pOstr
)
FILE		 *fp;
OctetString	 *pOstr;

#endif

{
        int     i;
        char    *b;

        i = 0;
        b = g_acbuf;

        while   ((i< 31) && ((g_acbuf [i] = fgetc (fp)) != 0x0a)
                && (feof (fp) == 0))
                i++;

	pOstr->noctets = i;
	pOstr->octets  = g_acbuf;
}


/***************************************************************
 *
 * Procedure i_return
 *
 ***************************************************************/
#ifdef __STDC__

static int i_return(
	int	 rc
)

#else

static int i_return(
	rc
)
int	 rc;

#endif

{
        if      (rc != 0)
    		{
		if	(g_errno == 0)	
			{
				g_errno	= sca_errno;
				g_errmsg	= sca_errmsg;
			}
#ifdef SECSCTEST
            	printf 	("g_errno %d \n errno %d \n errmsg %s \n", g_errno, sca_errno, sca_errmsg);
#endif
               	sca_errno = 0;
                }
#ifdef SECSCTEST
        printf ("rc %d \n", rc);
#endif
	return (rc);
}


/***************************************************************
 *
 * Procedure i_errno
 *
 ***************************************************************/
#ifdef __STDC__

static int i_errno(
)

#else

static int i_errno(
)

#endif

{
        if      (g_errno != 0)	
        	{
		sca_errno	= g_errno;
		sca_errmsg	= g_errmsg;
		g_errmsg	= CNULL;
		g_errno		= 0;
		return	(-1);
		}
	return	(0);
}


	



#else
sta_man_dummy() {}
#endif

