/* ./src/secure/sec_rand.c */

static char *rcsid = "$Id: sec_rand.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: sec_rand.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: sec_rand.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*-----------------------------------------------------------------------*/
/* sec_random.c: Funktionen sec_random_*()                               */
/*-----------------------------------------------------------------------*/

#include "secure.h"
extern ObjId *Random_OID;
#ifdef TEST
#include <stdio.h>
#endif
#include "arithmetic.h"



Boolean random_from_pse = FALSE;	/* if TRUE, read random number from PSE */


/***************************************************************
 *
 * Procedure sec_init_random_seed_from_keyboard
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_init_random_seed_from_keyboard(
)

#else

RC sec_init_random_seed_from_keyboard(
)

#endif

{
	char	    	*proc = "sec_init_random_seed_from_keyboard";
	char 		*input;
	int 		 len;

	do {
		if(!(input = getpass("Input random string : "))) {
			aux_add_error(EMALLOC, "Can't get tty input", CNULL, 0, proc);
			return(-1);
		}
	} while (!(len = strlen(input)));

	sec_init_random_seed_with_string(input);

	
	return(0);
}

/***************************************************************
 *
 * Procedure sec_update_random
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_update_random(
)

#else

RC sec_update_random(
)

#endif

{
	PSESel 		* pse_sel;
	OctetString 	  random, *content;
	char		* proc = "sec_update_random", octets[200];
	int 		  ret;
	L_NUMBER          random_seed[40];

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif
	

	if (!(pse_sel = (PSESel *)af_pse_open(Random_OID, TRUE))) {
		aux_add_error(LASTERROR, "af_pse_open failed", CNULL, 0, proc);
		return (-1);
	}

	random.noctets = 0;
	random.octets = octets;

	sec_get_random_seed(random_seed);

	lntoINTEGER(random_seed, &random);

	while(random_seed[0]) random_seed[random_seed[0]--] = 0;

	if (!(content = e_OctetString(&random)) ) {
		aux_free_PSESel(&pse_sel);
		aux_add_error(EENCODE, "e_OctetString failed", CNULL, 0, proc);
		return (-1);
	}
	while(random.noctets) octets[--random.noctets] = 0;

	ret = sec_write_PSE(pse_sel, Random_OID, content);

	if(ret<0) aux_add_error(EWRITEPSE, "sec_write_PSE failed", (char *) pse_sel, PSESel_n, proc);

	aux_free_PSESel(&pse_sel);
	aux_free_OctetString(&content);


	return(ret);
	

}
/***************************************************************
 *
 * Procedure sec_get_random
 *
 ***************************************************************/
#ifdef __STDC__

RC sec_get_random(
)

#else

RC sec_get_random(
)

#endif

{
	PSESel      * pse_sel;
	OctetString   content, *random;
	ObjId         objid;
	char	    * proc = "sec_get_random";
	L_NUMBER      random_seed[30];

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif


	if (!(pse_sel = (PSESel *)af_pse_open(Random_OID, FALSE))) {
		return (1);
	}


	if (sec_read_PSE(pse_sel, &objid, &content) < 0 ) {
		aux_add_warning(EREADPSE, "PSE object Random not found.", (char *) pse_sel, PSESel_n, proc);
        	aux_free_PSESel(&pse_sel);
		return (1);
	}
       	aux_free_PSESel(&pse_sel);
        if(aux_cmp_ObjId(&objid, Random_OID)) {
		aux_add_error(EDAMAGE, "PSE object has wrong objid", CNULL, 0, proc);
		return (-1);
	}

	random = d_OctetString(&content);
	if (! random) {
		aux_add_error(EDECODE, "d_OctetString failed", CNULL, 0, proc);
		return (-1);
	}
	while(content.noctets) content.octets[--content.noctets] = 0;
	free(content.octets);

	INTEGERtoln(random, random_seed);

	while(random->noctets) random->octets[--random->noctets] = 0;
	aux_free_OctetString(&random);

	if(sec_init_random(random_seed) < 0) {
		AUX_ADD_ERROR;
		return (-1);
	}
	while(random_seed[0]) random_seed[random_seed[0]--] = 0;


	return(0);
	

}
