static char *rcsid = "$Header: /home/secude/secude/src/sca/RCS/sca_test.c,v 1.1 1995/02/21 13:27:44 surkau Exp $";
/*
 * $Id: sca_test.c,v 1.1 1995/02/21 13:27:44 surkau Exp $
 * 
 * $Log: sca_test.c,v $
 * 
 */
#include "sca.h"
/*
#include <sys/time.h>
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>

/*#define TRUE 1
#define FALSE 0*/
#define NL '\012'
#define CNULL (char *)0
#define KEYATTRLISTNULL (KeyAttrList *)0
#define KEYALGIDNULL (AlgId *)0


#define ENDE		99

#define AUSGABE(p_out)\
        if (input == TRUE)\
 	  fprintf(stdout,p_out);

#define EINGABE(p1,p2,p3,p4)\
        if (input == TRUE)\
        {\
 	  fprintf(stdout,p3);\
          scanf(p1,p2);\
          getchar();\
        }\
        else\
	{\
 	  fprintf(stdout,p3);\
          fscanf(testfile,p1,p2);\
          fgetc(testfile);\
 	  fprintf(stdout,p1,p4);\
 	  fprintf(stdout,"\n");\
	}



/* Functions for Device Handling */
extern int	sca_init_icc();
extern int	sca_get_sct_info();
extern int	sca_eject_icc();

/* Functions for SCT-Display */
extern int	sca_display();
extern int      sca_journal();

/* Functions for Transfer Smartcard Command */
extern int	sca_trans();

/* Cryptographic functions */
extern int	sca_gen_user_key();
extern int	sca_inst_user_key();
extern int	sca_del_user_key();
extern int      sca_enc_des_key();
extern int	sca_sign();
extern int	sca_verify_sig();
extern int      sca_encrypt();
extern int      sca_decrypt();
extern int	sca_hash();
extern int      sca_enc_des_key();
extern int      sca_dec_des_key();
extern int	sca_challenge();

/* Functions for User Authentication */
extern int	sca_inst_verification_data();
extern int	sca_change_pin();
extern int	sca_verify_pin();
extern int	sca_unblock_pin();

/* Functions for Device Authentication and device handling */
extern int	sca_get_card_data();
extern int	sca_auth();
extern int      sca_gen_dev_key();
extern int      sca_del_dev_key();
extern int      sca_inst_dev_key();
extern int	sca_save_devkeyset();
extern int	sca_load_devkeyset();
extern int	sca_enable_deletion();
extern int	sca_gen_sessionkey();
extern int	sca_del_sessionkey();

/* Functions for File Handling and Data Access on the SC */
extern int	sca_create_file();
extern int	sca_register();
extern int	sca_select_file();
extern int	sca_close_file();
extern int	sca_lock_file();
extern int	sca_unlock_file();
extern int	sca_delete_file();
extern int	sca_delete_record();
extern int	sca_lock_key();
extern int	sca_unlock_key();
extern int	sca_read_binary();
extern int	sca_write_binary();
extern int	sca_lock_key();
extern int	sca_unlock_key();
extern int	sca_read_record();
extern int	sca_write_record();

extern int	sca_reset();
extern int	sca_get_sctport();

/* Functions to print error message */
extern int	sca_print_errmsg();

/* Functions for secure messaging */
extern int	sca_set_mode();



/* auxiliary functions */
extern int		aux_OctetString2file();
extern void		aux_free_OctetString();
extern OctetString	*aux_file2OctetString();
extern void		aux_xdump();
extern void		aux_free2_OctetString();

/* System functions */
extern long	ftell();

extern void men();
extern void getfilesel();
extern void getsecmess();
extern void getSCTsecmess();
extern void getfileid();
extern void getfilecat();
extern void getkeyid();
extern void getpin();
extern int  getkeyattrlist();
extern void getalgid();		/* request algorithm from user */
extern void getuserkeyid();
extern void getdevpurpose();
extern void getkeydevsel();
extern void getapplid();
extern int  getkeyidlist();



/* forward declarations */
void gettbwfile();		/* request name of the file to be write */
void getauthobjid();
void getauthprocid();
int  getenckey();

void printpublickey();		/* print public RSA key on stdout */

void chartobool();
void getpkfile();		/* request name of the file in which the PK is stored */
void gethashfile();		/* request name of the file where the hash_result is to be stored */
void gettxtfile();		/* request name of the file to be hashed */
void gethashalgid();            /* request hash algorithm from user */
void getencdesfile();
void gettbsfile();		/* request name of the file to be signed */
void getsignaturefile();	/* request name of the file where the signature is to be stored */
void gettbvfile();		/* request name of the file to be verified */
void getdencfile();		/* request name of the file where the ENC/DEC_result is to be stored */









Boolean      input;
int	     rcode;
char         algname[32];

FILE   	     *testfile;
FILE   	     *MF_file;

char         tbw_file[32];
char         sign_file[32];
char         pk_file[32];
char         encdes_file[32];
char         tbs_file[32];
char         txt_file[32];
char         hash_file[32];
char         pk_filename[32];
char         enc_file[32];

char	     fermatf4[3] = {'\001', '\000', '\001'};




main(argn, argc) char **argc;
{
     	unsigned int aw1;
	int	     		sct_id;
	int			value, j, len, zahl, zahl2, in_val;
	int	     		time_out, com_mode, port, record_no;
	int	     		memory_units;
	int	     	        sct_no, i, keysize, get_keysize;
	unsigned int		offset, noctets, short_index, rec_id, n;
	int			*alg_parm_int;


	Boolean      		alarm, exec_error, present;


	char	     		data[512], add_data[5], file[30], sec_key[24], name_data[17];
static	char         		out_put[1000];




	AccessControlValue	sec_status;
	AlgId	     		*alg_id, *des_alg_id;

	ATRInfo	     		atr_info;
	AuthProcId   		auth_proc_id;
	AuthObjectId 		auth_object_id;

	ChallengeMode		mode;

	DataStruc    		data_struc;
	Destination		destination;

	EncryptedKey 		encrypted_key;

	FileCat      		file_cat;
	FileControlInfo  	finfo;
	FileCloseContext 	file_close_context;
	FileSel      		file_sel;
	FileId	     		file_id;
	FileInfoReq  		file_info_req;
	FileInfo    		file_info;

	HashPar      		hash_par;

	ICC_SecMess   		sec_mess;

	KeyAttrList  		key_attr_list;
	KeyId			key_id, pin_key_id, des_key_id, rsa_key_id;
	KeyId			dev_key1, dev_key2, dev_key3;
	KeyId			*keyid_list[4];
	KeyInfo			enc_key;
	KeySel	    		key_sel, encryption_key, plain_key, decryption_key;
	KeySel			verification_key;
	KeySel			signature_key;
	KeyBits	     		key_bits;
        KeyDevSel    		key_dev_sel;
	KeyPurpose		purpose_set[4];
	KeyLevel		key_level;
	KeyDevList		key_dev_list;

	More			more;

	OctetString  		file_name, addinfo, atr, in_data, out_data, in_octets;
	OctetString		sc_command, sc_response, appl_id, record;
	OctetString     	hash_result, key_ostr, out_octets;
	OctetString  		*ostr ;
	OctetString  		*pk_ostr, *sig;
	OctetString  		*enckey_ostr;

	Signature    		signature;
	SCT_SecMess		sct_sec_mess;
	SessionKey		session_key;
	SCTPort			sct_info, get_sct_port;

	TransMode    		trans_mode;

	VerifyDataStruc		verify_data;

	WriteMode		write_mode;



	sct_info.bwt 		= 0x05;
	sct_info.cwt		= 0x02;
	sct_info.baud		= 0x0E;
	sct_info.databits	= 0x30;
	sct_info.stopbits	= 0x40;
	sct_info.parity		= 0x00;
	sct_info.dataformat	= 0x3B;
	sct_info.tpdusize	= 0xFF;
	sct_info.apdusize	= 0xFB;
	sct_info.edc		= 0x00;
	sct_info.protocoltype	= 0x81;
	sct_info.chaining	= 0x00;
	sct_info.icc_request	= 0x01;
	sct_info.first_pad_byte = 0x00;
	sct_info.next_pad_byte  = 0x00;
	sct_info.always		= 0x00;
		





	fprintf(stderr,"SCT_ID : \n");
	scanf("%d",&sct_id);
	getchar();
	fprintf(stderr,"INPUT from Console (1) / File (0) ? ");
	scanf("%d",&value);
	getchar();

        if (value == 0)
	{
	  input = FALSE;
	  fprintf(stderr,"Name of Testfile: \n");
	  scanf("%s",file);
	  getchar();
          testfile = fopen(file,"r");
	}
	else
	  input = TRUE;

	men();
	
        if (input == TRUE)
	{
	  scanf("%d",&aw1);
          getchar();
	}
	else
        {

	  fscanf(testfile,"%d",&aw1);
          fgetc(testfile);
	}

	while (aw1 != ENDE)
	{

		switch (aw1)
		{

			case 1:
				fprintf(stdout, "call sca_init_icc\n ");

			        EINGABE("%s",data,"\nDISPLAY_TEXT :",data);
			        EINGABE("%d",&time_out,"\nTIME_OUT :",time_out);
				EINGABE("%d",&atr_info,"\nATR_INFO (NO_ATR(0) / ATR_HISTORICAL(1)) :",atr_info);

				rcode = sca_init_icc (sct_id, data, time_out,
						      atr_info, &atr);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout, "icc initialized ! \n");
				   if (atr_info == ATR_HISTORICAL) {
				   	fprintf(stdout, "atr :\n");

				   	aux_xdump(atr.octets, atr.noctets, 0);
				   }

				}
				break;
			case 3:
				fprintf(stdout, "call sca_get_sct_info\n ");
				EINGABE("%d",&sct_no,"\nSCT_NO : ",sct_no);
				rcode = sca_get_sct_info(sct_no);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
			 	{
				   fprintf(stdout, "\nsca_get_sct_info executed ! \n");
				   fprintf(stdout, " rc   : %d\n", rcode);
				}

				break;
			case 4:
				fprintf(stdout, "call sca_eject_icc\n ");
				EINGABE("%s",data,"\nDISPLAY_TEXT :",data);
				EINGABE("%d",&value,"\nALARM (0=FALSE / 1=TRUE) :",value);
				if (value == 0)
				  alarm = FALSE;
				else
				  alarm = TRUE;

				rcode = sca_eject_icc (sct_id, data, alarm);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout, "sca_errmsg: %s\n", sca_errmsg);
				}
				
				break;
			case 5:
				fprintf(stdout, "call sca_display\n ");
				EINGABE("%s",data,"\nDISPLAY_TEXT :",data);
				EINGABE("%d",&time_out,"\nTIME_OUT :",time_out);

				rcode = sca_display (sct_id, data, time_out);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout, "sca_errmsg: %s\n", sca_errmsg);
				}
				break;

			case 6:
				fprintf(stdout, "call sca_trans\n ");
				fprintf(stdout,"\nSC_COMMAND : \n");

        			if (input == TRUE)
        			{
					rcode = icc_apdu(&sc_command);
        			}
        			else
				{
					/* read rcode out of testfile */
          				fscanf(testfile,"%d",&rcode);
          				fgetc(testfile);
 	  				fprintf(stdout,"rcode : %d\n",rcode);
				}



				if (rcode != 0)
					break;


				if (input == FALSE) {
					/* read sc_command out of testfile */
          				fscanf(testfile,"%d",&sc_command.noctets);
          				fgetc(testfile);
					for (i=0; i<sc_command.noctets; i++)
          					fscanf(testfile,"%c",&data[i]);
          				fgetc(testfile);
					sc_command.octets = data;
				}

				fprintf(stdout,"sc_command.noctets = %d\n", 
					sc_command.noctets);
				fprintf(stdout,"sc_command.octets : ");
				aux_fxdump(stdout,sc_command.octets,
					   sc_command.noctets,0);
					   


				EINGABE("%d",&trans_mode,"\nTRANS_MODE   (TRANSP(0)  / SECURE(1) :",trans_mode);
				rcode = sca_trans(sct_id,&sc_command,
						  trans_mode,&sc_response);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout, "sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "sc_response:");
				   aux_xdump(sc_response.octets,
						 sc_response.noctets, 0);
				   fprintf(stdout, "\nsca_trans executed ! \n");


				    /* release file_info.addinfo.octets  */
				    aux_free2_OctetString(&sc_response);
				}

				if (input == TRUE)
					aux_free2_OctetString(&sc_command);

				break;
			case 7:
				fprintf(stdout, "call sca_create_file\n ");
				getfilecat(&file_cat);


				AUSGABE("\nDATASTRUC (unused in case of MF,PARENT_DF,CHILD_DF) else ");
				EINGABE("%d",&data_struc,"\nDATASTRUC (NOTUSED(0) / FIX(1) / VAR(2) / CYC(3) / TRANSP(4) :",data_struc);

				/*  Eingabe der File Control Information  */
				EINGABE("%d",&finfo.units,"\nNumber of UNITS (mandatory => Value > 0) :",finfo.units);

				EINGABE("%d",&finfo.delrec_acv.compare_mode,
					"\nDELREC_ACV.CompareMode (EQ(0) / LT(1) / GE(2) / NOT_EQUAl(3)) :",finfo.delrec_acv.compare_mode);
				EINGABE("%d",&finfo.delrec_acv.state_number,
					"\nDELREC_ACV.state_number (0 - 63) :",
					finfo.delrec_acv.state_number);

				EINGABE("%d",&finfo.racv.compare_mode,
					"\nREAD_ACV.CompareMode (EQ(0) / LT(1) / GE(2) / NOT_EQUAl(3)) :",finfo.racv.compare_mode);

				EINGABE("%d",&finfo.racv.state_number,
					"\nREAD_ACV.state_number (0 - 63) :",
					finfo.racv.state_number);

				EINGABE("%d",&finfo.wacv.compare_mode,
					"\nWRITE_ACV.CompareMode (EQ(0) / LT(1) / GE(2) / NOT_EQUAl(3)) :",finfo.wacv.compare_mode);

				EINGABE("%d",&finfo.wacv.state_number,
					"\nWRITE_ACV.state_number (0 - 63) :",
					finfo.wacv.state_number);

				EINGABE("%d",&finfo.delfile_acv.compare_mode,
					"\nDELFILE_ACV.CompareMode (EQ(0) / LT(1) / GE(2) / NOT_EQUAl(3)) :",finfo.delfile_acv.compare_mode);

				EINGABE("%d",&finfo.delfile_acv.state_number,
					"\nDELFILE_ACV.state_number (0 - 63) :",
					finfo.delfile_acv.state_number);

				AUSGABE("\n ACCESS_SEC_MODE"); 

				EINGABE("%d",&finfo.access_sec_mode,"\nNORMAL(0) / AUTH(1)/ CONCEALED(2) / COMBINED(3) :",finfo.access_sec_mode);


				EINGABE("%d",&finfo.readwrite,"\nRW(0) / WORM(1)/ RONLY(2) / WONLY(3) :",finfo.readwrite);


				EINGABE("%c",&finfo.execute,"\nFile executable  (0) / File not executable(1):",finfo.execute);
				chartobool(&finfo.execute);

				EINGABE("%c",&finfo.not_erasable,"\nFile erasable  (0) / File not erasable(1):",finfo.not_erasable);
				chartobool(&finfo.not_erasable);

				AUSGABE("\nRecord or Element Size: "); 
				EINGABE("%d",&finfo.recordsize,"\n(> 0 only in case of LIN_FIX and CYCLIC): ",finfo.recordsize);
	


				file_name.octets  = data;
                  		getfilesel(&file_sel,&file_name,&file_id,file_cat);
                  		finfo.file_sel    = &file_sel;


				EINGABE("%s",add_data,"\nADDINFO (max. 4) :",add_data);
                  		addinfo.noctets = strlen(add_data);
                  		addinfo.octets  = add_data;
				finfo.addinfo   = &addinfo;                  		



				getsecmess(&sec_mess);

				rcode = sca_create_file (sct_id,file_cat,
							 data_struc,&finfo,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout, "sca_create_file executed ! \n");
				     }
				break;

			case  8:
				fprintf(stdout, "call sca_register\n ");
				EINGABE("%d",&memory_units,"\nMemory_units (must be > 0): ",memory_units);



				EINGABE("%d",&sec_status.compare_mode,
					"\nREG_ACV.CompareMode (EQ(0) / LT(1) / GE(2) / NOT_EQUAl(3)) :",sec_status.compare_mode);

				EINGABE("%d",&sec_status.state_number,
					"\nREG_ACV.state_number (0 - 63) :",
					sec_status.state_number);


				file_name.octets = data;


       				EINGABE("%d",&in_val,"\n  Eingabe = CHAR(0) / HEX(1) :",in_val);
       				if (in_val == 0) {
       					EINGABE("%s",file_name.octets,
					"\nFILENAME(max. 8) :",file_name.octets);
       					file_name.noctets = strlen(file_name.octets);
				}
				else {
       					EINGABE("%s",name_data,"\nFILENAME(HEX(A-F / 0-9) - max 16) :",name_data);

       					len = strlen(name_data);
					j = 0;
					for (i=0; i<len; i += 2) { 
						zahl = (int) name_data[i];
						if ((zahl >= 48) &&
		    		    		    (zahl <= 57))
							zahl = zahl - 48;
						else {
							if ((zahl >= 65) &&
			    	     	    		    (zahl <= 70))
								zahl = zahl - 55;
						}
 

						zahl2 = (int) name_data[i+1];
						if ((zahl2 >= 48) &&
		    	    	    		    (zahl2 <= 57))
							zahl2 = zahl2 - 48;
						else {
							if ((zahl2 >= 65) &&
			    	            		    (zahl2 <= 70))
								zahl2 = zahl - 55;
						}
						zahl = (zahl * 16) + zahl2;
						*(file_name.octets + j) = (char) zahl & 0xFF;
						j++;
					}
					file_name.noctets = len / 2;
				}





				getsecmess(&sec_mess);

				rcode = sca_register (sct_id,file_name,memory_units,
						      sec_status,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout, "sca_register executed ! \n");
				     }
				break;


			case  9:
				fprintf(stdout, "call sca_select_file\n ");

				getfilecat(&file_cat);

				EINGABE("%d",&file_info_req,"\nfile_info_req : NONE(0) / COMPL(4) :",file_info_req);


				file_name.octets  = data;
                  		getfilesel(&file_sel,&file_name,&file_id,file_cat);

				
				file_info.addinfo = &addinfo;

				getsecmess(&sec_mess);

				rcode = sca_select_file (sct_id,file_cat,&file_sel,
							 file_info_req,
							 &file_info,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
     				 if (file_info_req == COMP_INFO)
				 {
				   fprintf(stdout, "file_info.file_status.install_status: %x\n",file_info.file_status.install_status);
				   fprintf(stdout, "file_info.file_status.file_memory   : %x\n",file_info.file_status.file_memory);
				   fprintf(stdout, "file_info.file_status.file_access   : %x\n",file_info.file_status.file_access);
				   fprintf(stdout, "file_info.addinfo:");
				   aux_xdump(file_info.addinfo->octets,
						 file_info.addinfo->noctets, 0);
				   fprintf(stdout, "\nsca_select_file executed ! \n");


				    /* release file_info.addinfo.octets  */
				    aux_free2_OctetString(file_info.addinfo);
				 }




				}
				break;


			case  10:
				fprintf(stdout, "call sca_close_file\n ");
				getfilecat(&file_cat);

				EINGABE("%d",&file_close_context,"\nCONTEXT ( CREATE(0) / SELECT(1) :",file_close_context);



				file_name.octets  = data;
                  		getfilesel(&file_sel,&file_name,&file_id,file_cat);

				getsecmess(&sec_mess);

				rcode = sca_close_file (sct_id,file_cat,&file_sel,
							file_close_context,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "\nsca_close_file executed ! \n");

				}
				break;

			case  11:
				fprintf(stdout, "call sca_lock_file\n ");
				getfileid(&file_id);
				getsecmess(&sec_mess);

				rcode = sca_lock_file (sct_id,&file_id,&sec_mess);
-
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "\nsca_lock_file executed ! \n");

				}
				break;

			case  12:
				fprintf(stdout, "call sca_unlock_file\n ");
				getfileid(&file_id);
				getsecmess(&sec_mess);

				rcode = sca_unlock_file (sct_id,&file_id,&sec_mess);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "\nsca_unlock_file executed ! \n");

				}
				break;

			case  13:
				fprintf(stdout, "call sca_delete_file\n ");
				getfilecat(&file_cat);

				file_name.octets  = data;
                  		getfilesel(&file_sel,&file_name,&file_id,file_cat);


				getsecmess(&sec_mess);

				rcode = sca_delete_file (sct_id,file_cat,&file_sel,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "\nsca_delete_file executed ! \n");

				}
				break;

			case  14:
				fprintf(stdout, "call sca_read_binary\n ");
				short_index = 0;
				EINGABE("%d",&short_index,"\nshort_index  (0 or 1-15) :",short_index);

				EINGABE("%d",&offset,"\noffset   :",offset);
				EINGABE("%d",&noctets,"\nnoctets :",noctets);
				getsecmess(&sec_mess);
				rcode = sca_read_binary (sct_id,short_index,
						       offset, noctets,
						       &in_data,&sec_mess);


				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);

				}
				else
				   fprintf(stdout, "\nsca_read_binary executed ! \n");
				
				if (in_data.noctets == 0)
					fprintf(stdout,"no data received\n");
				else {
					fprintf(stdout, "in_data.noctets: %d\n",
					        in_data.noctets);
					aux_xdump(in_data.octets,
				          	in_data.noctets, 0);

					/* release in_data.octets  */
					aux_free2_OctetString(&in_data);
				}
				break;



			case  15:
				fprintf(stdout, "call sca_read_record\n ");
				EINGABE("%d",&short_index,"\nshort_index  (0 or 1-15) :",short_index);
				EINGABE("%d",&data_struc,"\nDATASTRUC (FIX(1) / VAR(2) / CYC(3)) :",data_struc);
				EINGABE("%d",&rec_id,"\nrec_id (FIX/CYCLIC(01 - FD) VAR(01-FE)) :",rec_id);

				EINGABE("%d",&noctets,"\nnoctets :",noctets);
				getsecmess(&sec_mess);

				rcode = sca_read_record(sct_id,short_index,data_struc,
						       rec_id,noctets,&in_data,
						       &sec_mess);



				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);

				}
				else
				   fprintf(stdout, "\nsca_read_record executed ! \n");

				if (in_data.noctets == 0)
					fprintf(stdout,"no data received\n");
				else {
					fprintf(stdout, "in_data:");
					aux_xdump(in_data.octets,
				          	in_data.noctets, 0);

					/* release in_data.octets  */
					aux_free2_OctetString(&in_data);
				}
				break;


			case  16:
				ostr = NULL;
				fprintf(stdout, "call sca_write_binary\n ");
				short_index = 0;
				EINGABE("%d",&short_index,"\nshort_index  (0 or 1-15) :",short_index);
				EINGABE("%d",&offset,"\noffset :",offset);
				gettbwfile();
                                if((ostr = aux_file2OctetString(tbw_file))) {
/* Attention please: ostr must be released */
				     ostr->noctets--; /* remove end of file */

				     aux_fxdump(stdout, ostr->octets, ostr->noctets, 0);
				     fprintf(stdout, "\n");


				  }
				getsecmess(&sec_mess);
				rcode = sca_write_binary (sct_id,short_index,
							offset,ostr,
							&sec_mess,&noctets);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{

				   fprintf(stdout, "\nsca_write_data executed ! \n");


				}
			        fprintf(stdout,"noctets: %d\n", noctets);

				/* release ostr  */
                		if (ostr != NULL)
					aux_free_OctetString(&ostr);
				break;
			case  17:
				fprintf(stdout, "call sca_write_record\n ");
				EINGABE("%d",&short_index,"\nshort_index  (0 or 1-15) :",short_index);
				EINGABE("%d",&data_struc,"\nDATASTRUC (FIX(1) / VAR(2) / CYC(3)) :",data_struc);
				EINGABE("%d",&rec_id,"\nrec_id (FIX(01 - FD) VAR(01-FE) CYCLIC=00 will be set by STARMOD) :",rec_id);

				EINGABE("%d",&write_mode,"\nwrite_mode (UPDATE(4) / APPEND(6)) :",write_mode);
				EINGABE("%s",data,"\nWRITE DATA :",data);


				out_data.noctets = strlen(data);
				out_data.octets	= data;
				getsecmess(&sec_mess);

				rcode = sca_write_record(sct_id,short_index,
						       data_struc,
						       rec_id, write_mode,&out_data,
						       &sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);

				}
				else
				{
				   fprintf(stdout, "\nsca_write_record executed ! \n");
				}
				break;

			case  18:
				fprintf(stdout, "call sca_delete_record\n ");
				EINGABE("%d",&short_index,"\nshort_index  (0 or 1-15) :",short_index);
				EINGABE("%d",&data_struc,"\nDATASTRUC (FIX(1) / VAR(2)) :",data_struc);
				EINGABE("%d",&rec_id,"\nrec_id (FIX(01 - FD) VAR(01-FE)) :",rec_id);
				getsecmess(&sec_mess);

				rcode = sca_delete_record(sct_id,short_index,
						         data_struc,
							 rec_id,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "\nsca_delete_record executed ! \n");

				}
				break;

			case  19:
				fprintf(stdout, "call sca_lock_key\n ");
				getkeyid(&key_id);
				getsecmess(&sec_mess);

				rcode = sca_lock_key (sct_id,&key_id,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "\nsca_lock_key executed ! \n");

				}
				break;
			case  20:
				fprintf(stdout, "call sca_unlock_key\n ");
				getkeyid(&key_id);
				getsecmess(&sec_mess);

				rcode = sca_unlock_key (sct_id,&key_id,&sec_mess);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else
				{
				   fprintf(stdout, "\nsca_unlock_key executed ! \n");

				}
				break;

			case 21:
				fprintf(stdout, "TEST: call sca_inst_verification_data\n ");
				getkeyid(&key_id);
				getpin(&verify_data,&out_data,&pin_key_id);


			        rcode = getkeyattrlist(&key_attr_list);
			        if (rcode == 0)
                                  rcode = sca_inst_verification_data (sct_id, &key_id, &verify_data,
							    &key_attr_list);
				else
                                  rcode = sca_inst_verification_data (sct_id, &key_id, &verify_data,
							    KEYATTRLISTNULL);

				free(out_data.octets);

 

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0){
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout, "verification data installed \n");
				}

				break;


			case 22:
				fprintf(stdout, "TEST: call sca_change_pin\n ");
				getkeyid(&key_id);
				getsecmess(&sec_mess);

				rcode = sca_change_pin (sct_id, &key_id, &sec_mess);
					    fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout, "pin replaced \n");
				}
				break;
			case 23:
				fprintf(stdout, "TEST: call sca_verify_pin\n ");
				getkeyid(&key_id);
				getsecmess(&sec_mess);

				rcode = sca_verify_pin (sct_id, &key_id, &sec_mess);					    fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout, "pin checked \n");
				}
				break;
			case 24:
				fprintf(stdout, "TEST: call sca_unblock_pin\n ");
				getkeyid(&key_id);
				getsecmess(&sec_mess);

				rcode = sca_unblock_pin (sct_id, &key_id, &sec_mess);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout, "pin unblocked \n");
				}
				break;

			case 25:
				fprintf(stdout, "TEST: call sca_auth\n ");
				getauthobjid(&auth_object_id);
				getauthprocid(&auth_proc_id);
				rcode = 1;
				in_data.noctets = 0;
				if (auth_object_id == DTE_ICC) {
					getkeyid(&key_id);
					EINGABE("%s",data,"\nAUTH_OUT_DATA :",data);
					out_data.noctets = strlen(data);
					out_data.octets	= data;
					rcode = getenckey(&enc_key, sec_key);
					getsecmess(&sec_mess);
				}

				if (rcode == 0) 
					rcode = sca_auth(sct_id, auth_proc_id,
					        auth_object_id,
						&key_id, &out_data, &enc_key,
					        &sec_mess, &in_data);
				else
					rcode = sca_auth(sct_id, auth_proc_id,
					        auth_object_id,
						&key_id, &out_data, KEYINFONULL,
					        &sec_mess, &in_data);


				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout,"TEST: Authentication successful! \n");
				   if (in_data.noctets == 0)
					fprintf(stdout,"no data received\n");
				  else {
					fprintf(stdout, "in_data: \n");
					aux_xdump(in_data.octets,
				          	  in_data.noctets, 0);

					/* release in_data.octets  */
					aux_free2_OctetString(&in_data);
				  }
				}


				break;

			case 26:
				
				fprintf(stdout, "TEST: call sca_gen_user_key\n ");
				/* in the parameter key_sel
				 * - key_algid
				 * - key_id and
				 * - key_bits
				 * are evaluated
				 */

                                getalgid(&alg_id, &get_keysize);
				key_sel.key_algid = alg_id;
				if (get_keysize == 1) {
					/* RSA; get keysize */
					EINGABE("%d",&keysize,"\nkeysize  (512 or 1024) :",keysize);
					if (keysize != 512) {
	
				  		alg_parm_int = (int *) (key_sel.key_algid->param);
						*alg_parm_int = keysize;
					}

				}

					
				getuserkeyid(&key_id);
			      	key_sel.key_bits = &key_bits;
			      	key_sel.key_id   = &key_id;

                   		 rcode = sca_gen_user_key (sct_id, &key_sel);

     
/* Attention please: (In case of RSA) key_sel.key_bits->part1.octets must be released */
/* Attention please: (In case of RSA) key_sel.key_bits->part2.octets must be released */

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else {
				   fprintf(stdout,"TEST: key generation successful! \n");

/* In case of RSA, the public key is stored in file :key-no:||".PK". */			   
                                   if(strncmp(algname, "RSA",3) == 0) {

                                     /* create or overwrite file ":key_id:.pk" 
				        and store public key into it.           */
                                     sta_itoa(pk_filename,key_id.key_number);
                                     strcat(pk_filename,".pk");
				     fprintf(stdout, "Public Key saved in File : %s\n",pk_filename);

				     
	
                                     rcode = aux_OctetString2file (&key_sel.key_bits->part1, pk_filename, 2);   
 
                                     /* display public key */
                                     fprintf(stdout, "\npublic key :\n");
                                     printpublickey(key_sel.key_bits);
                                  }
				} /* end else */

                                /* release storage for public key */
				if (key_sel.key_bits->part1.octets)
                                     free(key_sel.key_bits->part1.octets);
				if (key_sel.key_bits->part2.octets)
                                     free(key_sel.key_bits->part2.octets);


				break;

			case 27:
                                fprintf(stdout, "TEST: call sca_del_user_key\n ");
				/* in the parameter key_sel
				 * - key_id 
				 * are evaluated
				 */


                                getalgid(&alg_id, &get_keysize);
				key_sel.key_algid = NULL;
				getuserkeyid(&key_id);
			      	key_sel.key_id   = &key_id;

                                rcode = sca_del_user_key (sct_id, &key_sel);
                                fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                if (rcode < 0){
                                   fprintf(stdout, "sca_errno: %d\n", sca_errno);
                                   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else {
                                   fprintf(stdout, "key deleted \n");
                                }
                                break;



			case 28:
				pk_ostr = NULL;
				ostr = NULL;
				fprintf(stdout, "TEST: call sca_sign\n ");

                                gettbsfile();
				/* read text to be signed */
                		ostr = aux_file2OctetString(tbs_file);
/* Attention please: ostr must be released */
				if (ostr == NULL) { 
					fprintf(stdout,"Can't read TEXT_File : %s\n",tbs_file);
					out_octets.noctets = 0;
					out_octets.octets  = NULL;
				}


				AUSGABE("\nAll Signature Algorithm are allowed ");
				getalgid(&alg_id, &get_keysize);
				signature_key.key_algid = alg_id;
				if (get_keysize == 1) {
					/* RSA-SQMODN; get keysize */
					EINGABE("%d",&keysize,"\nkeysize  (512 or 1024) :",keysize);	
					alg_parm_int = (int *) (signature_key.key_algid->param);
					*alg_parm_int = keysize;
				}

				signature_key.key_bits = &key_bits;
				EINGABE("%d",&keysize,"\nLength of Public Key (64 Bytes / 128 Bytes):",keysize);
                	        signature_key.key_bits->part1.noctets = keysize;


				if (alg_id == NULL )
					AUSGABE("\nalg_id = NULL => sca_sign use SQMODN with keysize = 512 ");


               			hash_par.sqmodn_par.part1.noctets = 0;
                		hash_par.sqmodn_par.part1.octets =  NULL;

                                if ((strncmp(algname, "Sqmodn",7) == 0) ||
				    (alg_id == NULL)) { 

					/* read modulus out of pk */
					getpkfile();
                			pk_ostr = aux_file2OctetString (pk_file);
/* Attention please: pk_ostr must be released */
					if (pk_ostr == NULL)  
						fprintf(stdout,"Can't read PK_File: %s\n",pk_file);
					else {
                				hash_par.sqmodn_par.part1.noctets = pk_ostr->noctets;
                				hash_par.sqmodn_par.part1.octets =  pk_ostr->octets;
                				hash_par.sqmodn_par.part2.noctets = 3;
                				hash_par.sqmodn_par.part2.octets = fermatf4;
					}
				}
			

 

				AUSGABE("\nKeyId of the private RSA key stored in the ICC");
				getkeyid(&key_id);
				signature_key.key_id = &key_id; 

				if (ostr) {

					out_octets.noctets = ostr->noctets;
					out_octets.octets  = ostr->octets;
					offset		   = 0;
				}
				exec_error = FALSE;

				do {
					EINGABE("%d",&more,"\nmore (SEC_END(0) / SEC_MORE(1) :",more);
					if (more == SEC_MORE) {
						AUSGABE("\n10 bytes of the Text are sent by MORE ");
						if (ostr) {
							out_octets.noctets = 10;
							out_octets.octets  = ostr->octets + offset;
						}
						if (exec_error == FALSE) {
                					rcode = sca_sign(sct_id, &out_octets, &signature_key,
							 	 &hash_par,more, &signature);
                                  			fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  			if (rcode < 0) {
                                     				fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     				fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
								exec_error = TRUE;

				  			}
				  			else
				     				fprintf(stdout,"first call of sign successful\n");
						}

			 			fprintf(stdout,"\nCONTINUE (0) ?");
						scanf("%d",&value);
						getchar();

						offset+= 10;
					}
					else {
						/* send rest of text */
						if (ostr) {
							out_octets.noctets = ostr->noctets - offset;
							out_octets.octets  = ostr->octets + offset;
						}
						if (exec_error == FALSE) {
                					rcode = sca_sign(sct_id, &out_octets, &signature_key,
							 	 &hash_par,more, &signature);
                                  			fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  			if (rcode < 0) {
                                     				fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     				fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
								exec_error = TRUE;

				  			}
				  			else
				     				fprintf(stdout,"last call of sign successful\n");
						}
					}
				  }while (more != SEC_END);

			          getsignaturefile();
				  if (rcode == 0) {

			  	  	fprintf(stdout,"TEST: Signature generation successful! \n");
                                  	fprintf(stdout, "signature: \n");
                                  	n = signature.signature.nbits;
                                  	aux_xdump(signature.signature.bits, n/8, 0);

                                  	writesignature(&signature, sign_file);
                                  	aux_free_OctetString(&ostr);
                                  	free(signature.signature.bits);
				  }


				  /* release pk_ostr, ostr and signature.bits */
                                  if (pk_ostr != NULL)
			             	aux_free_OctetString(&pk_ostr);

                                  if (ostr != NULL)
			             	aux_free_OctetString(&ostr);




				break;


			case 29:
				ostr = NULL;
				pk_ostr = NULL;
				sig = NULL;
				fprintf(stdout, "TEST: call sca_verify_sig\n ");
                                gettbvfile();
				/* read text to be verified */
                		ostr = aux_file2OctetString(tbs_file);
/* Attention please: ostr must be released */
				if (ostr == NULL) { 
					fprintf(stdout,"Can't read TEXT_File : %s\n",tbs_file);
					out_octets.noctets = 0;
					out_octets.octets  = NULL;
				}

                                getsignaturefile();
				/* read signature out of file */
                		sig = aux_file2OctetString(sign_file);
				if (sig == NULL) { 
					fprintf(stdout,"Can't read SIG_File - SIG\n");
					signature.signature.nbits = 0;
					signature.signature.bits  = NULL;

				}
				else {
					signature.signature.nbits = sig->noctets * 8;
					signature.signature.bits  = sig->octets;
				}

 /* Attention please: sig must be released */

				/* read modulus out of pk */
				getpkfile();
                		pk_ostr = aux_file2OctetString (pk_file);
/* Attention please: pk_ostr must be released */
				if (pk_ostr == NULL) {  
					fprintf(stdout,"Can't read PK_File: %s\n",pk_file);
                			verification_key.key_bits = NULL;
				}
				else {
                			verification_key.key_bits = &key_bits;
                			verification_key.key_bits->part1.noctets = pk_ostr->noctets;
                			verification_key.key_bits->part1.octets =  pk_ostr->octets;

                			verification_key.key_bits->part2.noctets = 0;
                			verification_key.key_bits->part2.octets =  NULL;

                                verification_key.key_bits->part2.noctets = 3;
                                verification_key.key_bits->part2.octets = fermatf4;


				}

                		hash_par.sqmodn_par.part1.noctets = 0;
                		hash_par.sqmodn_par.part1.octets =  NULL;
                		hash_par.sqmodn_par.part2.noctets = 0;
                		hash_par.sqmodn_par.part2.octets = NULL;

				AUSGABE("\nAll Signature Algorithm are allowed ");
#ifdef OLD
                                getalgid(&signature.signAI, &get_keysize);
#endif

				getalgid(&alg_id, &get_keysize);
				signature.signAI = alg_id;

				if (get_keysize == 1) {
					/* RSA-SQMODN; get keysize */
					EINGABE("%d",&keysize,"\nkeysize  (512 or 1024) :",keysize);	
					alg_parm_int = (int *) (signature.signAI->param);
					*alg_parm_int = keysize;
				}

                                if (strncmp(algname, "Sqmodn",7) == 0){ 

					if (pk_ostr) {
                				hash_par.sqmodn_par.part1.noctets = pk_ostr->noctets;
                				hash_par.sqmodn_par.part1.octets =  pk_ostr->octets;
                				hash_par.sqmodn_par.part2.noctets = 3;
                				hash_par.sqmodn_par.part2.octets = fermatf4;
					}
				}

				if (ostr) {

					out_octets.noctets = ostr->noctets;
					out_octets.octets  = ostr->octets;
					offset		   = 0;
				}


				exec_error = FALSE;

				do {
				EINGABE("%d",&more,"\nmore (SEC_END(0) / SEC_MORE(1) :",more);
				if (more == SEC_MORE) {
					AUSGABE("\n10 bytes of the Text are sent by MORE ");
					if (ostr) {
						out_octets.noctets = 10;
						out_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
                				rcode = sca_verify_sig(sct_id, &out_octets, &signature,
							       &verification_key,
			         			       &hash_par,more);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;;

				  		}
				  		else
				     			fprintf(stdout,"first call of verify_sig successful\n");
					}

			 		fprintf(stdout,"\nCONTINUE (0) ?");
					scanf("%d",&value);
					getchar();

					offset+= 10;
				}
				else {
					/* send rest of text */
					if (ostr) {
						out_octets.noctets = ostr->noctets - offset;
						out_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
                				rcode = sca_verify_sig(sct_id, &out_octets, &signature,
							       &verification_key,
			         			       &hash_par,more);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;

				  		}
				  		else
				     			fprintf(stdout,"last call of verify_sig successful\n");
					}
				}
				}while (more != SEC_END);

				/* release pk_ostr  */
                		if (pk_ostr != NULL)
					aux_free_OctetString(&pk_ostr);

				/* release ostr  */
                		if (ostr != NULL)
					aux_free_OctetString(&ostr);

				/* release sig  */
                		if (sig != NULL)
					aux_free_OctetString(&sig);
				break;


			case 30:

				fprintf(stdout, "\n\nTEST: call sca_print_errmsg\n ");
				rcode = sca_print_errmsg("Error of stamod function");
                                fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                if (rcode < 0){
                                   fprintf(stdout, "sca_errno: %d\n", sca_errno);
                                   fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}

				break;

			case 31:
				fprintf(stdout, "TEST: call sca_set_mode\n ");
				getSCTsecmess(&sct_sec_mess);

				rcode = sca_set_mode(sct_id, &sct_sec_mess);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else
				   fprintf(stdout,"TEST: SCA_set_mode successful! \n");



				break;

			case 32:
				fprintf(stdout, "call sca_challenge\n ");

				EINGABE("%d",&destination,"\ndestination (SCT(0) / ICC(1)) : ",destination);
				if (destination == SCT) {
					EINGABE("%d",&in_data.noctets,"\nLength (1 - 240): ",in_data.noctets);
				}
				else {
					EINGABE("%d",&mode,"\nmode (GET_CHALLENGE(0) / SEND_CHALLENGE(1) / EX_CHALLENGE(2)): ",mode);
					if (mode != GET_CHALLENGE) {
						EINGABE("%s",data,"\nRandom :",data);
						out_data.noctets = strlen(data);
						out_data.octets	= data;
					}
					getsecmess(&sec_mess);
				}

				rcode = sca_challenge (sct_id, destination, mode,
						       &in_data, &out_data, &sec_mess);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else
				{
				  fprintf(stdout,"Random - OctetString\n");
				  fprintf(stdout," noctets = %d\n",in_data.noctets);
				  if (in_data.octets) { 
				  	fprintf(stdout," octets  = \n");
                                  	aux_xdump(in_data.octets, in_data.noctets, 0);
				  	aux_free2_OctetString(&in_data);
				  }
				}



				break;
			case 33:

				ostr = NULL;
				fprintf(stdout, "TEST: call sca_encrypt\n ");

				/* read text to be encrypted */
				gettxtfile();
                		ostr = aux_file2OctetString(txt_file);
/* Attention please: ostr must be released */
				if (ostr == NULL) { 
					fprintf(stdout,"Can't read TEXT_File : %s\n",txt_file);
					in_octets.noctets = 0;
					in_octets.octets  = NULL;
				}
				ostr->noctets--;		/* release end of File */



				out_octets.noctets = 0;
				out_octets.octets  = out_put;
				pk_ostr = NULL;
                		encryption_key.key_bits = NULL;



				AUSGABE("\nAll Encryption Algorithms are allowed ");
                                getalgid(&encryption_key.key_algid, &get_keysize);
                                if (strncmp(algname, "RSA",3) == 0){ 

					/* read modulus out of pk */
					getpkfile();
                			pk_ostr = aux_file2OctetString (pk_file);
/* Attention please: pk_ostr must be released */
					if (pk_ostr == NULL) {  
						fprintf(stdout,"Can't read PK_File: %s\n",pk_file);
                				encryption_key.key_bits = NULL;
					}
					else {
                				encryption_key.key_bits = &key_bits;
                				encryption_key.key_bits->part1.noctets = pk_ostr->noctets;
                				encryption_key.key_bits->part1.octets =  pk_ostr->octets;

                				encryption_key.key_bits->part2.noctets = 0;
                				encryption_key.key_bits->part2.octets =  NULL;

                                encryption_key.key_bits->part2.noctets = 3;
                                encryption_key.key_bits->part2.octets = fermatf4;

					}
				}
				else {
					getkeyid(&key_id);
					encryption_key.key_id = &key_id;
				}

				EINGABE("%d",&destination,"\ndestination (SCT(0) / ICC(1)) : ",destination);

				if (destination == ICC)
					getsecmess(&sec_mess);
				offset = 0;

			        getdencfile();

				exec_error = FALSE;


				do {
				EINGABE("%d",&more,"\nmore (SEC_END(0) / SEC_MORE(1) :",more);


				if (more == SEC_MORE) {
					AUSGABE("\n10 bytes of the Text are sent by MORE ");
					if (ostr) {
						in_octets.noctets = 10;
						in_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
                				rcode = sca_encrypt(sct_id, &in_octets, &out_octets,
							       &encryption_key,
							       destination, &sec_mess, 
			         			       more);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;

				  		}
				  		else
				     			fprintf(stdout,"first call of encrypt successful\n");
					}


			 		fprintf(stdout,"\nCONTINUE (0) ?");
					scanf("%d",&value);
					getchar();

					offset+= 10;
				}
				else {
					/* send rest of text */
					if (ostr) {
						in_octets.noctets = ostr->noctets - offset;
						in_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
                				rcode = sca_encrypt(sct_id, &in_octets, &out_octets,
							       &encryption_key, destination,
			         			       &sec_mess, more);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;

				  		}
				  		else
				     			fprintf(stdout,"last call of encrypt successful\n");
					}
				}
				}while (more != SEC_END);

				if (rcode > 0) {

                                  fprintf(stdout, "TEST: Encryption  successful\n");
                                  fprintf(stdout, "TEST: out_octets.noctets : %d\n",
						   out_octets.noctets);

                                  fprintf(stdout, "TEST: out_put: \n");
                                  aux_xdump(out_put, out_octets.noctets, 0);
			          out_octets.octets = out_put;
                                  writeencresult(&out_octets, enc_file);
                                }
                                else {
					fprintf(stdout, "TEST: Encryption not successful\n");

				}


				/* release pk_ostr  */
                		if (pk_ostr != NULL)
					aux_free_OctetString(&pk_ostr);

				/* release ostr  */
                		if (ostr != NULL)
					aux_free_OctetString(&ostr);
  

				break;


			case 34:

				fprintf(stdout, "TEST: call sca_decrypt\n ");

				/* read text to be decrypted */
				gettxtfile();
                		ostr = aux_file2OctetString(txt_file);
/* Attention please: ostr must be released */
				if (ostr == NULL) { 
					fprintf(stdout,"Can't read TEXT_File : %s\n",txt_file);
					in_octets.noctets = 0;
					in_octets.octets  = NULL;
				}



				out_octets.noctets = 0;
				out_octets.octets  = out_put;



				AUSGABE("\nAll Encryption Algorithms are allowed ");
                                getalgid(&decryption_key.key_algid, &get_keysize);
				getkeyid(&key_id);
				decryption_key.key_id = &key_id;

				EINGABE("%d",&destination,"\ndestination (SCT(0) / ICC(1)) : ",destination);

				if (destination == ICC)
					getsecmess(&sec_mess);
				offset = 0;
				exec_error = FALSE;

				do {
				EINGABE("%d",&more,"\nmore (SEC_END(0) / SEC_MORE(1) :",more);
				if (more == SEC_MORE) {
					AUSGABE("\n10 bytes of the Text are sent by MORE ");
					if (ostr) {
						in_octets.noctets = 10;
						in_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
                				rcode = sca_decrypt(sct_id, &in_octets, &out_octets,
							       &decryption_key,
							       destination, &sec_mess, 
			         			       more);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;

				  		}
				  		else
				     			fprintf(stdout,"first call of decrypt successful\n");
					}

			 		fprintf(stdout,"\nCONTINUE (0) ?");
					scanf("%d",&value);
					getchar();

					offset+= 10;
				}
				else {
					/* send rest of text */
					if (ostr) {
						in_octets.noctets = ostr->noctets - offset;
						in_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
                				rcode = sca_decrypt(sct_id, &in_octets, &out_octets,
							       &decryption_key, destination,
			         			       &sec_mess, more);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;

				  		}
				  		else
				     			fprintf(stdout,"last call of decrypt successful\n");
					}
				}
				}while (more != SEC_END);

			        getdencfile();
				if (rcode > 0) {

                                  fprintf(stdout, "TEST: Decryption  successful\n");
                                  fprintf(stdout, "TEST: out_octets.noctets : %d\n",
						   out_octets.noctets);

                                  fprintf(stdout, "TEST: out_put: \n");
                                  aux_xdump(out_put, out_octets.noctets, 0);
			          out_octets.octets = out_put;
                                  writedecresult(&out_octets, enc_file);
                                }
                                else {
					fprintf(stdout, "TEST: Decryption not successful\n");

				}


				/* release ostr  */
                		if (ostr != NULL)
					aux_free_OctetString(&ostr);
  
				break;


			case 35:
				ostr = NULL;
				pk_ostr = NULL;
				fprintf(stdout, "TEST: call sca_hash\n ");

                                gettxtfile();
                                ostr = aux_file2OctetString(txt_file);
			

			        if (ostr == NULL)
				{ 
				  fprintf(stdout,"Can't read Textfile\n");
				  break;
				} 
                                gethashfile();
                                gethashalgid(&alg_id);

/* if hash = sqmodn then get public key from file  for hash_input */
                                  if(strncmp(algname, "Sqmodn",7) == 0) 
			          {
				     getpkfile();

                                     pk_ostr = aux_file2OctetString (pk_file);
			             if (pk_ostr == NULL)
			             { 
				       fprintf(stdout,"Can't read PK_File\n");
				       aux_free_OctetString(&ostr);
				       break;
				     } 
  
/* Attention please: pk_ostr must be released */
				     fprintf(stdout, "pk from file:\n");
				     aux_fxdump(stdout, pk_ostr->octets, pk_ostr->noctets, 0);
				     fprintf(stdout, "\n");

                                     /* hash-input = public key */ 
                                     hash_par.sqmodn_par.part1.noctets = pk_ostr->noctets;
                                     hash_par.sqmodn_par.part1.octets = pk_ostr->octets;
                                     hash_par.sqmodn_par.part2.noctets = 3;
                                     hash_par.sqmodn_par.part2.octets = fermatf4;
				  }


				if (ostr) {

					out_octets.noctets = ostr->noctets;
					out_octets.octets  = ostr->octets;
					offset		   = 0;
				}

				exec_error = FALSE;


				do {
				EINGABE("%d",&more,"\nmore (SEC_END(0) / SEC_MORE(1) :",more);
				if (more == SEC_MORE) {
					AUSGABE("\n10 bytes of the Text are sent by MORE ");
					if (ostr) {
						out_octets.noctets = 10;
						out_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
		                  		rcode = sca_hash(sct_id, &out_octets,alg_id, &hash_par,
        				                 more,&hash_result);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;

				  		}
				  		else
				     			fprintf(stdout,"first call of hash successful\n");
					}

			 		fprintf(stdout,"\nCONTINUE (0) ?");
					scanf("%d",&value);
					getchar();

					offset+= 10;
				}
				else {
					/* send rest of text */
					if (ostr) {
						out_octets.noctets = ostr->noctets - offset;
						out_octets.octets  = ostr->octets + offset;
					}
					if (exec_error == FALSE) {
		                  		rcode = sca_hash(sct_id, &out_octets,alg_id, &hash_par,
        				                 more,&hash_result);
                                  		fprintf(stdout, "TEST: rcode: %d\n", rcode);
                                  		if (rcode < 0) {
                                     			fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     			fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
							exec_error = TRUE;

				  		}
				  		else
				     			fprintf(stdout,"last call of hash successful\n");
					}
				}
				}while (more != SEC_END);


				if (rcode == 0) {
			  	     fprintf(stdout,"TEST: sca_hash successful! \n");
                                     fprintf(stdout, ": \n");
                                     n = hash_result.noctets;
                                     aux_xdump(hash_result.octets, n, 0);
                                     writehashresult(&hash_result, hash_file);
                                     aux_free2_OctetString(&hash_result);
                                 } /* end else */


				/* release pk_ostr  */
                		if (pk_ostr != NULL)
					aux_free_OctetString(&pk_ostr);

				/* release ostr  */
                		if (ostr != NULL)
					aux_free_OctetString(&ostr);

				break;

			case 36:
				pk_ostr = NULL;
                                fprintf(stdout, "TEST: call sca_enc_des_key\n ");
				AUSGABE("\nEncryption_AlgId (RSA(0) / RSAEncryption(8)) ");
				AUSGABE("\nall other values are invalid ");
				getalgid(&alg_id, &get_keysize);

				getpkfile();

/* Attention please: pk_ostr must be released */
                                pk_ostr = aux_file2OctetString (pk_file);
			        if (pk_ostr == NULL)
			        { 
				   fprintf(stdout,"Can't read PK_File\n");
				   break;
				} 

				AUSGABE("\nPlainkey_AlgId (NULL(=15) / DES-CBC(9) / DES3-CBC(12) ");
				AUSGABE("\nall other values are invalid ");
				getalgid(&des_alg_id, &get_keysize);
				AUSGABE("\nKeyId of the plainkey ");
				getkeyid(&key_id);
				getencdesfile();

                                encryption_key.key_algid = alg_id;
  
                                encryption_key.key_bits = &key_bits;
                                encryption_key.key_bits->part1.noctets = pk_ostr->noctets;
                                encryption_key.key_bits->part1.octets =  pk_ostr->octets;
                                encryption_key.key_bits->part2.noctets = 3;
                                encryption_key.key_bits->part2.octets = fermatf4;


				plain_key.key_algid = des_alg_id;
				plain_key.key_id    = &key_id;


                                rcode = sca_enc_des_key (sct_id, &encryption_key,&plain_key,
							 &encrypted_key);
/* Attention please: encrypted_key.subjectkey.bits must be released */

                                if (rcode < 0){
                                     fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else {
			  	     fprintf(stdout,"TEST: sca_enc_des_key successful! \n");
                                     fprintf(stdout, "encrypted_key: \n");
                                     n = encrypted_key.subjectkey.nbits;
                                     aux_xdump(encrypted_key.subjectkey.bits, n/8, 0);
				     key_ostr.noctets = n/8;
				     key_ostr.octets  = encrypted_key.subjectkey.bits;
                                     writeencdeskey(&key_ostr, encdes_file);
                                } /* end else */

                                if (pk_ostr != NULL)
			             aux_free_OctetString(&pk_ostr);

				if (key_ostr.octets != NULL)
				     free(key_ostr.octets);

                                break;

			case 37:
                                fprintf(stdout, "TEST: call sca_dec_des_key\n ");
				AUSGABE("\nEncrypted_RSA_AlgId (RSA(0) / RSAEncryption(8)) ");
				AUSGABE("\nall other values are invalid ");
				getalgid(&encrypted_key.encryptionAI, &get_keysize);

				AUSGABE("\nEncrypted_DES_AlgId (DES-CBC(9) / DES3-CBC(12) ");
				AUSGABE("\nall other values are invalid ");
				getalgid(&encrypted_key.subjectAI, &get_keysize);


				getencdesfile();
/* Attention please: enckey_ostr must be released */
                                enckey_ostr = aux_file2OctetString (encdes_file);
			        if (enckey_ostr == NULL)
			        { 
				   fprintf(stdout,"Can't read ENCDES_File\n");
				   break;
				} 


				encrypted_key.subjectkey.nbits = enckey_ostr->noctets * 8;
				encrypted_key.subjectkey.bits = enckey_ostr->octets; 


				AUSGABE("\nPlain key_id ");
				getkeyid(&des_key_id);
				plain_key.key_id = &des_key_id;


				AUSGABE("\nDecryption key_id ");
				getkeyid(&rsa_key_id);
				decryption_key.key_id = &rsa_key_id;

                                rcode = sca_dec_des_key (sct_id, &encrypted_key,
							&plain_key,&decryption_key);

                                if (rcode < 0){
                                     fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else {
                                     fprintf(stdout,"rcode: %d\n", rcode);

			  	     fprintf(stdout,"TEST: sca_dec_des_key successful! \n");
                                } /* end else */

                                if (enckey_ostr != NULL)
			             aux_free_OctetString(&enckey_ostr);

                                break;

			case 38:
                                fprintf(stdout, "TEST: call sca_gen_dev_key\n ");
				/* in the parameter key_dev_sel
				 * - key_algid
				 * - key_id and
				 * - key_purpose 
				 * are evaluated
				 */

                                getalgid(&alg_id, &get_keysize);
				key_dev_sel.key_algid = alg_id;
				if (get_keysize == 1) {
					/* RSA; get keysize */
					EINGABE("%d",&keysize,"\nkeysize  (512 or 1024) :",keysize);	
					if (keysize != 512) {
				  		alg_parm_int = (int *) (key_sel.key_algid->param);
						*alg_parm_int = keysize;
					}
				}

					
				getkeyid(&key_id);
			      	key_dev_sel.key_id   = &key_id;

				getdevpurpose(&key_dev_sel.key_purpose);

				EINGABE("%s",data,"\nAPPL_ID (6 OCTETS):",data);


				out_data.noctets = strlen(data);
				out_data.octets	= data;



                                rcode = sca_gen_dev_key (sct_id, &key_dev_sel,
						         &out_data); 

                                if (rcode < 0){
                                     fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else {
			  	     fprintf(stdout,"TEST: sca_gen_dev_key successful! \n");
                                } /* end else */


                                break;
			case 39:
                                fprintf(stdout, "TEST: call sca_inst_dev_key\n ");

				getkeydevsel(&key_dev_sel,&key_id);
				if (key_dev_sel.key_status == 1) {
					/* ANY */
					EINGABE("%s",data,"\nAPPL_ID (6 OCTETS):",data);


					out_data.noctets = strlen(data);
					out_data.octets	= data;
				}

			        rcode = getkeyattrlist(&key_attr_list);

			        if (rcode == 0) {
					if (key_dev_sel.key_status == 1) {
                                  		rcode = sca_inst_dev_key (sct_id, &key_dev_sel,
							    		  &out_data,
							    	 	  &key_attr_list);
					}
 					else {
                                 		rcode = sca_inst_dev_key (sct_id, &key_dev_sel,
							    		  NULLOCTETSTRING,
							    	 	  &key_attr_list);
					}
				}
				else {
					if (key_dev_sel.key_status == 1) {
                                  		rcode = sca_inst_dev_key (sct_id, &key_dev_sel,
							   		  &out_data, 
							    		  KEYATTRLISTNULL);
					}
				else {
                                  		rcode = sca_inst_dev_key (sct_id, &key_dev_sel,
							   		  NULLOCTETSTRING, 
							    		  KEYATTRLISTNULL);
					}
				}


                                if (rcode < 0){
                                     fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else {
			  	     fprintf(stdout,"TEST: sca_inst_dev_key successful! \n");
                                } /* end else */




                                break;
			case 40:
                                fprintf(stdout, "TEST: call sca_del_dev_key\n ");
				getkeydevsel(&key_dev_sel,&key_id);
				EINGABE("%s",data,"\nAPPL_ID (6 OCTETS):",data);


				out_data.noctets = strlen(data);
				out_data.octets	= data;

                                rcode = sca_del_dev_key (sct_id, &key_dev_sel,
						         &out_data);

                                if (rcode < 0){
                                     fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else {
			  	     fprintf(stdout,"TEST: sca_del_dev_key successful! \n");
                                } /* end else */


                                break;
			case 41:
                                fprintf(stdout, "TEST: call sca_load_devkeyset\n ");
   				AUSGABE("\nKey_status:  ");
   				EINGABE("%d",&key_dev_list.key_status,"\nOWN(0) / ANY  (1) ",key_dev_list.key_status);
				switch (key_dev_list.key_status) {
				 case DEV_OWN:
					key_dev_list.list_ref.purpose_list = purpose_set;
					break;
				 case DEV_ANY:
					key_dev_list.list_ref.keyid_list = keyid_list;
					break;
				}

                                rcode = sca_load_devkeyset (sct_id, &appl_id,
							   &key_dev_list);



                                if (rcode < 0){
                                     fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else 
			  	     fprintf(stdout,"TEST: sca_load_devkeyset successful! \n");
				if (appl_id.octets != NULL) {
                                     aux_xdump(appl_id.octets, appl_id.noctets, 0);
				    /* release appl_id.octets  */
				    aux_free2_OctetString(&appl_id);
				}
				    switch(key_dev_list.key_status) {
					case DEV_OWN:
						i = 0;
			  	     		fprintf(stdout,"key_status = DEV_OWN \n");
						while (*(key_dev_list.list_ref.purpose_list + i) != '\0') {
						switch (purpose_set[i]) {
						case PURPOSE_AUTH:
						     fprintf(stdout, "AUTHENTICATE \n");
						     break;
						case PURPOSE_SECAUTH:
						     fprintf(stdout, "SECURE_AUTH \n");
						     break;
						case PURPOSE_SECCONC:
						     fprintf(stdout, "SECURE_CONCEALED \n");
						     break;
						default:
						     fprintf(stdout, "not allowed \n");
						     break;
						}
						i++;
						};
						break;
					case DEV_ANY:
			  	     		fprintf(stdout,"key_status = DEV_ANY \n");
						print_keyidlist (key_dev_list.list_ref.keyid_list);
						i = 0;
						while (keyid_list[i] != KEYIDNULL) {
							free(keyid_list[i]);
							i++;
						}
						break;
					default:
			  	     		fprintf(stdout,"key_status = undefined\n");
						break;
				    }
 


				     



                                break;


			case 42:
                                fprintf(stdout, "TEST: call sca_save_devkeyset\n ");

				getpin(&verify_data,&out_data,&pin_key_id);

			        rcode = getkeyattrlist(&key_attr_list);

				appl_id.octets = data;
				getapplid(&appl_id);

				getkeyidlist(keyid_list, &dev_key1, &dev_key2,
					      &dev_key3);


			        if (rcode == 0)
                                  rcode = sca_save_devkeyset (sct_id, &verify_data, &key_attr_list, &appl_id, keyid_list);
                                else
                                  rcode = sca_save_devkeyset (sct_id, &verify_data, KEYATTRLISTNULL, &appl_id, keyid_list);


				free(out_data.octets);


                                if (rcode < 0){
                                     fprintf(stdout,"sca_errno: %d\n", sca_errno);
                                     fprintf(stdout,"sca_errmsg: %s\n", sca_errmsg);
				}
                                else {
			  	     fprintf(stdout,"TEST: sca_save_devkeyset successful! \n");
                                } /* end else */


                                break;





			case 43:
				fprintf(stdout, "TEST: call sca_inst_user_key\n ");

				/* in the parameter key_sel
				 * - key_id 
				 * are evaluated
				 */

                                getalgid(&alg_id, &get_keysize);
				key_sel.key_algid = NULL;
			        getuserkeyid(&key_id);
			      	key_sel.key_id   = &key_id;

       			        rcode = getkeyattrlist(&key_attr_list);
			        if (rcode == 0)
                   		 rcode = sca_inst_user_key (sct_id, &key_sel,
							    &key_attr_list);
				else
                   		 rcode = sca_inst_user_key (sct_id, &key_sel,
							    KEYATTRLISTNULL);

     

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else 
				   fprintf(stdout,"TEST: key installation successful! \n");


				break;

			case 44:
				fprintf(stdout, "TEST: call sca_enable_deletion\n ");
				appl_id.octets = data;
				getapplid(&appl_id);

                   		 rcode = sca_enable_deletion (sct_id, &appl_id, purpose_set);

     

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else 
				   fprintf(stdout,"TEST: enable successful! \n");

				i = 0; 
				while (purpose_set[i] != '\0') {
					switch (purpose_set[i]) {
						case PURPOSE_AUTH:
						     fprintf(stdout, "AUTHENTICATE \n");
						     break;
						case PURPOSE_SECAUTH:
						     fprintf(stdout, "SECURE_AUTH \n");
						     break;
						case PURPOSE_SECCONC:
						     fprintf(stdout, "SECURE_CONCEALED \n");
						     break;
						default:
						     fprintf(stdout, "not allowed \n");
						     break;
					}
					i++;
				};

				break;


			case 45:
				fprintf(stdout, "TEST: call sca_get_card_data\n ");

			        getsecmess(&sec_mess);

                   		 rcode = sca_get_card_data (sct_id, &in_data,
							    &sec_mess);

     

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else 
				   fprintf(stdout,"TEST: get card data successful! \n");

				
				if (in_data.noctets == 0)
					fprintf(stdout,"no data received\n");
				else {
					fprintf(stdout, "in_data.noctets: %d\n",
					        in_data.noctets);
					aux_xdump(in_data.octets,
				          	in_data.noctets, 0);

					/* release in_data.octets  */
					aux_free2_OctetString(&in_data);
				}



				break;
			case 46:
				fprintf(stdout, "TEST: call sca_activate_devkeyset\n ");
   				EINGABE("%d",&key_level,"\nKEY_LEVEL  (MASTER(4) / CURRENT (5) / PARENT(6) / EEPROM(7)) :",key_level);

   				EINGABE("%d",&value,"\nDEFINE APPL_ID?     YES(0) / NO(1)",value);
   				if (value == 0) {
					appl_id.octets = data;
					getapplid(&appl_id);


                   		 	rcode = sca_activate_devkeyset (sct_id, appl_id, key_level);
				}
				else
                   		 	rcode = sca_activate_devkeyset (sct_id, NULLOCTETSTRING, key_level);

     

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else 
				   fprintf(stdout,"TEST: activate successful! \n");


				break;


			case 47:
				fprintf(stdout, "TEST: call sca_gen_sessionkey\n ");

				AUSGABE("\nINTEGRITY_ALGID: Only NULL(15), DES-CBC-ISO0 or DES3-CBC-ISO0 allowed ");
				getalgid(&session_key.integrity_key,
				         &get_keysize);

				AUSGABE("\nCONCEALED_ALGID: Only NULL(15), DES-CBC-ISO0 or DES3-CBC-ISO0 allowed ");
				getalgid(&session_key.concealed_key,
				         &get_keysize);


                   		rcode = sca_gen_sessionkey (sct_id, &session_key);

     

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else 
				   fprintf(stdout,"TEST: generate session_key successful! \n");


				break;

			case 48:
				fprintf(stdout, "TEST: call sca_del_sessionkey\n ");

				AUSGABE("\nINTEGRITY_ALGID: Only NULL(15), DES-CBC-ISO0 or DES3-CBC-ISO0 allowed ");
				getalgid(&session_key.integrity_key,
				         &get_keysize);

				AUSGABE("\nCONCEALED_ALGID: Only NULL(15), DES-CBC-ISO0 or DES3-CBC-ISO0 allowed ");
				getalgid(&session_key.concealed_key,
				         &get_keysize);


                   		rcode = sca_del_sessionkey (sct_id, &session_key);

     

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else 
				   fprintf(stdout,"TEST: delete session_key successful! \n");


				break;

			case 49:
				fprintf(stdout, "TEST: call sca_reset\n ");

			        EINGABE("%d",&com_mode,"\nMODE (COM_OPEN = 0 / COM_CLOSE = 1) :",com_mode);
				if (com_mode == COM_OPEN) {
			        	EINGABE("%d",&port,"\nPORT (NULL = 0) :",port);
				}
				else
					port = 0;


				if (port == 0)
                   			rcode = sca_reset (sct_id, com_mode, NULL);
				else {

			        	EINGABE("%d",&sct_info.icc_request,"\nICC_REQUEST (FALSE=0 / TRUE=1) :",sct_info.icc_request);
                   			rcode = sca_reset (sct_id, com_mode, sct_info);
				}

     

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else { 
				   fprintf(stdout,"TEST: sca_reset successful! \n");
				   switch (rcode) {
				   case 2:
				   	fprintf(stdout,"M_NO_CARD_INSERTED\n");
					break;

				   case 3:
				   	fprintf(stdout,"M_CARD_INSERTED\n");
					break;

				   case 4:
				   	fprintf(stdout,"M_REMOVE_CARD\n");
					break;
				   }
				}


				break;
			case 50:
				fprintf(stdout, "TEST: call sca_get_sctport\n ");

                   		rcode = sca_get_sctport (sct_id, &get_sct_port);

				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout,"sca_errno: %d\n", sca_errno);
				   fprintf(stdout,"TEST: error-message: %s\n", sca_errmsg);
				}
				else 
				   fprintf(stdout,"TEST: sca_get_sctport successful! \n");


				break;

			case 51:
				fprintf(stdout, "call sca_journal\n ");
				EINGABE("%d",&record_no,"\nRECORD_NO (last = 0 / previous = 1 / next = 2) :",record_no);
				EINGABE("%d",&value,"\nPRESENT (0=plaintext / 1=chiffre) :",value);
				if (value == 0)
				  present = FALSE;
				else
				  present = TRUE;


				record.noctets = 0;
				record.octets = NULL;
				rcode = sca_journal (sct_id, record_no,
						     present, &record);
				fprintf(stdout, "TEST: rcode: %d\n", rcode);
				if (rcode < 0) {
				   fprintf(stdout, "sca_errno: %d\n", sca_errno);
				   fprintf(stdout, "sca_errmsg: %s\n", sca_errmsg);
				}
				else {

				   fprintf(stdout, "record: \n");
				   aux_xdump(record.octets,
					     record.noctets, 0);
				   fprintf(stdout, "\nsca_journal executed ! \n");


				    /* release record.octets  */
				    aux_free2_OctetString(&record);
				}

				break;

			default:
				break;
		}

		fprintf(stdout,"\nCONTINUE (0) ?");
		scanf("%d",&value);
		getchar();

		men();
		if (input == TRUE)
		{
		  scanf("%d",&aw1);
		  getchar();
		}
		else
		{
        	  fscanf(testfile,"%d",&aw1);
		  fgetc(testfile);
		}



	}

#ifdef MFCHECK
  MF_file = fopen("MF_CHECK","w");

  MF_fprint(MF_file);
#endif 

   rcode = sca_reset (sct_id, COM_CLOSE, NULL);
   exit(); 


}


print_keyidlist(keyidlist)
KeyId **keyidlist;
{
	int i;
	KeyId *key_id;

	i = 0;
	while (*(keyidlist + i) != KEYIDNULL) {
		key_id = *(keyidlist + i);
		fprintf(stdout, "Key (%d)   : \n",i+1);
		fprintf(stdout, "  KeyLevel : ");
		switch (key_id->key_level) {
		 case FILE_MF:
			fprintf(stdout, "FILE_MF \n");
			break;
		 case FILE_DF:
			fprintf(stdout, "FILE_DF \n");
			break;
		 case FILE_CHILD:
			fprintf(stdout, "FILE_CHILD \n");
			break;
		 case FILE_MASTER:
			fprintf(stdout, "FILE_MASTER\n");
			break;
		 case FILE_CURRENT:
			fprintf(stdout, "FILE_CURRENT \n");
			break;
		 case FILE_PARENT:
			fprintf(stdout, "FILE_PARENT \n");
			break;
		 default:
			fprintf(stdout, "undefined \n");
			break;
		};
		fprintf(stdout, "  KeyNumber: %d \n",key_id->key_number);
		i++;
	};
}
		

sta_itoa(s,n)			     /* from integer to character string */
char s[];
int n;
{
    int c,i,j, sign;

    if((sign = n) < 0)
      n = -n;
    i = 0;
    do {			 /* generation from right to left */
	 s[i++] = n % 10 + '0';
    } while ((n /= 10) > 0);
    s[i] = '\0';

    /* reverse(s);*/
    for (i=0, j=strlen(s)-1; i<j; i++, j--) {
	c = s[i];
	s[i] = s[j];
	s[j] = c;
    } /* end for */

} /* end sta_itoa */














void chartobool(char_value)
char *char_value;
{
  *char_value -= 0x30;
}

void gettbwfile() {
       EINGABE("%s",tbw_file,"\nFile to be write in smartcard: ",tbw_file);
}

void getauthobjid(obj)
AuthObjectId *obj;
{
      int value;
      EINGABE("%d",&value,"\n  AuthObjectId: DTE_ICC(0) / SCT_ICC(1):",value);
      *obj = value;
}

void getauthprocid (proc_id)
AuthProcId *proc_id;
{
      int value;
      EINGABE("%d",&value,"\n  AuthProcId: IN_AUTH(66) / EX_AUTH(67) / MU_AUTH(69) / MU_AUTHWithINITIAL(70):",value);
      *proc_id = value;
}

int getenckey (key, sec_key)
KeyInfo	*key;
char    *sec_key;
{
    char alg_no;
    int  value;

   EINGABE("%d",&value,"\nKeyInfo?     YES(0) / NO(1)",value);
   if (value == 0)
   {

      AUSGABE("\nSubjectAI:  ");
      EINGABE("%c",&alg_no,"\ndesCBC_ISO0 (0) \n ",alg_no);
      switch (alg_no)
      {
	  case '0': 
		key->subjectAI = desCBC_ISO0;
		break;

	  default:
		key->subjectAI =  rsa;
		break;
      }

      EINGABE("%s",sec_key,"\nSubjectkey :",sec_key);
      key->subjectkey.nbits = strlen(sec_key) * 8;
      key->subjectkey.bits  = sec_key;
    }
    return(value);
}


void printpublickey(key_bits)
KeyBits *key_bits;
{
        int n, k;
        char *alg;                  

        n = key_bits->part1.noctets;
        aux_xdump(key_bits->part1.octets, n, 0);
        fprintf(stdout, "\n");
        n = key_bits->part2.noctets;
        aux_xdump(key_bits->part2.octets, n, 0);
}

void  gethashalgid(aid)
AlgId **aid;
{
   char alg_no;
   strcpy(algname," ");

   AUSGABE("\nAlgorithm:  ");
   EINGABE("%c",&alg_no,"\nSqmodn(1) / MD2(2) / MD4(3) / MD5(4) / SHA(5)\n ",alg_no);

      switch (alg_no)
      {
	  case '1': 
		*aid = 	sqmodn;
		strcpy(algname,"Sqmodn");
		break;
	  case '2': 
		*aid = 	md2;
		break;
	  case '3': 
		*aid = 	md4;
		break;
	  case '4': 
		*aid = 	md5;
		break;
	  case '5': 
		*aid = 	sha;
		break;

	  default:
		*aid =  rsa;
		break;

      }

}



void getpkfile() {
       EINGABE("%s",pk_file,"\nFile where the PK is stored: ",pk_file);
}


void gethashfile() {
       EINGABE("%s",hash_file,"\nFile where the hash_result is to be stored: ",hash_file);
}

void gettxtfile() {
       EINGABE("%s",txt_file,"\nFile which shall be hashed / encrypted / decrypted: ",txt_file);
}




void getencdesfile() {
       EINGABE("%s",encdes_file,"\nFile where the encrypted key is to be stored: ",encdes_file);
}

void gettbsfile() {
       EINGABE("%s",tbs_file,"\nFile to be signed: ",tbs_file);
}

void getsignaturefile() {
       EINGABE("%s",sign_file,"\nSignature File: ",sign_file);
}
void gettbvfile() {
       EINGABE("%s",tbs_file,"\nFile to be verified: ",tbs_file);
}



void getdencfile() {
       EINGABE("%s",enc_file,"\nFile where the ENC/DEC_result is to be stored: ",enc_file);
}




int writehashresult(ostring, name)
OctetString *ostring;
char *name;
{
        RC rc;
        rc = aux_OctetString2file(ostring, name, 2);
        return(rc);
}


int writeencdeskey(ostring, name)
OctetString *ostring;
char *name;
{
        RC rc;
        rc = aux_OctetString2file(ostring, name, 2);
        return(rc);
}

int writesignature(signature, name)
Signature *signature;
char *name;
{
        OctetString ostring;
        RC rc;
	int i;
	char *proc="writesignature";
	ostring.noctets = signature->signature.nbits / 8;
	if ((ostring.octets = (char *) malloc(ostring.noctets)) == NULL)
		{ fprintf (stderr, "memory error \n"); return (-1); }
	for (i=0; i<ostring.noctets; i++)
		*(ostring.octets + i) = *(signature->signature.bits + i);

        rc = aux_OctetString2file(&ostring, name, 2);
        free (ostring.octets);
        return(rc);
}


int writeencresult(ostring, name)
OctetString *ostring;
char *name;
{
        RC rc;
        rc = aux_OctetString2file(ostring, name, 2);
        return(rc);
}

int writedecresult(ostring, name)
OctetString *ostring;
char *name;
{
        RC rc;
        rc = aux_OctetString2file(ostring, name, 2);
        return(rc);
}










