/* smalloc.c - error checking malloc */

#ifndef lint
static char *rcsid = "$Header: /ic/dev/isode/integration/isode/src/lib/compat/RCS/smalloc.c,v 10.1 1994/02/17 17:18:41 awy Rel $";
#endif

/*
 * $Header: /ic/dev/isode/integration/isode/src/lib/compat/RCS/smalloc.c,v 10.1 1994/02/17 17:18:41 awy Rel $
 *
 *
 * $Log: smalloc.c,v $
 */

/*
 *                                NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include "compat/general.h"
#include "compat/manifest.h"

/*  */

static void default_smalloc_handler (void)
{
	abort ();
}

static VFP smalloc_handler = default_smalloc_handler;

VFP set_smalloc_handler (fnx)
VFP fnx;
{
	VFP savefnx = smalloc_handler;

	if (fnx)
		smalloc_handler = fnx;
	else	smalloc_handler = default_smalloc_handler;
	return savefnx;
}

char *
smalloc(int size)
{
	register char *ptr;

	if ((ptr = malloc((unsigned) size)) == (char *)0) {
		(*smalloc_handler) ();
		_exit(1);	/* just in case */
	}

	return(ptr);
}
