/* prim2num.c - presentation element to integer */

#ifndef	lint
static char *rcsid = "$Header: /ic/dev/isode/integration/isode/src/lib/asn1/ber/RCS/prim2num.c,v 10.1 1994/02/17 17:17:54 awy Rel $";
#endif

/* 
 * $Header: /ic/dev/isode/integration/isode/src/lib/asn1/ber/RCS/prim2num.c,v 10.1 1994/02/17 17:17:54 awy Rel $
 *
 *
 * $Log: prim2num.c,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <stdio.h>
#include "asn1/asn1.h"

/*  */

integer	prim2num (register PE pe)
{
    register integer    i;
    register PElementData dp,
			  ep;

    if (pe -> pe_form != PE_FORM_PRIM || pe -> pe_prim == NULLPED)
	return pe_seterr (pe, PE_ERR_PRIM, NOTOK);
    if (pe -> pe_len > sizeof (i))
	return pe_seterr (pe, PE_ERR_OVER, NOTOK);

    pe -> pe_errno = PE_ERR_NONE;/* in case integer is NOTOK-valued */
    dp = pe -> pe_prim;
    if (pe -> pe_len > 1 && ((*dp == 0 && ((*(dp+1)) & 0x80) == 0) ||
	(*dp == 0xff && ((*(dp + 1)) & 0x80) == 0x80)))
	return pe_seterr (pe, PE_ERR_SYNTAX, NOTOK);
    i = ((*dp) & 0x80) ? (-1) : 0;
    for (ep = dp + pe -> pe_len; dp < ep;)
	i = (i << 8) | (*dp++ & 0xff);

    return i;
}
