/* pe2text.c - write a PE thru a debug filter */

#ifndef	lint
static char *rcsid = "$Header: /ic/dev/isode/integration/isode/src/lib/asn1/ber/RCS/pe2text.c,v 10.1 1994/02/17 17:17:54 awy Rel $";
#endif

/* 
 * $Header: /ic/dev/isode/integration/isode/src/lib/asn1/ber/RCS/pe2text.c,v 10.1 1994/02/17 17:17:54 awy Rel $
 *
 *
 * $Log: pe2text.c,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <stdio.h>
#include "asn1/asn1.h"
#include "compat/logger.h"

/*  */

/* logfile-backed abstract for PStreams */

/* ARGSUSED */

static int  ll_pswrite (PS ps, PElementData data, PElementLen n, int in_line)
{
    register LLog    *lp = (LLog *) ps -> ps_addr;

    if (lp -> ll_stat & LLOGTTY) {
	(void) fflush (stdout);

	(void) fwrite ((char *) data, sizeof *data, (int) n, stderr);
	(void) fflush (stderr);
    }

    if (lp -> ll_fd == NOTOK) {
	if ((lp -> ll_stat & (LLOGERR | LLOGTTY)) == (LLOGERR | LLOGTTY))
	    return ((int) n);
	if (ll_open (lp) == NOTOK)
	    return NOTOK;
    }
    else
	if (ll_check (lp) == NOTOK)
	    return NOTOK;

    return write (lp -> ll_fd, (char *) data, (int) n);
}

/*  */

static int  ll_psopen (register PS ps)
{
    ps -> ps_writeP = ll_pswrite;

    return OK;
}

#define	ll_psetup(ps, lp)	((ps) -> ps_addr = (caddr_t) (lp), OK)

/*  */

void	pe2text (register LLog *lp, register PE pe, int rw, int cc)
{
    register char   *bp;
    char   buffer[BUFSIZ];
    register PS ps;

    bp = buffer;
    (void) sprintf (bp, "%s PE", rw ? "read" : "wrote");
    bp += strlen (bp);
    if (pe -> pe_context != PE_DFLT_CTX) {
	(void) sprintf (bp, ", context %d", pe -> pe_context);
	bp += strlen (bp);
    }
    if (cc != NOTOK) {
	(void) sprintf (bp, ", length %d", cc);
	bp += strlen (bp);
    }
    LLOG (lp, LLOG_ALL, ("%s", buffer));

    if ((ps = ps_alloc (ll_psopen)) != NULLPS) {
	if (ll_psetup (ps, lp) != NOTOK)
	    (void) pe2pl (ps, pe);

	ps_free (ps);
    }

    (void) ll_printf (lp, "-------\n");

    (void) ll_sync (lp);
}
