#include <ll/internet.h>

static char *empty = 0;
#ifdef	h_addr
    static char *addrs[2] = { 0 };
#endif

#ifdef DG
#   define IADDR_TYPE struct in_addr
#   define IADDR_ADDR(ia) ((ia).s_addr)
#else
#   define IADDR_TYPE u_long
#   define IADDR_ADDR(ia) (ia)
#endif


struct hostent *gethostbystring (char *s)
{
    register struct hostent *h;
    static IADDR_TYPE iaddr;
    static struct hostent   hs;

    iaddr = inet_addr (s);
    if (IADDR_ADDR(iaddr) == NOTOK && strcmp (s, "255.255.255.255"))
	return gethostbyname (s);

    h = &hs;
    h -> h_name = s;
    h -> h_aliases = &empty;
    h -> h_addrtype = AF_INET;
    h -> h_length = sizeof (iaddr);
#   if defined(h_addr)
	h -> h_addr_list = addrs;
#   endif
    h -> h_addr = (char *) &iaddr;

    return h;
}

