/* asprintf.c - sprintf with errno */

#ifndef	lint
static char *rcsid = "$Header: /ic/dev/isode/integration/isode/src/lib/compat/RCS/asprintf.c,v 10.2 1994/09/08 07:41:06 awy Rel $";
#endif

/* 
 * $Header: /ic/dev/isode/integration/isode/src/lib/compat/RCS/asprintf.c,v 10.2 1994/09/08 07:41:06 awy Rel $
 *
 *
 * $Log: asprintf.c,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <stdio.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include "compat/general.h"
#include "compat/manifest.h"

/*    DATA */

extern int errno;

/*  */

void	asprintf (char *bp, va_list ap)		/* what, fmt, args, ... */
         
       	   
{
    char   *what, *fmt;

    what = va_arg (ap, char *);
    fmt = va_arg (ap, char *);

    _vasprintf (bp, what, fmt, ap);
}

#ifdef X25
unsigned char isode_x25_err[2];
char isode_x25_errflag = 0;
#endif

void	_vasprintf (register char *bp, char *what, char *fmt, va_list ap)
{
    register int    eindex;

    eindex = errno;

    *bp = 0;

    if (fmt) {
#ifndef	VSPRINTF
	struct _iobuf iob;
#endif

#ifndef	VSPRINTF
#ifdef	pyr
	bzero ((char *) &iob, sizeof iob);
	iob._file = _NFILE;
#endif
	iob._flag = _IOWRT | _IOSTRG;
#if	!defined(vax) && !defined(pyr)
	iob._ptr = (unsigned char *) bp;
#else
	iob._ptr = bp;
#endif
	iob._cnt = BUFSIZ;
	_doprnt (fmt, ap, &iob);
	putc (NULL, &iob);
#else
	(void) vsprintf (bp, fmt, ap);
#endif
	bp += strlen (bp);

    }

    if (what) {
	if (*what) {
	    (void) sprintf (bp, " %s: ", what);
	    bp += strlen (bp);
	}
	(void) strcpy (bp, sys_errname (eindex));
	bp += strlen (bp);

#ifdef X25
	if (isode_x25_errflag) {	
		(void) sprintf (bp, " (%02x %02x)",isode_x25_err[0],isode_x25_err[1]);
		bp += strlen (bp);
	}
#endif

    }

    errno = eindex;
}

void	_asprintf (register char *bp, char *what, va_list ap) /* fmt, ... */
{
    char *fmt = va_arg(ap, char *);
    _vasprintf(bp, what, fmt, ap);
    return;
}
