/* tsap.h - include file for transport users (TS-USER) */

/* 
 * $Header: /ic/dev/isode/integration/isode/src/h/ll/RCS/tsap.h,v 10.4 1994/10/10 08:12:23 jmf Rel $
 *
 *
 * $Log: tsap.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_TSAP_
#define	_TSAP_			

#ifndef P_
#ifdef __STDC__
#define P_(p) p
#else
#define P_(p) ()
#endif
#endif

#include "compat/manifest.h"
#include "compat/general.h"
#include "ll/isoaddrs.h"

#ifdef __cplusplus
extern "C" {
#endif

/*  */

struct TSAPstart {		/* T-CONNECT.INDICATON */
    int     ts_sd;		/* TRANSPORT descriptor */

    struct TSAPaddr ts_calling;	/* address of peer calling */
    struct TSAPaddr ts_called;	/* address of peer called */

    int     ts_expedited;	/* EXPEDITED DATA ok */

    int	    ts_tsdusize;	/* largest atomic TSDU */

    struct QOStype ts_qos;	/* quality of service */

				/* initial DATA from peer */
#define	TS_SIZE		32
    int	    ts_cc;		/*   length */
    char    ts_data[TS_SIZE];	/*   data */
};


struct TSAPconnect {		/* T-CONNECT.CONFIRMATION */
    int     tc_sd;		/* TRANSPORT descriptor */

    struct TSAPaddr tc_responding;/* address of peer responding */

    int     tc_expedited;	/* EXPEDITED DATA ok */

    int	    tc_tsdusize;	/* largest atomic TSDU */

    struct QOStype tc_qos;	/* quality of service */

				/* initial DATA from peer */
#define	TC_SIZE		32
    int	    tc_cc;		/*   length */
    char    tc_data[TC_SIZE];	/*   data */
};


struct TSAPdata {		/* T-READ.INDICATION */
    int     tx_expedited;

				/* DATA from peer */
#define	TX_SIZE		16	/* EXPEDITED DATA only */
    int	    tx_cc;		/*   total length */
    struct qbuf tx_qbuf;	/*   chained data */
};
#define	TXFREE(tx)	QBFREE (&((tx) -> tx_qbuf))


struct TSAPdisconnect {		/* T-DISCONNECT.INDICATION */
    int     td_reason;		/* reason for DISCONNECT, from ISO8072: */
#define	DR_BASE		0x80
#define	DR_NORMAL	(DR_BASE + 0)	/* NORMAL disconnect by SESSION
					   entity */
#define	DR_REMOTE	(DR_BASE + 1)	/* Remote TRANSPORT entity congested at
					   connect request time */
#define	DR_CONNECT	(DR_BASE + 2)	/* Connection negotiation failed */
#define	DR_DUPLICATE	(DR_BASE + 3)	/* Duplicate source reference detected
				           for the same pair of NSAPs */
#define	DR_MISMATCH	(DR_BASE + 4)	/* Mismatched references */
#define	DR_PROTOCOL	(DR_BASE + 5)	/* Protocol error */
#define	DR_OVERFLOW	(DR_BASE + 7)	/* Reference overflow */
#define	DR_REFUSED	(DR_BASE + 8)	/* Connect request refused on this
				           network connection */
#define	DR_LENGTH	(DR_BASE + 10)	/* Header or parameter length
					   invalid */

					/* begin UNOFFICIAL */
#define	DR_NETWORK	(DR_BASE + 11)	/* Network disconnect */
#define	DR_PARAMETER	(DR_BASE + 12)	/* Invalid parameter */
#define	DR_OPERATION	(DR_BASE + 13)	/* Invalid operation */
#define	DR_TIMER	(DR_BASE + 14)	/* Timer expired */
#define	DR_WAITING	(DR_BASE + 15)	/* Indications waiting */
					/* end UNOFFICIAL */

#define	DR_UNKNOWN	0		/* Reason not specifed */
#define	DR_CONGEST	1		/* Congestion at TSAP */
#define	DR_SESSION	2		/* Session entity not attached to
					   TSAP */
#define	DR_ADDRESS	3		/* Address unknown */

#ifdef	notdef
#define	DR_FATAL(r)	((r) < DR_BASE || (r) < DR_PARAMETER)
#define	DR_OFFICIAL(r)	((r) < DR_BASE || (r) < DR_NETWORK)
#else
#define	DR_FATAL(r)	((r) < DR_PARAMETER)
#define	DR_OFFICIAL(r)	((r) < DR_NETWORK)
#endif

#define DR_CONS			256		/* Base for CONS reson codes */
#define DR_CONS_UNDEFINED  	DR_CONS+0	/* Undefined */
		/* originator: NS_PROVIDER */
#define	DR_CONS_PROVIDER	DR_CONS+224	/* GENERIC */
#define	DR_CP_DIS_TRANS		DR_CONS+225	/* Disconnect - transient */
#define	DR_CP_DIS_PERM		DR_CONS+226	/* Disconnect - permanent */
#define	DR_CP_REJ_UNSPEC_TRANS	DR_CONS+227	/* Reject - transient */
#define	DR_CP_REJ_UNSPEC_PERM  	DR_CONS+228	/* Reject - permanent */
#define	DR_CP_REJ_NO_QOS_TRANS 	DR_CONS+229	/* No QOS - transient */
#define	DR_CP_REJ_NO_QOS_PERM  	DR_CONS+230	/* No QOS - permanent */
#define	DR_CP_REJ_NSAP_UNREACH_TRANS 	DR_CONS+231	/* NSAP unreachable */
#define	DR_CP_REJ_NSAP_UNREACH_PERM  	DR_CONS+232	/* NSAP unreachable */
#define	DR_CP_RESET_UNSPEC	DR_CONS+233	/* Unspecified RESET */
#define	DR_CP_RESET_CONGESTION 	DR_CONS+234	/* RESET due to congestion */
#define	DR_CP_REJ_NSAP_UNKNOWN_PERM  	DR_CONS+235	/* Unknown NSAP */
		/* originator: NS_USER */
#define	DR_CONS_USER		DR_CONS+240	/* GENERIC */
#define	DR_CU_DIS_NORMAL	DR_CONS+241	/* Normal disconnect */
#define	DR_CU_DIS_ABNORMAL	DR_CONS+242	/* Abnormal disconnect */
#define	DR_CU_REJ_UNSPEC_TRANS	DR_CONS+244	/* Reject - transient */
#define	DR_CU_REJ_UNSPEC_PERM	DR_CONS+245	/* Reject - permanent */
#define	DR_CU_REJ_NO_QOS_TRANS 	DR_CONS+246	/* No QOS - transient */
#define	DR_CU_REJ_NO_QOS_PERM  	DR_CONS+247	/* No QOS - permanent */
#define	DR_CU_REJ_INCOMPAT	DR_CONS+248	/* Incompatable NS user data */
#define	DR_CU_RESET_USER_RESYNCH DR_CONS+250	/* User RESET */

				/* disconnect DATA from peer */
#define	TD_SIZE		64
    int	    td_cc;		/*   length */
    char    td_data[TD_SIZE];	/*   data */
};

/*  */

extern char *tsapversion;

extern int tsaplose P_((
    register struct TSAPdisconnect *td,
    int reason,
    ...
));

/*  T-CONNECT.INDICATION 
 */
extern int TInit P_((
    register int vecp,
    register char **vec,
    register struct TSAPstart * ts,
    register struct TSAPdisconnect * td
));

/*  T-CONNECT.RESPONSE 
 */
extern int TConnResponse P_((
    int sd,
    register struct TSAPaddr * responding,
    int expedited,
    char *data,
    int cc,
    struct QOStype * qos,
    register struct TSAPdisconnect * td
));

/*  T-CONNECT.REQUEST (backwards-compatible) 
 */
#define	TConnRequest(a1,a2,a3,a4,a5,a6,a7,a8) \
	TAsynConnRequest(a1,a2,a3,a4,a5,a6,a7,a8,0)

/*  T-(ASYN-)CONNECT.REQUEST 
 */
extern int TAsynConnRequest P_((
    struct TSAPaddr * calling,
    struct TSAPaddr * called,
    int expedited,
    char *data,
    int cc,
    struct QOStype * qos,
    struct TSAPconnect * tc,
    struct TSAPdisconnect * td,
    int async
));

/*  T-ASYN-RETRY.REQUEST (pseudo) 
 */
extern int TAsynRetryRequest P_((
    int sd,
    struct TSAPconnect * tc,
    struct TSAPdisconnect * td
));

/*  Try next NSAP *now*! 
 */
extern int TAsynNextRequest P_((
    int sd,
    struct TSAPconnect *tc,
    struct TSAPdisconnect *td
));

/*  T-DATA.REQUEST 
 */
extern int TDataRequest P_((
    int sd,
    char *data,
    int cc,
    struct TSAPdisconnect * td
));

/*  T-WRITE.REQUEST (pseudo) 
 */
extern int TWriteRequest P_((
    int sd,
    struct udvec * uv,
    struct TSAPdisconnect * td
));

extern int TWriteRequest2 P_((
    int sd,
    struct udvec * uv,
    struct TSAPdisconnect * td,
    int eot
));

/*  T-EXPEDITED-DATA.REQUEST 
 */
extern int TExpdRequest P_((
    int sd,
    char *data,
    int cc,
    struct TSAPdisconnect * td
));

/*  T-READ.REQUEST (pseudo) 
 */
extern int TReadRequest P_((
    int sd,
    register struct TSAPdata * tx,
    int secs,
    register struct TSAPdisconnect * td
));

/*  T-DISCONNECT.REQUEST 
 */
extern int TDiscRequest P_((
    int sd,
    char *data,
    int cc,
    register struct TSAPdisconnect * td
));

/*  define vectors for INDICATION events 
 */
extern int TSetIndications P_((
    int sd,
    VFP data,
    VFP disc,
    struct TSAPdisconnect * td
));

/*  map transport descriptors for select() 
 */
extern int TSelectMask P_((
    int sd,
    fd_set * mask,
    int *nfds,
    register struct TSAPdisconnect * td
));

/*  return select() mask of all listening transport descriptors
 */
extern int TGetReadMask P_((
    fd_set *mask,
    int *nfds
));

/*  return select() mask of all transport descriptors with queued
 *  writes pending
 */
extern int TGetWriteMask P_((
    fd_set *mask,
    int *nfds
));

/*  service listens and/or queued writes on specified transport
 *  descriptors
 */
extern int TNetCheck P_((
    int *vecp,
    char **vec,
    fd_set *ifds,
    fd_set *ofds,
    int nfds,
    struct TSAPdisconnect *td
));

/*  estimate of octets that might be returned 
 */
extern int TSelectOctets P_((
    int sd,
    long int *nbytes,
    register struct TSAPdisconnect * td
));

/*  get TSAPs 
 */
extern int TGetAddresses P_((
    int sd,
    struct TSAPaddr * initiating,
    struct TSAPaddr * responding,
    register struct TSAPdisconnect * td
));

#ifdef MGMT
/*  defining transport manager 
 */
extern int TSetManager P_((
    int sd,
    IFP fnx,
    register struct TSAPdisconnect *td 
));
#endif

/*  return TSAP error code in string form 
 */
extern char *TErrString P_((
    register int code 
));
	
/*  start listenting on an TSAP 
 */
extern int TNetListen P_((
    register struct TSAPaddr * ta,
    struct TSAPdisconnect * td
));
extern int TNetListenAux P_((
    register struct TSAPaddr *ta,
    IFP magic,
    struct TSAPdisconnect *td
));

/*  start listenting on a set of unique TSAPs 
 */
extern int TNetUnique P_((
    register struct TSAPaddr * ta,
    struct TSAPdisconnect * td
));

#define	TNetAccept(p,v,n,r,w,e,s,t) \
	TNetAcceptAux ((p), (v), NULLIP, NULLTA, (n), (r), (w), (e), (s), (t))

/*  accept a call on a TSAP 
 */
extern int TNetAcceptAux P_((
    int *vecp,
    char **vec,
    int *newfd,
    struct TSAPaddr * ta,
    int nfds,
    fd_set * rfds,
    fd_set * wfds,
    fd_set * efds,
    int secs,
    struct TSAPdisconnect * td
));

/*  stop listening on a TSAP 
 */
extern int TNetClose P_((
    register struct TSAPaddr * ta,
    struct TSAPdisconnect * td
));

/*  enable/disable queued (non-blocking) writes 
 */
extern int TSetQueuesOK P_((
    int sd,
    int onoff,
    struct TSAPdisconnect * td
));

extern int TSaveState P_((
    int sd,
    char **vec,
    register struct TSAPdisconnect *td
));
extern int TRestoreState P_((
    char *buffer,
    register struct TSAPstart *ts,
    register struct TSAPdisconnect *td
));

extern int TNetFork P_((
    int vecp,
    char **vec,
    struct TSAPdisconnect *td
));

/*  return name of local host (sigh) 
 */
#define	TLocalHostName	getlocalhost
extern char *TLocalHostName P_((
    void
));


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _TSAP_ */
