/* isoservent.h - ISODE services database access routines */

/* 
 * $Header: /ic/dev/isode/integration/isode/src/h/ll/RCS/isoservent.h,v 10.2 1994/09/21 16:02:23 jmf Rel $
 *
 *
 * $Log: isoservent.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_ISOSERVENT_
#define	_ISOSERVENT_

#ifndef P_
#ifdef __STDC__
#define P_(p) p
#else
#define P_(p) ()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct isoservent {
    char         *is_entity;	/* name of entity */
    char         *is_provider;	/* name of service provider */

#define	ISSIZE	64		/* xSAP selector/ID */
    int		  is_selectlen;
    union {
	char		is_un_selector[ISSIZE];
	unsigned short  is_un_port;
    }		un_is;
#define	is_selector	un_is.is_un_selector
#define	is_port		un_is.is_un_port

    char        **is_vec;	/* exec vector */
    char        **is_tail;	/* next free slot in vector */
};


extern int setisoservent P_((
    int f
));
extern int endisoservent P_((
    void
));

extern struct isoservent *getisoservent P_((
    void
));

extern struct isoservent *getisoserventbyname P_((
    char *entity,
    char *provider
));
extern struct isoservent *getisoserventbyselector P_((
    char *provider,
    char *selector,
    int selectlen
));
extern struct isoservent *getisoserventbyport P_((
    char *provider,
    short unsigned int port
));


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _ISOSERVENT_ */
