/* isoaddrs.h - ISODE addressing */

/* 
 * $Header: /ic/dev/isode/integration/isode/src/h/ll/RCS/isoaddrs.h,v 10.5 1994/09/21 16:01:57 jmf Rel $
 *
 *
 * $Log: isoaddrs.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_ISOADDRS_
#define	_ISOADDRS_

#ifndef P_
#ifdef __STDC__
#define P_(p) p
#else
#define P_(p) ()
#endif
#endif

#include "compat/manifest.h"
#include "compat/general.h"
#include "ll/isoservent.h"

#ifdef __cplusplus
extern "C" {
#endif

/*  */

struct NSAPaddr {		/* this structure shouldn't have holes in it */
    long     na_stack;			/* TS-stack */
#define	NA_NSAP	0			/*   native COTS */
#define	NA_TCP	1			/*   RFC1006/TCP */
#define	NA_X25	2			/*   TP0/X.25 */

    long    na_community;		/* internal community # */
#define	SUBNET_REALNS		(-1)	/* hard-wired */
#define	SUBNET_INT_X25		1	
/* (unused)
#define	SUBNET_JANET		2
 */
#define	SUBNET_INTERNET		3
#define	SUBNET_DYNAMIC		100	/* dynamic start here... */

    union {
	struct na_nsap {		/* real network service */
#define	NASIZE	64			/* 20 ought to do it */
	    char    na_nsap_address[NASIZE];
	    char    na_nsap_addrlen;
	    char    na_nsap_addr_class;	/* CONS/CLNS */
#define NAS_UNKNOWN	0		/* don't know */
#define NAS_CONS	1		/* is CONS  */
#define NAS_CLNS	2		/* is CLNS */
	}               un_na_nsap;

	struct na_tcp {			/* emulation via RFC1006 */
#define	NSAP_DOMAINLEN	63
	    char    na_tcp_domain[NSAP_DOMAINLEN + 1];

	    u_short na_tcp_port;	/* non-standard TCP port */
	    u_short na_tcp_tset;	/* transport set */
#define	NA_TSET_TCP	0x0001		/*   .. TCP */
#define	NA_TSET_UDP	0x0002	        /*   .. UDP */
	}               un_na_tcp;

	struct na_x25 {			/* X.25 (assume single subnet) */
#define	NSAP_DTELEN	36
	    char    na_x25_dte[NSAP_DTELEN + 1]; /* Numeric DTE + Link */
	    char    na_x25_dtelen;	/* number of digits used */

/* Conventionally, the PID sits at the first head bytes of user data and so
 * should probably not be mentioned specially. A macro might do it, if
 * necessary.
 */

#define	NPSIZE	4
	    char    na_x25_pid[NPSIZE];	/* X.25 protocol id */
	    char    na_x25_pidlen;	/*   .. */

#define	CUDFSIZE 16
	    char    na_x25_cudf[CUDFSIZE];/* call user data field */
	    char    na_x25_cudflen;	/* .. */
/*
 * X25 Facilities field. 
 */
#define	FACSIZE	6
	    char    na_x25_fac[FACSIZE];	/* X.25 facilities */
	    char    na_x25_faclen;		/*   .. */
	}               un_na_x25;
    }               na_un;
#define	na_address	na_un.un_na_nsap.na_nsap_address
#define	na_addrlen	na_un.un_na_nsap.na_nsap_addrlen
#define na_addr_class	na_un.un_na_nsap.na_nsap_addr_class

#define	na_domain	na_un.un_na_tcp.na_tcp_domain
#define	na_port		na_un.un_na_tcp.na_tcp_port
#define	na_tset		na_un.un_na_tcp.na_tcp_tset

#define	na_dte		na_un.un_na_x25.na_x25_dte
#define	na_dtelen	na_un.un_na_x25.na_x25_dtelen
#define	na_pid		na_un.un_na_x25.na_x25_pid
#define	na_pidlen	na_un.un_na_x25.na_x25_pidlen
#define	na_cudf		na_un.un_na_x25.na_x25_cudf
#define	na_cudflen	na_un.un_na_x25.na_x25_cudflen
#define	na_fac		na_un.un_na_x25.na_x25_fac
#define	na_faclen	na_un.un_na_x25.na_x25_faclen

/* for backwards compatibility... these two will be removed after ISODE 7.0 */
#define	na_type		na_stack
#define	na_subnet	na_community
};
#define	NULLNA			((struct NSAPaddr *) 0)

struct NSAPinfo {
	char is_prefix[NASIZE];
	int  is_plen;
	struct NSAPaddr is_nsap;
	char	is_class[NASIZE];
	int	is_stack;
};
#define NULLNI	((struct NSAPinfo *)0)

struct TSAPaddr {
#define	NTADDR	8			/* according to NIST OIW */
    struct NSAPaddr ta_addrs[NTADDR];	/* choice of network addresses */
    int     ta_naddr;

#define	TSSIZE	64
    int	    ta_selectlen;

    union un_ta_type {				/* TSAP selector */
	char    ta_un_selector[TSSIZE];

	u_short ta_un_port;
    }               un_ta;
#define	ta_selector	un_ta.ta_un_selector
#define	ta_port		un_ta.ta_un_port
};
#define	NULLTA			((struct TSAPaddr *) 0)


struct SSAPaddr {
    struct TSAPaddr sa_addr;		/* transport address */

#define	SSSIZE	64
    int	    sa_selectlen;

    union {				/* SSAP selector */
	char    sa_un_selector[SSSIZE];

	u_short sa_un_port;
    }               un_sa;
#define	sa_selector	un_sa.sa_un_selector
#define	sa_port		un_sa.sa_un_port
};
#define	NULLSA			((struct SSAPaddr *) 0)


struct PSAPaddr {
    struct SSAPaddr pa_addr;		/* session address */

#define	PSSIZE	64
    int	    pa_selectlen;

    union {				/* PSAP selector */
	char    pa_un_selector[PSSIZE];

	u_short pa_un_port;
    }               un_pa;
#define	pa_selector	un_pa.pa_un_selector
#define	pa_port		un_pa.pa_un_port
};
#define	NULLPA			((struct PSAPaddr *) 0)

/*  */

#ifdef	NULLPE
extern PE (*acsap_lookup) ();

extern char *alias2name P_((
    char *name 
));

extern int add_alias P_((
    char *name,
    char *value 
));

extern int free_isode_alias P_((
    void 
));

extern PE str2dnpe P_((
    char *str 
));

extern PE str2rdnpe P_((
    char *str 
));

extern PE name2value_dase P_((
    char *name,
    char *context,
    int ontty,
    char *userdn,
    char *passwd,
    PE *real_name 
));

extern PE name2value_dase P_((
    char *name,
    char *context,
    int ontty,
    char *userdn,
    char *passwd,
    PE *real_name 
));

extern int build_DSE_PSAPaddr P_((
    PE *pe,
    int explicit,
    int len,
    char *buffer,
    struct PSAPaddr *pa 
));

extern int parse_DSE_PSAPaddr P_((
    register PE pe,
    int explicit,
    int *len,
    char **buffer,
    struct PSAPaddr *pa 
));

extern int set_lookup_dase P_((
    char flag 
));

#endif /* NULLPE */

/*  */
typedef struct AEInfo {		/* "real" directory services! */
#ifdef	NULLPE
    PE	    aei_ap_title;
    PE	    aei_ae_qualifier;
#else
    char *  aei_ap_title;
    char *  aei_ae_qualifier;
#endif

    int	    aei_ap_id;
    int	    aei_ae_id;

    int	    aei_flags;
#define	AEI_NULL	0x00
#define	AEI_AP_ID	0x01
#define	AEI_AE_ID	0x02
    struct PSAPaddr aei_paddr;
}	AEInfo, *AEI;
#define	NULLAEI		((AEI) 0)
#ifdef	NULLPE
#define	AEIFREE(aei) { \
    if ((aei) -> aei_ap_title) \
	pe_free ((aei) -> aei_ap_title), \
	    (aei) -> aei_ap_title = NULLPE; \
    if ((aei) -> aei_ae_qualifier) \
	pe_free ((aei) -> aei_ae_qualifier), \
	    (aei) -> aei_ae_qualifier = NULLPE; \
}
#else
#define	AEIFREE(aei) ;
#endif

/*  application entity title to PSAPaddr 
 */
extern struct PSAPaddr *aei2addr P_((
    AEI aei
));

#ifdef NULLOID
extern AEI oid2aei P_((
    OID oid
));
#endif

#define	str2aei(d,q)	_str2aei ((d), (q), NULLCP, 0, NULLCP, NULLCP)
#define	str2aeinfo(string,context,interactive,userdn,passwd) \
	_str2aei ((string), NULLCP, (context), (interactive), (userdn), \
		  (passwd))
extern AEI _str2aei P_((
    char *designator,
    char *qualifier,
    char *context,
    int interactive,
    char *userdn,
    char *passwd
));

extern char *sprintaei P_((
    AEI aei
));

extern AEI str2aei_dse P_((
    char *string,
    char *context,
    int ontty,
    char *userdn,
    char *passwd
));
extern struct PSAPaddr *aei2addr_dse P_((
    AEI aei
));

struct isoentity {		/* for stub directory service */
    char    *ie_identifier;
    char    *ie_qualifier;
    char    *ie_descriptor;

    struct PSAPaddr ie_addr;
};

extern int setisoentity P_((
    int f
));
extern int endisoentity P_((
    void
));
extern struct isoentity *getisoentity P_((
    void
));

/*  old-style 
 */
extern AEI ie2aei P_((
    register struct isoentity *ie
));

/*  service entry to PSAPaddr 
 */
extern struct PSAPaddr *is2paddr P_((
    char *host,
    char *service,
    struct isoservent *is
));

/*  service entry to SSAPaddr 
 */
extern struct SSAPaddr *is2saddr P_((
    char *host,
    char *service,
    struct isoservent *is
));

/*  service entry to TSAPaddr 
 */
extern struct TSAPaddr *is2taddr P_((
    char *host,
    char *service,
    struct isoservent *is
));

/*  */

/*  string encoding to PSAPaddr 
 */
extern struct PSAPaddr *str2paddr P_((
    char *str
));

/*  string encoding to SSAPaddr 
 */
extern struct SSAPaddr *str2saddr P_((
    char *str
));

/*  string encoding to TSAPaddr 
 */
extern struct TSAPaddr *str2taddr P_((
    char *str
));

#define	paddr2str(pa,na)	_paddr2str ((pa), (na), 0)

/*  PSAPaddr to string encoding 
 */
extern char *_paddr2str P_((
    register struct PSAPaddr *pa,
    register struct NSAPaddr *na,
    int compact
));

/*  SSAPaddr to string encoding 
 */
extern char *saddr2str P_((
    register struct SSAPaddr *sa
));

/*  TSAPaddr to string encoding 
 */
extern char *taddr2str P_((
    register struct TSAPaddr *ta
));

/*  normalize NSAPaddr 
 */
extern struct NSAPaddr *na2norm P_((
    register struct NSAPaddr *na
));

/*  info about an NSAP  
 */
extern struct NSAPinfo *getnsapinfo P_((
    struct NSAPaddr *nsap
));

/*  pretty-print NSAPaddr 
 */
extern char *na2str P_((
    register struct NSAPaddr *na
));

/*  pretty-print PSAPaddr 
 */
extern char *pa2str P_((
    register struct PSAPaddr *px
));

/*  */

/* all of this really should be in "isoqos.h" ... */
   
struct QOStype {
				/* transport QOS */
    int	    qos_reliability;	/* "reliability" element */
#define	HIGH_QUALITY	0
#define	LOW_QUALITY	1

				/* session QOS */
    int	    qos_sversion;	/* session version required */
    int	    qos_extended;	/* extended control */
    int	    qos_maxtime;	/* for SPM response during S-CONNECT */
};
#define	NULLQOS	((struct QOStype *) 0)


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _ISOADDRS_ */
