/* tailor.h - ISODE tailoring */

/* 
 * $Header: /ic/dev/isode/integration/isode/src/h/compat/RCS/tailor.h,v 10.5 1994/09/20 17:38:16 jmf Rel $
 *
 *
 * $Log: tailor.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_TAILOR_
#define	_TAILOR_

#ifndef	_LOGGER_
#include "logger.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* SYSTEM AREAS */

extern char    *isodename;
extern char    *isodebinpath;
extern char    *isodesbinpath;
extern char    *isodetcpath;
extern char    *isodelogpath;


/* LOGGING */

extern LLog *compat_log, _compat_log;
extern LLog *addr_log, _addr_log;
extern LLog *tsap_log, _tsap_log;
extern LLog *ssap_log, _ssap_log;

extern LLog *psap_log, _psap_log;
extern LLog *psap2_log, _psap2_log;
extern LLog *acsap_log, _acsap_log;
extern LLog *rtsap_log, _rtsap_log;
extern LLog *rosap_log, _rosap_log;

extern	int	_tailor_logging_only;


/* TRANSPORT-SWITCH */

extern int	ts_stacks;
#define	TS_NONE	0x00
#define	TS_TCP	0x01
#define	TS_X25	0x02
#define	TS_TP4	0x08
#define TS_X2584 0x10
#define TS_COTS2 0x20
#define	TS_ALL	0xff

struct ts_interim {
    char   *ts_name;		/* community name, also MACRO name */
    char   *ts_value;		/*   .. MACRO value */

    int	    ts_subnet;		/* internal key */
    int	    ts_syntax;		/* same values as na_stack */

    char    ts_prefix[20];	/* NSAP prefix */
    int	    ts_length;		/*   .. and length */
};
extern struct ts_interim ts_interim[];

extern int	ts_communities[];
extern int	ts_comm_nsap_default;
extern int	ts_comm_x25_default;
extern int	ts_comm_tcp_default;

extern int	nsap_default_stack;	/* NAS_CONS or NAS_CLNS */
extern char * local_nsap, * local_clns_nsap, * local_cons_nsap;

extern char *tsb_addresses[];
extern int tsb_communities[];

extern char *tsb_default_address;

#if defined(TLI_TP) || defined(XTI_TP)
extern char * tli_cons_dev;
extern char * tli_clns_dev;
#endif

#ifdef ICL_TLI		/* TLI X25 on ICL DRS6000 */
extern char * icl_tli_initiator;
extern char * icl_tli_responder;
#endif /* ICL_TLI */




/* X.25 */

#ifdef	X25
extern char    *x25_local_dte;
extern char    *x25_local_pid;

extern char     x25_intl_zero;
extern char     x25_strip_dnic;
extern char     *x25_dnic_prefix[];

extern u_char   reverse_charge;
extern u_short  recvpktsize;
extern u_short  sendpktsize;
extern u_char   recvwndsize;
extern u_char   sendwndsize;
extern u_char   recvthruput;
extern u_char   sendthruput;
extern u_char   cug_req;
extern u_char   cug_index;
extern u_char   fast_select_type;
extern u_char   rpoa_req;
extern u_short  rpoa;

extern LLog *x25_log, _x25_log;

#ifdef	CAMTEC_CCL
extern char     x25_outgoing_port;
#endif

#ifdef  CCUR_X25
extern int	x25_communities[];
extern char *	x25_lines[];
extern char *	x25_default_line;
#endif

#ifdef ULTRIX_X25
extern char     *x25_default_template;
extern char     *x25_default_filter;
extern char     *x25_default_class;
#endif
#endif


/* TRANSPORT */

extern int	tp0_ts1_timer;


/* SESSION */

extern int	ses_ab_timer;
extern int	ses_dn_timer;
extern int	ses_rf_timer;


/* USER-FRIENDLY NAMESERVICE */

extern char	ns_enabled;
extern char    *ns_address;


/* ROUTINES */

extern void isodetailor P_((
    char *myname,
    int wantuser
));
extern int isodesetvar P_((
    char *name,
    char *value,
    int dynamic
));
extern void isodexport P_((
    char *myname
));
extern char *isodesetailor P_((
    char *file
));

#define	isodefile(file,ispgm) \
	_isodefile ((ispgm) ? isodesbinpath : isodetcpath, (file))

extern char *_isodefile P_((
    char *path,
    char *file
));

extern char *getlocalhost P_((
    void
));

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _TAILOR_ */
