/* asn1.h - include file for presentation users (PS-USER) */

/* 
 * $Header: /ic/dev/isode/integration/isode/src/h/asn1/RCS/asn1.h,v 10.10 1994/09/21 17:13:19 jmf Rel $
 *
 *
 * $Log: asn1.h,v $
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#ifndef	_ASN1_H_
#define	_ASN1_H_

#ifndef P_
#ifdef __STDC__
#define P_(p) p
#else
#define P_(p) ()
#endif
#endif

#include "compat/manifest.h"
#include "compat/general.h"
#include "compat/logger.h"
#include <math.h>
#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

/*  */

#ifndef USE_BUILTIN_OIDS
#define USE_BUILTIN_OIDS	1
#endif


typedef struct OIDentifier {
    int	    oid_nelem;		/* number of sub-identifiers */

    unsigned int *oid_elements;	/* the (ordered) list of sub-identifiers */
}			OIDentifier, *OID;
#define	NULLOID	((OID) 0)

extern OID ode2oid P_((
    char *descriptor
));

extern int oid_cmp P_((
    register OID p,
    register OID q
));

extern int elem_cmp P_((
    register unsigned int *ip,
    register int i,
    register unsigned int *jp,
    register int j
));

extern OID oid_cpy P_((
    register OID q
));

extern int oid_free P_((
    register OID oid
));

#define	oid2ode(i)	oid2ode_aux ((i), 1)

extern char *oid2ode_aux P_((
    OID identifier,
    int quoted
));

extern char *sprintoid P_((
    register OID oid
));

extern OID str2oid P_((
    char *s
));

#ifdef DEBUG
extern int free_oid_cache P_((
    void
));
#endif

/*  */

typedef	u_char	   PElementClass;

typedef	u_char	   PElementForm;

typedef u_short    PElementID;	/* 0..16383 are meaningful (14 bits) */
#define	PE_ID_BITS	14

#define	PE_ID(class,code) \
	((int) ((((code) & 0x3fff) << 2) | ((class) & 0x0003)))

typedef	int	   PElementLen;


typedef u_char	  byte, *PElementData;
#define	NULLPED	((PElementData) 0)

#define	PEDalloc(s)		((PElementData) malloc ((unsigned int) (s)))

#define	PEDrealloc(p, s)	((PElementData) \
				    realloc ((char *) (p), (unsigned int) (s)))

#define	PEDfree(p)		free ((char *) (p))

#define	PEDcmp(b1, b2, length)	\
			bcmp ((char *) (b1), (char *) (b2), (int) (length))

#define	PEDcpy(b1, b2, length)	\
			bcopy ((char *) (b1), (char *) (b2), (int) (length))

/*  */

typedef struct PElement {
    int	    pe_errno;		/* Error codes */
#define	PE_ERR_NONE	0	/*   No error */
#define	PE_ERR_OVER	1	/*   Overflow */
#define	PE_ERR_NMEM	2	/*   Out of memory */
#define	PE_ERR_BIT	3	/*   No such bit */
#define	PE_ERR_UTCT	4	/*   Malformed universal timestring */
#define	PE_ERR_GENT	5	/*   Malformed generalized timestring */
#define	PE_ERR_MBER	6	/*   No such member */
#define	PE_ERR_PRIM	7	/*   Not a primitive form */
#define	PE_ERR_CONS	8	/*   Not a constructor form */
#define	PE_ERR_TYPE	9	/*   Class/ID mismatch in constructor */
#define	PE_ERR_OID	10	/*   Malformed object identifier */
#define	PE_ERR_BITS	11	/*   Malformed bitstring */
#define PE_ERR_NOSUPP	12	/*   Type not supported */
#define	PE_ERR_SIGNED	13	/*   Signed integer not expected */
#define PE_ERR_DUPLICATE 14	/*   duplicate member */
#define PE_ERR_SYNTAX	15	/*   syntax error */

				/* for the PSAP */
    int	    pe_context;		/* indirect reference */
#define	PE_DFLT_CTX	0	/*   the default context */

#define	PE_ID_XTND	0x1f	/* distinguished ID for extension bits */
#define	PE_ID_MORE	0x80	/* more to come flag */
#define	PE_ID_MASK	0x7f	/* value in extension byte */
#define	PE_ID_SHIFT	7

#define	PE_CLASS_MASK	0xc0	/* identifier class bits (8-7) */
#define	PE_CLASS_SHIFT	6
#define	PE_FORM_MASK	0x20	/* identifier form bit (6) */
#define	PE_FORM_SHIFT	5
#define	PE_CODE_MASK	0x1f	/* identifier code bits (5-1) + ... */
#define	PE_CODE_SHIFT	0

    PElementClass	pe_class;
#define	PE_CLASS_UNIV	0x0	/*   Universal */
#define	PE_CLASS_APPL	0x1	/*   Application-wide */
#define	PE_CLASS_CONT	0x2	/*   Context-specific */
#define	PE_CLASS_PRIV	0x3	/*   Private-use */

    PElementForm	pe_form;
#define	PE_FORM_PRIM	0x0	/*   PRIMitive */
#define	PE_FORM_CONS	0x1	/*   CONStructor */
#define	PE_FORM_ICONS	0x2	/*   internal: Inline CONStructor */

    PElementID pe_id;		/* should be extensible, 14 bits for now */
				/* Pseudo Types */
#define	PE_UNIV_EOC	0x000	/*   End-of-contents */

				/* Built-in Types */
#define	PE_PRIM_BOOL	0x001	/*   Boolean */
#define	PE_PRIM_INT	0x002	/*   Integer */
#define	PE_PRIM_BITS	0x003	/*   Bitstring */
#define	PE_PRIM_OCTS	0x004	/*   Octetstring */
#define	PE_PRIM_NULL	0x005	/*   Null */
#define	PE_PRIM_OID	0x006	/*   Object identifier */
#define	PE_PRIM_ODE	0x007	/*   Object descriptor */
#define	PE_CONS_EXTN	0x008	/*   External */
#define PE_PRIM_REAL	0x009	/*   Real */
#define PE_PRIM_ENUM	0x00a	/*   Enumerated type */
#define PE_PRIM_ENCR	0x00b	/*   Encrypted */
#define	PE_CONS_SEQ	0x010	/*   Sequence */
#define	PE_CONS_SET	0x011	/*   Set */

				/* Defined Types */
#define	PE_DEFN_NUMS	0x012	/*   Numeric String */
#define	PE_DEFN_PRTS	0x013	/*   Printable String */
#define	PE_DEFN_T61S	0x014	/*   T.61 String */
#define	PE_DEFN_VTXS	0x015	/*   Videotex String */
#define	PE_DEFN_IA5S	0x016	/*   IA5 String */
#define	PE_DEFN_UTCT	0x017	/*   UTC Time */
#define	PE_DEFN_GENT	0x018	/*   Generalized Time */
#define	PE_DEFN_GFXS	0x019	/*   Graphics string (ISO2375) */
#define	PE_DEFN_VISS	0x01a	/*   Visible string */
#define	PE_DEFN_GENS	0x01b	/*   General string */
#define	PE_DEFN_CHRS	0x01c	/*   Character string */

    PElementLen	pe_len;
#define	PE_LEN_XTND	0x80	/* long or indefinite form */
#define	PE_LEN_SMAX	127	/* largest short form */
#define	PE_LEN_MASK	0x7f	/* mask to get number of bytes in length */
#define	PE_LEN_INDF	(-1)	/* indefinite length */

    PElementLen	pe_ilen;

    union {
	PElementData	 un_pe_prim;	/* PRIMitive value */
	struct PElement *un_pe_cons;	/* CONStructor head */
    }                       pe_un1;
#define	pe_prim	pe_un1.un_pe_prim
#define	pe_cons	pe_un1.un_pe_cons

    union {
	int	    un_pe_cardinal;	/* cardinality of list */
	int	    un_pe_nbits;	/* number of bits in string */
    }			    pe_un2;
#define	pe_cardinal	pe_un2.un_pe_cardinal
#define	pe_nbits	pe_un2.un_pe_nbits

    int	    pe_inline;		/* for "ultra-efficient" PElements */
    char   *pe_realbase;	/*   .. */

    int	    pe_offset;		/* offset of element in sequence */

    struct PElement *pe_next;

    int	    pe_refcnt;		/* hack for ANYs in pepy */

#ifdef	DEBUG
    struct PElement *pe_link;	/* malloc debugging... */
#endif
}			PElement, *PE;
#define	NULLPE	((PE) 0)
#define	NULLPEP	((PE *) 0)

#define	pe_seterr(pe, e, v)	((pe) -> pe_errno = (e), (v))


extern	int	pe_allocs;
extern	int	pe_frees;
extern	int	pe_most;
extern	PE	pe_list;
#ifdef	DEBUG
extern	PE	pe_active;
#endif

extern PE pe_alloc P_((
    PElementClass pe_class,
    PElementForm form,
    PElementID id
));

extern int pe_free P_((
    register PE pe
));

extern int pe_cmp P_((
    register PE p,
    register PE q
));

extern PE pe_cpy P_((
    register PE pe
));

extern int pe_pullup P_((
    register PE pe
));

extern PE pe_expunge P_((
    PE pe,
    PE r
));

extern int pe_extract P_((
    PE pe,
    PE r
));

extern PE str2pe P_((
    char *s,
    int len,
    int *advance,
    int *result
));

extern PE qb2pe P_((
    register struct qbuf *qb,
    int len,
    int depth,
    int *result
));

extern int    pe_maxclass;
extern char  *pe_classlist[];

extern int    pe_maxuniv;
extern char  *pe_univlist[];

extern int    pe_maxappl;
extern char **pe_applist;

extern int    pe_maxpriv;
extern char **pe_privlist;

/*  */

typedef struct UTCtime {
    int	    ut_year;
    int	    ut_mon;
    int	    ut_mday;
    int	    ut_hour;
    int	    ut_min;
    int	    ut_sec;

    int	    ut_usec;

    int	    ut_zone;

    int	    ut_flags;
#define	UT_NULL		0x00
#define	UT_ZONE		0x01
#define	UT_SEC		0x02
#define	UT_USEC		0x04
}			UTCtime, *UTC;
#define	NULLUTC	((UTC) 0)


extern void tm2ut P_((
    register struct tm *tm,
    register UTC ut
));

extern time_t gtime P_((
    register struct tm *tm
));

extern struct tm *ut2tm P_((
    register UTC ut
));

/*  */

extern char *berversion;


extern int prim2flag P_((
    register PE pe
));

extern PE flag2prim P_((
    register int b,
    PElementClass pe_class,
    PElementID id
));

#define	bool2prim(b)		flag2prim ((b), PE_CLASS_UNIV, PE_PRIM_BOOL)

extern integer prim2num P_((
    register PE pe
));

extern PE num2prim P_((
    register integer i,
    PElementClass pe_class,
    PElementID id
));

#define	int2prim(i)		num2prim ((integer) (i), PE_CLASS_UNIV, PE_PRIM_INT)


#define	prim2enum(i)		prim2num((i))
#define enum2prim(a,b,c)	num2prim((a), (b), (c))
#define enumint2prim(i)		enum2prim ((i), PE_CLASS_UNIV, PE_PRIM_ENUM)


/* psap REAL parameters - tons of 'em */
#define PE_REAL_FLAGS	0300	/* flag bits of real */
#define 	PE_REAL_BINENC	0200	/* binary encoding */
#define 	PE_REAL_DECENC	0000	/* decimal encoding */
#define 	PE_REAL_SPECENC	0100	/* special encoding */

#define PE_REAL_B_S	0100	/* sign bit */
#define PE_REAL_B_BASE	0060	/* base bits */
#define 	PE_REAL_B_B2	0000
#define 	PE_REAL_B_B8	0020
#define 	PE_REAL_B_B16	0040

#define PE_REAL_B_F	0014	/* factor bits */
#define PE_REAL_B_EXP	0003	/* exponent type bits */
#define		PE_REAL_B_EF1	0000
#define 	PE_REAL_B_EF2	0001
#define		PE_REAL_B_EF3	0002
#define		PE_REAL_B_EF4	0003

#define	PE_REAL_PLUSINF		0200
#define PE_REAL_MINUSINF	0201

#ifndef HUGE
#ifdef MAXFLOAT
#define PE_REAL_INFINITY	MAXFLOAT
#else
#define	PE_REAL_INFINITY	99.e99
#endif
#else
#define PE_REAL_INFINITY	HUGE
#endif

extern double prim2real P_((
    register PE pe
));

extern PE real2prim P_((
    register double d,
    PElementClass pe_class,
    PElementID id
));

#define double2prim(i)		real2prim ((i), PE_CLASS_UNIV, PE_PRIM_REAL)


extern char *prim2str P_((
    register PE pe,
    register int *len
));

extern PE str2prim P_((
    register char *s,
    register int len,
    PElementClass pe_class,
    PElementID id
));

extern struct qbuf *prim2qb P_((
    register PE pe
));

extern char *oct2str P_((
   register char *s,
   register int len
));

extern PE qb2prim_aux P_((
    register struct qbuf *qb,
    PElementClass pe_class,
    PElementID id,
    int in_line
));		/* really should be qb2pe () */
#define	qb2prim(q,c,i)		qb2prim_aux ((q), (c), (i), 0)
#define	oct2prim(s,len)		str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_PRIM_OCTS)
#define	ia5s2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_IA5S)
#define	nums2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_NUMS)
#define	prts2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_PRTS)
#define	t61s2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_T61S)
#define	vtxs2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_VTXS)
#define	gfxs2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_GFXS)
#define	viss2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_VISS)
#define	gens2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_GENS)
#define	chrs2prim(s,len)	str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_DEFN_CHRS)
#define	ode2prim(s,len)		str2prim ((s), (len), \
					    PE_CLASS_UNIV, PE_PRIM_ODE)

extern PE prim2bit P_((
    register PE pe
));

extern PE bit2prim P_((
    register PE pe
));

extern int bit_on P_((
    register PE pe,
    register int i
));

extern int bit_off P_((
    register PE pe,
    register int i
));

extern int bit_test P_((
    register PE pe,
    register int i
));

extern OID prim2oid P_((
    register PE pe
));

extern PE obj2prim P_((
    register OID o,
    PElementClass pe_class,
    PElementID id
));

#define	oid2prim(o)		obj2prim ((o), PE_CLASS_UNIV, PE_PRIM_OID)

#ifdef DEBUG
extern int free_static_oid P_((
    void
));
#endif

extern UTC prim2time P_((
    register PE pe,
    int generalized
));
#define	prim2utct(pe)		prim2time ((pe), 0)
#define	prim2gent(pe)		prim2time ((pe), 1)

extern PE time2prim P_((
    register UTC u,
    int generalized,
    PElementClass pe_class,
    PElementID id
));
#define	utct2prim(u)		time2prim ((u), 0, PE_CLASS_UNIV, PE_DEFN_UTCT)
#define	gent2prim(u)		time2prim ((u), 1, PE_CLASS_UNIV, PE_DEFN_GENT)

extern char *time2str P_((
    register UTC u,
    int generalized
));
#define	utct2str(u)		time2str ((u), 0)
#define	gent2str(u)		time2str ((u), 1)

extern UTC str2utct P_((
    register char *cp,
    register int len
));

extern UTC str2gent P_((
    char *cp,
    int len
));

extern PE prim2set P_((
    register PE pe
));

#define	set2prim(pe)		(pe)

extern int set_add P_((
    register PE pe,
    register PE r
));

extern int set_addon P_((
    PE pe,
    PE last,
    PE new_pe
));

extern int set_del P_((
    register PE pe,
    register PElementClass pe_class,
    register PElementID id
));

extern PE set_find P_((
    register PE pe,
    register PElementClass pe_class,
    register PElementID id
));

#define	first_member(pe)	((pe) -> pe_cons)
#define	next_member(pe,p)	((p) -> pe_next)

#define	prim2seq(pe)		(prim2set (pe))
#define	seq2prim(pe)		(pe)

extern int seq_add P_((
    register PE pe,
    register PE r,
    register int i
));

extern int seq_addon P_((
    PE pe,
    PE last,
    PE new_pe
));

extern int seq_del P_((
    register PE pe,
    register int i
));

extern PE seq_find P_((
    register PE pe,
    register int i
));


extern char *pe_error P_((
    int c
));

/*  */

#ifdef SVR4_UCB
#ifdef PS	/* ucb define PS in sys/sparc/reg.h for "portability" !?! */
#undef PS
#endif
#endif

typedef struct {
    int	    ps_errno;		/* Error codes */
#define	PS_ERR_NONE	 0	/*   No error */
#define	PS_ERR_OVERID	 1	/*   Overflow in ID */
#define	PS_ERR_OVERLEN	 2	/*   Overflow in length */
#define	PS_ERR_NMEM	 3	/*   Out of memory */
#define	PS_ERR_EOF	 4	/*   End of file */
#define	PS_ERR_EOFID	 5	/*   End of file reading extended ID */
#define	PS_ERR_EOFLEN	 6	/*   End of file reading extended length */
#define	PS_ERR_LEN	 7	/*   Length mismatch */
#define	PS_ERR_TRNC	 8	/*   Truncated */
#define	PS_ERR_INDF	 9	/*   Indefinite length in primitive form */
#define	PS_ERR_IO	10	/*   I/O error */
#define	PS_ERR_EXTRA	11	/*   Extraneous octets */
#define	PS_ERR_XXX	12	/*   XXX */

    union {
	caddr_t un_ps_addr;
	struct {
	    char   *st_ps_base;
	    int	    st_ps_cnt;
	    char   *st_ps_ptr;
	    int	    st_ps_bufsiz;
	}			un_ps_st;
	struct {
	    struct udvec *uv_ps_head;
	    struct udvec *uv_ps_cur;
	    struct udvec *uv_ps_end;
	    int	    uv_ps_elems;
	    int	    uv_ps_slop;
	    int	    uv_ps_cc;
	}			un_ps_uv;
    }                       ps_un;
#define	ps_addr	ps_un.un_ps_addr
#define	ps_base	ps_un.un_ps_st.st_ps_base
#define	ps_cnt	ps_un.un_ps_st.st_ps_cnt
#define	ps_ptr	ps_un.un_ps_st.st_ps_ptr
#define	ps_bufsiz	ps_un.un_ps_st.st_ps_bufsiz
#define	ps_head	ps_un.un_ps_uv.uv_ps_head
#define	ps_cur	ps_un.un_ps_uv.uv_ps_cur
#define	ps_end	ps_un.un_ps_uv.uv_ps_end
#define	ps_elems	ps_un.un_ps_uv.uv_ps_elems
#define	ps_slop	ps_un.un_ps_uv.uv_ps_slop
#define	ps_cc	ps_un.un_ps_uv.uv_ps_cc

    caddr_t ps_extra;		/* for George's recursive PStreams */

    int	    ps_inline;		/* for "ultra-efficient" PStreams */

    int	    ps_scratch;		/* XXX */

    int	    ps_byteno;		/* byte position */

    IFP	    ps_primeP;
    IFP	    ps_readP;
    IFP	    ps_writeP;
    IFP	    ps_flushP;
    IFP	    ps_closeP;
}			PStream, *PS;
#define	NULLPS	((PS) 0)

#define	ps_seterr(ps, e, v)	((ps) -> ps_errno = (e), (v))


extern PS ps_alloc P_((
    register IFP io
));

extern void ps_free P_((
    register PS ps
));

extern int ps_io P_((
    register PS ps,
    register IFP io,
    register PElementData data,
    register PElementLen n,
    int in_line
));
#define	ps_read(ps, data, cc)	ps_io ((ps), (ps) -> ps_readP, (data), (cc), 0)
#define	ps_write(ps, data, cc)	ps_write_aux ((ps), (data), (cc), 0)
#define	ps_write_aux(ps, data, cc, in_line) \
    	ps_io ((ps), (ps) -> ps_writeP, (data), (cc), (in_line))

extern int ps_write_id P_((
    register PS ps,
    register PE pe
));

extern int ps_write_len P_((
    register PS ps,
    register PE pe
));

extern int ps_read_id P_((
    register PS ps,
    int top,
    register PElementClass *pe_class,
    register PElementForm *form,
    register PElementID *id
));

extern int ps_read_len P_((
    register PS ps,
    register PElementLen *len
));

extern int ps_read_cons P_((
    register PS ps,
    register PE *pe,
    register PElementLen len
));

extern int ps_flush P_((
    register PS ps
));

extern int ps_prime P_((
    register PS ps,
    int waiting
));

extern int std_open P_((
    register PS ps
));
#define	std_setup(ps, fp)	((ps) -> ps_addr = (caddr_t) (fp), OK)

extern int str_open P_((
    register PS ps
));

extern int str_setup P_((
    register PS ps,
    register char *cp,
    register int cc,
    int in_line
));

extern int std_flush P_((
    PS ps
));

extern int dg_open P_((
    register PS ps
));

extern int dg_setup P_((
    register PS ps,
    int fd,
    int size,
    IFP rfx,
    IFP wfx,
    IFP cfx
));

extern int fdx_open P_((
    register PS ps
));

extern int fdx_setup P_((
    register PS ps,
    int fd
));

extern int fdx_reset P_((
    register PS ps
));

extern int qbuf_open P_((
    register PS ps
));
#define	qbuf_setup(ps, qb)	((ps) -> ps_addr = (caddr_t) (qb), OK)

#define	ts_open	dg_open
#define	ts_setup(p,f,s)		dg_setup ((p), (f), (s), ts_read, ts_write)
extern int ts_read P_((
    int fd,
    struct qbuf **q
));
extern int ts_write P_((
    int fd,
    register struct qbuf *qb
));

extern int uvec_open P_((
    register PS ps
));

extern int uvec_setup P_((
    register PS ps,
    int len
));


#define	ps2pe(ps)		ps2pe_aux ((ps), 1, 1)

extern PE ps2pe_aux P_((
    register PS ps,
    int top,
    int all
));

#define	pe2ps(ps, pe)		pe2ps_aux ((ps), (pe), 1)

extern int pe2ps_aux P_((
    register PS ps,
    register PE pe,
    int eval
));

extern PE pl2pe P_((
    register PS ps
));

extern int pe2pl P_((
    register PS ps,
    register PE pe
));

extern int    ps_len_strategy;
#define	PS_LEN_SPAG	0
#define	PS_LEN_INDF	1
#define	PS_LEN_LONG	2

extern int ps_get_abs P_((
    register PE pe
));

extern int ps_get_plen P_((
    register PE pe
));


extern char *ps_error P_((
    int c
));

/*  */

struct isobject {
    char   *io_descriptor;

    OIDentifier io_identity;
};

extern int setisobject P_((
    int f
));
extern int endisobject P_((
    void
));
extern struct isobject *getisobject P_((
    void
));

extern struct isobject *getisobjectbyname P_((
    char *descriptor
));
extern struct isobject *getisobjectbyoid P_((
    register OID oid
));

/*  */

extern	int	Len;
extern	char   *Qcp;
extern	char   *Ecp;

extern int pe2qb_f P_((
    register PE pe
));


extern	int	Byteno;
extern	int	Qbrefs;
extern struct qbuf *Hqb;
extern struct qbuf *Fqb;
extern struct qbuf *Qb;

#ifdef USE_QBUF2PE_FAST
	/*  This is a faster version of qbuf2pe, but it has a memory leak. */
#define qbuf2pe(qb, len, result) (Byteno = 0, Hqb = qb, \
                                        Fqb = (Qb = (qb) -> qb_forw), \
                                        qbuf2pe_f (result))
#else
extern PE qbuf2pe P_((
    register struct qbuf *qb,
    int len,
    int *result
));
#endif

extern PE qbuf2pe_f P_((
    int *result
));
char   *qb2str ();
extern struct qbuf *str2qb P_((
    char *s,
    int len,
    int head
));
extern int qb_free P_((
    register struct qbuf *qb
));
extern int qb_pullup P_((
    register struct qbuf *qb
));
extern struct qbuf *qb_cpy P_((
    struct qbuf *qb
));
#ifdef DEBUG
extern int qbprintf P_((
    void
));
#endif

extern int pe2ssdu P_((
    register PE pe,
    char **base,
    int *len
));
extern PE ssdu2pe P_((
    char *base,
    int len,
    char *realbase,
    int *result
));

extern void pe2text P_((
    register LLog *lp,
    register PE pe,
    int rw,
    int cc
));

extern int pe2uvec P_((
    register PE pe,
    struct udvec **uv
));

extern char *int2strb P_((
    register int n,
    int len
));
extern int strb2int P_((
    register char *cp,
    register int len
));

extern PE strb2bitstr P_((
    register char *cp,
    register int len,
    PElementClass pe_class,
    PElementID id
));
extern char *bitstr2strb P_((
    PE pe,
    int *k
));

/*  */

extern char PY_pepy[];

extern void PY_advise P_((
    char *what,
    char *fmt,
    ...
));

extern int vpush P_((
    void
));
extern int vpop P_((
    void
));
extern int vname P_((
    char *name
));
extern int vtag P_((
    int pe_class,
    int id
));
extern int vprint P_((
    char *fmt,
    ...
));
extern int vstring P_((
    register PE pe
));
extern int vunknown P_((
    register PE pe
));

extern char *bit2str P_((
    PE pe,
    char *s
));

extern int vpushfp P_((
    FILE *fp,
    PE pe,
    char *s,
    int rw
)); 
extern int vpopfp P_((
    void
));

extern int vpushstr P_((
    char *cp
));
extern int vpopstr P_((
    void
));

extern int vpushpp P_((
    caddr_t pv,
    IFP pfnx,
    register PE pe,
    char *text,
    int rw
));
extern int vpopp P_((
    void
));

#ifdef PEPSY_VERSION
/* handle calls to the vunknown print routine */
#define vunknown_P 	0, ((modtyp *) 0)

/*
 * vpdu now comes out of the closet as a real pepsy function "pvpdu" we
 * keep the #define for vpdu for backwards compatiability of other peoples'
 * code
 */
#ifdef __STDC__
#define	vpdu(lp,fnx,pe,text,rw) \
{ \
    pvpdu ((lp), fnx##_P, (pe), (text), (rw)); \
}
#else   /* __STDC__ */
#define	vpdu(lp,fnx,pe,text,rw) \
{ \
    pvpdu ((lp), fnx/**/_P, (pe), (text), (rw)); \
}
#endif /* __STDC__ */

#else
	/* Backwards compatibility with posy/pepy */
#define vpdu(lp,fnx,pe,text,rw) \
{ \
    int    fnx (); \
 \
    _vpdu ((lp), fnx, (pe), (text), (rw)); \
}

int     _vpdu ();
#endif

/* pepy string definitions */
extern char *pepy_strings[];

#define	 PEPY_ERR_BAD 			(pepy_strings[0])
#define	 PEPY_ERR_BAD_BITS 		(pepy_strings[1])
#define	 PEPY_ERR_BAD_BOOLEAN 		(pepy_strings[2])
#define	 PEPY_ERR_BAD_CLASS 		(pepy_strings[3])
#define	 PEPY_ERR_BAD_CLASS_FORM_ID 	(pepy_strings[4])
#define	 PEPY_ERR_BAD_FORM 		(pepy_strings[5])
#define	 PEPY_ERR_BAD_INTEGER 		(pepy_strings[6])
#define	 PEPY_ERR_BAD_OID 		(pepy_strings[7])
#define	 PEPY_ERR_BAD_OCTET 		(pepy_strings[8])
#define	 PEPY_ERR_BAD_REAL 		(pepy_strings[9])
#define	 PEPY_ERR_BAD_SEQ 		(pepy_strings[10])
#define	 PEPY_ERR_BAD_SET 		(pepy_strings[11])
#define	 PEPY_ERR_TOO_MANY_BITS 	(pepy_strings[12])
#define	 PEPY_ERR_TOO_MANY_ELEMENTS 	(pepy_strings[13])
#define	 PEPY_ERR_UNKNOWN_CHOICE 	(pepy_strings[14])
#define	 PEPY_ERR_UNK_COMP 		(pepy_strings[15])
#define	 PEPY_ERR_INIT_FAILED 		(pepy_strings[16])
#define	 PEPY_ERR_INVALID_CHOICE 	(pepy_strings[17])
#define	 PEPY_ERR_MISSING 		(pepy_strings[18])
#define	 PEPY_ERR_NOMEM  		(pepy_strings[19])
#define	 PEPY_ERR_TOO_MANY_TAGGED 	(pepy_strings[20])
#define	 PEPY_ERR_EXTRA_MEMBERS 	(pepy_strings[21])

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _ASN1_H_ */
