/* ./src/crypt/shs/shs_if.c */

static char *rcsid = "$Header: /home/secude/new_release/secude/src/crypt/shs/RCS/shs_if.c,v 1.5 1995/01/09 12:49:48 surkau Exp $";

/* 
 *
 * $Header: /home/secude/new_release/secude/src/crypt/shs/RCS/shs_if.c,v 1.5 1995/01/09 12:49:48 surkau Exp $
 *
 * $Log: shs_if.c,v $
 *
 */
 
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 *  SHS interface module between sec_hash, sec_sign, sec_verify and the 
 *  SHS C version by Peter Gutmann, HPACK Conspiracy Secret Laboratory
 *  
 *
 *  Imports:
 *
 *  shsInit(shsInfo)
 *  shsUpdate(shsInfo, inBuf, inLen)
 *  shsFinal(shsInfo)
 *
 *
 *  sha_hash(in_octets, hash_result, more)
 *
 */

#include "sec_global.h"
#include "shs.h"

/***************************************************************
 *
 * Procedure sha_hash
 *
 ***************************************************************/

#ifdef __STDC__

RC sha_hash(
	OctetString	 *in_octets,
	OctetString	 *hash_result,
	More		  more
)

#else

RC sha_hash(
	in_octets,
	hash_result,
	more
)
OctetString	 *in_octets;
OctetString	 *hash_result;
More		  more;

#endif

{
        static char first = TRUE;
        static SHS_INFO shsInfo;
	int i;

        if(first) {
                shsInit(&shsInfo);
                first = FALSE;
        }
        shsUpdate(&shsInfo, (BYTE *) in_octets->octets, in_octets->noctets);

        if(more == SEC_END) {
                first = TRUE;
                shsFinal(&shsInfo);
 		for (i = 0; i < 5; i++)
			shsInfo.digest[i] = ntohl(shsInfo.digest[i]);

               /* memory of hash_result->octets provided by calling program */

                bcopy(&shsInfo.digest[0], (BYTE *) hash_result->octets, SHS_DIGESTSIZE);

                hash_result->noctets = SHS_DIGESTSIZE;
        }
        return(0);
}
