/* ./src/crypt/shs/shs.h */

/* 
 *
 * $Header: /home/secude/new_release/secude/src/crypt/shs/RCS/shs.h,v 1.4 1994/11/12 11:20:45 schneiw Exp $
 *
 * $Log: shs.h,v $
 *
 */
 
#ifndef _SHS_DEFINED

#define _SHS_DEFINED

/* Define the following to use the updated SHS implementation */

#include "sec_config.h"

/* Some useful types */

#if SIZEOFINT == 32
#define long int
#endif

typedef unsigned char   BYTE;
typedef unsigned int    WORD;
typedef unsigned long   LONG;

/* Exit status of functions. */

#define OK      0
#define ERROR   -1


/* The SHS block size and message digest sizes, in bytes */

#define SHS_DATASIZE    64
#define SHS_DIGESTSIZE  20

/* The structure for storing SHS info */

typedef struct {
               LONG digest[ 5 ];            /* Message digest */
               LONG countLo, countHi;       /* 64-bit bit count */
               LONG data[ 16 ];             /* SHS data buffer */
               } SHS_INFO;

/* Message digest functions */

#ifdef __STDC__

void shsInit( SHS_INFO *shsInfo );
void shsUpdate( SHS_INFO *shsInfo, BYTE *buffer, int count );
void shsFinal( SHS_INFO *shsInfo );

#else

void shsInit();
void shsUpdate();
void shsFinal();

#endif


#endif /* _SHS_DEFINED */
