/* ./src/crypt/rsa/rsa.c */

static char *rcsid = "$Header: /home/secude/new_release/secude/src/crypt/rsa/RCS/rsa.c,v 1.6 1995/01/10 13:31:09 surkau Exp $";

/* 
 *
 * $Header: /home/secude/new_release/secude/src/crypt/rsa/RCS/rsa.c,v 1.6 1995/01/10 13:31:09 surkau Exp $
 *
 * $Log: rsa.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 * RSA - modul fuer secure interface
 *
 * rsa_encrypt(), rsa_decrypt(), rsa_sign(), rsa_verify(), hash_sqmodn(),
 * rsa_set_key(), rsa_pkmap()
 */


#include "arithmetic.h"
#include "rsa.h"

extern  L_NUMBER   lz_fermat5[];

#define ERASEKEY bzero((char *)&K,sizeof(K))
/*---------------------------------------------------------------*
 * statische Variablen fuer restliche input Bloecke und RSA keys *
 *---------------------------------------------------------------*/

static RSAkeys  K;              /* RSA key fields */
static L_NUMBER ACC[MAXLGTH];   /* residual value */
static int      freesize;       /* free bitlen in ACC */

#ifdef __STDC__

static void	unpk	(char *buf, L_NUMBER L[], int len);
#else
static void	unpk	();
#endif

/*----------------------------------------------get_rsa_key---*/

#ifdef TRACE_ALL
#define TRACE_RSA
#endif

#ifdef TRACE_RSA
#define TRACE_BLOCK(text, input , output) { \
OctetString *t_ostr;\
fprintf(secude_trace_file, "%s\n", text);\
fprintf(secude_trace_file, "in:\n");\
t_ostr = aux_LN2OctetString(input, 0);\
aux_fprint_OctetString(secude_trace_file, t_ostr);\
aux_free_OctetString(&t_ostr);\
fprintf(secude_trace_file, "out:\n");\
t_ostr = aux_LN2OctetString(output, 0);\
aux_fprint_OctetString(secude_trace_file, t_ostr);\
aux_free_OctetString(&t_ostr);\
fprintf(secude_trace_file, "Key part 1:\n");\
t_ostr = aux_LN2OctetString(K.sk.p, 0);\
aux_fprint_OctetString(secude_trace_file, t_ostr);\
aux_free_OctetString(&t_ostr);\
fprintf(secude_trace_file, "Key part 2:\n");\
t_ostr = aux_LN2OctetString(K.sk.q, 0);\
aux_fprint_OctetString(secude_trace_file, t_ostr);\
aux_free_OctetString(&t_ostr);\
fprintf(secude_trace_file, "\n\n\n");\
}
#else
#define TRACE_BLOCK(text, in , out)
#endif



/***************************************************************
 *
 * Procedure rsa_set_key
 *
 ***************************************************************/
#ifdef __STDC__

int rsa_set_key(
	KeyBits	 *d_key
)

#else

int rsa_set_key(
	d_key
)
KeyBits	 *d_key;

#endif

{
	L_NUMBER	n[MAXLGTH];

        INTEGERtoln(&(d_key->part1), K.pk.n);
        INTEGERtoln(&(d_key->part2), K.pk.e);

        inttoln(0, K.sk.u);
        freesize = 0;

	if(comp(K.pk.e, lz_fermat5) && comp(K.pk.e, lz_drei)) {

		mult(K.sk.p, K.sk.q, n);
		return(lngtouse(n) + 1);

	}
	else {
		return(lngtouse(K.pk.n) + 1);


	}
}


/*----------------------------------------------rsa_encrypt---*/
/***************************************************************
 *
 * Procedure rsa_encrypt
 *
 ***************************************************************/
#ifdef __STDC__

RC rsa_encrypt(
	OctetString	 *in,
	BitString	 *out,
	More		  more,
	int		  keysize
)

#else

RC rsa_encrypt(
	in,
	out,
	more,
	keysize
)
OctetString	 *in;
BitString	 *out;
More		  more;
int		  keysize;

#endif

{
        extern L_NUMBER lz_eins[];
        L_NUMBER        L[MAXLGTH], X[MAXLGTH];
        int             r, off, blocksize;
        int             ret = out->nbits;

#ifdef TRACE_RSA
	fprintf(secude_trace_file, "--> rsa_encrypt\n");
#endif
        blocksize = (keysize - 1) / BYTEL;
        if (freesize)
                r = freesize / BYTEL;
        else
                r = blocksize;
        off = r;

        if (in && (in->noctets > 0)) {
                if (r > in->noctets)
                        r = in->noctets;
                octetstoln(in, L, 0, r);
                if (off > r) {  /* incomplete block */
                        shift(L, (off - r) * BYTEL, L);
                        if (freesize)
                                add(ACC, L, L);
                        if (more == SEC_MORE) {
                                freesize = (off - r) * BYTEL;
                                trans(L, ACC);
#ifdef TRACE_RSA
				fprintf(secude_trace_file, "<-- rsa_encrypt\n");
#endif
                                return 0;
                        }
                } else if (freesize)
                        add(ACC, L, L);
        } else {                /* no input, but check ACC */
                if (freesize && (more == SEC_END))
                        trans(ACC, L)
                else
                        goto finish;
        }
        freesize = 0;

        r = blocksize;
        do {
#ifdef   PAD
                if (comp(L, lz_eins) <= 0) {    /* pad values 0 and 1 */
                        inttoln(1, X);
                        shift(X, lngtouse(K.pk.n), X);
                        add(X, L, L);
                }
#endif
                rsa_encblock(L, X, &K.pk);
		TRACE_BLOCK("Encrypt block", L, X);
                lntobits(X, out, keysize);
                /* load next block, if possible */
                if (off + r > in->noctets)
                        r = in->noctets - off;
                if (r > 0)
                        octetstoln(in, L, off, r);
                off += blocksize;
        } while (off <= in->noctets);

        /* work on rest block in L */
        if (r > 0) {
                shift(L, (blocksize - r) * BYTEL, L);   /* pads 0's */
                if (more == SEC_MORE) {
                        freesize = (blocksize - r) * BYTEL;
                        trans(L, ACC);
#ifdef TRACE_RSA
			fprintf(secude_trace_file, "<-- rsa_encrypt\n");
#endif
                        return out->nbits - ret;
                }
#ifdef   PAD
                if (comp(L, lz_eins) <= 0) {    /* pad values 0 and 1 */
                        inttoln(1, X);
                        shift(X, lngtouse(K.pk.n), X);
                        add(X, L, L);
                }
#endif
                rsa_encblock(L, X, &K.pk);
		TRACE_BLOCK("Encrypt last block", L, X);
                lntobits(X, out, keysize);
        }
finish:
        if (more == SEC_END)
                ERASEKEY;
#ifdef TRACE_RSA
	fprintf(secude_trace_file, "<-- rsa_encrypt\n");
#endif
        return out->nbits - ret;
}


/*----------------------------------------------rsa_decrypt---*/
/***************************************************************
 *
 * Procedure rsa_decrypt
 *
 ***************************************************************/
#ifdef __STDC__

RC rsa_decrypt(
	BitString	 *in,
	OctetString	 *out,
	More		  more,
	int		  keysize
)

#else

RC rsa_decrypt(
	in,
	out,
	more,
	keysize
)
BitString	 *in;
OctetString	 *out;
More		  more;
int		  keysize;

#endif

{
        L_NUMBER        L[MAXLGTH], X[MAXLGTH];
        int             r, off, blocksize;
        int             ret = out->noctets;

#ifdef TRACE_RSA
	fprintf(secude_trace_file, "--> rsa_decrypt\n");
#endif
        blocksize = (keysize - 1) / BYTEL;
        if (freesize)
                r = freesize;
        else
                r = keysize;
        off = r;

        if (in && (in->nbits > 0)) {
                if (r > in->nbits)
                        r = in->nbits;
                bitstoln(in, L, 0, r);
                if (off > r) {  /* incomplete block */
                        shift(L, (off - r), L);
                        if (freesize)
                                add(ACC, L, L);
                        if (more == SEC_MORE) {
                                freesize = (off - r);
                                trans(L, ACC);
#ifdef TRACE_RSA
				fprintf(secude_trace_file, "<-- rsa_decrypt\n");
#endif
                                return 0;
                        }
                } else if (freesize)
                        add(ACC, L, L);
        } else {                /* no input, but check ACC */
                if (freesize && (more == SEC_END))
                        trans(ACC, L)
                else
                        goto finish;
        }
        freesize = 0;

        r = keysize;
        do {
                rsa_decblock(L, X, &K.sk);
		TRACE_BLOCK("Decrypt block", L, X);
                lntoctets(X, out, blocksize);
                /* load next block, if possible */
                if (off + r > in->nbits)
                        r = in->nbits - off;
                if (r > 0)
                        bitstoln(in, L, off, r);
                off += keysize;
        } while (off <= in->nbits);

        /* work on rest block in L */
        if (r > 0) {
                shift(L, (keysize - r), L);     /* pads 0's */
                if (more == SEC_MORE) {
                        freesize = (keysize - r);
                        trans(L, ACC);
#ifdef TRACE_RSA
			fprintf(secude_trace_file, "<-- rsa_decrypt\n");
#endif
                        return out->noctets - ret;
                }
                rsa_decblock(L, X, &K.sk);
		TRACE_BLOCK("Decrypt last block", L, X);
                lntoctets(X, out, blocksize);
        }
finish:
        if (more == SEC_END)
                ERASEKEY;
#ifdef TRACE_RSA
	fprintf(secude_trace_file, "<-- rsa_decrypt\n");
#endif
        return out->noctets - ret;
}



/***************************************************************
 *
 * Procedure unpk
 *
 ***************************************************************/
#ifdef __STDC__

static void unpk(
	char		 *buf,
	L_NUMBER	  L[],
	int		  len
)

#else

static void unpk(
	buf,
	L,
	len
)
char		 *buf;
L_NUMBER	  L[];
int		  len;

#endif

{
        char            hash[MAXLGTH * WBYTES];
        char           *out;
        char             b;
        int             cnt = len;
        OctetString     ostr;

        out = hash;
        for (; len > 0; len--) {
                b = *buf++;
                *out = (b >> 4) | 0xF0;
                 out++;
                *out = (b & 0x0F) | 0xF0;
                 out++;
        }
        ostr.noctets = cnt << 1;
        ostr.octets = hash;
        INTEGERtoln(&ostr, L);
        return;
}


/***************************************************************
 *
 * Procedure hash_sqmodn
 *
 ***************************************************************/
#ifdef __STDC__

RC hash_sqmodn(
	OctetString	 *in,
	OctetString	 *sum,
	More		  more,
	int		  keysize
)

#else

RC hash_sqmodn(
	in,
	sum,
	more,
	keysize
)
OctetString	 *in;
OctetString	 *sum;
More		  more;
int		  keysize;

#endif

{
        extern L_NUMBER lz_eins[];
        L_NUMBER        L[MAXLGTH], X[MAXLGTH];
        int             r, off, blocksize;

        blocksize = (keysize - 1) / (BYTEL << 1);
        if (freesize)
                r = freesize / (BYTEL << 1);
        else
                r = blocksize;
        off = r;

        if (in && (in->noctets > 0)) {
                if (r > in->noctets)
                        r = in->noctets;
                unpk(in->octets, L, r);

                if (off > r) {  /* incomplete block */
                        shift(L, (off - r) * (BYTEL << 1), L);
                        if (freesize)
                                add(ACC, L, L);
                        if (more == SEC_MORE) {
                                freesize = (off - r) * (BYTEL << 1);
                                trans(L, ACC);
                                return 0;
                        } else {/* pad with 1's */
                                inttoln(1, X);
                                shift(X, (off - r) * (BYTEL << 1), X);
                                sub(X, lz_eins, X);
                                add(X, L, L);
                        }
                } else if (freesize)
                        add(ACC, L, L);
        } else {                /* no input, but check ACC */
                if (!freesize || (more == SEC_MORE))
                        goto finish2;
                trans(ACC, L);
                if (more == SEC_END) {      /* needs padding */
                        inttoln(1, X);
                        shift(X, freesize, X);
                        sub(X, lz_eins, X);
                        add(X, L, L);
                }
        }
        freesize = 0;

        INTEGERtoln(sum, X);    /* load last result */
        r = blocksize;
        do {
                xor(L, X, X);   /* add ... */
                mmult(X, X, X, K.pk.n); /* ... and square */
                /* load next block, if possible */
                if (off + r > in->noctets)
                        r = in->noctets - off;
                if (r > 0)
                        unpk(in->octets + off, L, r);
                off += blocksize;
        } while (off <= in->noctets);

        /* work on rest block in L */
        if (r > 0) {
                shift(L, (blocksize - r) * (BYTEL << 1), L);    /* pads 0's */
                if (more == SEC_MORE) {
                        freesize = (blocksize - r) * (BYTEL << 1);
                        trans(L, ACC);
                        goto finish;
                } else {        /* pad 1's */
                        inttoln(1, ACC);
                        shift(ACC, (blocksize - r) * (BYTEL << 1), ACC);
                        sub(ACC, lz_eins, ACC);
                        add(ACC, L, L);
                }
                xor(L, X, X);   /* add ... */
                mmult(X, X, X, K.pk.n); /* ... and square */
        }
finish:
        lntoINTEGER(X, sum);

finish2:
        if (more == SEC_END)
                ERASEKEY;
        return 0;
}


/*---------------------------------------------rsa_sign-------*/
/***************************************************************
 *
 * Procedure rsa_sign
 *
 ***************************************************************/
#ifdef __STDC__

RC rsa_sign(
	OctetString	 *hash,
	BitString	 *sign
)

#else

RC rsa_sign(
	hash,
	sign
)
OctetString	 *hash;
BitString	 *sign;

#endif

{
        L_NUMBER        L[MAXLGTH];
        L_NUMBER        S[MAXLGTH];

#ifdef TRACE_RSA
	fprintf(secude_trace_file, "--> rsa_sign\n");
#endif
        if(MAXLGTH * SIZEOFINT < hash->noctets * BYTEL) return(-1);

        sign->nbits = 0;
        INTEGERtoln(hash, L);
        rsa_decblock(L, S, &K.sk);
	TRACE_BLOCK("Decrypt block for signing", L, S);
        lntobits(S, sign, (lngtouse(S) + BYTEL) & (~(BYTEL - 1)));
        ERASEKEY;
#ifdef TRACE_RSA
	fprintf(secude_trace_file, "<-- rsa_sign\n");
#endif
        return 0;
}


/*---------------------------------------------rsa_verify-----*/
#include <stdio.h>
/***************************************************************
 *
 * Procedure rsa_verify
 *
 ***************************************************************/
#ifdef __STDC__

RC rsa_verify(
	OctetString	 *hash,
	BitString	 *sign
)

#else

RC rsa_verify(
	hash,
	sign
)
OctetString	 *hash;
BitString	 *sign;

#endif

{
        L_NUMBER        L[MAXLGTH];
        L_NUMBER        C[MAXLGTH];
	OctetString     *ostr;


#ifdef TRACE_RSA
	fprintf(secude_trace_file, "--> rsa_verify\n");
#endif
        if(MAXLGTH * SIZEOFINT < sign->nbits) return(-1);
        if(MAXLGTH * SIZEOFINT < hash->noctets * BYTEL) return(-1);

        bitstoln(sign, L, 0, sign->nbits);
        rsa_encblock(L, C, &K.pk);
	TRACE_BLOCK("Encrypt block for verifiing", L, C);
        INTEGERtoln(hash, L);
        ERASEKEY;
	if(sec_verbose) {
		ostr = (OctetString *)malloc(sizeof(OctetString));
		ostr->octets = (char *)malloc(512);
		lntoctets(C, ostr, 0);
		aux_fprint_OctetString(stderr, ostr);
		aux_free_OctetString(&ostr);
	}
        if (comp(L, C)) {
#ifdef TRACE_RSA
		fprintf(secude_trace_file, "<-- rsa_verify (rc = -1) \n");
#endif
                return -1;
	}
        else {
#ifdef TRACE_RSA
		fprintf(secude_trace_file, "<-- rsa_verify (rc = 0) \n");
#endif
                return 0;
	}
}

/*---------------------------------------------rsa_encblock2OctetString-----*/
/***************************************************************
 *
 * Procedure rsa_encblock2OctetString
 *
 ***************************************************************/
#ifdef __STDC__

RC rsa_encblock2OctetString(
	BitString	 *sign,
	OctetString	 *hash
)

#else

RC rsa_encblock2OctetString(
	sign,
	hash
)
BitString	 *sign;
OctetString	 *hash;

#endif

{
        L_NUMBER        L[MAXLGTH];
        L_NUMBER        C[MAXLGTH];

        if(MAXLGTH * SIZEOFINT < sign->nbits) return(-1);
        if(MAXLGTH * SIZEOFINT < hash->noctets * BYTEL) return(-1);

        bitstoln(sign, L, 0, sign->nbits);
        rsa_encblock(L, C, &K.pk);
        lntoINTEGER(C, hash);
        return 0;
}

