/* ./src/crypt/global/util.c */

static char *rcsid = "$Id: util.c,v 1.10 1995/01/30 14:39:49 surkau Exp $";

/* 
 *
 * $Id: util.c,v 1.10 1995/01/30 14:39:49 surkau Exp $
 *
 * $Log: util.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "sec_global.h"

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

/* Transforms "OctetString" representation of Integer into "int" representation*/

/***************************************************************
 *
 * Procedure aux_cmp_BitString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_BitString(
	BitString	 *bitstring1,
	BitString	 *bitstring2
)

#else

int aux_cmp_BitString(
	bitstring1,
	bitstring2
)
BitString	 *bitstring1;
BitString	 *bitstring2;

#endif

{
	int	  i, nob, rob;
	char	* proc = "aux_cmp_Bitstring";

	if ( !bitstring1 && !bitstring2 )
		return( 0) ;
	if ( !bitstring1 || !bitstring2 )
		return( 1) ;

	if ( (nob = bitstring1->nbits) == bitstring2->nbits ) {
		rob = nob % 8;
		nob = nob / 8;
		if(bcmp(bitstring1->bits, bitstring2->bits, nob)) return(1);
		if ( rob ) {
			if ( ((unsigned char)bitstring2->bits[nob] >> (8 - rob)) != 
			    ((unsigned char)bitstring1->bits[nob] >> (8 - rob)) )
				return( 1 );
		}
		return( 0 );
	} else
		return( 1 );
}

/***************************************************************
 *
 * Procedure aux_cmp_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_OctetString(
	OctetString	 *octetstring1,
	OctetString	 *octetstring2
)

#else

int aux_cmp_OctetString(
	octetstring1,
	octetstring2
)
OctetString	 *octetstring1;
OctetString	 *octetstring2;

#endif

{
	int	       s;
	unsigned char  a, b;
	char	       *proc = "aux_cmp_OctetString";

	if ( !octetstring1 && !octetstring2 )
		return( 0) ;
	if ( !octetstring1 || !octetstring2 )
		return( 1) ;

	if (octetstring1->noctets > octetstring2->noctets)
		return(1);
	else if (octetstring1->noctets < octetstring2->noctets)
		return(2);
	else{
		s = 0;
		while (s < octetstring1->noctets && octetstring1->octets[s] == octetstring2->octets[s])
			s++;
		if(s == octetstring1->noctets)
			return(0);
		a = octetstring1->octets[s];
		b = octetstring2->octets[s];
		if(a > b) return(1);
		else return(2);
	}
}
/***************************************************************
 *
 * Procedure aux_OctetString2int
 *
 ***************************************************************/
#ifdef __STDC__

int aux_OctetString2int(
	OctetString	 *ostr_repr
)

#else

int aux_OctetString2int(
	ostr_repr
)
OctetString	 *ostr_repr;

#endif

{
	unsigned int	   int_repr;
	int		   result;
	L_NUMBER 	   lnum[8];
	char		 * proc = "aux_OctetString2int";

	if (!ostr_repr) {
		global_add_error(EINVALID, "empty parameter", CNULL, 0, proc);
		return(-1);
	}

	if(ostr_repr->noctets == 0) return(0);

	if(ostr_repr->noctets <= sizeof(int)) {
		octetstoln(ostr_repr, lnum, 0, ostr_repr->noctets);
		int_repr =  lnum[1];
		if(int_repr < 0) global_add_error(EINVALID, "Can't transform OctetString to uint (too long)", CNULL, 0, proc);
		return(int_repr);
	}
	else {
		global_add_error(EINVALID, "Can't transform OctetString to uint (too long)", CNULL, 0, proc);
		return(-1);
	}

/*
	if (build_SEC_OURINTEGER(&P_OURINTEGER, 1, 0, CNULL, ostr_repr) == NOTOK)
		return (-1);

	int_repr = prim2num(P_OURINTEGER);
	pe_free(P_OURINTEGER);
*/

	
}

/***************************************************************
 *
 * Procedure aux_cmp_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_KeyBits(
	KeyBits	 *keybits1,
	KeyBits	 *keybits2
)

#else

int aux_cmp_KeyBits(
	keybits1,
	keybits2
)
KeyBits	 *keybits1;
KeyBits	 *keybits2;

#endif

{
	char	* proc = "aux_cmp_KeyBits";

	if (!keybits1 || !keybits2) {
		if(!keybits1 && !keybits2) return(0);
		return(1);
	}
	if ( aux_cmp_OctetString(&keybits1->part1, &keybits2->part1) ) return( 1 );
	if ( aux_cmp_OctetString(&keybits1->part2, &keybits2->part2) ) return( 1 );
	if ( aux_cmp_OctetString(&keybits1->part3, &keybits2->part3) ) return( 1 );
	if ( aux_cmp_OctetString(&keybits1->part4, &keybits2->part4) ) return( 1 );
	return(0);
}
/***************************************************************
 *
 * Procedure aux_cpy_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

KeyBits *aux_cpy_KeyBits(
	KeyBits	 *keybits
)

#else

KeyBits *aux_cpy_KeyBits(
	keybits
)
KeyBits	 *keybits;

#endif

{
	KeyBits * dup_keybits;
	char	* proc = "aux_cpy_KeyBits";


	if (!keybits)
		return ( (KeyBits * ) 0);

	if ( !(dup_keybits = (KeyBits * )malloc(sizeof(KeyBits))) ) {
		global_add_error(EMALLOC, "dup_keybits", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part1, &keybits->part1)) {
		global_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part2, &keybits->part2)) {
		global_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part3, &keybits->part3)) {
		global_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}
	if (aux_cpy2_OctetString(&dup_keybits->part4, &keybits->part4)) {
		global_add_error(LASTERROR, "aux_cpy2_OctetString failed(1)", CNULL, 0, proc);
		return ( (KeyBits * ) 0);
	}

	return(dup_keybits);
}
/***************************************************************
 *
 * Procedure aux_cpy2_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_ObjId(
	ObjId	 *dup_oid,
	ObjId	 *oid
)

#else

int aux_cpy2_ObjId(
	dup_oid,
	oid
)
ObjId	 *dup_oid;
ObjId	 *oid;

#endif

{
	int	  i;
	char	* proc = "aux_cpy2_ObjId";


	if ( (oid == (ObjId * )0) || (dup_oid == (ObjId * )0) || 
	    ((oid->oid_nelem > 0) && (oid->oid_elements == (unsigned int *)0)) ) {
		global_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}
	dup_oid->oid_nelem = oid->oid_nelem;
	if ( !dup_oid->oid_nelem ) {
		dup_oid->oid_nelem = 0;
		dup_oid->oid_elements = (unsigned *)0;
	} else {
		if ( (dup_oid->oid_elements
		     = (unsigned int *)malloc(oid->oid_nelem * sizeof(unsigned int)))
		     == (unsigned int *)0 ) {
			global_add_error(EMALLOC, "dup_oid->oid_elements", CNULL, 0, proc);
			return( -1 );
		} else
			for ( i = 0; i < oid->oid_nelem; i++)
				dup_oid->oid_elements[i] = oid->oid_elements[i];
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cmp_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_ObjId(
	ObjId	 *oid1,
	ObjId	 *oid2
)

#else

int aux_cmp_ObjId(
	oid1,
	oid2
)
ObjId	 *oid1;
ObjId	 *oid2;

#endif

{
	int	  i;
	char	* proc = "aux_cmp_ObjId";

	if ( !oid1 && !oid2 )
		return( 0) ;
	if ( !oid1 || !oid2 )
		return( 1) ;


	if ( oid1->oid_nelem == oid2->oid_nelem ) {
		for ( i = 0; i < oid1->oid_nelem; i++) {
			if ( oid1->oid_elements[i] != oid2->oid_elements[i] )
				return( 1 );
		}
		return( 0 );
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cpy_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

AlgId *aux_cpy_AlgId(
	AlgId	 *aid
)

#else

AlgId *aux_cpy_AlgId(
	aid
)
AlgId	 *aid;

#endif

{
	AlgId   * dup_aid;
	char	* proc = "aux_cpy_AlgId";


	if ( (aid == (AlgId * )0) || (aid->objid == (ObjId * )0) )
		return( (AlgId * )0 );


	if ( (dup_aid = (AlgId * )malloc(sizeof(AlgId))) == (AlgId * )0 ) {
		global_add_error(EMALLOC, "dup_aid", CNULL, 0, proc);
		return( (AlgId * )0 );
	}
	if (aux_cpy2_AlgId (dup_aid, aid)) {
		global_add_error(LASTERROR, "aux_cpy2_AlgId failed", CNULL, 0, proc);
		return( (AlgId * )0 );
	}
	return( dup_aid );
}


/***************************************************************
 *
 * Procedure aux_cpy2_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_AlgId(
	AlgId	 *dup_aid,
	AlgId	 *aid
)

#else

int aux_cpy2_AlgId(
	dup_aid,
	aid
)
AlgId	 *dup_aid;
AlgId	 *aid;

#endif

{
	int			   i;
	rsa_parm_type    	 * rsa_p1;
	desCBC_parm_type 	 * des_p1, * des_p2;
	char			 * proc = "aux_cpy2_AlgId";


	if ( (aid == (AlgId * )0) || (dup_aid == (AlgId * )0) || (aid->objid == (ObjId * )0) ) {
		global_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_aid->objid = aux_cpy_ObjId(aid->objid);
	if (!dup_aid->objid) {
		global_add_error(LASTERROR, "aux_cpy_ObjId failed", CNULL, 0, proc);
		return(-1);
	}

	if ( !aid->param ) {
		dup_aid->param = (char *)0 ;
		return( 0 );
	}

	switch ( aux_ObjId2ParmType( dup_aid->objid ) ) {

	case PARM_INTEGER:
		if ( !(rsa_p1 = (rsa_parm_type * )malloc(sizeof(rsa_parm_type))) ) {
			global_add_error(EMALLOC, "rsa_p1", CNULL, 0, proc);
			return( -1 );
		}
		*rsa_p1 = RSA_PARM(aid->param);
		dup_aid->param = (char *)rsa_p1;
		break;
	case PARM_KeyBits:
		if ( !(dup_aid->param = (char *)aux_cpy_KeyBits((KeyBits *)aid->param)) ) {
			global_add_error(LASTERROR, "aux_cpy_KeyBits", CNULL, 0, proc);
			return( -1 );
		}

		break;
	case PARM_OctetString:
		if ( !(des_p1 = (desCBC_parm_type * )
		    malloc(sizeof(desCBC_parm_type))) ) {
			global_add_error(EMALLOC, "des_p1", CNULL, 0, proc);
			return( -1 );
		}
		des_p2 = (desCBC_parm_type * )(aid->param);
		des_p1->noctets = des_p2->noctets;
		if(des_p2->noctets) {
			if ( !(des_p1->octets = (char *)malloc(des_p1->noctets)) ) {
				global_add_error(EMALLOC, "des_p1->octets", CNULL, 0, proc);
				return( -1 );
			}
			bcopy(des_p2->octets, des_p1->octets, des_p2->noctets);
		}
		else des_p1->octets = aux_cpy_String("");
		dup_aid->param = (char *)des_p1;
		break;
	default:
		/* non-standard parm ignored */
		dup_aid->param = (char *)0;
		break;
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cmp_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cmp_AlgId(
	AlgId	 *aid1,
	AlgId	 *aid2
)

#else

int aux_cmp_AlgId(
	aid1,
	aid2
)
AlgId	 *aid1;
AlgId	 *aid2;

#endif

{
	int	i;
	rsa_parm_type     * rsa_p1, *rsa_p2;
	desCBC_parm_type * des_p1, *des_p2;
	dhKeyAgreement_parm_type * dh_p1, *dh_p2;

	char	*proc = "aux_cmp_AlgId";

	if ( !aid1 && !aid2 )
		return( 0) ;
	if ( !aid1 || !aid2 )
		return( 1) ;

	if ( !aux_cmp_ObjId(aid1->objid, aid2->objid) ) {

		if ( !aid1->param || !aid2->param ) {
			if ( !aid1->param && !aid2->param )
				return( 0 );
			else
				return( 1 );
		}

		switch ( aux_ObjId2ParmType( aid1->objid ) ) {

		case PARM_NULL:
			return(0);
		case PARM_KeyBits:
			dh_p1 = (dhKeyAgreement_parm_type * )(aid1->param);
			dh_p2 = (dhKeyAgreement_parm_type * )(aid2->param);
			return( aux_cmp_KeyBits(dh_p1, dh_p2) );
		case PARM_INTEGER:
			rsa_p1 = (rsa_parm_type * )(aid1->param);
			rsa_p2 = (rsa_parm_type * )(aid2->param);
			if ( *rsa_p1 == *rsa_p2 )
				return( 0 );
			else
				return( 1 );
		case PARM_OctetString:
			des_p1 = (desCBC_parm_type * )(aid1->param);
			des_p2 = (desCBC_parm_type * )(aid2->param);
			if ( des_p1->noctets == des_p2->noctets ) {
				if(bcmp(des_p1->octets, des_p2->octets, des_p1->noctets)) return(1);
				return( 0 );
			} 
			else
				return( 1 );

		default:
			/* objids are equal, but parms cannot be compared */
			return( 1 );
		}
	} else
		return( 1 );
}


/***************************************************************
 *
 * Procedure aux_cpy_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

KeyInfo *aux_cpy_KeyInfo(
	KeyInfo	 *keyinfo
)

#else

KeyInfo *aux_cpy_KeyInfo(
	keyinfo
)
KeyInfo	 *keyinfo;

#endif

{
	KeyInfo * dup_ki;
	char	* proc = "aux_cpy_KeyInfo";


	if ((keyinfo == (KeyInfo * )0))
		return( (KeyInfo * )0);
	if ((dup_ki = (KeyInfo * )malloc(sizeof(KeyInfo))) == (KeyInfo * )0 ) {
		global_add_error(EMALLOC, "dup_ki", CNULL, 0, proc);
		return((KeyInfo * )0);
	}
	if (aux_cpy2_KeyInfo (dup_ki, keyinfo)) {
		global_add_error(LASTERROR, "aux_cpy2_KeyInfo failed", CNULL, 0, proc);
		return( (KeyInfo * )0 );
	}
	return(dup_ki);
}


/***************************************************************
 *
 * Procedure aux_cpy2_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_KeyInfo(
	KeyInfo	 *dup_ki,
	KeyInfo	 *keyinfo
)

#else

int aux_cpy2_KeyInfo(
	dup_ki,
	keyinfo
)
KeyInfo	 *dup_ki;
KeyInfo	 *keyinfo;

#endif

{
	char	* proc = "aux_cpy2_KeyInfo";


	if ( (keyinfo == (KeyInfo * )0) || (dup_ki == (KeyInfo * )0) ) {
		global_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}


	dup_ki->subjectAI = aux_cpy_AlgId(keyinfo->subjectAI);
	if (!dup_ki->subjectAI) {
		global_add_error(LASTERROR, "aux_cpy_AlgId failed", CNULL, 0, proc);
		return(-1);
	}
	if (aux_cpy2_BitString(&dup_ki->subjectkey, &keyinfo->subjectkey)) {
		global_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return( -1 );
	}
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_cpy_ObjId(
	ObjId	 *oid
)

#else

ObjId *aux_cpy_ObjId(
	oid
)
ObjId	 *oid;

#endif

{
	ObjId   * dup_oid;
	char	* proc = "aux_cpy_ObjId";


	if ( (oid == (ObjId * )0) || 
	    ((oid->oid_nelem > 0) && (oid->oid_elements == (unsigned int *)0)) )
		return( (ObjId * )0 );

	if ( (dup_oid = (ObjId * )malloc(sizeof(ObjId)))
	     == (ObjId * )0 ) {
		global_add_error(EMALLOC, "dup_oid", CNULL, 0, proc);
		return( (ObjId * )0 );
	}
	if (aux_cpy2_ObjId (dup_oid, oid)) {
		global_add_error(LASTERROR, "aux_cpy2_ObjId failed", CNULL, 0, proc);
		return( (ObjId * )0 );
	}
	return( dup_oid );
}



/***************************************************************
 *
 * Procedure aux_cpy2_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_OctetString(
	OctetString	 *dup_ostr,
	OctetString	 *ostr
)

#else

int aux_cpy2_OctetString(
	dup_ostr,
	ostr
)
OctetString	 *dup_ostr;
OctetString	 *ostr;

#endif

{
	int	  i;
	char	* proc = "aux_cpy2_OctetString";


	if ( (ostr == (OctetString * )0) || (dup_ostr == (OctetString * )0) ) {
		global_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}
	dup_ostr->noctets = ostr->noctets;
	if(ostr->noctets) {
		if ( (dup_ostr->octets = (char *)malloc(dup_ostr->noctets)) == (char *)0 ) {
			global_add_error(EMALLOC, "dup_ostr->octets", CNULL, 0, proc);
			return( -1 );
		}
		bcopy(ostr->octets, dup_ostr->octets, ostr->noctets);
	}
	else {
		if(ostr->octets) dup_ostr->octets = aux_cpy_String("");
		else dup_ostr->octets = CNULL;
	}


	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy2_BitString
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cpy2_BitString(
	BitString	 *dup_bstr,
	BitString	 *bstr
)

#else

int aux_cpy2_BitString(
	dup_bstr,
	bstr
)
BitString	 *dup_bstr;
BitString	 *bstr;

#endif

{
	int	  i, nob;
	char	* proc = "aux_cpy2_BitString";


	if ( (bstr == (BitString * )0) || (dup_bstr == (BitString * )0) ) {
		global_add_error(EINVALID, "one param empty", CNULL, 0, proc);
		return( -1 );
	}

	dup_bstr->nbits = bstr->nbits;
	nob = dup_bstr->nbits / 8;
	if ( dup_bstr->nbits % 8 )
		nob++;
	if ( (dup_bstr->bits = (char *)malloc(nob)) == (char *)0 ) {
		global_add_error(EMALLOC, "dup_bstr->bits", CNULL, 0, proc);
		return( 0 );
	}
	bcopy(bstr->bits, dup_bstr->bits, nob);
	return( 0 );
}


/***************************************************************
 *
 * Procedure aux_cpy_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_cpy_OctetString(
	OctetString	 *ostr
)

#else

OctetString *aux_cpy_OctetString(
	ostr
)
OctetString	 *ostr;

#endif

{
	OctetString * dup_ostr;
	char	    * proc = "aux_cpy_OctetString";


	if (!ostr)
		return (NULLOCTETSTRING);

	if ( !(dup_ostr = (OctetString * )malloc(sizeof(OctetString))) ) {
		global_add_error(EMALLOC, "dup_ostr", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	if (aux_cpy2_OctetString(dup_ostr, ostr)) {
		global_add_error(LASTERROR, "aux_cpy2_OctetString failed", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	return(dup_ostr);
}


/***************************************************************
 *
 * Procedure aux_cpy_BitString
 *
 ***************************************************************/
#ifdef __STDC__

BitString *aux_cpy_BitString(
	BitString	 *bstr
)

#else

BitString *aux_cpy_BitString(
	bstr
)
BitString	 *bstr;

#endif

{
	BitString * dup_bstr;
	int	    nob, i;
	char	  * proc = "aux_cpy_BitString";


	if (!bstr)
		return (NULLBITSTRING);

	if ( !(dup_bstr = (BitString * )malloc(sizeof(BitString))) ) {
		global_add_error(EMALLOC, "dup_bstr", CNULL, 0, proc);
		return (NULLBITSTRING);
	}
	if (aux_cpy2_BitString(dup_bstr, bstr)) {
		global_add_error(LASTERROR, "aux_cpy2_BitString failed", CNULL, 0, proc);
		return (NULLBITSTRING);
	}
	return(dup_bstr);
}


/***************************************************************
 *
 * Procedure aux_Name2ObjId
 *
 ***************************************************************/
#ifdef __STDC__

ObjId *aux_Name2ObjId(
	char	 *name
)

#else

ObjId *aux_Name2ObjId(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2ObjId";

	if (!name)
		return((ObjId * )0);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(aux_cpy_ObjId(a->algid->objid));
		a++;
	}
	return((ObjId * )0);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgId
 *
 ***************************************************************/
#ifdef __STDC__

AlgId *aux_Name2AlgId(
	char	 *name
)

#else

AlgId *aux_Name2AlgId(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgId";

	if (!name)
		return((AlgId * )0);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(aux_cpy_AlgId(a->algid));
		a++;
	}
	return((AlgId * )0);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgType
 *
 ***************************************************************/
#ifdef __STDC__

AlgType aux_Name2AlgType(
	char	 *name
)

#else

AlgType aux_Name2AlgType(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgType";

	if (!name)
		return(NoAlgType);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algtype);
		a++;
	}
	return(NoAlgType);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgEnc
 *
 ***************************************************************/
#ifdef __STDC__

AlgEnc aux_Name2AlgEnc(
	char	 *name
)

#else

AlgEnc aux_Name2AlgEnc(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgEnc";

	if (!name)
		return(NoAlgEnc);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algenc);
		a++;
	}
	return(NoAlgEnc);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgHash
 *
 ***************************************************************/
#ifdef __STDC__

AlgHash aux_Name2AlgHash(
	char	 *name
)

#else

AlgHash aux_Name2AlgHash(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgHash";

	if (!name)
		return(NoAlgHash);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->alghash);
		a++;
	}
	return(NoAlgHash);
}


/***************************************************************
 *
 * Procedure aux_Name2AlgMode
 *
 ***************************************************************/
#ifdef __STDC__

AlgMode aux_Name2AlgMode(
	char	 *name
)

#else

AlgMode aux_Name2AlgMode(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgMode";

	if (!name)
		return(NoAlgMode);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algmode);
		a++;
	}
	return(NoAlgMode);
}

/***************************************************************
 *
 * Procedure aux_Name2AlgSpecial
 *
 ***************************************************************/
#ifdef __STDC__

AlgSpecial aux_Name2AlgSpecial(
	char	 *name
)

#else

AlgSpecial aux_Name2AlgSpecial(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2AlgSpecial";

	if (!name)
		return(NoAlgSpecial);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->algspecial);
		a++;
	}
	return(NoAlgSpecial);
}

/***************************************************************
 *
 * Procedure aux_Name2ParmType
 *
 ***************************************************************/
#ifdef __STDC__

ParmType aux_Name2ParmType(
	char	 *name
)

#else

ParmType aux_Name2ParmType(
	name
)
char	 *name;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_Name2ParmType";

	if (!name)
		return(NoParmType);
	while (a->name) {
		if (strcmp(name, a->name) == 0)
			return(a->parmtype);
		a++;
	}
	return(NoParmType);
}




/***************************************************************
 *
 * Procedure aux_ObjId2Name
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_ObjId2Name(
	ObjId	 *given_objid
)

#else

char *aux_ObjId2Name(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2Name";

	if (!given_objid)
		return((char *)0);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(aux_cpy_String(a->name));
		a++;
	}
	return((char *)0);
}


/***************************************************************
 *
 * Procedure aux_ObjId2AlgType
 *
 ***************************************************************/
#ifdef __STDC__

AlgType aux_ObjId2AlgType(
	ObjId	 *given_objid
)

#else

AlgType aux_ObjId2AlgType(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgType";

	if (!given_objid)
		return(NoAlgType);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algtype);
		a++;
	}
	return(NoAlgType);
}


/***************************************************************
 *
 * Procedure aux_ObjId2AlgEnc
 *
 ***************************************************************/
#ifdef __STDC__

AlgEnc aux_ObjId2AlgEnc(
	ObjId	 *given_objid
)

#else

AlgEnc aux_ObjId2AlgEnc(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgEnc";

	if (!given_objid)
		return(NoAlgEnc);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algenc);
		a++;
	}
	return(NoAlgEnc);
}


/***************************************************************
 *
 * Procedure aux_ObjId2AlgHash
 *
 ***************************************************************/
#ifdef __STDC__

AlgHash aux_ObjId2AlgHash(
	ObjId	 *given_objid
)

#else

AlgHash aux_ObjId2AlgHash(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgHash";

	if (!given_objid)
		return(NoAlgHash);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->alghash);
		a++;
	}
	return(NoAlgHash);
}

/***************************************************************
 *
 * Procedure aux_ObjId2AlgSpecial
 *
 ***************************************************************/
#ifdef __STDC__

AlgSpecial aux_ObjId2AlgSpecial(
	ObjId	 *given_objid
)

#else

AlgSpecial aux_ObjId2AlgSpecial(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgSpecial";

	if (!given_objid)
		return(NoAlgSpecial);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algspecial);
		a++;
	}
	return(NoAlgSpecial);
}

/***************************************************************
 *
 * Procedure aux_ObjId2AlgMode
 *
 ***************************************************************/
#ifdef __STDC__

AlgMode aux_ObjId2AlgMode(
	ObjId	 *given_objid
)

#else

AlgMode aux_ObjId2AlgMode(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgMode";

	if (!given_objid)
		return(NoAlgMode);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->algmode);
		a++;
	}
	return(NoAlgMode);
}

/***************************************************************
 *
 * Procedure aux_ObjId2AlgId
 *
 ***************************************************************/
#ifdef __STDC__

AlgId *aux_ObjId2AlgId(
	ObjId	 *given_objid
)

#else

AlgId *aux_ObjId2AlgId(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2AlgId";

	if (!given_objid)
		return((AlgId * )0);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(aux_cpy_AlgId(a->algid));
		a++;
	}
	return((AlgId * )0);
}


/***************************************************************
 *
 * Procedure aux_ObjId2ParmType
 *
 ***************************************************************/
#ifdef __STDC__

ParmType aux_ObjId2ParmType(
	ObjId	 *given_objid
)

#else

ParmType aux_ObjId2ParmType(
	given_objid
)
ObjId	 *given_objid;

#endif

{
	register AlgList * a = &alglist[0];
	char		 * proc = "aux_ObjId2ParmType";

	if (!given_objid)
		return(NoParmType);
	while (a->name) {
		if (!aux_cmp_ObjId(given_objid, a->algid->objid))
			return(a->parmtype);
		a++;
	}
	return(NoParmType);
}


/***************************************************************
 *
 * Procedure aux_cpy_String
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_cpy_String(
	char	 *str
)

#else

char *aux_cpy_String(
	str
)
char	 *str;

#endif

{
	char	* new_;
	char	* proc = "aux_cpy_String";


	if ( ! str )
		return ( (char *) 0);

	new_ = (char *)malloc(strlen(str) + 1);
	if (!new_)  {
		global_add_error(EMALLOC, "new_", CNULL, 0, proc);
		return(new_);
	}
	strcpy(new_, str);
	return(new_);
}

/***************************************************************
 *
 * Procedure error_addr_cpy
 *
 ***************************************************************/
#ifdef __STDC__

static char *error_addr_cpy(
	char		 *addr,
	Struct_No	  addrtype
)

#else

static char *error_addr_cpy(
	addr,
	addrtype
)
char		 *addr;
Struct_No	  addrtype;

#endif

{


	if (!addr) return((char *)0);

	switch (addrtype) {
	case char_n:
		return((char *)aux_cpy_String(addr));
	case int_n:
		return(addr);
	case OctetString_n:
		return((char *)aux_cpy_OctetString((OctetString *)addr));
	case BitString_n:
		return((char *)aux_cpy_BitString((BitString *)addr));
	case AlgId_n:
		return((char *)aux_cpy_AlgId((AlgId *)addr));
	case KeyInfo_n:
		return((char *)aux_cpy_KeyInfo((KeyInfo *)addr));
	case ObjId_n:
		return((char *)aux_cpy_ObjId((ObjId *)addr));
	case KeyBits_n:
		return((char *)aux_cpy_KeyBits((KeyBits *)addr));
	}
	return((char *)0);

}

/***************************************************************
 *
 * Procedure FPRINTF
 *
 ***************************************************************/

#ifdef __STDC__

FPRINTF(
	FILE	  *ff,
	char      *format,
	...
)

#else 

FPRINTF(
	ff,
	format,
	va_alist
)
FILE	 *ff;
char     *format;
va_dcl

#endif

{
	va_list args;
	int i;
	static Boolean indent = TRUE;
	
	if(indent) for(i = 0; i < print_indent; i++) fprintf(ff, " ");

#ifdef __STDC__
	va_start(args, format);
#else 
	va_start(args);
#endif
	vfprintf(ff, format, args);
	va_end(args);

	if(format[strlen(format) - 1] == '\n') indent = TRUE;
	else indent = FALSE;

	return(0);
}


/***************************************************************
 *
 * Procedure CATSPRINTF
 *
 ***************************************************************/

#ifdef __STDC__

char *CATSPRINTF(
	char	  *string,
	char      *format,
	...
)

#else 

char *CATSPRINTF(
	string,
	format,
	va_alist
)
char	 *string;
char     *format;
va_dcl

#endif 

{
	static Boolean indent = TRUE;
	va_list args;
	int i;
	char tmp[1000];
	char *proc = "CATSPRINTF";

	tmp[0] = '\0';
	if(indent && print_indent) for(i = 0; i < print_indent; i++) strcat(tmp, " ");
#ifdef __STDC__
	va_start(args, format);
#else 
	va_start(args);
#endif
	vsprintf(tmp + strlen(tmp), format, args);
	va_end(args);
	if(tmp[strlen(tmp) - 1] == '\n') indent = TRUE;
	else indent = FALSE;

	if(string) string = realloc(string, strlen(string) + strlen(tmp) + 1);
	else {
		string = malloc(strlen(tmp) + 1);
		string[0] = '\0';
	}
	if(!string) {
		global_add_error(EMALLOC, "string", CNULL, 0, proc);
		return(CNULL);
	}
	strcat(string, tmp);

	return(string);
}
#ifdef __STDC__

char *CATNSTR(
	char	  *string,
	char      *cat,
	int        chars
)

#else 
char *CATNSTR(
	string,
	cat,
	chars
)
char	 *string;
char     *cat;
int	  chars;

#endif 

{
	char *proc = "CATNSTR";


	if(!cat || !chars) chars = 0;
	else if(chars < 0) chars = strlen(cat);

	if(string) {
		string = realloc(string, strlen(string) + chars + 1);
		if(!string) {
			global_add_error(EMALLOC, "string", CNULL, 0, proc);
			return(CNULL);
		}
	}
	else {
		string = malloc(chars + 1);
		if(!string) {
			global_add_error(EMALLOC, "string", CNULL, 0, proc);
			return(CNULL);
		}
		string[0] = '\0';
	}
	if(chars) strncat(string, cat, chars);

	return(string);
}


/***************************************************************
 *
 * Procedure global_add_error
 *
 ***************************************************************/
#ifdef __STDC__

void global_add_error(
	int		  number,
	char		 *text,
	char		 *addr,
	Struct_No	  addrtype,
	char		 *proc
)

#else

void global_add_error(
	number,
	text,
	addr,
	addrtype,
	proc
)
int		  number;
char		 *text;
char		 *addr;
Struct_No	  addrtype;
char		 *proc;

#endif

{
	struct ErrStack  * err;
	char		 * local_proc = "global_add_error";


        if(err_stack == &err_malloc) return; /* malloc failed already, can't do much */

	err = (struct ErrStack *) malloc(sizeof(struct ErrStack ));

	if (err && number != EMALLOC) {
		err->e_is_error = TRUE;
		err->e_number   = number;
		err->e_text     = aux_cpy_String(text);
		err->e_addr     = error_addr_cpy(addr, addrtype);
		err->e_addrtype = addrtype;
		err->e_proc     = proc;
		err->next       = err_stack;
		err_stack = err;
	} 
	else {
		err_malloc.e_is_error = TRUE;
		err_malloc.e_number   = number;
		err_malloc.e_text     = text;
		err_malloc.e_addr     = CNULL;
		err_malloc.e_addrtype = addrtype;
		err_malloc.e_proc     = proc;
		err_malloc.next       = err_stack;
		err_stack = &err_malloc;
	}
        return;
}

/* You need this byteswap routine on a LITTLE_ENDIAN machine if you
   you don't have htonl */

/* Byte swap a long */

#if SIZEOFLONG == 64
#define HTONL_TYPE unsigned int
#else
#define HTONL_TYPE unsigned long
#endif
/***************************************************************
 *
 * Procedure htonl
 *
 ***************************************************************/
#ifdef __STDC__

HTONL_TYPE htonl(
	HTONL_TYPE	  x
)

#else

HTONL_TYPE htonl(
	x
)
HTONL_TYPE	  x;

#endif

{
#ifdef LITTLE_ENDIAN
	register char *cp,tmp;

	cp = (char *)&x;

#if SIZEOFLONG == 16
	tmp = cp[1];
	cp[1] = cp[0];
	cp[0] = tmp;
#else
	tmp = cp[3];
	cp[3] = cp[0];
	cp[0] = tmp;

	tmp = cp[2];
	cp[2] = cp[1];
	cp[1] = tmp;
#endif

#endif

	return x;
}
/***************************************************************
 *
 * Procedure ntohl
 *
 ***************************************************************/
#ifdef __STDC__

HTONL_TYPE ntohl(
	HTONL_TYPE	  x
)

#else

HTONL_TYPE ntohl(
	x
)
HTONL_TYPE	  x;

#endif

{
	return(htonl(x));
}


FILE *secude_trace_file = stderr;

int open_trace_file()
{
	secude_trace_file = fopen("secude.trc", "w");
	if(!secude_trace_file) secude_trace_file = stderr;
}
int close_trace_file()
{
	fclose(secude_trace_file);
	secude_trace_file = stderr;
}



/***************************************************************
 *
 * Procedure aux_BitString2EncryptionKey
 *
 ***************************************************************/
#ifdef __STDC__

KeyInfo *aux_BitString2EncryptionKey(
	AlgId	 *alg,
	BitString *bstr
)

#else

KeyInfo *aux_BitString2EncryptionKey(
	alg,
	bstr
)
AlgId	 *alg;
BitString *bstr;

#endif

{
	KeyInfo * keyinfo;
	char	* proc = "aux_BitString2EncryptionKey";
	AlgEnc    algenc;
	int       n;

        algenc = aux_ObjId2AlgEnc(alg->objid);

	if(algenc != DES && algenc != DES3 && algenc != IDEA)  {

		global_add_error(EINVALID, "Need a symmetric algorithm", CNULL, 0, proc);
		return( (KeyInfo * )0 );
	}

        if(!(keyinfo = (KeyInfo *)calloc(1, sizeof(KeyInfo)))) {
		global_add_error(EMALLOC, "keyinfo", CNULL, 0, proc);
		return( (KeyInfo * )0 );
	}

	keyinfo->subjectAI = aux_cpy_AlgId(alg);

	keyinfo->subjectkey.bits = (char *)malloc(17);
        if(algenc == DES) keyinfo->subjectkey.nbits = 64;
        else keyinfo->subjectkey.nbits = 128;

	for(n = 0; n < keyinfo->subjectkey.nbits/8; n++ )
		if(n < bstr->nbits/8) keyinfo->subjectkey.bits[n] = bstr->bits[n];
		else keyinfo->subjectkey.bits[n] = '\0';


	return(keyinfo);
}

