/* ./src/crypt/global/fprint.c */

static char *rcsid = "$Id: fprint.c,v 1.5 1995/01/04 14:31:38 surkau Exp $";

/* 
 *
 * $Id: fprint.c,v 1.5 1995/01/04 14:31:38 surkau Exp $
 *
 * $Log: fprint.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*-----------------------string = aux_sprint.c----------------------*/
/*------------------------------------------------------------------*/
/* GMD Darmstadt Institut fuer Telekooperationstechnik (I2)         */
/* Rheinstr. 75 / Dolivostr. 15                                     */
/* 6100 Darmstadt                                                   */
/* Grimm/Luehe/Nausester/Schneider/Viebeg et alii                   */
/*------------------------------------------------------------------*/
/*                                                                  */
/* DESCRIPTION                                                      */
/*   This modul presents functions to print SecuDe                  */
/*   relevant C-structures to a char pointer.                       */
/*                                                                  */
/* EXPORT                                                           */
/*                                                                  */
/*   *print means either print, fprint, or sprint                   */
/*                                                                  */
/*                           aux_*print_OctetString()               */
/*                           aux_*print_BitString()                 */
/*                           aux_*print_ObjId()                     */
/*                           aux_*print_KeyBits()                   */
/*                           aux_*print_AlgId()                     */
/*                           global_*print_error()                  */
/*------------------------------------------------------------------*/
#include "sec_global.h"

static char	*EKEYBITS      = "KeyBits is NULL pointer";
static char	*EAID          = "AlgId is NULL pointer";
static char	*EEKEYINFO     = "KeyInfo is NULL pointer";

/***************************************************************
 *
 * Procedure aux_sprint_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_OctetString(
	char		 *string,
	OctetString	 *ostr
)

#else

char *aux_sprint_OctetString(
	string,
	ostr
)
char		 *string;
OctetString	 *ostr;

#endif

{
	if(!ostr) return(string);
	string = CATSPRINTF(string, "OctetString length: %d octets\n", ostr->noctets);
	if(ostr->noctets) {
		print_indent += 10;
		string = CATSPRINTF(string, "    OctetString:\n");
		string = aux_sxdump(string, ostr->octets, ostr->noctets, 0);
		print_indent -= 10;
	}
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_BitString
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_BitString(
	char		 *string,
	BitString	 *bstr
)

#else

char *aux_sprint_BitString(
	string,
	bstr
)
char		 *string;
BitString	 *bstr;

#endif

{
	if(!bstr) return(string);
	string = CATSPRINTF(string, "BitString length: %d bits\n", bstr->nbits);
	if(bstr->nbits) {
		print_indent += 10;
		string = CATSPRINTF(string, "    BitString:\n");
		string = aux_sxdump2(string, bstr->bits, (bstr->nbits + 7)/8, 0);
		print_indent -= 10;
	}
	return(string);
}
/***************************************************************
 *
 * Procedure aux_fprint_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_OctetString(
	FILE	*ff,
	OctetString	 *ostr
)

#else

RC aux_fprint_OctetString(
	ff,
	ostr
)
FILE	*ff;
OctetString	 *ostr;

#endif

{
	char *string = aux_sprint_OctetString(CNULL, ostr);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}

/***************************************************************
 *
 * Procedure aux_fprint_BitString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_BitString(
	FILE	*ff,
	BitString	 *bstr
)

#else

RC aux_fprint_BitString(
	ff,
	bstr
)
FILE	*ff;
BitString	 *bstr;

#endif

{
	char *string = aux_sprint_BitString(CNULL, bstr);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}

/***************************************************************
 *
 * Procedure aux_print_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_OctetString(
	OctetString	 *ostr
)

#else

RC aux_print_OctetString(
	ostr
)
OctetString	 *ostr;

#endif

{
	return(aux_fprint_OctetString(stderr, ostr));
}

/***************************************************************
 *
 * Procedure aux_print_BitString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_BitString(
	BitString	 *bstr
)

#else

RC aux_print_BitString(
	bstr
)
BitString	 *bstr;

#endif

{
	return(aux_fprint_BitString(stderr, bstr));
}



/***************************************************************
 *
 * Procedure aux_sprint_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_KeyBits(
	char	 *string,
	KeyBits	 *keybits
)

#else

char *aux_sprint_KeyBits(
	string,
	keybits
)
char	 *string;
KeyBits	 *keybits;

#endif

{
	int	n;

	if ( !keybits ) {
		string = CATSPRINTF(string, "%s\n", EKEYBITS);
		return(string);
	}
	if(keybits->part2.noctets == 0) {

		/* DSA key */

		n = keybits->part1.noctets;
		if (print_keyinfo_flag & PK) {
			string = CATSPRINTF(string, "    Public y (no. of bits = %d):\n", n * 8);
		} 
		else if (print_keyinfo_flag & SK) {
			string = CATSPRINTF(string, "    Private x (no. of bits = %d):\n", n * 8);
		} 
		else {
			string = CATSPRINTF(string, "    Key part1 (no. of bits = %d):\n", n * 8);
		}
		string = aux_sxdump2(string, keybits->part1.octets, n, 0);


	} 
	else if(keybits->part3.noctets && keybits->part4.noctets == 0) {

		if(keybits->part3.noctets <= 4) {
			/* DH parameter */
	
			n = keybits->part1.noctets;
			string = CATSPRINTF(string, "    DH prime p (no. of bits = %d):\n", n * 8);
			string = aux_sxdump2(string, keybits->part1.octets, n, 0);
	
			n = keybits->part2.noctets;
			string = CATSPRINTF(string, "    DH base g (no. of bits = %d):\n", n * 8);
			string = aux_sxdump2(string, keybits->part2.octets, n, 0);
	
			string = CATSPRINTF(string, "    PrivateValueLength: %d (bits)\n", aux_OctetString2int(&(keybits->part3)));
 		}
		else {
			/* DSA parameter */
	
			n = keybits->part1.noctets;
			string = CATSPRINTF(string, "    DSA prime p (no. of bits = %d):\n", n * 8);
			string = aux_sxdump2(string, keybits->part1.octets, n, 0);
	
			n = keybits->part2.noctets;
			string = CATSPRINTF(string, "    DSA prime q (no. of bits = %d):\n", n * 8);
			string = aux_sxdump2(string, keybits->part2.octets, n, 0);
	
			n = keybits->part3.noctets;
			string = CATSPRINTF(string, "    DSA base g (no. of bits = %d):\n", n * 8);
			string = aux_sxdump2(string, keybits->part3.octets, n, 0);
	
 		}
 	}

	else {

		/* RSA key */

		n = keybits->part1.noctets;
		if (print_keyinfo_flag & PK || keybits->part2.noctets <= 3) {
			string = CATSPRINTF(string, "    Public modulus (no. of bits = %d):\n", n * 8);
		} 
		else if (print_keyinfo_flag & SK) {
			string = CATSPRINTF(string, "    Prime p (no. of bits = %d):\n", n * 8);
		} 
		else {
			string = CATSPRINTF(string, "    Key part1 (no. of bits = %d):\n", n * 8);
		}
		string = aux_sxdump2(string, keybits->part1.octets, n, 0);

		n = keybits->part2.noctets;
		if (print_keyinfo_flag & PK || n <= 3) {
			string = CATSPRINTF(string, "    Public exponent (no. of bits = %d):\n", n * 8);
		} 
		else if (print_keyinfo_flag & SK) {
			string = CATSPRINTF(string, "    Prime q (no. of bits = %d):\n", n * 8);
		} 
		else {
			string = CATSPRINTF(string, "    Key part2 (no. of bits = %d):\n", n * 8);
		}
		string = aux_sxdump2(string, keybits->part2.octets, n, 0);
	}
	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_ObjId(
	char	 *string,
	ObjId	 *objid
)

#else

char *aux_sprint_ObjId(
	string,
	objid
)
char	 *string;
ObjId	 *objid;

#endif

{
	register int	i;

 	string = CATSPRINTF(string, "OID ");
  	for ( i = 0; i < objid->oid_nelem; i++) {
 		if (i == objid->oid_nelem -1) string = CATSPRINTF(string, "%d", objid->oid_elements[i]);
 		else string = CATSPRINTF(string, "%d.", objid->oid_elements[i]);
  	}
  	return(string);
}


/***************************************************************
 *
 * Procedure aux_sprint_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_AlgId(
	char	 *string,
	AlgId	 *aid
)

#else

char *aux_sprint_AlgId(
	string,
	aid
)
char	 *string;
AlgId	 *aid;

#endif

{
	int	paramchoice;
	int     DHplength;
	rsa_parm_type     * rsa_parm;
	desCBC_parm_type * des_parm;
	char *name;
	KeyBits * kbits;

	if ( !aid || !aid->objid ) {
		string = CATSPRINTF(string, "%s\n", EAID);
		return(string);
	}

  	string = CATSPRINTF(string, "Algorithm ");
  
  	name = aux_ObjId2Name(aid->objid);
  	if(name) {
 		string = CATSPRINTF(string, "%s (", name);
  		free(name);
 		string = aux_sprint_ObjId(string, aid->objid);
 		string = CATSPRINTF(string, ")");
  
  		if ( aid->param ) {
			switch ( paramchoice = aux_ObjId2ParmType( aid->objid ) ) {

			case PARM_INTEGER:
				rsa_parm = (rsa_parm_type * )(aid->param);
				string = CATSPRINTF(string, ", Keysize = %d\n", *rsa_parm);
				break;

			case PARM_OctetString:
				des_parm = (desCBC_parm_type * )(aid->param);
				string = CATSPRINTF(string, ", DES-Initial-Vector(len %d): ", des_parm->noctets);
				if (des_parm->noctets) 
					string = aux_sxdump2(string, des_parm->octets, des_parm->noctets, 0);
				string = CATSPRINTF(string, "\n");
				break;
			case PARM_KeyBits:
				print_indent += 10;
				kbits = (KeyBits * )(aid->param);

				string = CATSPRINTF(string, ",\n");
				if(kbits->part3.noctets <= 4) {
					int n;
					/* DH parameter */
			
					n = kbits->part1.noctets;
					string = CATSPRINTF(string, "    DH prime p (no. of bits = %d):\n", n * 8);
					string = aux_sxdump2(string, kbits->part1.octets, n, 0);
			
					n = kbits->part2.noctets;
					string = CATSPRINTF(string, "    DH base g (no. of bits = %d):\n", n * 8);
					string = aux_sxdump2(string, kbits->part2.octets, n, 0);
			
					string = CATSPRINTF(string, "    PrivateValueLength: %d (bits)\n", aux_OctetString2int(&(kbits->part3)));
				 }
				else {
					int n;
					/* DSA parameter */
			
					n = kbits->part1.noctets;
					string = CATSPRINTF(string, "    DSA prime p (no. of bits = %d):\n", n * 8);
					string = aux_sxdump2(string, kbits->part1.octets, n, 0);
			
					n = kbits->part2.noctets;
					string = CATSPRINTF(string, "    DSA prime q (no. of bits = %d):\n", n * 8);
					string = aux_sxdump2(string, kbits->part2.octets, n, 0);
			
					n = kbits->part3.noctets;
					string = CATSPRINTF(string, "    DSA base g (no. of bits = %d):\n", n * 8);
					string = aux_sxdump2(string, kbits->part3.octets, n, 0);
			
				 }
				print_indent -= 10;
				break;
			default:
				string = CATSPRINTF(string, "?? Unidentified parameter:\n");
				string = CATSPRINTF(string, "  Parameter is set to INTEGER 0 (encode) or ");
				string = CATSPRINTF(string, "ignored (decode).\n");
			}
		} 
	        else switch ( paramchoice = aux_ObjId2ParmType( aid->objid ) ) {
			case PARM_NULL:
				string = CATSPRINTF(string, ", NULL\n");
				break;
	                case PARM_ABSENT:
	        		string = CATSPRINTF(string, ", no parameter\n");
	                        break;
	        }

	}
 	else {
 		string = aux_sprint_ObjId(string, aid->objid);
 		string = CATSPRINTF(string, " (unknown object identifier)\n");
 	}
	return(string);
}

/***************************************************************
 *
 * Procedure aux_sprint_algorithm
 *
 * Print algorithm information to string
 * name of algorithm is searched by aux_ObjId2Name if name is CNULL
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_sprint_algorithm(
	char	 *string,
	ObjId	 *oid,
	char	 *name
)

#else

char *aux_sprint_algorithm(
	string,
	oid,
	name
)
char	 *string;
ObjId	 *oid;
char	 *name;

#endif

{
	char			*proc = "aux_sprint_algorithm";
	char			*s = "<not specified>";
	char			*algname;
	char			*algoid;
	AlgType			algtype;
	AlgEnc			algenc;
	ParmType		algparmtype;
	AlgHash			alghash;
	AlgSpecial		algspecial;
	AlgMode			algmode;
	
	
	if (!oid) {
		string = CATSPRINTF(string, "%s\n", EAID);
		return(string);	}

	if (name) algname = aux_cpy_String(name);
	else algname = aux_ObjId2Name(oid);
	algoid = aux_sprint_ObjId(CNULL, oid);
	algparmtype = aux_ObjId2ParmType(oid);
	algtype = aux_ObjId2AlgType(oid);
	algenc = aux_ObjId2AlgEnc(oid);
	alghash = aux_ObjId2AlgHash(oid);
	algspecial = aux_ObjId2AlgSpecial(oid);
	algmode = aux_ObjId2AlgMode(oid);

	string = CATSPRINTF(string,
		"\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
		"         Algorithm name:  ", algname ? algname : "Unknown algorithm",
		"              object id:  ", algoid ? algoid : "Unknown identifier",
		"                   type:  ", algtype >= 0 ? algtype_name[algtype] : s,
		"                    enc:  ", algenc >= 0 ? algenc_name[algenc] : s,
		"              parameter:  ", algparmtype >= 0 ? algparmtype_name[algparmtype] : s,
		"                   hash:  ", alghash >= 0 ? alghash_name[alghash] : s,
		"                special:  ", algspecial >= 0 ? algspecial_name[algspecial - 1] : s,
		"                   mode:  ", algmode >= 0 ? algmode_name[algmode] : s);
				
	free(algname);
	free(algoid);
				
	return(string);
}


/***************************************************************
 *
 * Procedure aux_fprint_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_KeyBits(
	FILE	*ff,
	KeyBits	 *keybits
)

#else

RC aux_fprint_KeyBits(
	ff,
	keybits
)
FILE	*ff;
KeyBits	 *keybits;

#endif

{
	char *string = aux_sprint_KeyBits(CNULL, keybits);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_ObjId(
	FILE	*ff,
	ObjId	 *objid
)

#else

RC aux_fprint_ObjId(
	ff,
	objid
)
FILE	*ff;
ObjId	 *objid;

#endif

{
	char *string = aux_sprint_ObjId(CNULL, objid);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_AlgId(
	FILE	*ff,
	AlgId	 *aid
)

#else

RC aux_fprint_AlgId(
	ff,
	aid
)
FILE	*ff;
AlgId	 *aid;

#endif

{
	char *string = aux_sprint_AlgId(CNULL, aid);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure aux_fprint_algorithm
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_algorithm(
	FILE	*ff,
	ObjId	*oid
)

#else

RC aux_fprint_algorithm(
	ff,
	oid
)
FILE	*ff;
ObjId	*oid;

#endif

{
	char *string = aux_sprint_algorithm(CNULL, oid, CNULL);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}






/***************************************************************
 *
 * Procedure aux_print_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_KeyBits(
	KeyBits	 *keybits
)

#else

RC aux_print_KeyBits(
	keybits
)
KeyBits	 *keybits;

#endif

{
	return(aux_fprint_KeyBits(stderr, keybits));
}


/***************************************************************
 *
 * Procedure aux_print_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_ObjId(
	ObjId	 *objid
)

#else

RC aux_print_ObjId(
	objid
)
ObjId	 *objid;

#endif

{
	return(aux_fprint_ObjId(stderr, objid));
}


/***************************************************************
 *
 * Procedure aux_print_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_AlgId(
	AlgId	 *aid
)

#else

RC aux_print_AlgId(
	aid
)
AlgId	 *aid;

#endif

{
	return(aux_fprint_AlgId(stderr, aid));
}



/***************************************************************
 *
 * Procedure aux_print_algorithm
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_print_algorithm(
	ObjId	 *oid
)

#else

RC aux_print_algorithm(
	oid
)
ObjId	 *oid;

#endif

{
	return(aux_fprint_algorithm(stderr, oid));
}

/***************************************************************
 *
 * Procedure global_sprint_error
 *
 ***************************************************************/
#ifdef __STDC__

char *global_sprint_error(
	char	 *string,
	int	  verbose
)

#else

char *global_sprint_error(
	string,
	verbose
)
char	 *string;
int	  verbose;

#endif

{
	struct ErrStack *err = err_stack;
	int	n;


	if (!err_stack) return(CNULL);
	if (verbose == 0) {
 	       string = CATSPRINTF(string, "%s", err->e_text);
		if (err->e_addrtype == char_n && err->e_addr) string = CATSPRINTF(string, " :  %s\n", (char *)err->e_addr);
		else string = CATSPRINTF(string, "\n");
		return(string);
	}

	for (err = err_stack ; err != 0 ; err = err->next ) {
		for (n = 0; err_list[n].id != 0; n++) if (err_list[n].id == err->e_number) break;
		string = CATSPRINTF(string, "%s in %s: (%d) %s ", err->e_is_error ? "ERROR" : "WARNING", err->e_proc, err->e_number, err->e_text);
		if (verbose > 1 && err->e_addr) {
		
 			if (err->e_addrtype != int_n && err->e_addrtype != char_n) string = CATSPRINTF(string, "\n");
 			
 			switch (err->e_addrtype) {

			case char_n:
				string = CATSPRINTF(string, ": \"%s\"\n", err->e_addr);
				break;
			case int_n:
				string = CATSPRINTF(string, "%d\n", err->e_addr);
				break;
			case OctetString_n:
				string = aux_sxdump2(string, ((OctetString * )err->e_addr)->octets, ((OctetString * )err->e_addr)->noctets , 0);
				break;
			case BitString_n:
				string = aux_sxdump2(string, ((OctetString * )err->e_addr)->octets, (((OctetString * )err->e_addr)->noctets + 7) / 8 , 0);
				break;
			case AlgId_n:
				string = aux_sprint_AlgId(string, (AlgId *)err->e_addr);
				break;
			case ObjId_n:
				string = aux_sprint_ObjId(string, (ObjId *)err->e_addr);
				break;
			case KeyBits_n:
				string = aux_sprint_KeyBits(string, (KeyBits *)err->e_addr);
				break;
			}
		}
 		else string = CATSPRINTF(string, "\n");

	}
	return(string);
}


/***************************************************************
 *
 * Procedure global_fprint_error
 *
 ***************************************************************/
#ifdef __STDC__

RC global_fprint_error(
	FILE	*ff,
	int	  verbose
)

#else

RC global_fprint_error(
	ff,
	verbose
)
FILE	*ff;
int	  verbose;

#endif

{
	char *string = global_sprint_error(CNULL, verbose);

	if(string) {
		fprintf(ff, "%s", string);
		free(string);
		return(0);
	}
	else return(-1);
}


/***************************************************************
 *
 * Procedure global_print_error
 *
 ***************************************************************/
#ifdef __STDC__

RC global_print_error(
	int	  verbose
)

#else

RC global_print_error(
	verbose
)
int	  verbose;

#endif

{
	return(global_fprint_error(stderr, verbose));
}


