
static char *rcsid = "$Id: file.c,v 1.2 1995/02/21 14:50:32 surkau Exp $";

/* 
 *
 * $Id: file.c,v 1.2 1995/02/21 14:50:32 surkau Exp $
 *
 * $Log: file.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/



#ifndef MAC
#include <sys/types.h>
#include <sys/stat.h>
#else
#include <stdlib.h>
#include <string.h>
#include "MacTypes.h"
#include "Mac.h"
#endif /* MAC */

#ifndef MS_DOS
extern char     *sys_errlist[];
#endif /* MS_DOS */

#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include "sec_global.h"

#define WMODE 0644

/***************************************************************
 *
 * Procedure aux_file2OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_file2OctetString(
	char	 *fn
)

#else

OctetString *aux_file2OctetString(
	fn
)
char	 *fn;

#endif

{
	int	fd = -1, current;
	struct stat statbuf;
	char	*buf;
	unsigned int	fsize = 0, rest, rpt = 0, portion = 4096;
	OctetString * ostr; /* returned */
	char	*proc = "aux_file2OctetString";

	if (!(ostr = (OctetString * )malloc(sizeof(OctetString)))) {
		global_add_error(EMALLOC, "ostr", CNULL, 0, proc);
		return(NULLOCTETSTRING);
	}

	if ( !fn || !strlen(fn)) {
		fd = 0;
		rest = portion;
		if (!(buf = (char *)malloc(portion))) {
			global_add_error(EMALLOC, "buf(1)", CNULL, 0, proc);
			free(ostr);
			return(NULLOCTETSTRING);
		}
		while ((current = read(fd, buf + rpt, rest)) > 0) {
			rpt += current;
			rest -= current;
			if(!rest) {
				rest = portion;
				if (!(buf = (char *)realloc(buf, rpt + portion))) {
					global_add_error(EMALLOC, "buf(3)", CNULL, 0, proc);
					return( NULLOCTETSTRING );
				}
			}

		} 
		if(current < 0) {
			global_add_error(ESYSTEM, "Can't read file", sys_errlist[errno], char_n, proc);
			return( NULLOCTETSTRING );
		}
		if(rpt) {
			if (!(buf = (char *)realloc(buf, rpt))) {
				global_add_error(EMALLOC, "buf(3)", CNULL, 0, proc);
				return( NULLOCTETSTRING );
			}
		}
		else {
			free(buf);
			buf = CNULL;
		}
	} 
	else {
		if ( stat(fn, &statbuf) == -1 ) {
			global_add_error(ESYSTEM, sys_errlist[errno], (char *) fn, char_n, proc);
			free(ostr);
			return(NULLOCTETSTRING);
		}
		fsize = (unsigned int)statbuf.st_size;
		rest = fsize;
		if ( !(buf = (char *)malloc(fsize))) {
			global_add_error(EMALLOC, "buf(2)", CNULL, 0, proc);
			free(ostr);
			return( NULLOCTETSTRING );
		}

	
#ifndef MS_DOS
		if((fd = open(fn, O_RDONLY)) < 0 ) {
#else
                if((fd = open(fn, O_RDONLY | O_BINARY)) < 0 ) {
#endif
			global_add_error(ESYSTEM, "Can't open file", fn, char_n, proc);
			free(ostr);
			free(buf);
			return( NULLOCTETSTRING );
		}
		while ((current = read(fd, buf + rpt, rest)) > 0) {
			rpt += current;
			rest -= current;
		} 
		if(current < 0) {
			global_add_error(ESYSTEM, "Can't read file", sys_errlist[errno], char_n, proc);
			return( NULLOCTETSTRING );
		}
	}



	ostr->noctets = rpt;
	ostr->octets = buf;
	if (fd > 2) close(fd);
	return(ostr);
}


/***************************************************************
 *
 * Procedure aux_file2OctetString
 *
 ***************************************************************/
/*
   aux_OctetString2file writes fn from OctetString ostr;
   flag=0:      no overwrite (file must not exist),
       =1:      overwrite    (file must exist),
       =2:      create or overwrite,
       =3:      append       (file must exist),
       =4:      create or append,
       default: like flag=0;
   aux_OctetString2file returns 0 on success and -1 on error.
*/
#ifdef __STDC__


int	aux_OctetString2file	(
	OctetString 	*ostr,
	char 		*fn,
	int 		 flag
)

#else

int	aux_OctetString2file	(
	ostr,
	fn,
	flag
)
OctetString 	*ostr;
char 		*fn;
int 		 flag;

#endif

{
	int	        fd = -1;
	struct stat     statbuf;
	long	        rest, wpt;
	int	        openflag;
	char	      * proc = "aux_OctetString2file";

	if ( !ostr ) {
		global_add_error(EINVALID, "ostr empty", CNULL, 0, proc);
		return(-1);
	}
	if ( !fn || !strlen(fn) ) 
		fd = 1;
	else {
		switch (flag) {
		case 0:
			openflag = O_CREAT | O_EXCL | O_WRONLY;
			break;
		case 1:
			openflag = O_TRUNC | O_WRONLY;
			break;
		case 2:
			openflag = O_CREAT | O_TRUNC | O_WRONLY;
			break;
		case 3:
			openflag = O_APPEND | O_WRONLY;
			break;
		case 4:
			openflag = O_CREAT | O_APPEND | O_WRONLY;
			break;
		}
#ifdef MS_DOS
                openflag = openflag | O_BINARY;
#endif
#ifdef MAC
 		if ((fd = open(fn, openflag)) < 0 ) 
#else
 		if ((fd = open(fn, openflag, WMODE)) < 0 ) {
#endif
			global_add_error(ESYSTEM, "Can't write file", fn, char_n, proc);
			return(-1);
		}
	}

	wpt = 0;
	rest = ostr->noctets;
	if(rest)
		while (((wpt = write(fd, ostr->octets + wpt, rest)) < rest) && wpt) {
			if (wpt < 0) {
				if (fd > 2) 
					close(fd);
				global_add_error(ESYSTEM, "write failed", CNULL, 0, proc);
				return(-1);
			}
			rest = rest - wpt;
		}
	if (fd > 2) close(fd);
	return(0);
}


