/* ./src/crypt/dsa/dsa.c */

static char *rcsid = "$Id: dsa.c,v 1.7 1995/01/04 14:29:22 surkau Exp $";

/* 
 *
 * $Id: dsa.c,v 1.7 1995/01/04 14:29:22 surkau Exp $
 *
 * $Log: dsa.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*
 * DSA - modul fuer secure interface
 *
 * dsa_encrypt(), dsa_decrypt(), dsa_sign(), dsa_verify(), hash_sqmodn(),
 * dsa_set_key(), dsa_pkmap()
 */

#include "arithmetic.h"

#include "dsa.h"

#define ERASEKEY bzero((char *)&K,sizeof(K))
/*---------------------------------------------------------------*
 * statische Variablen fuer restliche input Bloecke und DSA keys *
 *---------------------------------------------------------------*/
static DSA_keys  K;              /* DSA key fields */


#ifdef TRACE_ALL
#define TRACE_DSA
#endif

/*----------------------------------------------get_dsa_key---*/

/***************************************************************
 *
 * Procedure dsa_set_key
 *
 ***************************************************************/
#ifdef __STDC__

RC dsa_set_key(
	OctetString	  *d_key,	
	KeyBits		  *common
)

#else

RC dsa_set_key(
	d_key,
	common
)
OctetString	  *d_key;
KeyBits		  *common;

#endif

{
	
        INTEGERtoln(d_key, K.pk.y);
	INTEGERtoln(&common->part1, K.pk.p);
	INTEGERtoln(&common->part2, K.pk.q);
       	INTEGERtoln(&common->part3, K.pk.g);

#ifdef TRACE_DSA
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dsa_set_key\n");

		fprintf(secude_trace_file, "y:\n");
		t_ostr = aux_LN2OctetString(K.pk.y, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "p:\n");
		t_ostr = aux_LN2OctetString(K.pk.p, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "q:\n");
		t_ostr = aux_LN2OctetString(K.pk.q, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "g:\n");
		t_ostr = aux_LN2OctetString(K.pk.g, 0);
		aux_fprint_OctetString(secude_trace_file, t_ostr);
		aux_free_OctetString(&t_ostr);

		fprintf(secude_trace_file, "<-- dsa_set_key\n");
	}
#endif
        return 0;
}




/*---------------------------------------------dsa_sign-------*/
/***************************************************************
 *
 * Procedure dsa_sign
 *
 ***************************************************************/
#ifdef __STDC__

RC dsa_sign(
	OctetString	 *hash,
	KeyBits	 *sign
)

#else

RC dsa_sign(
	hash,
	sign
)
OctetString	 *hash;
KeyBits	 *sign;

#endif

{
        L_NUMBER        L[MAXLGTH];
        L_NUMBER        S[MAXLGTH];
	DSA_sig	 	sig;
	char		p1[25], p2[25];
        BitString       *sigtmp;

#ifdef TRACE_DSA
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dsa_sign\n");

		fprintf(secude_trace_file, "hash:\n");
		aux_fprint_OctetString(secude_trace_file, hash);
	}
#endif

        if(MAXLGTH * SIZEOFINT < hash->noctets * BYTEL) return(-1);


        INTEGERtoln(hash, L);

        dsa_signblock(L, &sig, &K.sk);

	if(aux_LN2OctetString2(&sign->part1, sig.s, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return(-1);
	}
	if(aux_LN2OctetString2(&sign->part2, sig.r, 0) < 0) {
		global_add_error(LASTERROR, LASTTEXT, LASTADDR, proc);
		return(-1);
	}
	sign->part3.noctets = 0;
	sign->part4.noctets = 0;

#ifdef TRACE_DSA
	{

		fprintf(secude_trace_file, "sig:\n");
		aux_fprint_KeyBits(secude_trace_file, sign);

		fprintf(secude_trace_file, "<-- dsa_sign\n");
	}
#endif

        ERASEKEY;
        return 0;
}


/*---------------------------------------------dsa_verify-----*/
/***************************************************************
 *
 * Procedure dsa_verify
 *
 ***************************************************************/
#ifdef __STDC__

RC dsa_verify(
	OctetString	 *hash,
	KeyBits	 *sign
)

#else

RC dsa_verify(
	hash,
	sign
)
OctetString	 *hash;
KeyBits	 *sign;

#endif

{
        L_NUMBER        L[MAXLGTH];
        L_NUMBER        C[MAXLGTH];
	RC 		rc;
	DSA_sig	 	sig;

#ifdef TRACE_DSA
	{
		OctetString *t_ostr;
		fprintf(secude_trace_file, "--> dsa_verify\n");

		fprintf(secude_trace_file, "hash:\n");
		aux_fprint_OctetString(secude_trace_file, hash);

		fprintf(secude_trace_file, "sig:\n");
		aux_fprint_KeyBits(secude_trace_file, sign);

	}
#endif
        if(MAXLGTH * WBYTES < sign->part1.noctets) return(-1);
        if(MAXLGTH * WBYTES < sign->part2.noctets) return(-1);


        INTEGERtoln(&sign->part1, sig.s);
        INTEGERtoln(&sign->part2, sig.r);


        INTEGERtoln(hash, L);

        rc = dsa_verifyblock(L, &sig, &K.pk);

#ifdef TRACE_DSA
	{
		fprintf(secude_trace_file, "rc: %d\n", rc);

		fprintf(secude_trace_file, "<-- dsa_verify\n");
	}
#endif
        ERASEKEY;
        return(-rc*rc);
}

