/* ./src/crypt/crypt_test.c */

static char *rcsid = "$Id: crypt_test.c,v 1.14 1995/02/20 15:43:12 surkau Exp $";

/* 
 *
 * $Id: crypt_test.c,v 1.14 1995/02/20 15:43:12 surkau Exp $
 *
 * $Log: crypt_test.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/












#define BUF_SIZE 200
#define HASH_SIZE 128
#define SIG_SIZE 256

#ifdef MSC
#define NO_TIME
#else
#include <sys/time.h>
#endif

#include "sec_global.h"
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#define fprintf print_to_file_and_stderr
FILE *out_file;





#ifdef __STDC__

print_to_file_and_stderr(
	FILE	  *ff,
	char      *format,
	...
)

#else 

print_to_file_and_stderr(
	ff,
	format,
	va_alist
)
FILE	 *ff;
char     *format;
va_dcl

#endif

{
	va_list args;
	

#ifdef __STDC__
	va_start(args, format);
#else 
	va_start(args);
#endif
	vfprintf(ff, format, args);
	if(out_file) vfprintf(out_file, format, args);
	va_end(args);


	return(0);
}


static void     usage();

char 	 plainbuf[BUF_SIZE];
char  	 hashbuf[HASH_SIZE];
char  	 sigbuf[SIG_SIZE];
char 	 encrbuf[2*BUF_SIZE];
char 	 decrbuf[2*BUF_SIZE];

OctetString plain;


typedef struct TEST_KEYS_RSA     TEST_KEYS_RSA;
struct TEST_KEYS_RSA {
	int keysize;
	KeyBits private;
	KeyBits public;
};

extern TEST_KEYS_RSA test_keys_rsa[];
#define TEST_KEYS_RSA_NO 3

typedef struct TEST_KEYS_DSA     TEST_KEYS_DSA;
struct TEST_KEYS_DSA {
	int keysize;
	KeyBits private;
	KeyBits public;
};

extern TEST_KEYS_DSA test_keys_dsa[];
#define TEST_KEYS_DSA_NO 9

static void start_time()
{
#ifndef NO_TIME
	gettimeofday(&sec_tp1, &sec_tzp1);
#endif
}
static char  *print_time()
{
#ifdef NO_TIME
	return("");
#else
	static char t[100];
	long time;

	gettimeofday(&sec_tp2, &sec_tzp2);
	time = (sec_tp2.tv_sec - sec_tp1.tv_sec) * 1000000 + (sec_tp2.tv_usec - sec_tp1.tv_usec);
	sprintf(t, "[ Time used: %ld us]", time);
	return(t);
#endif
}



int test_rsa() {
	int n, keysize, testkey = 0, rc;
	OctetString hash;
	BitString sign;
	KeyBits *skey, *pkey;
	BitString encr;
	OctetString decr;

	hash.octets = hashbuf;
	hash.noctets = 0;

	sign.bits = sigbuf;
	sign.nbits = 0;

	encr.bits = encrbuf;
	decr.octets = decrbuf;

	fprintf(stderr, "---------- Begin of RSA test --------------------\n");
	for(keysize = 512; keysize <= 768; keysize += 256) {
		
		fprintf(stderr, "---------- Testing key size %d with generating the keys --------------------\n", keysize);

		fprintf(stderr, "Generating keys ...\n");
		rsa_gen_key(keysize, &skey, &pkey);
		fprintf(stderr, "done.\n");

		encr.nbits = 0;
		decr.noctets = 0;
		sign.nbits = 0;
		hash.noctets = 0;

		fprintf(stderr, "Encrypting ...");
		rsa_set_key(pkey);
		rsa_encrypt(&plain, &encr, SEC_END, keysize);
		fprintf(stderr, " %d octets --> %d bits ... done.\n", plain.noctets, encr.nbits);


		fprintf(stderr, "Decrypting ...");
		rsa_set_key(skey);
		rc = rsa_decrypt(&encr, &decr, SEC_END, keysize);
		fprintf(stderr, " %d bits --> %d octets ... done.\n", encr.nbits, decr.noctets);

		for(n = 0; n<BUF_SIZE; n++) {
			if(plainbuf[n] != decrbuf[n]) break;
		}
		if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
		else fprintf(stderr, "Verification f a i l e d !\n");


		fprintf(stderr, "Hashing ...");
		md5_hash(&plain, &hash, SEC_END);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Signing ...");
		rsa_set_key(skey);
		rsa_sign(&hash,&sign);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Verifing ...");
		rsa_set_key(pkey);
		rc = rsa_verify(&hash,&sign);
		fprintf(stderr, " done.\n");

		if(rc == 0) fprintf(stderr, "Verification successful !\n");
		else fprintf(stderr, "Verification f a i l e d !\n");
	}
	for(testkey = 0; testkey < TEST_KEYS_RSA_NO; testkey ++) {

		keysize = test_keys_rsa[testkey].keysize;
	
		fprintf(stderr, "---------- Testing key size %d --------------------\n", keysize);

		encr.nbits = 0;
		decr.noctets = 0;
		sign.nbits = 0;
		hash.noctets = 0;

		skey = &test_keys_rsa[testkey].private;
		pkey = &test_keys_rsa[testkey].public;

		fprintf(stderr, "Encrypting ...");
		rsa_set_key(pkey);
		rsa_encrypt(&plain, &encr, SEC_END, keysize);
		fprintf(stderr, " %d octets --> %d bits ... done.\n", plain.noctets, encr.nbits);


		fprintf(stderr, "Decrypting ...");
		rsa_set_key(skey);
		rc = rsa_decrypt(&encr, &decr, SEC_END, keysize);
		fprintf(stderr, " %d bits --> %d octets ... done.\n", encr.nbits, decr.noctets);

		for(n = 0; n<BUF_SIZE; n++) {
			if(plainbuf[n] != decrbuf[n]) break;
		}
		if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
		else fprintf(stderr, "Verification f a i l e d !\n");


		fprintf(stderr, "Hashing ...");
		md5_hash(&plain, &hash, SEC_END);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Signing ...");
		rsa_set_key(skey);
		rsa_sign(&hash,&sign);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Verifing ...");
		rsa_set_key(pkey);
		rc = rsa_verify(&hash,&sign);
		fprintf(stderr, " done.\n");

		if(rc == 0) fprintf(stderr, "Verification successful !\n");
		else fprintf(stderr, "Verification f a i l e d !\n");
	}

	fprintf(stderr, "---------- End of RSA test --------------------\n");
}


int test_dsa() {

	int testkey = 0;
	OctetString hash;
	OctetString  *skey, *pkey;
	KeyBits  sign, *dsacommon;
	char	signp1[100];
	char	signp2[100];
	RC rc;
	int m, keysize;

	sign.part1.octets = signp1;
	sign.part1.noctets = 0;
	sign.part2.octets = signp2;
	sign.part2.noctets = 0;

	hash.octets = hashbuf;
	hash.noctets = 0;


	fprintf(stderr, "---------- Begin of DSA test --------------------\n");
	for(keysize = 512; keysize <= 768; keysize += 256) {
		
		fprintf(stderr, "---------- Testing key size %d with generating the keys --------------------\n", keysize);

		fprintf(stderr, "Generating keys ...\n");
		dsacommon = dsa_gen_common(keysize);
		dsa_gen_key(&skey, &pkey, dsacommon);
		fprintf(stderr, "done.\n");

		fprintf(stderr, "Hashing ...");
		sha_hash(&plain, &hash, SEC_END);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Signing ...");
		dsa_set_key(skey, dsacommon);
		dsa_sign(&hash,&sign);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Verifing ...");
		dsa_set_key(pkey, dsacommon);
		rc = dsa_verify(&hash,&sign);
		fprintf(stderr, " done.\n");

		if(rc == 0) fprintf(stderr, "Verification successful !\n");
		else fprintf(stderr, "Verification f a i l e d !\n");
	}
	for(testkey = 0; testkey<TEST_KEYS_DSA_NO; testkey++) {
		keysize = test_keys_dsa[testkey].keysize;
		fprintf(stderr, "---------- Testing key size %d --------------------\n", keysize);
		
		skey = &(test_keys_dsa[testkey].private.part4);
		pkey = &(test_keys_dsa[testkey].public.part4);
		dsacommon = &(test_keys_dsa[testkey].private);

		fprintf(stderr, "Hashing ...");
		sha_hash(&plain, &hash, SEC_END);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Signing ...");
		dsa_set_key(skey, dsacommon);
		dsa_sign(&hash,&sign);
		fprintf(stderr, " done.\n");
	
		fprintf(stderr, "Verifiing ...");
		dsa_set_key(pkey, dsacommon);
		rc = dsa_verify(&hash,&sign);
		fprintf(stderr, " done.\n");

		if(rc == 0) fprintf(stderr, "Verification successful !\n");
		else fprintf(stderr, "Verification f a i l e d !\n");
	}
	fprintf(stderr, "---------- End of DSA test --------------------\n");
}
int test_des() {

	int 		 testkey = 0;
	OctetString  	*skey, *pkey;
	BitString 	 encr;
	OctetString 	 decr;
	RC 		 rc, n;
	int 		 m, keysize;
	KeyInfo 	 keyinfo;

	encr.bits = encrbuf;
	decr.octets = decrbuf;

	fprintf(stderr, "---------- Begin of DES test --------------------\n");

	encr.nbits = 0;
	decr.noctets = 0;
	keyinfo.subjectAI = desCBC;
	keyinfo.subjectkey.nbits = 64;
	keyinfo.subjectkey.bits = "abcdefgh";

	fprintf(stderr, "---------- testing algorithm desCBC --------------------\n");
	fprintf(stderr, "Encrypting ...");
	start_time();
	des_encrypt(&plain, &encr, SEC_END, &keyinfo);
	fprintf(stderr, " %d octets --> %d bits ... done %s.\n", plain.noctets, encr.nbits, print_time());

	fprintf(stderr, "Decrypting ...");
	start_time();
	rc = des_decrypt(&encr, &decr, SEC_END, &keyinfo);
	fprintf(stderr, " %d bits --> %d octets ... done %s.\n", encr.nbits, decr.noctets, print_time());

	for(n = 0; n<BUF_SIZE; n++) {
		if(plainbuf[n] != decrbuf[n]) break;
	}
	if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
	else fprintf(stderr, "Verification f a i l e d !\n");


	encr.nbits = 0;
	decr.noctets = 0;
	keyinfo.subjectAI = desECB;
	keyinfo.subjectkey.nbits = 64;
	keyinfo.subjectkey.bits = "abcdefgh";

	fprintf(stderr, "---------- testing algorithm desECB --------------------\n");
	fprintf(stderr, "Encrypting ...");
	start_time();
	des_encrypt(&plain, &encr, SEC_END, &keyinfo);
	fprintf(stderr, " %d octets --> %d bits ... done %s.\n", plain.noctets, encr.nbits, print_time());

	fprintf(stderr, "Decrypting ...");
	start_time();
	rc = des_decrypt(&encr, &decr, SEC_END, &keyinfo);
	fprintf(stderr, " %d bits --> %d octets ... done %s.\n", encr.nbits, decr.noctets, print_time());

	for(n = 0; n<BUF_SIZE; n++) {
		if(plainbuf[n] != decrbuf[n]) break;
	}
	if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
	else fprintf(stderr, "Verification f a i l e d !\n");



	encr.nbits = 0;
	decr.noctets = 0;
	keyinfo.subjectAI = desCBC3;
	keyinfo.subjectkey.nbits = 128;
	keyinfo.subjectkey.bits = "abcdefghABCDEFGH";

	fprintf(stderr, "---------- testing algorithm desCBC3 --------------------\n");
	fprintf(stderr, "Encrypting ...");
	start_time();
	des_encrypt(&plain, &encr, SEC_END, &keyinfo);
	fprintf(stderr, " %d octets --> %d bits ... done %s.\n", plain.noctets, encr.nbits, print_time());

	fprintf(stderr, "Decrypting ...");
	start_time();
	rc = des_decrypt(&encr, &decr, SEC_END, &keyinfo);
	fprintf(stderr, " %d bits --> %d octets ... done %s.\n", encr.nbits, decr.noctets, print_time());

	for(n = 0; n<BUF_SIZE; n++) {
		if(plainbuf[n] != decrbuf[n]) break;
	}
	if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
	else fprintf(stderr, "Verification f a i l e d !\n");


	fprintf(stderr, "---------- End of DES test --------------------\n");
}
int test_idea() {

	int 		 testkey = 0;
	OctetString  	*skey, *pkey;
	BitString 	 encr;
	OctetString 	 decr;
	RC 		 rc, n;
	int 		 m, keysize;
	KeyInfo 	 keyinfo;

	encr.bits = encrbuf;
	decr.octets = decrbuf;

	fprintf(stderr, "---------- Begin of IDEA test --------------------\n");

	encr.nbits = 0;
	decr.noctets = 0;
	keyinfo.subjectAI = idea;
	keyinfo.subjectkey.nbits = 128;
	keyinfo.subjectkey.bits = "abcdefghABCDEFGH";

	fprintf(stderr, "---------- testing algorithm idea --------------------\n");
	fprintf(stderr, "Encrypting ...");
	start_time();
	idea_encrypt(&plain, &encr, SEC_END, &keyinfo);
	fprintf(stderr, " %d octets --> %d bits ... done %s.\n", plain.noctets, encr.nbits, print_time());

	fprintf(stderr, "Decrypting ...");
	start_time();
	rc = idea_decrypt(&encr, &decr, SEC_END, &keyinfo);
	fprintf(stderr, " %d bits --> %d octets ... done %s.\n", encr.nbits, decr.noctets, print_time());

	for(n = 0; n<BUF_SIZE; n++) {
		if(plainbuf[n] != decrbuf[n]) break;
	}
	if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
	else fprintf(stderr, "Verification f a i l e d !\n");


	fprintf(stderr, "---------- End of IDEA test --------------------\n");
}
int test_dh() {

	BitString 	*bstr1, *bstr2;
	RC 		 rc;
	int 		 keysize = 512;
	KeyInfo 	*public1, *public2;
	KeyInfo 	*private1, *private2;
	AlgId		*dh_param;

	fprintf(stderr, "---------- Begin of DH test --------------------\n");

	fprintf(stderr, "----- Test with transfering the DH parameter ---\n");

	fprintf(stderr, "Generating DH algorithm parameter ...\n");
	start_time();
	dh_param = dh_init(keysize, 56);
	fprintf(stderr, "done %s.\n\n", print_time());


	fprintf(stderr, "Generating key pair ...");
	start_time();
	public1 = dh_phase1(dh_param, &private1, DH_ALG_WITH_PARAM);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      ----->\n\n");

	fprintf(stderr, "\t\t\t\tGenerating key pair ...");
	start_time();
	public2 = dh_phase1(public1->subjectAI, &private2, DH_ALG_WITHOUT_PARAM);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\t\t\t\tCalculating common BitString ...");
	start_time();
	bstr2 =  dh_phase2(public1->subjectAI, private2, public1);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      <------\n\n");

	fprintf(stderr, "Calculating common BitString ...");
	start_time();
	bstr1 =  dh_phase2(dh_param, private1, public2);
	fprintf(stderr, " done %s\n", print_time());


	if(aux_cmp_BitString(bstr2, bstr1)) fprintf(stderr, "\nThe BitStrings differ !\n");


	fprintf(stderr, "----- Test with common DH parameter ---\n");


	fprintf(stderr, "Generating key pair ...");
	start_time();
	public1 = dh_phase1(dh_param, &private1, DH_ALG_WITHOUT_PARAM);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      ----->\n\n");

	fprintf(stderr, "\t\t\t\tGenerating key pair ...");
	start_time();
	public2 = dh_phase1(dh_param, &private2, DH_ALG_WITHOUT_PARAM);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\t\t\t\tCalculating common BitString ...");
	start_time();
	bstr2 =  dh_phase2(dh_param, private2, public1);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      <------\n\n");

	fprintf(stderr, "Calculating common BitString ...");
	start_time();
	bstr1 =  dh_phase2(dh_param, private1, public2);
	fprintf(stderr, " done %s\n", print_time());


	if(aux_cmp_BitString(bstr2, bstr1)) fprintf(stderr, "\nThe BitStrings differ !\n");


	fprintf(stderr, "\n---------- End of DH test --------------------\n");
}
int test_dh_new() {

	RC 		 rc;
	int 		 n;

	void *ctx1 = 0,*ctx2 = 0;
	OctetString ostr1, ostr2,  *ostrp1, *ostrp2;

	fprintf(stderr, "---------- Begin of DH test --------------------\n");


	fprintf(stderr, "Generating DH context ...\n");
	start_time();
	if(dh_start(&ctx1, 512, 64, FALSE, 8) < 0) return(-1);
	fprintf(stderr, "done %s.\n\n", print_time());

	fprintf(stderr, "----- Test with transfering the DH parameter ---\n");

	fprintf(stderr, "Generating key pair ...");
	start_time();
	ostrp1 = (OctetString *)dh_connect(&ctx1);
	if(!ostrp1) return(-1);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      ----->\n\n");

	fprintf(stderr, "\t\t\t\tGenerating key pair and calculating common BitString ...");
	start_time();
	ostrp2 = (OctetString *)dh_reply(&ctx2, ostrp1);
	if(!ostrp2) return(-1);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      <------\n\n");

	fprintf(stderr, "Calculating common BitString ...");
	start_time();
	if(dh_accept(&ctx1, ostrp2) < 0) return(-1);
	fprintf(stderr, " done %s\n", print_time());


	fprintf(stderr, "Encrypting ...");
	start_time();
	ostrp1 = (OctetString *)dh_encrypt(&ctx1, &plain);
	if(!ostrp1) return(-1);
	fprintf(stderr, " %d octets --> %d octets ... done %s.\n", plain.noctets, ostrp1->noctets, print_time());

	fprintf(stderr, "Decrypting ...");
	start_time();
	ostrp2 = (OctetString *)dh_decrypt(&ctx2, ostrp1);
	if(!ostrp2) return(-1);
	fprintf(stderr, " %d octets --> %d octets ... done %s.\n", ostrp1->noctets, ostrp2->noctets, print_time());

	for(n = 0; n<BUF_SIZE; n++) {
		if(plainbuf[n] != ostrp2->octets[n]) break;
	}
	if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
	else fprintf(stderr, "Verification f a i l e d !\n");
	fprintf(stderr, "----- Test with transfering the DH parameter ---\n");

	fprintf(stderr, "Generating key pair ...");
	start_time();
	ostrp1 = (OctetString *)dh_connect(&ctx1);
	if(!ostrp1) return(-1);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      ----->\n\n");

	fprintf(stderr, "\t\t\t\tGenerating key pair and calculating common BitString ...");
	start_time();
	ostrp2 = (OctetString *)dh_reply(&ctx2, ostrp1);
	if(!ostrp2) return(-1);
	fprintf(stderr, " done %s\n", print_time());

	fprintf(stderr, "\n\t\tTransfering public key\n");
	fprintf(stderr, "\t\t      <------\n\n");

	fprintf(stderr, "Calculating common BitString ...");
	start_time();
	if(dh_accept(&ctx1, ostrp2) < 0) return(-1);
	fprintf(stderr, " done %s\n", print_time());


	fprintf(stderr, "Encrypting ...");
	start_time();
	ostrp1 = (OctetString *)dh_encrypt(&ctx1, &plain);
	if(!ostrp1) return(-1);
	fprintf(stderr, " %d octets --> %d octets ... done %s.\n", plain.noctets, ostrp1->noctets, print_time());

	fprintf(stderr, "Decrypting ...");
	start_time();
	ostrp2 = (OctetString *)dh_decrypt(&ctx2, ostrp1);
	if(!ostrp2) return(-1);
	fprintf(stderr, " %d octets --> %d octets ... done %s.\n", ostrp1->noctets, ostrp2->noctets, print_time());

	for(n = 0; n<BUF_SIZE; n++) {
		if(plainbuf[n] != ostrp2->octets[n]) break;
	}
	if(n == BUF_SIZE || !rc) fprintf(stderr, "Verification successful !\n");
	else fprintf(stderr, "Verification f a i l e d !\n");
	dh_end(&ctx2);
	fprintf(stderr, "\n---------- End of DH test --------------------\n");
}
int test_exp() {

	int              n;
	L_NUMBER	*bases[17];
	L_NUMBER	*exponents[17];
	L_NUMBER	*moduls[17];
	L_NUMBER	*results[17];

	fprintf(stderr, "---------- Begin of exponentiation test --------------------\n");

	start_time();
	fprintf(stderr, "Generating random Numbers ...");
	for( n = 64; n <= 1024; n += 64) {
		bases[n/64] = (L_NUMBER *) malloc(140);
		rndm(n , bases[n/64]);
		exponents[n/64] = (L_NUMBER *) malloc(140);
		rndm(n , exponents[n/64]);
		moduls[n/64] = (L_NUMBER *) malloc(140);
		rndm(n+1 , moduls[n/64]);
		results[n/64] = (L_NUMBER *) malloc(140);
	}
		
	fprintf(stderr, " done %s\n", print_time());
	
	for( n = 64; n <= 1024; n += 64) {
		fprintf(stderr, "Calculating with mexp a = b^e (mod n) with keysize %d ...", n);
		start_time();
		mexp(bases[n/64], exponents[n/64], results[n/64], moduls[n/64]);
		fprintf(stderr, " done %s\n", print_time());

	}

	for( n = 64; n <= 1024; n += 64) {
		free(bases[n/64]);
		free(exponents[n/64]);
		free(moduls[n/64]);
		free(results[n/64]);
	}

	fprintf(stderr, "\n---------- End of exponentiation test --------------------\n");
}

/***************************************************************
 *
 * Procedure main
 *
 ***************************************************************/
#ifdef __STDC__

int main(
	int	  cnt,
	char	 *parms[]
)

#else

int main(
	cnt,
	parms
)
int	  cnt;
char	 *parms[];

#endif

{
	int n = 1, m;
	
	sec_verbose = 0;
	sec_gen_verbose = 1;

	if(cnt == 1 || !strcmp(parms[1], "-h")) usage();
		
	plain.octets = plainbuf;
	plain.noctets = BUF_SIZE;
	for(m = 0; m<BUF_SIZE; m++) plainbuf[m] = m % 95 + ' ';
	open_trace_file();
	out_file = fopen("cr_test.out", "w");
	while(n<cnt) {
		for(m = strlen(parms[n]) - 1; m >= 0 ; m--) 
			if(parms[n][m] <= 'z' && parms[n][m] >= 'a') parms[n][m] += 'A' - 'a';
		if(!strcmp(parms[n], "RSA")) test_rsa();
		else if(!strcmp(parms[n], "DSA")) test_dsa();
		else if(!strcmp(parms[n], "DES")) test_des();
		else if(!strcmp(parms[n], "IDEA")) test_idea();
		else if(!strcmp(parms[n], "DH")) test_dh();
		else if(!strcmp(parms[n], "DHNEW")) test_dh_new();
		else if(!strcmp(parms[n], "EXP")) test_exp();
		else if(!strcmp(parms[n], "ALL")) {
			test_rsa();
			test_dsa();
			test_des();
			test_idea();
			test_dh();
			exit(0);
		}
		n++;
	}

	if(out_file) fclose(out_file);
	close_trace_file();

}
/***************************************************************
 *
 * Procedure usage
 *
 ***************************************************************/
static void usage()

{

        fprintf(stderr, "crypt_test:  Testing some algorithms and keys\n\n\n");
	fprintf(stderr, "Description:\n\n"); 
	fprintf(stderr, "'crypt_test' tests the algorithms in the parameter list.\n\n\n");
        fprintf(stderr, "usage:\n\n");
	fprintf(stderr, "crypt_test [rsa] [dsa] [des] [idea] [dh] [exp] [all]\n\n");

        exit(-1);                               
}


char test_key_rsa_public_p1_1[] = { -0x7f,-0x71,-0x4 ,-0x5e,-0x3a,-0x13, 0x3 ,-0x48,-0x3 , 0x19,-0x13, 0x41,-0x5d, 0x5d, 0x1 ,-0x2 ,-0x15, 0x37, 0x79,-0x3e,-0x67,-0x5a, 0x22, 0x2f, 0x20, 0x47,-0x10,-0x6e,-0x2e, 0x59, 0x1c,-0x3b };
char test_key_rsa_public_p1_2[] = {  0x1 ,  0x0 ,  0x1  };

char test_key_rsa_private_p1_1[] = {  0x8 , 0x17,-0x56, 0x4e, 0x7b,-0x79, 0x5 , 0x2e,-0x27,-0x50,-0x5d,-0xc ,-0x36,-0x75,-0x26,-0x79,-0x15 };
char test_key_rsa_private_p1_2[] = {  0x10, 0x2 ,-0x5d, 0x2a, 0x23,-0x76, 0x61, 0x0 , 0x79, 0x75, 0x4b,-0x3a, 0x47, 0x6d,-0xe , 0xf  };



char test_key_rsa_public_p2_1[] = { -0x78,-0x65, 0x74, 0x3a,-0x7e,-0x55, 0x29,-0x24, 0x72, 0x74,-0x69, 0x11, 0x62, 0x4d, 0x6d, 0x2b,-0x6a, 0x23, 0x1d,-0x19,-0x3e, 0x49,-0x60,-0x8 , 0x43,-0x17, 0x15,-0x9 , 0x0 , 0x45,-0x29, 0x43,-0x80, 0x79,-0x72, 0x59,-0x79,-0x70,-0x4d,-0x12, 0x15,-0x54,-0x55, 0x6f, 0x4b, 0x68,-0x3e,-0x1e, 0x4 ,-0x3d,-0x5d,-0x7 ,-0x74, 0x2 , 0x69, 0x7 ,-0x30,-0x66, 0x3b, 0x1e, 0x31,-0x70, 0x34,-0x27 };
char test_key_rsa_public_p2_2[] = {  0x1 ,  0x0 ,  0x1  };

char test_key_rsa_private_p2_1[] = {  0x1 ,-0x70,-0x18, 0x1d,-0x4b,-0xd , 0x56,-0x72, 0x1a, 0x5e,-0x6 , 0x65,-0x3d,-0x16, 0x1b,-0x20, 0xf , 0x48, 0x4c,-0x16, 0x40,-0x35, 0x26, 0x8 , 0x63, 0x55,-0x67, 0x2e,-0x5 ,-0x18,-0x63, 0x2a, 0x23 };
char test_key_rsa_private_p2_2[] = {  0x57, 0x3b, 0x1c,-0x80,-0x5f, 0x61,-0x59,-0x73, 0x6f, 0x27,-0x34,-0x22,-0xa , 0x76, 0x5a, 0x71,-0x56, 0x52,-0x32,-0x4d,-0x51,-0x46,-0x14,-0x68,-0x1a, 0x21,-0x72, 0x69, 0x19, 0x6 , 0x3e,-0x2d };


char test_key_rsa_public_p3_1[] = {  0x5d, 0x7c, 0x49,-0x2a,-0x48, 0x1 ,-0x51,-0x7 ,-0xe , 0x76, 0x33, 0x79, 0x29,-0x23, 0x38,-0x10,-0xf ,-0x53, 0x58,-0x44,-0x5e,-0x37,-0x75,-0x44,-0x69,-0x4b,-0x8 , 0x6a,-0x70, 0x7d,-0x4f,-0x48,-0x1 ,-0x38,-0xd , 0x4d,-0x2 , 0x66, 0x1c, 0x7a,-0x63,-0x48, 0x45, 0x44,-0x33, 0x3d,-0x71,-0x41,-0x32, 0x5 , 0x47,-0x1c, 0x3a,-0x5b, 0x46,-0x5d, 0x19,-0x68,-0x1a,-0x71,-0x22,-0x7 ,-0x56,-0x59,-0x62,-0x3d,-0x52,-0x24,-0x2 ,-0x76,-0x5d, 0x5a,-0x49, 0x2f,-0x4e, 0x4f, 0x37,-0x5e, 0x5d,-0x42,-0x1d, 0x4a, 0xa ,-0x28,-0x4d, 0x6f,-0x19, 0x21,-0x7e,-0x55, 0x5d, 0x46,-0x77,-0x61,-0x6a, 0x13, 0x17,-0x58,-0x5 ,-0x30, 0x1 , 0x76, 0x52, 0x54,-0x9 , 0x4e, 0x3f, 0x75, 0x7c,-0x69,-0x58,-0x5e, 0x78, 0x1c,-0x51, 0x67, 0x6c,-0x58, 0x0 , 0x6d, 0x63,-0x2a, 0x2f,-0x72,-0x5b };
char test_key_rsa_public_p3_2[] = {  0x1 ,  0x0 ,  0x1  };

char test_key_rsa_private_p3_1[] = {  0xb ,-0x4a, 0x1 ,-0x7 , 0x3c,-0x3b,-0x71,-0x6b, 0x4e,-0x71,-0x21,-0x5c,-0x4 ,-0x6a,-0x3e,-0x7a,-0x46, 0x35, 0x28, 0x59,-0x12,-0x9 , 0x3f,-0x5f,-0xc , 0x2 ,-0xc , 0x28, 0x43, 0x4e, 0x44, 0x4f, 0x15,-0x49,-0x1b,-0x5d,-0x16,-0x1b,-0x35, 0x60,-0x48, 0x4c, 0x3c, 0x5e, 0x22, 0x16, 0x5d, 0x5e, 0x3 ,-0x12,-0x17, 0x1c, 0x34,-0x61,-0x24,-0x15, 0x1a,-0x63,-0x5a,-0x2f,-0x3 ,-0x5a,-0x79 };
char test_key_rsa_private_p3_2[] = {  0x7 ,-0x5 ,-0x6c, 0x3e,-0x5d, 0x38, 0xa ,-0x3d,-0x70,-0x42, 0x4a, 0xf ,-0x22, 0x74, 0x3a,-0x4c,-0x7 , 0x17, 0x2 , 0x5c, 0x62, 0x3c,-0x32,-0x31, 0x10, 0x6c, 0x72, 0x21,-0x44, 0x7c,-0x34,-0x3e, 0x8 ,-0x68,-0x41,-0x6e, 0x49, 0x2 , 0x1b, 0x9 , 0x4d,-0xa , 0x49, 0xf , 0x24, 0x50,-0x1e, 0x58,-0x54,-0x1c,-0x68, 0x60, 0x51, 0x2e,-0x31,-0x29,-0x7 ,-0x6f, 0x58, 0x76,-0x7c, 0x40, 0x73 };


TEST_KEYS_RSA test_keys_rsa[] = {
	{
		256,
		{
			{17, test_key_rsa_private_p1_1}, 
			{16, test_key_rsa_private_p1_2}, 
			{0, CNULL}, 
			{0, CNULL}
		},
		{
			{32, test_key_rsa_public_p1_1}, 
			{3, test_key_rsa_public_p1_2}, 
			{0, CNULL}, 
			{0, CNULL}
		}
	},
	{
		512,
		{
			{33, test_key_rsa_private_p2_1}, 
			{32, test_key_rsa_private_p2_2}, 
			{0, CNULL}, 
			{0, CNULL}
		},
		{
			{64, test_key_rsa_public_p2_1}, 
			{3, test_key_rsa_public_p2_2}, 
			{0, CNULL}, 
			{0, CNULL}
		}


	},
	{
		999,
		{
			{63, test_key_rsa_private_p3_1}, 
			{63, test_key_rsa_private_p3_2}, 
			{0, CNULL}, 
			{0, CNULL}
		},
		{
			{125, test_key_rsa_public_p3_1}, 
			{3, test_key_rsa_public_p3_2}, 
			{0, CNULL}, 
			{0, CNULL}
		}


	}


};








char test_key_dsa_512_p[] = {
    -0x66, -0x33, -0x67, -0x27,
     0x11, -0x5e,  0x5a,  0x18,
     0x38, -0x1f,  0x4b,  0x26,
    -0x14,  0x17, -0x29, -0x13,
    -0x1 ,  0x33, -0x24, -0x37,
    -0x68, -0x4a, -0x60,  0x31,
    -0x72,  0x7b,  0x15,  0x1e,
    -0x18, -0x17,  0x57, -0x20,
    -0x8 ,  0x3e, -0x30,  0x3b,
     0x35,  0x42, -0x78, -0x61,
     0x3d, -0x55,  0x72, -0x11,
     0x3b,  0xf ,  0x3b, -0x6b,
    -0x5 , -0x24, -0x19,  0x3b,
    -0x72,  0x6e,  0x62, -0x18,
     0x6a,  0x44,  0x2b,  0x27,
    -0x54,  0x49,  0x7b, -0x21 };
char test_key_dsa_512_q[] = {
    -0x7f,  0x2a,  0x17,  0x1b,
     0x63, -0x44,  0x65, -0x6c,
     0x43, -0x46,  0x78, -0x76,
     0x44, -0x5a,  0x23,  0x3c,
     0x43,  0x1 ,  0x7 , -0x1  };
char test_key_dsa_512_g[] = {
     0x18,  0x3e,  0x79, -0x47,
     0x1b, -0x53,  0x14, -0x80,
    -0xd , -0x42, -0x8 , -0x49,
     0x61, -0x41,  0x58,  0xa ,
    -0x63, -0x31, -0x25,  0x18,
     0x4a, -0x70, -0x27,  0x67,
    -0x71,  0xd ,  0x3 , -0x44,
    -0x3c, -0x10, -0x6 , -0x67,
    -0x21, -0x1e,  0x12, -0x76,
    -0x6c, -0x54,  0x77,  0x32,
     0x5f, -0x42, -0x74,  0x57,
     0x78,  0x61,  0x12,  0x36,
    -0x54,  0x73,  0x16,  0x24,
    -0xa ,  0x5a,  0x74, -0x3c,
    -0x2f, -0x5 , -0x32,  0x2a,
    -0x52, -0x67, -0x48, -0x5e };
 
char test_key_dsa_512_x[] = {
    -0x31, -0x44, -0x4a, -0x50,
     0x4b, -0x26,  0x68,  0x7e,
    -0x53,  0x5d, -0x1b,  0x43,
    -0x6c, -0x2c,  0x52, -0x31,
     0x15, -0x64,  0x74,  0x41 };
char test_key_dsa_512_y[] = {
     0x1 ,  0x16,  0x67,  0x7 ,
    -0x4b, -0x6d, -0x78, -0x2b,
    -0x64, -0x71,  0x1a, -0x49,
     0x77,  0x3a, -0x6b, -0x75,
     0x5a,  0x7b,  0x75,  0x12,
    -0x42,  0x3f,  0x5f, -0x31,
     0x75,  0x1d,  0x77,  0x5f,
     0x51, -0x64,  0xd ,  0x4c,
    -0x79,  0x7c, -0x76, -0x2b,
     0x28, -0x54,  0x72, -0x21,
     0x5f,  0x20, -0x71, -0x1c,
    -0x3a,  0x28, -0x3c, -0x32,
     0x2f,  0x4f, -0x26, -0x47,
    -0x31,  0x2b,  0x7d, -0x20,
    -0x5a,  0x1f,  0x73, -0x59,
    -0x3e,  0x41,  0x7c };




char test_key_dsa_576_p[] = {
    -0x5b, -0x43, -0x65,  0x5 ,
     0x28, -0x12, -0x59, -0x1f,
    -0xd ,  0x65, -0x6b,  0x4 ,
    -0x35, -0x2c,  0x7 , -0x5b,
     0x4a,  0x6 , -0x33,  0xd ,
     0x79, -0x7b, -0x59,  0x30,
    -0x12,  0x11,  0x8 ,  0x38,
    -0x70, -0x53, -0x27, -0xc ,
     0x9 ,  0x64, -0x3e,  0x8 ,
    -0x76,  0x10,  0x3 , -0x39,
     0x4 ,  0x1e, -0x43,  0x3e,
     0x22, -0x3e,  0x0 , -0xb ,
    -0x3 ,  0x57, -0x1d,  0x6a,
    -0x71, -0x7 ,  0x6c, -0x7 ,
     0x27,  0x5a, -0x43,  0x38,
    -0x46, -0x4f, -0x26, -0x1d,
    -0xa ,  0x59, -0x68, -0x3e,
    -0xb ,  0x70,  0x4e,  0x25 };
char test_key_dsa_576_q[] = {
     0x9 ,  0x75,  0x21,  0x6b,
    -0x66, -0x37,  0x14, -0x1d,
    -0xf , -0xa ,  0x78, -0x38,
     0x9 , -0x4f, -0x20,  0xa ,
     0x55, -0x6e, -0x1 , -0x3  };
char test_key_dsa_576_g[] = {
    -0x5f, -0x80, -0x33, -0x5c,
     0x59,  0x40, -0x22,  0x5d,
    -0x7d, -0x5 ,  0x41,  0x31,
    -0x42, -0x5a,  0x7a, -0xa ,
    -0x68,  0x4b, -0x5a, -0x49,
     0x5f,  0x1b,  0x1c, -0x68,
     0x6b, -0x5 , -0x4a,  0x58,
     0x38, -0x11, -0x3 ,  0x4 ,
     0x4c,  0x6 , -0x27,  0x38,
     0x65,  0x6 ,  0x16, -0x21,
     0x67, -0x2c, -0xc ,  0x36,
    -0x13,  0x63,  0x71,  0x78,
     0x62,  0x29,  0x61,  0x4d,
    -0x4e,  0x19, -0x28, -0x69,
     0x26, -0x6 ,  0x23, -0x3a,
     0x5 , -0x57,  0x1d,  0x12,
    -0x62, -0x47,  0x6c,  0x67,
    -0xb ,  0x32,  0x68,  0x33 };
 
char test_key_dsa_576_x[] = {
     0x60, -0x79, -0x29,  0x53,
     0x16,  0x7b, -0x5f, -0x5d,
     0x30,  0x5a,  0x26, -0x64,
     0x27, -0x6e,  0x7c,  0x15,
    -0x3 , -0x80,  0x2 , -0x4c };
char test_key_dsa_576_y[] = {
    -0x7f,  0x59, -0x49, -0x61,
     0x7 ,  0x4a,  0x25, -0x74,
     0x77, -0x54,  0x53,  0x11,
     0x59, -0x64, -0x6d,  0x56,
     0x49, -0x20,  0x1f, -0x67,
    -0x5f,  0x18, -0x3b,  0x9 ,
     0x66, -0x76,  0x3a,  0x6f,
    -0x21, -0x2d,  0x42,  0x42,
    -0x3c,  0x6f, -0x70, -0x6d,
     0x3a, -0x72,  0x1e,  0x66,
     0x20, -0x49, -0x6e,  0xa ,
     0x27,  0xd , -0x2 , -0x8 ,
    -0x53, -0x4b, -0x59, -0x55,
     0x74,  0x7e, -0x7f, -0x73,
     0x6f, -0x71,  0x43, -0x41,
    -0x40, -0x34,  0x25, -0x2c,
     0x24, -0x4d,  0x6e,  0x41,
     0xb ,  0x66, -0x25,  0x1c };





char test_key_dsa_640_p[] = {
    -0x47, -0x45, -0x3c, -0x75,
     0x56,  0x7b,  0x42, -0x3f,
     0x73, -0x5c, -0x53,  0x25,
    -0x6d,  0x7f, -0x15, -0x3 ,
    -0x4e, -0x60, -0x1b, -0x35,
    -0x7e,  0x3f, -0x58, -0x27,
     0x7d,  0x0 , -0x7d, -0xb ,
    -0x6a, -0x1c,  0x6e,  0x4 ,
     0x14, -0x12,  0x21, -0x39,
    -0x68,  0x36, -0x10,  0x32,
     0x3b, -0x4f,  0x1e,  0x36,
     0x37, -0x64, -0x7d, -0x7c,
     0x43,  0x41,  0x25, -0x51,
     0x4d, -0x51,  0x9 ,  0x60,
    -0x58, -0x7d,  0x33,  0x64,
    -0x68, -0x5d,  0x62, -0x7f,
     0x77,  0x7e, -0x19, -0x2c,
     0x57, -0x2 ,  0x2f, -0x75,
    -0x44,  0x41,  0x5c, -0x1b,
     0x1c, -0x1e,  0x27,  0x4d };
char test_key_dsa_640_q[] = {
    -0x6d,  0x31, -0x75, -0x18,
     0x27,  0x69,  0x4e,  0x70,
    -0xc , -0x6b, -0x11, -0x16,
     0x17, -0x32, -0x6f, -0x37,
     0x7a, -0x4c, -0x1f, -0x6d };
char test_key_dsa_640_g[] = {
    -0x4a,  0x24,  0x21,  0x7b,
     0x4c, -0x47, -0x34,  0x16,
     0x5a,  0x53,  0x30, -0x75,
    -0x60,  0x16,  0x7e,  0x13,
     0x7 ,  0x7e, -0x62, -0x44,
     0x11,  0x63,  0x63, -0x6b,
     0x19, -0x8 , -0x3d, -0x80,
     0x27,  0x5 ,  0x7a,  0x56,
     0x6c, -0x33, -0x2f,  0x22,
    -0x43, -0x4d,  0x4 , -0x2f,
     0x6a,  0x34, -0x51, -0x70,
     0x61,  0xb ,  0x33, -0x3a,
    -0x40,  0x28,  0x3e, -0x2b,
    -0x22,  0x63,  0x7f,  0x4c,
    -0x1 ,  0x7 , -0x27,  0x5c,
     0x76,  0x6f, -0x39,  0x2b,
    -0x1a,  0x1a,  0x6c, -0x70,
     0x3a, -0x30,  0x34,  0x71,
    -0x35, -0x55, -0x73,  0x55,
     0x73, -0x3d, -0x1e,  0x21 };
 
char test_key_dsa_640_x[] = {
     0x1b, -0x57, -0x70,  0xb ,
     0x63, -0x5d, -0x1a,  0x1b,
    -0x40, -0x7b,  0x53,  0x50,
    -0x6a, -0x7a, -0x68,  0x3f,
    -0x33,  0xb , -0x47, -0x2d };
char test_key_dsa_640_y[] = {
     0x4e, -0x2d, -0x2a,  0x3a,
    -0x6b, -0x3c,  0x13,  0x69,
    -0x65, -0x10, -0x18, -0x78,
    -0x58,  0x24, -0x47, -0x40,
    -0x67, -0x1b,  0x40,  0x6 ,
     0x74, -0x17,  0x7d, -0x6b,
     0x6f,  0x35,  0x3c,  0x28,
    -0x53,  0x13, -0x32, -0x30,
    -0x23,  0x4 ,  0x31, -0x38,
     0x30,  0x12,  0x5 , -0x80,
     0x27,  0x79,  0x24,  0x15,
    -0x2 , -0x3c,  0x6c, -0x9 ,
    -0x32,  0x37,  0x3c, -0x18,
     0xc ,  0x24, -0x13,  0x61,
     0x5a,  0x59,  0x73,  0x2d,
     0xa ,  0x20,  0x5b, -0x7b,
    -0x67, -0xe ,  0x14,  0x53,
     0x7 ,  0x55,  0x7d, -0x5a,
     0x79, -0x18,  0x3f, -0x68,
    -0x7b, -0x32, -0x3f,  0x35 };



char test_key_dsa_704_p[] = {
    -0x4a,  0x36,  0x52,  0x6a,
     0x3b,  0xb , -0x77, -0xe ,
     0xb , -0x57,  0x25, -0x1c,
    -0x1b, -0x56, -0x56,  0x45,
    -0x3c, -0x49, -0x75,  0x21,
    -0x6b,  0x2b,  0x6c,  0x16,
     0xb ,  0x19, -0x69, -0x37,
    -0x6c,  0x61, -0x39,  0x63,
     0x50, -0x35,  0x47, -0x31,
     0x11, -0x51,  0x11,  0x3c,
    -0x13, -0x21,  0x77, -0x1e,
    -0x7d,  0x7b,  0x45,  0x2d,
    -0x6 ,  0x1b,  0x34, -0x24,
    -0x77, -0x40, -0x68, -0x9 ,
    -0x8 ,  0x30, -0x4a, -0x7c,
    -0x5f, -0x58,  0x3b,  0x57,
     0x78,  0x2d,  0x16,  0x31,
     0x5b,  0x4f, -0x4f,  0x4 ,
     0xa , -0x5a, -0x26,  0x48,
     0xa ,  0x68, -0x4 , -0x25,
     0x41,  0x1 ,  0x2c, -0x7b,
     0x1e, -0x25, -0x15, -0x59 };
char test_key_dsa_704_q[] = {
    -0x7d, -0x2b,  0x57, -0x1f,
    -0x1f, -0x2 , -0x68,  0x73,
    -0x41, -0x62, -0x26,  0x48,
    -0x66, -0x4e, -0x5 ,  0x50,
     0x46,  0x3a,  0x5f, -0x41 };
char test_key_dsa_704_g[] = {
    -0x61, -0x1a,  0x38,  0x73,
    -0x28, -0x80, -0x70,  0x51,
    -0x25, -0x1b, -0x54,  0x19,
    -0x61, -0x5c,  0x45, -0x6 ,
     0x57,  0x7b, -0x16,  0x17,
     0x3b,  0x48,  0x46,  0x68,
     0x78,  0x23, -0x43,  0x52,
     0x6e, -0x4d, -0x7d,  0xe ,
     0x7 ,  0x1e,  0x43,  0x73,
    -0x11,  0x26,  0x9 ,  0x2 ,
     0x74,  0x28, -0x7d, -0x24,
     0x25,  0x4b, -0x64,  0x8 ,
     0x28, -0x76, -0x4e, -0x3f,
     0x7e, -0x4a,  0x51,  0x19,
     0x28, -0x7e, -0x58, -0x11,
     0x3 ,  0xc ,  0x42,  0x7 ,
     0x41,  0x11,  0x5e, -0x43,
     0x65,  0x3e,  0x52,  0x34,
    -0x2d,  0x19, -0x5d, -0x47,
    -0x1f, -0x5c,  0x6e,  0x74,
     0x1e,  0x6c,  0x2c,  0x39,
     0x55, -0x3f, -0x40,  0x29 };
 
char test_key_dsa_704_x[] = {
     0x1e, -0x32,  0x58,  0x20,
    -0x6e,  0x8 , -0x58,  0x63,
    -0x7e,  0x2e,  0x3 ,  0x1a,
     0x1 , -0x34,  0x4c,  0x74,
    -0x6c,  0x11, -0x2f, -0x70 };
char test_key_dsa_704_y[] = {
    -0x5b,  0x14, -0x61, -0x20,
     0x15,  0x2a, -0x4b, -0x18,
    -0x43,  0x44, -0x19,  0x19,
    -0x62,  0x58,  0x31, -0x44,
     0x4d,  0xf , -0x1e, -0x2c,
     0x54, -0x12,  0x1e,  0x10,
     0x65,  0xd , -0x4c, -0xe ,
    -0x62,  0x1a, -0x66,  0x4f,
    -0x5d, -0x37, -0x12, -0x1e,
     0x79, -0x39, -0x33, -0x5f,
     0x71,  0x75, -0x3e,  0x6b,
    -0x3b,  0xb , -0x3b, -0x67,
    -0x59, -0x2d, -0x5c,  0x27,
    -0x4b,  0x1f,  0x3c, -0x5f,
    -0x60, -0x6e,  0x5f,  0x1d,
     0x23,  0x6e, -0x5c, -0x49,
    -0x7a,  0x3e,  0x4b, -0x30,
     0x4 ,  0xb ,  0x31,  0x23,
    -0x30, -0x59, -0x5f, -0x56,
     0x7e,  0x7 ,  0x6e,  0x5e,
    -0x6c,  0x14,  0x1f, -0x1a,
     0x7 ,  0x26, -0x8 ,  0x55 };


char test_key_dsa_768_p[] = {
    -0x3f, -0x54,  0x28, -0x7e,
     0x39,  0x10, -0x4e,  0x63,
     0x4 , -0x1f,  0x3a, -0x2c,
     0x3f,  0x6a,  0x7d,  0xe ,
    -0x58,  0x78, -0x2e,  0x4b,
    -0x9 ,  0x32, -0x1a, -0x51,
     0x4b, -0x4b, -0x23,  0x3d,
    -0x11, -0x7 , -0xe , -0x22,
    -0x44, -0x23,  0x43, -0x31,
     0x1d, -0x6f, -0x35,  0x1c,
    -0x15, -0x37, -0x24, -0xd ,
    -0x73,  0x19,  0x56,  0x1e,
     0x27, -0x50,  0x1a, -0x6f,
     0x18,  0x3 ,  0x6f, -0x57,
    -0x74, -0x45,  0x63, -0x11,
    -0x37,  0x30,  0x6a, -0x21,
     0x79, -0x62, -0x5 , -0x28,
     0x21, -0x27, -0x37, -0x76,
     0x2d,  0x22, -0x4e,  0x7d,
     0x5a,  0x5d, -0x6d, -0x44,
     0x13, -0x5 ,  0x4e,  0x12,
    -0x3 ,  0x3b,  0x15,  0xd ,
     0x77, -0x29, -0x61, -0x73,
     0x66, -0x5f, -0x4d, -0x39 };
char test_key_dsa_768_q[] = {
     0x65,  0x9 ,  0x12, -0x19,
    -0xf , -0x69,  0x76,  0x70,
     0x12, -0x40,  0x7e, -0x72,
     0x67, -0x42,  0x33,  0x1 ,
    -0x50,  0x2e,  0x71, -0x6f };
char test_key_dsa_768_g[] = {
    -0x3f,  0x6b,  0x5b,  0x23,
    -0x41, -0x36, -0x65,  0x54,
    -0x11,  0x1 ,  0x20,  0x58,
    -0x2f,  0x42,  0x2e,  0x29,
     0x6a,  0xb , -0x43, -0x68,
    -0x66, -0xa ,  0x15, -0x32,
    -0x4c, -0x73,  0x68,  0x7f,
     0x49,  0x48,  0x64, -0x5e,
    -0x5f,  0x32,  0x6d, -0x20,
    -0x2f,  0x7b,  0x2 , -0x13,
    -0x3d,  0x40, -0x4a,  0x6e,
    -0xc , -0x63, -0x54, -0x49,
    -0x31, -0x73,  0x5d,  0x45,
    -0x3e, -0x1c, -0x16,  0x74,
    -0x13,  0x7a,  0x70, -0x4b,
    -0x3f,  0x54, -0x6 ,  0x2c,
    -0x52, -0x52,  0x1c,  0x57,
    -0x52,  0x21, -0x1d, -0x68,
     0x53,  0x4b,  0x18,  0x72,
    -0x46,  0x44, -0x64, -0x73,
    -0x1a,  0x77, -0x14, -0x58,
     0x0 ,  0x74, -0x66,  0x16,
    -0x8 , -0x45,  0xe ,  0x12,
     0x3e, -0x5b, -0x72,  0x1  };
 
char test_key_dsa_768_x[] = {
     0x28,  0x45,  0x9 ,  0x65,
    -0x1e, -0x5a, -0x3d, -0x19,
    -0xc ,  0x69,  0x47,  0x60,
    -0x71,  0x42, -0x40, -0x47,
     0x30,  0x7b, -0x59,  0x58 };
char test_key_dsa_768_y[] = {
    -0x42, -0x47, -0x4c,  0x13,
    -0x52, -0x58,  0x66, -0x3f,
    -0x7b,  0x12,  0x12,  0x5b,
     0x44,  0x36,  0x1b, -0x33,
    -0x14,  0x20, -0x36,  0x1a,
     0x3d, -0x62,  0x45, -0x1a,
     0x56,  0x31,  0x58, -0x5 ,
     0x0 ,  0x3b, -0x23,  0xb ,
    -0xe ,  0x59,  0x20,  0x1a,
    -0x5f,  0x21,  0x15,  0x20,
    -0x66, -0x35,  0x54, -0xd ,
     0x0 ,  0x6e, -0x79, -0x1 ,
    -0x76,  0x52,  0x55, -0x1f,
     0x9 , -0x1f,  0x78, -0x41,
     0x5a,  0x44,  0x22, -0x55,
     0x18,  0x72, -0x7d,  0x14,
    -0x36,  0x56, -0x72,  0x62,
     0x2 , -0x50,  0x2c,  0x18,
     0x4b,  0x7d, -0x40, -0xc ,
    -0x2c, -0x55, -0x74, -0x68,
    -0x74, -0x61, -0x6d,  0x22,
    -0x34, -0x1c, -0x75,  0x25,
    -0x19, -0x25,  0x52,  0x23,
     0x6e, -0x33,  0x15,  0x7b };




char test_key_dsa_832_p[] = {
    -0x80, -0x70, -0x55, -0x43,
    -0x38, -0x5e, -0x15, -0x18,
    -0x7b, -0x7d,  0x24, -0x13,
    -0x71, -0x78, -0x6a, -0x27,
    -0xc ,  0x6b, -0x5 , -0x50,
     0x35, -0x12,  0x16,  0x7 ,
    -0x7e,  0x45,  0x33,  0x54,
    -0x1c, -0xe , -0x39, -0x30,
    -0x9 ,  0xb ,  0xb , -0x42,
     0x32, -0xa ,  0x14, -0x76,
    -0x80,  0x44, -0x7d, -0x4a,
    -0x37, -0x60, -0xe ,  0x10,
     0x27, -0x2d,  0x66,  0x2e,
    -0x1d,  0x75,  0xc , -0x23,
     0x65,  0x3e, -0x45,  0x7f,
     0x33, -0x24,  0x4 , -0x40,
    -0x13, -0x6f,  0x60, -0x6c,
     0x48, -0x30, -0xd ,  0x5a,
     0x63, -0x70,  0x5f, -0x7f,
    -0x1d, -0x74, -0x5c, -0x22,
     0x12,  0x42, -0x13, -0x66,
    -0x6f, -0x7c,  0x5a, -0x55,
    -0x6a, -0x50,  0x5c, -0x13,
    -0x2c,  0x29, -0x32,  0x38,
     0x40, -0x69, -0x6 ,  0x7e,
    -0x1f, -0x1a,  0x62, -0x25 };
char test_key_dsa_832_q[] = {
     0x5f, -0x4b,  0x1f,  0x46,
    -0x25, -0x24, -0x7f, -0x6b,
    -0x2f, -0x40, -0x1a,  0x63,
    -0x4a,  0x9 ,  0x3e,  0x2 ,
     0x78,  0x1e,  0x58, -0x75 };
char test_key_dsa_832_g[] = {
     0xd ,  0x8 ,  0x23,  0x69,
    -0x44,  0x6 ,  0x7e, -0x6c,
     0x4d, -0xb , -0xb ,  0x55,
    -0x50, -0x9 ,  0x4c,  0x43,
     0x46, -0x5e, -0x32,  0x12,
     0x4f,  0x5b, -0x51, -0x4f,
     0x7e, -0x1e, -0x2d,  0x62,
    -0x3b, -0x5a, -0x72, -0x67,
    -0x23,  0x39,  0x1b,  0x0 ,
    -0x34,  0x74,  0x47,  0x7b,
     0x39, -0x9 ,  0x5f,  0x75,
    -0x42, -0x64,  0x29,  0x57,
    -0x2c, -0x71,  0x1a, -0x19,
     0x22, -0x75,  0x40, -0x6 ,
    -0x7d, -0x4e, -0x49, -0x53,
    -0x18, -0x41,  0x2e, -0x1a,
     0x6 ,  0x8 ,  0x55,  0x43,
     0x2e, -0x24,  0x2e, -0x75,
     0x6e,  0x59, -0x6e, -0x6c,
    -0x23,  0x6a, -0x28, -0x80,
     0x1 ,  0x7 ,  0x52, -0x30,
     0x7e, -0x62, -0x50,  0x62,
    -0x4d,  0x4e, -0x66, -0x5d,
    -0x64,  0x43, -0x46, -0x38,
    -0x3d,  0xf ,  0x15, -0x1 ,
    -0xc , -0x38, -0xb ,  0x3  };
 
char test_key_dsa_832_x[] = {
    -0x55, -0x3e, -0x26,  0x76,
     0x55, -0x22, -0xe ,  0x76,
     0x7a,  0x1a,  0x6c, -0x4a,
     0x7 , -0x7b, -0x7f, -0x5e,
     0x66, -0x77,  0x43,  0x39 };
char test_key_dsa_832_y[] = {
     0x4c, -0x25,  0x4b, -0x7a,
     0x3f, -0x6c, -0x5e, -0x7f,
     0x2 ,  0x24,  0x2b,  0x67,
     0x5d, -0x3d,  0x74,  0x47,
    -0x65,  0x72,  0xa ,  0x56,
    -0x7c, -0x33,  0x65, -0x1a,
    -0x3c, -0x34,  0x33, -0x1b,
    -0x18,  0x5f,  0x19,  0x4a,
     0xf ,  0x4f,  0x2b, -0x44,
     0x5c, -0x65, -0x75, -0x68,
     0x40, -0x5f, -0x30,  0x65,
     0xf , -0x48,  0x13, -0x36,
    -0x13,  0x74, -0x34, -0x7d,
    -0x2f, -0x5f, -0x4e, -0x40,
     0x2a,  0x37,  0x21,  0x30,
    -0x19,  0x5e,  0x5c, -0x5a,
     0x78,  0x3e,  0x57,  0x30,
    -0x1a,  0x5e, -0x27, -0x78,
    -0x43, -0x51, -0x37,  0x47,
    -0x56,  0x67, -0x49, -0x70,
    -0x75, -0x4f, -0x76,  0x11,
    -0x9 , -0x2e,  0x74, -0x3c,
    -0x57, -0x20, -0x63,  0x3e,
     0x5 , -0x3a, -0x52, -0x6f,
    -0x1a, -0x7f,  0x19, -0x46,
     0x53, -0x1f,  0x5f, -0x59 };


char test_key_dsa_896_p[] = {
    -0x4a, -0x3f, -0x22, -0x30,
    -0x19,  0x7 , -0x47,  0x26,
     0x59, -0x4c, -0xa , -0x4f,
    -0x3e, -0x34, -0x5a, -0x1d,
     0x1 ,  0x40,  0x68, -0x7 ,
    -0x11,  0x1d, -0x68,  0x6c,
     0x14, -0x6e, -0x14, -0x38,
     0x76, -0x32,  0x47, -0x79,
    -0x51, -0x1f, -0x2b, -0x42,
     0x68, -0x21,  0x21, -0x38,
     0x4b, -0x5a, -0x2e,  0x5f,
    -0x63, -0x26,  0x43,  0x41,
     0x65, -0x8 , -0x21,  0x48,
     0x31,  0x67, -0x40, -0x69,
     0x3b,  0x4 ,  0x37, -0x27,
     0x21,  0x49,  0x59, -0x5d,
     0x71,  0x4c, -0x62,  0x58,
     0x7a, -0x68, -0x71,  0x55,
    -0x4a, -0x5 ,  0x32, -0x5f,
     0x66, -0x62, -0x3 , -0xd ,
     0x6d, -0x5d, -0x3c, -0x6b,
    -0x46,  0x55, -0x28, -0x50,
     0x56, -0x32, -0x68,  0x7d,
     0x74, -0x7f, -0x50, -0x9 ,
    -0x3c, -0x77, -0x3b,  0x7b,
     0x4a, -0x44, -0x3a,  0x76,
    -0x17,  0x3 ,  0x53, -0x6e,
     0x58, -0x9 , -0x7a, -0x43 };
char test_key_dsa_896_q[] = {
     0xd , -0x55, -0x4e, -0x4f,
     0x1e, -0x2e,  0x7b,  0x39,
    -0x53, -0x3a,  0x51, -0x52,
     0xb ,  0x77,  0x78,  0x4 ,
    -0x2a, -0x41,  0xf , -0x4d };
char test_key_dsa_896_g[] = {
    -0x52, -0x15,  0x4d,  0x1a,
     0x2a, -0x3a,  0x63, -0x2a,
     0x1 , -0xf , -0x64,  0x6f,
     0x3c,  0x2e, -0x13,  0x68,
    -0x7a, -0x2e, -0x3e,  0x64,
    -0x28,  0x52, -0x66,  0x2e,
     0x12,  0xd , -0x28,  0x66,
     0x31, -0x7c, -0x2d, -0x20,
    -0x80, -0x69,  0x37, -0x4b,
    -0x42, -0x5b,  0x6d, -0x45,
    -0x24,  0x39,  0x39,  0xb ,
     0x55,  0x79,  0x79,  0x58,
     0x22,  0x71, -0x5 ,  0x4c,
     0x48,  0x2f,  0x5f,  0x5c,
    -0x6 ,  0x1a,  0x6 ,  0x15,
    -0x39, -0x6c, -0x66, -0x2b,
     0x55,  0x18, -0x1a, -0x39,
    -0x5b,  0x48,  0x4f, -0x56,
     0xa ,  0x65,  0x3e,  0x7e,
     0x30, -0x5c,  0x2a,  0x13,
     0x18, -0x33, -0x4b,  0xe ,
     0x2b, -0x6c, -0x35,  0x36,
    -0x52,  0x4c, -0x79,  0x6c,
    -0xe , -0x5 ,  0x48, -0xc ,
    -0x1d, -0x5e, -0x7d, -0x59,
    -0x71,  0x10, -0x60,  0x70,
    -0x56, -0x62, -0x75,  0x55,
    -0x7d, -0x19,  0x35,  0x71 };
 
char test_key_dsa_896_x[] = {
    -0x58, -0xc , -0x66, -0x23,
     0x63, -0x2a,  0x2b,  0x3a,
    -0x18,  0x61, -0x73,  0x56,
    -0x7a, -0x5c, -0x60,  0xe ,
     0x7e,  0x35, -0x16,  0x1b };
char test_key_dsa_896_y[] = {
    -0x5d,  0x2d, -0x63, -0x3f,
     0x11, -0x61,  0x55, -0x73,
    -0x6c,  0xd , -0x19, -0x33,
     0x2 , -0x6b, -0x5f, -0x46,
    -0x50, -0x33,  0x33,  0x45,
     0x30,  0x75,  0xa ,  0x19,
    -0x27,  0x7a,  0x5a,  0x76,
    -0x36, -0x27,  0x74,  0x63,
     0x77, -0x1c,  0x45,  0x3e,
    -0x26,  0x2e,  0x40, -0x2e,
    -0x59, -0x50,  0x33, -0x70,
     0x48,  0x42, -0x46,  0x3c,
     0x36, -0x3e,  0x59,  0x12,
     0x68,  0x3 ,  0x39,  0x42,
    -0x4a, -0x27,  0x8 ,  0x73,
    -0x7b,  0x12,  0x22, -0xe ,
    -0x65, -0x21, -0x37,  0x63,
     0x78,  0x7c, -0x22, -0x4f,
     0x32,  0x2c,  0x22, -0x16,
    -0x7e, -0x2c, -0x6c, -0x30,
     0x42, -0x3b, -0x2b,  0x3d,
     0x13, -0x1c, -0x4f,  0x1c,
    -0x55, -0x72, -0x37, -0x29,
     0x39,  0x41,  0x77, -0x46,
     0x39,  0x8 , -0x5c,  0x36,
    -0x2c, -0x30,  0x5d,  0x28,
     0x4f, -0x76, -0x7a, -0x67,
    -0x77,  0x5e, -0x70,  0x31 };



char test_key_dsa_960_p[] = {
    -0x25,  0x2d,  0x78, -0x44,
     0x7 ,  0x5f,  0x51, -0x57,
    -0x43, -0x5d, -0x2d,  0x5 ,
     0x1f, -0x51,  0x7 , -0x50,
    -0x33, -0x3 ,  0x39,  0x4e,
     0x5a, -0x40, -0x2b,  0x5d,
     0x20,  0x15, -0x25,  0x7e,
     0x44,  0x1b,  0x4c,  0x43,
     0x7a, -0x15, -0x3b,  0x2d,
     0x66,  0x1f,  0x7a, -0x4d,
    -0x1f, -0x5 , -0x18, -0x43,
     0x17, -0x27, -0x4f, -0x34,
    -0x14, -0x3a, -0x1c,  0x9 ,
    -0x33, -0x5 ,  0x1e,  0x9 ,
    -0x1a,  0xc ,  0x68, -0x13,
    -0x7a, -0x3c, -0x24, -0x26,
     0xc ,  0x73, -0x80,  0xe ,
     0x75,  0x7a,  0x7b, -0x25,
     0x70,  0x40,  0x1 , -0x5e,
    -0x64, -0x2d, -0x33,  0x1c,
     0x69, -0x45,  0x6b, -0x64,
    -0x68, -0x1c,  0xd ,  0xe ,
    -0x5b, -0x3c,  0x60,  0x15,
    -0x1 , -0x2b,  0x65, -0x75,
    -0x28,  0x7e, -0x16, -0x61,
    -0x2a, -0x6f,  0x6d,  0x56,
     0x51, -0x47,  0x2c,  0x60,
    -0x57, -0x55,  0x73, -0x68,
     0x1c, -0x27, -0x55, -0x2a,
     0x28,  0xd ,  0x55, -0x35 };
char test_key_dsa_960_q[] = {
     0x27, -0x16,  0xe , -0x40,
     0x17, -0x55, -0x4b,  0x36,
    -0x6e,  0x4 , -0x80, -0x31,
    -0x57, -0x20, -0x50,  0x28,
    -0x6d,  0x47,  0x6d, -0x7b };
char test_key_dsa_960_g[] = {
    -0x56,  0xa ,  0x1a, -0x44,
    -0x8 , -0x35, -0x6c,  0x27,
     0x26,  0x7e,  0x27, -0x6e,
     0x16,  0xb , -0x17, -0x34,
    -0x55,  0x64,  0x14, -0xc ,
     0x2 ,  0x68,  0x2d,  0x7 ,
     0x22,  0x70,  0x1d,  0x67,
     0x3f, -0x4a, -0x65,  0x60,
    -0x7f,  0x42, -0x5c,  0x7b,
     0x3 ,  0x6f,  0x1e,  0xe ,
     0x64, -0x62,  0x7d, -0x31,
    -0x67,  0x4 , -0x4b, -0x2e,
    -0x1e, -0x44,  0x34,  0x67,
    -0x9 , -0x3b,  0x43, -0x1e,
    -0x66, -0x64,  0x3a,  0x2a,
    -0x2b,  0x35, -0x6e,  0x66,
    -0x71, -0x16,  0x39,  0x66,
    -0x7b, -0x40,  0x7a,  0x71,
     0x58, -0x68, -0x2c, -0x6f,
     0x7a, -0x8 ,  0x5d,  0x5e,
     0x4c,  0x79,  0x5a,  0x7a,
    -0x4b,  0x6d, -0x52,  0x1 ,
     0xb ,  0x6c,  0x6b,  0x63,
    -0x4 ,  0x1d,  0x64,  0xa ,
    -0x68,  0x76,  0x31,  0x2a,
     0x36,  0x26, -0x4 ,  0x1c,
    -0x57,  0x11, -0x68, -0x8 ,
    -0x2d, -0x80,  0x32, -0x36,
     0x7e, -0x42, -0x51, -0x41,
    -0x6 , -0x6c,  0x1 , -0x47 };
 
char test_key_dsa_960_x[] = {
    -0x40, -0x1b, -0x56,  0xd ,
    -0x3 , -0x32, -0x4 , -0x61,
     0x12,  0x24,  0x74, -0x70,
    -0x70,  0x3f, -0x43, -0x4b,
     0x7a, -0x71, -0x50, -0x21 };
char test_key_dsa_960_y[] = {
    -0x33, -0x1d,  0x5 ,  0x36,
    -0x1d, -0x34, -0x12,  0x29,
    -0x60, -0xa , -0x65, -0x1a,
     0x4 ,  0x43, -0x7c, -0x7c,
    -0x65, -0x13,  0x2a, -0x77,
     0xa ,  0x65,  0x3 , -0x4d,
     0x41, -0x6f, -0x80, -0x14,
    -0x71, -0x7a,  0x42,  0x47,
    -0x70,  0x12, -0x16, -0x5e,
     0x28,  0x7f, -0x77, -0x1f,
    -0x44, -0x26, -0x21, -0x5f,
    -0x23, -0x4d, -0x11,  0x6b,
     0x4c, -0x23, -0x53,  0x64,
    -0x4d,  0x15,  0x5f, -0x43,
    -0x1a,  0x3a, -0xf ,  0x6d,
     0x5 ,  0x24,  0x4f, -0x4e,
     0x36,  0x23, -0x60, -0x45,
    -0x6f,  0x16, -0x77,  0xd ,
    -0x35, -0x7b,  0x78, -0x7 ,
    -0x43,  0x2 , -0x1e, -0x20,
     0x78, -0x35, -0x41, -0x37,
     0x5e,  0x7b, -0x20, -0x3c,
    -0x3b,  0x40,  0x65,  0x60,
     0xb ,  0x40,  0xb , -0x24,
    -0x71,  0x46, -0x2c, -0x3f,
    -0x7d,  0x6f, -0x52, -0x71,
    -0x60, -0x6b, -0x7f,  0x45,
    -0x59, -0x6d,  0x3d, -0x4 ,
    -0x6f, -0x2 , -0x11, -0x2d,
    -0x58, -0x58,  0x30, -0x11 };



char test_key_dsa_1024_p[] = {
    -0x3 , -0x5 ,  0x76, -0x6f,
    -0x43, -0x44,  0x2a,  0xc ,
     0x77,  0x4b, -0xc , -0x3a,
     0x25,  0x4c, -0x69, -0x47,
    -0x12, -0x31,  0x72,  0x9 ,
     0x2b,  0x77,  0x35, -0x1c,
    -0x74,  0x54, -0x4e, -0x43,
    -0x6e,  0xa ,  0x7 ,  0x16,
    -0x77,  0x29, -0x43,  0x48,
    -0x41,  0x64,  0x3e,  0x39,
    -0x3a, -0x7e, -0x6b, -0x19,
     0x8 , -0x3e,  0x74,  0xf ,
    -0x13,  0x9 ,  0x49,  0x1c,
    -0x3d, -0xd ,  0x15,  0x7f,
    -0x56,  0x5e, -0x74,  0x40,
     0x48,  0x4f,  0x69,  0x64,
    -0x7a,  0x25, -0x2 ,  0x4d,
     0x68, -0x4f, -0x71,  0x3 ,
     0x2c,  0xb , -0x2b, -0x4a,
    -0x45,  0x19,  0x72,  0x18,
     0xd ,  0x1a,  0x74, -0x1b,
    -0x77,  0xc ,  0x77, -0x6a,
     0x2c,  0x7d, -0x14, -0x59,
     0x69, -0x3f, -0x33, -0x67,
    -0x5d, -0x61, -0x7f, -0x64,
     0x21,  0x4a, -0x5d, -0x48,
     0x38, -0x79, -0x6f,  0x32,
    -0x11, -0x56, -0x13, -0x28,
     0x28, -0x14, -0x68,  0x16,
     0x5c, -0x44, -0x2 ,  0x15,
     0x15,  0x6 ,  0x19, -0x41,
    -0x1b, 0x1b,-0x5f, 0x29 };
char test_key_dsa_1024_q[] = {
     0x11, -0x3c, -0x61,  0x6a,
     0x8 ,  0x6e,  0x7 ,  0xe ,
     0x47, -0x3b, -0x54,  0x12,
     0x5a, -0x56,  0x8 , -0x63,
     0x70, 0x5 ,-0x13,-0x9  };
char test_key_dsa_1024_g[] = {
     0x53,  0x62,  0x2 , -0x35,
    -0x49,  0x24,  0x17, -0x59,
    -0x10, -0x6b,  0x14, -0x4 ,
     0x67,  0x59,  0x13, -0x12,
     0x62,  0x46, -0x52, -0x3 ,
     0x46, -0x1 , -0x3a, -0x38,
    -0x75, -0x34, -0x3 , -0x70,
     0x6f, -0x70,  0x0 ,  0x78,
     0x3e,  0x23, -0x5 ,  0x11,
     0x61, -0x3e, -0x2 ,  0x38,
     0x13, -0x35, -0x4e,  0x65,
     0x3a,  0x17, -0x4d,  0xd ,
    -0x7 , -0x36, -0x10, -0x6d,
    -0x40, -0x78, -0x1e, -0x5 ,
    -0x3f,  0x75, -0x66, -0x55,
     0x10,  0x3f,  0x62,  0x38,
     0x70,  0x73, -0x60,  0x4 ,
    -0x63, -0x22,  0x5a,  0x2a,
     0x25,  0x71, -0x74,  0x7c,
    -0x16,  0x33, -0xd ,  0x4 ,
    -0x22, -0x1 ,  0x1a, -0x39,
     0x51, -0x2d,  0x38, -0x6d,
    -0x28, -0x66, -0x28,  0x3f,
    -0x76,  0x78,  0x15,  0x6b,
    -0x49,  0x35, -0x42,  0x9 ,
    -0x6f,  0x22,  0x63,  0x67,
    -0x65,  0x78,  0x64,  0x15,
    -0x67,  0x53,  0x5f,  0x73,
     0x50, -0x70, -0x3 , -0x2d,
    -0x17, -0x1a,  0x78,  0x5 ,
    -0x27,  0x2c, -0x1f, -0x28,
     0x4d,-0x41, 0xc ,-0x49 };
 
char test_key_dsa_1024_x[] = {  0x63, -0x3e,  0x39, -0x62,
    -0x6 , -0x45,  0x48, -0x59,
     0xd , -0x22, -0x15,  0x69,
    -0x2f, -0x2d,  0x52, -0x7d,
     0x2b,  0x5b,  0x66, -0x62 };
char test_key_dsa_1024_y[] = { -0x60, -0xd , -0xb , -0x6c,
    -0x1e,  0x5f,  0x7e,  0x0 ,
    -0xe , -0x63, -0x29,  0xe ,
    -0x7 ,  0x4b, -0x34, -0x1d,
    -0x1b, -0x43,  0x7a,  0x4 ,
     0x1b,  0x9 , -0xd , -0x2 ,
    -0x75,  0x1 ,  0x18, -0x1b,
     0x37,  0x3a, -0x5f,  0x2c,
    -0x20, -0x5e, -0x1f,  0x5a,
    -0x49, -0x28, -0x1c,  0x6f,
    -0x24, -0x7b, -0x62, -0x48,
     0x54,  0x7f, -0x25, -0x3d,
     0x5e, -0x80, -0x11, -0xb ,
    -0x4e,  0x49,  0x3e, -0xc ,
     0x22, -0x2c,  0x1f, -0x3 ,
    -0x47,  0x44,  0x4d,  0x74,
    -0x7f,  0x10,  0x7 ,  0xa ,
     0x75,  0x1a,  0x43, -0x51,
     0xa , -0x3d, -0x18,  0x20,
    -0x51,  0xa ,  0x5e, -0x1e,
    -0x79, -0x21,  0x52, -0x48,
    -0x33, -0x5c,  0x18,  0x78,
    -0x59, -0x67, -0x34, -0x28,
    -0x4c, -0xd ,  0x73, -0x1d,
    -0x7b, -0x10, -0x6b, -0x78,
    -0x5f, -0x4a,  0x7f,  0x77,
     0x6 ,  0x7f, -0x52,  0x1 ,
    -0x6a, -0x37,  0x50, -0x1d,
     0x7a,  0x7e, -0x1 ,  0x7f,
    -0x6b, -0x5b, -0x2e,  0x6 ,
    -0x2d, -0x6c,  0x58,  0x74,
     0xf ,  0x6d, -0x55,  0x4a };
TEST_KEYS_DSA test_keys_dsa[9] = {
{
        512,
        {
                { 64, test_key_dsa_512_p},
                { 20, test_key_dsa_512_q},
                { 64, test_key_dsa_512_g},
                { 20, test_key_dsa_512_x}
        },
        {
                { 64, test_key_dsa_512_p},
                { 20, test_key_dsa_512_q},
                { 64, test_key_dsa_512_g},
                { 63, test_key_dsa_512_y}
        }
},
{
        576,
        {
                { 72, test_key_dsa_576_p},
                { 20, test_key_dsa_576_q},
                { 72, test_key_dsa_576_g},
                { 20, test_key_dsa_576_x}
        },
        {
                { 72, test_key_dsa_576_p},
                { 20, test_key_dsa_576_q},
                { 72, test_key_dsa_576_g},
                { 72, test_key_dsa_576_y}
        }
},
{
        640,
        {
                { 80, test_key_dsa_640_p},
                { 20, test_key_dsa_640_q},
                { 80, test_key_dsa_640_g},
                { 20, test_key_dsa_640_x}
        },
        {
                { 80, test_key_dsa_640_p},
                { 20, test_key_dsa_640_q},
                { 80, test_key_dsa_640_g},
                { 80, test_key_dsa_640_y}
        }
},
{
        704,
        {
                { 88, test_key_dsa_704_p},
                { 20, test_key_dsa_704_q},
                { 88, test_key_dsa_704_g},
                { 20, test_key_dsa_704_x}
        },
        {
                { 88, test_key_dsa_704_p},
                { 20, test_key_dsa_704_q},
                { 88, test_key_dsa_704_g},
                { 88, test_key_dsa_704_y}
        }
},
{
        768,
        {
                { 96, test_key_dsa_768_p},
                { 20, test_key_dsa_768_q},
                { 96, test_key_dsa_768_g},
                { 20, test_key_dsa_768_x}
        },
        {
                { 96, test_key_dsa_768_p},
                { 20, test_key_dsa_768_q},
                { 96, test_key_dsa_768_g},
                { 96, test_key_dsa_768_y}
        }
},
{
        832,
        {
                { 104, test_key_dsa_832_p},
                { 20, test_key_dsa_832_q},
                { 104, test_key_dsa_832_g},
                { 20, test_key_dsa_832_x}
        },
        {
                { 104, test_key_dsa_832_p},
                { 20, test_key_dsa_832_q},
                { 104, test_key_dsa_832_g},
                { 104, test_key_dsa_832_y}
        }
},

{
        896,
        {
                { 112, test_key_dsa_896_p},
                { 20, test_key_dsa_896_q},
                { 112, test_key_dsa_896_g},
                { 20, test_key_dsa_896_x}
        },
        {
                { 112, test_key_dsa_896_p},
                { 20, test_key_dsa_896_q},
                { 112, test_key_dsa_896_g},
                { 112, test_key_dsa_896_y}
        }
},
{
        960,
        {
                { 120, test_key_dsa_960_p},
                { 20, test_key_dsa_960_q},
                { 120, test_key_dsa_960_g},
                { 20, test_key_dsa_960_x}
        },
        {
                { 120, test_key_dsa_960_p},
                { 20, test_key_dsa_960_q},
                { 120, test_key_dsa_960_g},
                { 120, test_key_dsa_960_y}
        }
},
{
        1024,
        {
                { 128, test_key_dsa_1024_p},
                { 20, test_key_dsa_1024_q},
                { 128, test_key_dsa_1024_g},
                { 20, test_key_dsa_1024_x}
        },
        {
                { 128, test_key_dsa_1024_p},
                { 20, test_key_dsa_1024_q},
                { 128, test_key_dsa_1024_g},
                { 128, test_key_dsa_1024_y}
        }
}
};
