/* ./src/crypt/arithmetic/std/test.c */

static char *rcsid = "$Id: test.c,v 1.4 1994/11/08 14:36:51 surkau Exp $";

/* 
 *
 * $Id: test.c,v 1.4 1994/11/08 14:36:51 surkau Exp $
 *
 * $Log: test.c,v $
 *
 */
 
#include "arithmetic.h"

L_NUMBER	n1[MAXGENL], n2[MAXGENL], n3[MAXGENL], acc1[MAXGENL], acc2[MAXGENL], acc3[MAXGENL], acc4[MAXGENL], acc5[MAXGENL];



/* function intlog2() ==  int( log2() )
 */

/***************************************************************
 *
 * Procedure intlog2
 *
 ***************************************************************/
#ifdef __STDC__

int intlog2(
	unsigned int	  v
)

#else

int intlog2(
	v
)
unsigned int	  v;

#endif

{
	int     ret;
	for( ret = -1; v; v >>= 1, ret++) ;
	return ret;
}


/*
 * function lngtouse(modul) RETURNS BITLEN
 *
 * ::= mu(y: 2*2^y > modul)
 *
 */


/***************************************************************
 *
 * Procedure lngtouse
 *
 ***************************************************************/
#ifdef __STDC__

int lngtouse(
	L_NUMBER	  modul[]
)

#else

int lngtouse(
	modul
)
L_NUMBER	  modul[];

#endif

{
	register L_NUMBER	x;
	register int	i;
	
	if(!modul[0]) return(-1);
	i = (modul[0]-1) << SWBITS;
	x = modul[modul[0]];

	return i + intlog2(x);
}

/*	sign(A-B)	*/
/***************************************************************
 *
 * Procedure _comp
 *
 ***************************************************************/
#ifdef __STDC__

int _comp(
	register L_NUMBER	 *Ap,
	register L_NUMBER	 *Bp
)

#else

int _comp(
	Ap,
	Bp
)
register L_NUMBER	 *Ap;
register L_NUMBER	 *Bp;

#endif

{
	register int	s = *Ap - *Bp;
	
	if (s>0)	return 1;
	if (s<0)	return -1;
	
	{	register L_NUMBER	*stop = Ap;
		
		Ap += lngofln(Ap); Bp += lngofln(Bp);
		for ( ; Ap>stop; Ap--, Bp-- ) {
			if (*Ap > *Bp)	return 1;
			if (*Ap < *Bp)	return -1;
		}
	}
	return 0;
}

#define cmp(a, b) { for(m = 0; m <= a[0]; m++) if(a[m] != b[m]) {printf("Arithmetic test failed\n"); return(-1);}}

main() {
	int n, m;

	union {
		int a;
		char b[2];
	} endian;

	printf("Word length is %d bits. ", 8 * sizeof(int));

	if(sizeof(int) != WBYTES) {
		printf("SecuDE was installed with wrong word length. See src/config/CONFIG.make\n"); return(-1);
	}
	endian.a = 1;
	if(endian.b[0]) printf("Little endian machine. ");
	else printf("Big endian machine. ");

	n1[0] = n2[0] = n3[0] = 1;

	for(n = 0; n<30; n++) {
		n1[1] = n * 89 + 14;
		n2[1] = n * 81 + 6;
		n3[1] = n * 79 + 1;

		mult(n1, n2, acc1);
		mult(n1, n3, acc2);

		add(acc1, acc2, acc3);
		sub(acc3, acc2, acc4);
		cmp(acc1, acc4)



		div(acc1, acc2, acc3, acc4);

		mult(acc3, acc2, acc5);
		add(acc5, acc4, acc5);
		cmp(acc5, acc1)

		shift(acc5, 10 * n, acc5);
		shift(acc5, -10 * n, acc5);
		cmp(acc5, acc1)
	}



	printf("Arithmetic test OK\n");
	return(0);
}
